/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "av\u00e9stico";
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_bn = "bengali";
        final String metaValue_bo = "tibetano";
        final String metaValue_el = "grego";
        final String metaValue_he = "hebraico";
        final String metaValue_hy = "arm\u00eanio";
        final String metaValue_ja = "japon\u00eas";
        final String metaValue_jv = "javan\u00eas";
        final String metaValue_ka = "georgiano";
        final String metaValue_km = "khmer";
        final String metaValue_ko = "coreano";
        final String metaValue_la = "latim";
        final String metaValue_ml = "malaiala";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birman\u00eas";
        final String metaValue_or = "oriya";
        final String metaValue_si = "cingal\u00eas";
        final String metaValue_su = "sundan\u00eas";
        final String metaValue_ta = "t\u00e2mil";
        final String metaValue_th = "tailand\u00eas";
        final String metaValue_tl = "tagalo";
        final String metaValue_ban = "balin\u00eas";
        final String metaValue_bax = "bamum";
        final String metaValue_bug = "bugin\u00eas";
        final String metaValue_chr = "cherokee";
        final String metaValue_got = "g\u00f3tico";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_phn = "fen\u00edcio";
        final String metaValue_ssy = "saho";
        final String metaValue_syr = "sir\u00edaco";
        final String metaValue_uga = "ugar\u00edtico";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "Ogam", "og\u00e2mico" },
            { "mwl", "mirand\u00eas" },
            { "Zsym", "zsym" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "dialeto gniva/njiva" },
            { "egy", "eg\u00edpcio arcaico" },
            { "raj", "rajastani" },
            { "Phag", "phags-pa" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ilha de Ascens\u00e3o" },
            { "rar", "rarotongano" },
            { "tet", "t\u00e9tum" },
            { "AD", "Andorra" },
            { "AE", "Emirados \u00c1rabes Unidos" },
            { "nl_BE", "flamengo" },
            { "AF", "Afeganist\u00e3o" },
            { "AG", "Ant\u00edgua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Alb\u00e2nia" },
            { "AM", "Arm\u00eania" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtida" },
            { "AR", "Argentina" },
            { "Prti", "prti" },
            { "AS", "Samoa Americana" },
            { "AT", "\u00c1ustria" },
            { "AU", "Austr\u00e1lia" },
            { "AW", "Aruba" },
            { "en_US", "ingl\u00eas americano" },
            { "AX", "Ilhas \u00c5land" },
            { "mye", "myene" },
            { "AZ", "Azerbaij\u00e3o" },
            { "%%AREVELA", "arm\u00eanio oriental" },
            { "BA", "B\u00f3snia e Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumyk" },
            { "BE", "B\u00e9lgica" },
            { "gmh", "alem\u00e3o m\u00e9dio-alto" },
            { "BF", "Burquina Faso" },
            { "BG", "Bulg\u00e1ria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S\u00e3o Bartolomeu" },
            { "BM", "Bermudas" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Pa\u00edses Baixos Caribenhos" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "xog", "lusoga" },
            { "BT", "But\u00e3o" },
            { "BV", "Ilha Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorr\u00fassia" },
            { "BZ", "Belize" },
            { "Visp", "visible speech" },
            { "CA", "Canad\u00e1" },
            { "CC", "Ilhas Cocos (Keeling)" },
            { "mzn", "mazandarani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Rep\u00fablica Centro-Africana" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Su\u00ed\u00e7a" },
            { "CI", "Costa do Marfim" },
            { "CK", "Ilhas Cook" },
            { "CL", "Chile" },
            { "Kthi", "kthi" },
            { "CM", "Rep\u00fablica dos Camar\u00f5es" },
            { "CN", "China" },
            { "CO", "Col\u00f4mbia" },
            { "CP", "Ilha de Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Ilha Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Rep\u00fablica Tcheca" },
            { "eka", "ekajuk" },
            { "DE", "Alemanha" },
            { "goh", "alem\u00e3o arcaico alto" },
            { "ace", "ach\u00e9m" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarca" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "meitei mayek" },
            { "zun", "zunhi" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Arg\u00e9lia" },
            { "pag", "pangasin\u00e3" },
            { "pal", "p\u00e1lavi" },
            { "EA", "Ceuta e Melilha" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Equador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Est\u00f4nia" },
            { "tiv", "tiv" },
            { "EG", "Egito" },
            { "EH", "Saara Ocidental" },
            { "chg", "chagatai" },
            { "pau", "palauano" },
            { "chk", "chuukese" },
            { "chn", "chinook jargon" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritreia" },
            { "ES", "Espanha" },
            { "ET", "Eti\u00f3pia" },
            { "EU", "Uni\u00e3o Europeia" },
            { "elx", "elamite" },
            { "chy", "cheiene" },
            { "Inds", "indo" },
            { "ady", "adigue" },
            { "FI", "Finl\u00e2ndia" },
            { "FJ", "Fiji" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Micron\u00e9sia" },
            { "FO", "Ilhas Faroe" },
            { "Taml", metaValue_ta },
            { "FR", "Fran\u00e7a" },
            { "tkl", "toquelauano" },
            { "grb", "grebo" },
            { "grc", "grego arcaico" },
            { "GA", "Gab\u00e3o" },
            { "vot", "votic" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Ge\u00f3rgia" },
            { "GF", "Guiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "Tale", "tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Groenl\u00e2ndia" },
            { "enm", "ingl\u00eas m\u00e9dio" },
            { "GM", "G\u00e2mbia" },
            { "GN", "Guin\u00e9" },
            { "GP", "Guadalupe" },
            { "GQ", "Guin\u00e9 Equatorial" },
            { "GR", "Gr\u00e9cia" },
            { "GS", "Ilhas Ge\u00f3rgia do Sul e Sandwich do Sul" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guin\u00e9-Bissau" },
            { "tli", "tlinguite" },
            { "tlh", "klingon" },
            { "Talu", "novo tai lue" },
            { "GY", "Guiana" },
            { "ckb", "sor\u00e2ni curdo" },
            { "zxx", "sem conte\u00fado lingu\u00edstico" },
            { "de_AT", "alem\u00e3o austr\u00edaco" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong, RAE da China" },
            { "HM", "Ilhas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cro\u00e1cia" },
            { "agq", "aghem" },
            { "gsw", "alem\u00e3o su\u00ed\u00e7o" },
            { "HT", "Haiti" },
            { "HU", "Hungria" },
            { "tmh", "tamaxeque" },
            { "IC", "Ilhas Can\u00e1rias" },
            { "ID", "Indon\u00e9sia" },
            { "peo", "persa arcaico" },
            { "IE", "Irlanda" },
            { "nap", "napolitano" },
            { "%%NDYUKA", "dialeto ndyuka" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "Israel" },
            { "IM", "Ilha de Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Territ\u00f3rio Brit\u00e2nico do Oceano \u00cdndico" },
            { "IQ", "Iraque" },
            { "IR", "Ir\u00e3" },
            { "IS", "Isl\u00e2ndia" },
            { "IT", "It\u00e1lia" },
            { "Zmth", "zmth" },
            { "%%POSIX", "computador" },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jord\u00e2nia" },
            { "JP", "Jap\u00e3o" },
            { "%%1606NICT", "franc\u00eas antigo de 1606" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "tog", "tongan\u00eas de Nyasa" },
            { "Kali", "kayah li" },
            { "de_CH", "alto alem\u00e3o su\u00ed\u00e7o" },
            { "KE", "Qu\u00eania" },
            { "419", "Am\u00e9rica Latina" },
            { "KG", "Quirguist\u00e3o" },
            { "KH", "Camboja" },
            { "KI", "Quiribati" },
            { "KM", "Comores" },
            { "KN", "S\u00e3o Crist\u00f3v\u00e3o e Nevis" },
            { "Knda", "kannada" },
            { "Zinh", "herdado" },
            { "fr_CA", "franc\u00eas canadense" },
            { "KP", "Coreia do Norte" },
            { "KR", "Coreia do Sul" },
            { "Plrd", "fon\u00e9tico pollard" },
            { "fr_CH", "franc\u00eas su\u00ed\u00e7o" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Ilhas Cayman" },
            { "KZ", "Cazaquist\u00e3o" },
            { "Cyrl", "cir\u00edlico" },
            { "LA", "Laos" },
            { "LB", "L\u00edbano" },
            { "phn", metaValue_phn },
            { "LC", "Santa L\u00facia" },
            { "Cyrs", "cir\u00edlico eslavo eclesi\u00e1stico" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "baixo alem\u00e3o" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "acadiano" },
            { "cop", "copta" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lesoto" },
            { "Phlv", "pahlavi antigo" },
            { "LT", "Litu\u00e2nia" },
            { "LU", "Luxemburgo" },
            { "LV", "Let\u00f4nia" },
            { "Kana", "katakana" },
            { "LY", "L\u00edbia" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marrocos" },
            { "MC", "M\u00f4naco" },
            { "MD", "Mold\u00e1via" },
            { "ME", "Montenegro" },
            { "MF", "S\u00e3o Martinho" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Ilhas Marshall" },
            { "ale", "ale\u00fate" },
            { "MK", "Maced\u00f4nia" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birm\u00e2nia)" },
            { "MN", "Mong\u00f3lia" },
            { "new", "newari" },
            { "MO", "Macau, RAE da China" },
            { "MP", "Ilhas Marianas do Norte" },
            { "MQ", "Martinica" },
            { "MR", "Maurit\u00e2nia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maur\u00edcio" },
            { "alt", "altai do sul" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e9xico" },
            { "MY", "Mal\u00e1sia" },
            { "MZ", "Mo\u00e7ambique" },
            { "Phli", "phli" },
            { "NA", "Nam\u00edbia" },
            { "NC", "Nova Caled\u00f4nia" },
            { "%%WADEGILE", "romaniza\u00e7\u00e3o Wade-Giles" },
            { "%%UCRCOR", "ortografia revisada e unificada" },
            { "NE", "N\u00edger" },
            { "NF", "Ilha Norfolk" },
            { "NG", "Nig\u00e9ria" },
            { "trv", "taroko" },
            { "Phlp", "phlp" },
            { "NI", "Nicar\u00e1gua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Holanda" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nova Zel\u00e2ndia" },
            { "Merc", "mero\u00edtico cursivo" },
            { "rom", "romani" },
            { "Mero", "mero\u00edtico" },
            { "crh", "turco da Crimeia" },
            { "ang", "ingl\u00eas arcaico" },
            { "OM", "Om\u00e3" },
            { "anp", "angika" },
            { "Xpeo", "persa antigo" },
            { "PA", "Panam\u00e1" },
            { "csb", "kashubian" },
            { "en_GB", "ingl\u00eas brit\u00e2nico" },
            { "PE", "Peru" },
            { "PF", "Polin\u00e9sia Francesa" },
            { "PG", "Papua-Nova Guin\u00e9" },
            { "PH", "Filipinas" },
            { "PK", "Paquist\u00e3o" },
            { "PL", "Pol\u00f4nia" },
            { "ewo", "ewondo" },
            { "PM", "Saint Pierre e Miquelon" },
            { "PN", "Ilhas Pitcairn" },
            { "PR", "Porto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Territ\u00f3rios palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguai" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Catar" },
            { "%%SCOTLAND", "ingl\u00eas padr\u00e3o escoc\u00eas" },
            { "niu", "niueano" },
            { "QO", "Oceania Remota" },
            { "lez", "lezghian" },
            { "%%FONUPA", "fon\u00e9tica do Alfabeto Fon\u00e9tico Ur\u00e1lico" },
            { "tvl", "tuvaluano" },
            { "Tavt", "tavt" },
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica do Norte" },
            { "RE", "Reuni\u00e3o" },
            { "005", "Am\u00e9rica do Sul" },
            { "jbo", "lojban" },
            { "Rjng", "rejang" },
            { "009", "Oceania" },
            { "RO", "Rom\u00eania" },
            { "RS", "S\u00e9rvia" },
            { "RU", "R\u00fassia" },
            { "RW", "Ruanda" },
            { "Ugar", metaValue_uga },
            { "Mani", "maniqueano" },
            { "Khar", "kharoshthi" },
            { "SA", "Ar\u00e1bia Saudita" },
            { "pon", "pohnpeian" },
            { "Mand", "mandaico" },
            { "SB", "Ilhas Salom\u00e3o" },
            { "twq", "tasawaq" },
            { "011", "\u00c1frica Ocidental" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e3o" },
            { "013", "Am\u00e9rica Central" },
            { "SE", "Su\u00e9cia" },
            { "014", "\u00c1frica Oriental" },
            { "arc", "aramaico" },
            { "015", "\u00c1frica do Norte" },
            { "SG", "Cingapura" },
            { "SH", "Santa Helena" },
            { "017", "\u00c1frica Central" },
            { "SI", "Eslov\u00eania" },
            { "018", "\u00c1frica Austral" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Am\u00e9ricas" },
            { "SK", "Eslov\u00e1quia" },
            { "SL", "Serra Leoa" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e1lia" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "SR", "Suriname" },
            { "SS", "Sud\u00e3o do Sul" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00edria" },
            { "yao", "yao" },
            { "SZ", "Suazil\u00e2ndia" },
            { "arw", "arauaqui" },
            { "yap", "yapese" },
            { "TA", "Trist\u00e3o da Cunha" },
            { "asa", "asu" },
            { "021", "Am\u00e9rica Setentrional" },
            { "TC", "Ilhas Turks e Caicos" },
            { "yav", "yangben" },
            { "TD", "Chade" },
            { "TF", "Territ\u00f3rios Franceses do Sul" },
            { "TG", "Togo" },
            { "TH", "Tail\u00e2ndia" },
            { "TJ", "Tajiquist\u00e3o" },
            { "029", "Caribe" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "yemba" },
            { "TM", "Turcomenist\u00e3o" },
            { "%%BOONT", "boontling" },
            { "TN", "Tun\u00edsia" },
            { "TO", "Tonga" },
            { "TR", "Turquia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiano" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanz\u00e2nia" },
            { "nmg", "kwasio" },
            { "Zzzz", "escrita desconhecida" },
            { "UA", "Ucr\u00e2nia" },
            { "rup", "aromeno" },
            { "030", "\u00c1sia Oriental" },
            { "tyv", "tuviniano" },
            { "sw_CD", "sua\u00edli do Congo" },
            { "034", "\u00c1sia do Sul" },
            { "hai", "haida" },
            { "035", "Sudeste Asi\u00e1tico" },
            { "UG", "Uganda" },
            { "039", "Europa do Sul" },
            { "Sinh", metaValue_si },
            { "UM", "Ilhas Menores Distantes dos EUA" },
            { "US", "Estados Unidos" },
            { "haw", "havaiano" },
            { "%%1959ACAD", "acad\u00eamico" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbequist\u00e3o" },
            { "tzm", "tamazight do Atlas Central" },
            { "nnh", "ngiemboon" },
            { "VA", "Cidade do Vaticano" },
            { "pro", "proven\u00e7al arcaico" },
            { "VC", "S\u00e3o Vicente e Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Ilhas Virgens Brit\u00e2nicas" },
            { "VI", "Ilhas Virgens dos EUA" },
            { "VN", "Vietn\u00e3" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "n\u00f3rdico arcaico" },
            { "053", "Austral\u00e1sia" },
            { "%%AREVMDA", "arm\u00eanio ocidental" },
            { "054", "Melan\u00e9sia" },
            { "WF", "Wallis e Futuna" },
            { "057", "Regi\u00e3o da Micron\u00e9sia" },
            { "jgo", "nguemba" },
            { "lkt", "lacota" },
            { "%%HEPBURN", "romaniza\u00e7\u00e3o hepburn" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polin\u00e9sia" },
            { "XK", "Kosovo" },
            { "Gujr", "gujerati" },
            { "Zxxx", "\u00e1grafo" },
            { "Olck", "ol chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "bataque" },
            { "Blis", "s\u00edmbolos bliss" },
            { "YE", "I\u00eamen" },
            { "nqo", metaValue_nqo },
            { "fan", "fangue" },
            { "%%ROZAJ", "resiano" },
            { "fat", "fanti" },
            { "Sgnw", "signwriting" },
            { "YT", "Mayotte" },
            { "ZA", "\u00c1frica do Sul" },
            { "Deva", "devan\u00e1gari" },
            { "Hira", "hiragana" },
            { "ZM", "Z\u00e2mbia" },
            { "%%PINYIN", "romaniza\u00e7\u00e3o Pinyin" },
            { "ZW", "Zimb\u00e1bue" },
            { "ZZ", "Regi\u00e3o desconhecida" },
            { "Runr", "r\u00fanico" },
            { "lol", "mongo" },
            { "nso", "soto setentrional" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "hil", "hiligaynon" },
            { "nus", "nuer" },
            { "dak", "dacota" },
            { "hit", "hitita" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "hier\u00f3glifos maias" },
            { "lrc", "luri setentrional" },
            { "Copt", "c\u00f3ptico" },
            { "nwc", "newari cl\u00e1ssico" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "sah", "iacuto" },
            { "sam", "aramaico samaritano" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "judaico-persa" },
            { "sba", "ngambay" },
            { "Guru", "gurmuqui" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "biscainho" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "bal\u00fachi" },
            { "den", "slave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "luy", "luyia" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "jrb", "judaico-ar\u00e1bico" },
            { "es_ES", "espanhol europeu" },
            { "nzi", "nzima" },
            { "sco", "escoc\u00eas" },
            { "scn", "siciliano" },
            { "aa", "afar" },
            { "ab", "abc\u00e1zio" },
            { "ae", metaValue_ae },
            { "af", "afric\u00e2ner" },
            { "ak", "akan" },
            { "bbj", "ghomala\u2019" },
            { "am", "am\u00e1rico" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u00eas" },
            { "%%SOLBA", "dialeto stolvizza/solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana ou hiragana" },
            { "as", "assam\u00eas" },
            { "Lina", "linear A" },
            { "av", "avaric" },
            { "Linb", "linear B" },
            { "sdh", "curdo meridional" },
            { "ay", "aimara" },
            { "az", "azerbaijano" },
            { "%%OSOJS", "dialeto oseacco/osojane" },
            { "ba", "bashkir" },
            { "be", "bielorrusso" },
            { "bg", "b\u00falgaro" },
            { "bi", "bislam\u00e1" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bret\u00e3o" },
            { "bs", "b\u00f3snio" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "catal\u00e3o" },
            { "ses", "koyraboro senni" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "%%REVISED", "ortografia revisada" },
            { "co", "c\u00f3rsico" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tcheco" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "tchuvache" },
            { "cy", "gal\u00eas" },
            { "Yiii", "yi" },
            { "da", "dinamarqu\u00eas" },
            { "pt_PT", "portugu\u00eas europeu" },
            { "de", "alem\u00e3o" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "irland\u00eas arcaico" },
            { "dv", "divehi" },
            { "es_419", "espanhol latino-americano" },
            { "dz", "dzonga" },
            { "bez", "bena" },
            { "Lisu", "lisu" },
            { "dje", "zarma" },
            { "ee", "eve" },
            { "bfd", "bafut" },
            { "ro_MD", "mold\u00e1vio" },
            { "el", metaValue_el },
            { "en", "ingl\u00eas" },
            { "eo", "esperanto" },
            { "es", "espanhol" },
            { "et", "estoniano" },
            { "eu", "basco" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritano" },
            { "shi", "tachelhit" },
            { "hsb", "sor\u00e1bio alto" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persa" },
            { "Hans", "simplificado" },
            { "Hant", "tradicional" },
            { "az_Arab", "azeri sul" },
            { "ff", "fula" },
            { "shu", "\u00e1rabe chadiano" },
            { "fi", "finland\u00eas" },
            { "fj", "fijiano" },
            { "fon", "fom" },
            { "bgn", "bal\u00fachi ocidental" },
            { "yue", "canton\u00eas" },
            { "fo", "fero\u00eas" },
            { "umb", "umbundu" },
            { "fr", "franc\u00eas" },
            { "sid", "sidamo" },
            { "fy", "fr\u00edsio ocidental" },
            { "ga", "irland\u00eas" },
            { "gd", "ga\u00e9lico escoc\u00eas" },
            { "gl", "galego" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "idioma desconhecido" },
            { "gu", "guzerate" },
            { "gv", "manx" },
            { "ha", "hau\u00e7\u00e1" },
            { "he", metaValue_he },
            { "hi", "h\u00edndi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "%%FONIPA", "fon\u00e9tica do Alfabeto Fon\u00e9tico Internacional" },
            { "ia", "interl\u00edngua" },
            { "id", "indon\u00e9sio" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "sichuan yi" },
            { "frm", "franc\u00eas m\u00e9dio" },
            { "ik", "inupiaque" },
            { "fro", "franc\u00eas arcaico" },
            { "io", "ido" },
            { "frs", "fris\u00e3o oriental" },
            { "frr", "fr\u00edsio setentrional" },
            { "is", "island\u00eas" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "%%HOGNORSK", "alto noruego" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "bkm", "kom" },
            { "sma", "sami do sul" },
            { "jv", metaValue_jv },
            { "Shaw", "shaviano" },
            { "mad", "madur\u00eas" },
            { "smj", "sami de Lule" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "sami de Inari" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "sami de Skolt" },
            { "man", "mandinga" },
            { "kg", "congol\u00eas" },
            { "Goth", metaValue_got },
            { "ki", "quicuio" },
            { "mas", "massai" },
            { "kj", "kuanyama" },
            { "kk", "cazaque" },
            { "kl", "groenland\u00eas" },
            { "km", metaValue_km },
            { "kn", "canar\u00eas" },
            { "ko", metaValue_ko },
            { "kr", "can\u00fari" },
            { "ks", "caxemira" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "quirguiz" },
            { "snk", "soninqu\u00ea" },
            { "la", metaValue_la },
            { "lb", "luxemburgu\u00eas" },
            { "lg", "luganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgu\u00eas" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulano" },
            { "lo", "laosiano" },
            { "lt", "lituano" },
            { "lu", "luba-catanga" },
            { "lv", "let\u00e3o" },
            { "sog", "sogdiano" },
            { "mg", "malgaxe" },
            { "mh", "marshal\u00eas" },
            { "mi", "maori" },
            { "mk", "maced\u00f4nio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marata" },
            { "ms", "malaio" },
            { "mt", "malt\u00eas" },
            { "my", metaValue_my },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "mocsa" },
            { "mde", "maba" },
            { "dsb", "sor\u00e1bio baixo" },
            { "Armi", "armi" },
            { "na", "nauruano" },
            { "nb", "bokm\u00e5l noruegu\u00eas" },
            { "nd", "ndebele do norte" },
            { "ne", "nepali" },
            { "ng", "dongo" },
            { "mdr", "mandar" },
            { "nl", "holand\u00eas" },
            { "nn", "nynorsk noruegu\u00eas" },
            { "no", "noruegu\u00eas" },
            { "nr", "ndebele do sul" },
            { "nv", "navajo" },
            { "kaa", "kara-kalpak" },
            { "ny", "nianja" },
            { "kac", "kachin" },
            { "kab", "kabyle" },
            { "%%POLYTON", "polit\u00f4nico" },
            { "oc", "occit\u00e2nico" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "ossetic" },
            { "kbd", "kabardiano" },
            { "mfe", "morisyen" },
            { "srn", "idioma surinam\u00eas" },
            { "pa", "panjabi" },
            { "dua", "duala" },
            { "srr", "serere" },
            { "%%LIPAW", "dialeto lipovaz de Resian" },
            { "kbl", "kanembu" },
            { "pi", "p\u00e1li" },
            { "pl", "polon\u00eas" },
            { "dum", "holand\u00eas m\u00e9dio" },
            { "ps", "pashto" },
            { "pt", "portugu\u00eas" },
            { "mga", "irland\u00eas m\u00e9dio" },
            { "pt_BR", "portugu\u00eas do Brasil" },
            { "kcg", "tyap" },
            { "mgh", "macua" },
            { "bra", "braj" },
            { "Laoo", "lao" },
            { "mgo", "meta\u2019" },
            { "ssy", metaValue_ssy },
            { "qu", "qu\u00edchua" },
            { "zap", "zapoteca" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "maconde" },
            { "Ethi", "eti\u00f3pico" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "romeno" },
            { "%%SAAHO", metaValue_ssy },
            { "ru", "russo" },
            { "bss", "akoose" },
            { "rw", "quiniaruanda" },
            { "zbl", "s\u00edmbolos blis" },
            { "kea", "kabuverdianu" },
            { "mic", "miquemaque" },
            { "suk", "sukuma" },
            { "en_AU", "ingl\u00eas australiano" },
            { "sa", "s\u00e2nscrito" },
            { "%%UCCOR", "ortografia unificada" },
            { "sc", "sardo" },
            { "sus", "sosso" },
            { "sd", "sindi" },
            { "se", "sami do norte" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "servo-croata" },
            { "si", metaValue_si },
            { "sux", "sum\u00e9rio" },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "alban\u00eas" },
            { "sr", "s\u00e9rvio" },
            { "ss", "swati" },
            { "Java", metaValue_jv },
            { "st", "soto do sul" },
            { "su", metaValue_su },
            { "%%NEDIS", "dialeto natisone" },
            { "sv", "sueco" },
            { "sw", "sua\u00edli" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "\u00c1sia" },
            { "bua", "buriat" },
            { "143", "\u00c1sia Central" },
            { "te", "telugu" },
            { "145", "\u00c1sia Ocidental" },
            { "tg", "tajique" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigr\u00ednia" },
            { "kfo", "koro" },
            { "en_CA", "ingl\u00eas canadense" },
            { "tk", "turcomeno" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tongan\u00eas" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "swb", "comoriano" },
            { "Cakm", "cakm" },
            { "tt", "tatar" },
            { "dyu", "di\u00fala" },
            { "tw", "twi" },
            { "ty", "taitiano" },
            { "%%BISKE", "dialeto san giorgio/bila" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa Setentrional" },
            { "dzg", "dazaga" },
            { "155", "Europa Ocidental" },
            { "ug", "uigur" },
            { "Kore", metaValue_ko },
            { "Ital", "it\u00e1lico antigo" },
            { "Zyyy", "comum" },
            { "uk", "ucraniano" },
            { "ur", "urdu" },
            { "%%1994", "ortografia resiana padronizada" },
            { "xal", "kalmyk" },
            { "zen", "zenaga" },
            { "uz", "usbeque" },
            { "kha", "khasi" },
            { "%%1996", "ortografia alem\u00e3 de 1996" },
            { "nds_NL", "baixo-sax\u00e3o" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "kho", "khotan\u00eas" },
            { "khq", "koyra chiini" },
            { "%%TARASK", "ortografia taraskievica" },
            { "vo", "volapuque" },
            { "syc", "sir\u00edaco cl\u00e1ssico" },
            { "Osma", "osmania" },
            { "quc", "quich\u00e9" },
            { "gaa", "ga" },
            { "wa", "val\u00e3o" },
            { "gag", "gagauz" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "l\u00eddio" },
            { "Xsux", "sum\u00e9rio-acadiano cuneiforme" },
            { "wo", "u\u00f3lofe" },
            { "zgh", "tamazight marroquino padr\u00e3o" },
            { "ar_001", "\u00e1rabe moderno" },
            { "Cans", "escrita sil\u00e1bica unificada dos abor\u00edgenes canadenses" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manchu" },
            { "Latf", "latim fraktur" },
            { "gba", "gbaia" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "latim ga\u00e9lico" },
            { "xh", "xosa" },
            { "byn", "blin" },
            { "%%PAMAKA", "dialeto pamaka" },
            { "Lyci", "l\u00edcio" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "Moon", "moon" },
            { "moh", "moicano" },
            { "kkj", "kako" },
            { "%%1694ACAD", "franc\u00eas da idade moderna" },
            { "Syrc", metaValue_syr },
            { "yi", "i\u00eddiche" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "ioruba" },
            { "es_MX", "espanhol mexicano" },
            { "Syrj", "sir\u00edaco ocidental" },
            { "ota", "turco otomano" },
            { "Syre", "sir\u00edaco estrangelo" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "cariano" },
            { "kln", "kalenjin" },
            { "zh", "chin\u00eas" },
            { "Bopo", "bopomofo" },
            { "Perm", "p\u00e9rmico antigo" },
            { "zu", "zulu" },
            { "%%MONOTON", "monot\u00f4nico" },
            { "Geor", metaValue_ka },
            { "kmb", "quimbundo" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "Syrn", "sir\u00edaco oriental" },
            { "Tglg", metaValue_tl },
            { "Egyd", "dem\u00f3tico eg\u00edpcio" },
            { "Egyh", "hier\u00e1tico eg\u00edpcio" },
            { "ebu", "embu" },
            { "Egyp", "hier\u00f3glifos eg\u00edpcios" },
            { "Geok", "khutsuri georgiano" },
            { "zh_Hans", "chin\u00eas simplificado" },
            { "koi", "komi-permyak" },
            { "Hung", "h\u00fangaro antigo" },
            { "kok", "concani" },
            { "%%1901", "ortografia alem\u00e3 tradicional" },
            { "kos", "kosraean" },
            { "zh_Hant", "chin\u00eas tradicional" },
            { "Sund", metaValue_su },
            { "kpe", "kpelle" },
            { "ilo", "ilocano" },
            { "%%VALENCIA", "valenciano" },
            { "Cprt", "cipriota" },
            { "%%BAKU1926", "alfabeto latino turco unificado" },
            { "mua", "mundang" },
            { "mul", "idiomas m\u00faltiplos" },
            { "cad", "caddo" },
            { "mus", "creek" },
            { "Glag", "glagol\u00edtico" },
            { "gil", "gilbert\u00eas" },
            { "%%KKCOR", "ortografia comum" },
            { "Cher", metaValue_chr },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "krc", "karachay-balkar" },
            { "inh", "inguche" },
            { "krl", "idioma car\u00e9lio" },
            { "efi", "efique" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", "t\u00e9lugo" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
