/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_en extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ae = "Avestan";
        final String metaValue_ar = "Arabic";
        final String metaValue_bn = "Bengali";
        final String metaValue_bo = "Tibetan";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebrew";
        final String metaValue_hy = "Armenian";
        final String metaValue_ja = "Japanese";
        final String metaValue_jv = "Javanese";
        final String metaValue_ka = "Georgian";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_la = "Latin";
        final String metaValue_lo = "Lao";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolian";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sundanese";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_tl = "Tagalog";
        final String metaValue_ban = "Balinese";
        final String metaValue_bug = "Buginese";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptic";
        final String metaValue_got = "Gothic";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_peo = "Old Persian";
        final String metaValue_phn = "Phoenician";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_ssy = "Saho";
        final String metaValue_syr = "Syriac";
        final String metaValue_uga = "Ugaritic";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Blissymbols";
        final Object[][] data = new Object[][] {
            { "ksh", "Colognian" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandese" },
            { "Zsym", "Symbols" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "egl", "Emilian" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "Gniva/Njiva dialect" },
            { "xmf", "Mingrelian" },
            { "egy", "Ancient Egyptian" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ascension Island" },
            { "rar", "Rarotongan" },
            { "tet", "Tetum" },
            { "%%BARLA", "Barlavento dialect group of Kabuverdianu" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua & Barbuda" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "Prti", "Inscriptional Parthian" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "American English" },
            { "AX", "\u00c5land Islands" },
            { "mye", "Myene" },
            { "AZ", "Azerbaijan" },
            { "%%AREVELA", "Eastern Armenian" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Kumyk" },
            { "BE", "Belgium" },
            { "gmh", "Middle High German" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "Visp", "Visible Speech" },
            { "CA", "Canada" },
            { "CC", "Cocos (Keeling) Islands" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "Kthi", "Kaithi" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton Island" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "CZ", "Czech Republic" },
            { "eka", "Ekajuk" },
            { "Ahom", "Ahom" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "West Flemish" },
            { "%%RIGIK", "Classic Volap\u00fck" },
            { "DE", "Germany" },
            { "goh", "Old High German" },
            { "ace", "Achinese" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goan Konkani" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "ach", "Acoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominica" },
            { "DO", "Dominican Republic" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Main-Franconian" },
            { "Mtei", "Meitei Mayek" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Algeria" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta & Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estonia" },
            { "tiv", "Tiv" },
            { "EG", "Egypt" },
            { "EH", "Western Sahara" },
            { "chg", "Chagatai" },
            { "pau", "Palauan" },
            { "chk", "Chuukese" },
            { "chn", "Chinook Jargon" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "European Union" },
            { "elx", "Elamite" },
            { "chy", "Cheyenne" },
            { "Inds", "Indus" },
            { "ady", "Adyghe" },
            { "aeb", "Tunisian Arabic" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Faroe Islands" },
            { "Taml", metaValue_ta },
            { "FR", "France" },
            { "Kpel", metaValue_kpe },
            { "pcd", "Picard" },
            { "tkl", metaValue_TK },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "%%DAJNKO", "Dajnko alphabet" },
            { "rgn", "Romagnol" },
            { "grc", "Ancient Greek" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhur" },
            { "vot", "Votic" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Greenland" },
            { "enm", "Middle English" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvania German" },
            { "GW", "Guinea-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "New Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Central Kurdish" },
            { "zxx", "No linguistic content" },
            { "Jurc", "Jurchen" },
            { "tly", "Talysh" },
            { "pdt", "Plautdietsch" },
            { "de_AT", "Austrian German" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard & McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "agq", "Aghem" },
            { "gsw", "Swiss German" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "rif", "Riffian" },
            { "tmh", "Tamashek" },
            { "IC", "Canary Islands" },
            { "nan", "Min Nan Chinese" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "nap", "Neapolitan" },
            { "%%NDYUKA", "Ndyuka dialect" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "Tang", "Tangut" },
            { "IL", "Israel" },
            { "Nbat", "Nabataean" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "Zmth", "Mathematical Notation" },
            { "vro", "V\u00f5ro" },
            { "guc", "Wayuu" },
            { "%%POSIX", "Computer" },
            { "pfl", "Palatine German" },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "%%EKAVSK", "Serbian with Ekavian pronunciation" },
            { "JO", "Jordan" },
            { "gur", "Frafra" },
            { "JP", "Japan" },
            { "%%1606NICT", "Late Middle French to 1606" },
            { "ain", "Ainu" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "Swiss High German" },
            { "izh", "Ingrian" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts & Nevis" },
            { "Zinh", "Inherited" },
            { "fr_CA", "Canadian French" },
            { "KP", "North Korea" },
            { "KR", "South Korea" },
            { "Plrd", "Pollard Phonetic" },
            { "fr_CH", "Swiss French" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "Cyrillic" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "phn", metaValue_phn },
            { "LC", "St. Lucia" },
            { "Cyrs", "Old Church Slavonic Cyrillic" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Low German" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadian" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "Central Yupik" },
            { "LS", "Lesotho" },
            { "Phlv", "Book Pahlavi" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libya" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall Islands" },
            { "ale", "Aleut" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "Newari" },
            { "MO", "Macau SAR China" },
            { "aln", "Gheg Albanian" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "MU", "Mauritius" },
            { "alt", "Southern Altai" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "Phli", "Inscriptional Pahlavi" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Unified Revised Orthography" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Psalter Pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "tsd", "Tsakonian" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "New Zealand" },
            { "Merc", "Meroitic Cursive" },
            { "%%COLB1945", "Portuguese-Brazilian Orthographic Convention of 1945" },
            { "rom", "Romany" },
            { "Mero", "Meroitic" },
            { "crh", "Crimean Turkish" },
            { "ang", "Old English" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "csb", "Kashubian" },
            { "en_GB", "British English" },
            { "PE", "Peru" },
            { "ttt", "Muslim Tat" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "ewo", "Ewondo" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Scottish Standard English" },
            { "jam", "Jamaican Creole English" },
            { "pms", "Piedmontese" },
            { "niu", "Niuean" },
            { "QO", "Outlying Oceania" },
            { "ext", "Extremaduran" },
            { "lez", "Lezghian" },
            { "%%FONUPA", "UPA Phonetics" },
            { "tvl", metaValue_TV },
            { "Tavt", "Tai Viet" },
            { "%%SOTAV", "Sotavento dialect group of Kabuverdianu" },
            { "001", "World" },
            { "002", "Africa" },
            { "njo", "Ao Naga" },
            { "003", "North America" },
            { "RE", "R\u00e9union" },
            { "005", "South America" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "pnt", "Pontic" },
            { "Rjng", "Rejang" },
            { "009", "Oceania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "Mroo", "Mro" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "%%METELKO", "Metelko alphabet" },
            { "Ugar", metaValue_uga },
            { "Mani", "Manichaean" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saudi Arabia" },
            { "pon", "Pohnpeian" },
            { "Mand", "Mandaean" },
            { "SB", "Solomon Islands" },
            { "twq", "Tasawaq" },
            { "011", "Western Africa" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "013", "Central America" },
            { "SE", "Sweden" },
            { "014", "Eastern Africa" },
            { "arc", "Aramaic" },
            { "Loma", "Loma" },
            { "015", "Northern Africa" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "017", "Middle Africa" },
            { "SI", "Slovenia" },
            { "018", "Southern Africa" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Americas" },
            { "SK", "Slovakia" },
            { "Bamu", "Bamum" },
            { "Wole", "Woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "SR", "Suriname" },
            { "aro", "Araona" },
            { "SS", "South Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "arq", "Algerian Arabic" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "Yao" },
            { "SZ", "Swaziland" },
            { "arw", "Arawak" },
            { "arz", "Egyptian Arabic" },
            { "ary", "Moroccan Arabic" },
            { "yap", "Yapese" },
            { "rtm", "Rotuman" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "021", "Northern America" },
            { "TC", "Turks & Caicos Islands" },
            { "yav", "Yangben" },
            { "TD", "Chad" },
            { "TF", "French Southern Territories" },
            { "ase", "American Sign Language" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", metaValue_TK },
            { "029", "Caribbean" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "%%NULIK", "Modern Volap\u00fck" },
            { "TR", "Turkey" },
            { "TT", "Trinidad & Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "ast", "Asturian" },
            { "rue", "Rusyn" },
            { "rug", "Roviana" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Unknown Script" },
            { "Sind", "Khudawadi" },
            { "UA", "Ukraine" },
            { "lij", "Ligurian" },
            { "rup", "Aromanian" },
            { "030", "Eastern Asia" },
            { "tyv", "Tuvinian" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Southern Asia" },
            { "hai", "Haida" },
            { "035", "Southeast Asia" },
            { "UG", "Uganda" },
            { "hak", "Hakka Chinese" },
            { "039", "Southern Europe" },
            { "Sinh", metaValue_si },
            { "UM", "U.S. Outlying Islands" },
            { "liv", "Livonian" },
            { "US", "United States" },
            { "haw", "Hawaiian" },
            { "%%1959ACAD", "Academic" },
            { "UY", "Uruguay" },
            { "prg", "Prussian" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Central Atlas Tamazight" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatican City" },
            { "pro", "Old Proven\u00e7al" },
            { "VC", "St. Vincent & Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Old Norse" },
            { "053", "Australasia" },
            { "%%AREVMDA", "Western Armenian" },
            { "054", "Melanesia" },
            { "WF", "Wallis & Futuna" },
            { "057", "Micronesian Region" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "nov", "Novial" },
            { "avk", "Kotava" },
            { "%%HEPBURN", "Hepburn romanization" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "Bass", "Bassa Vah" },
            { "wal", "Wolaytta" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "Standard Orthography" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Unwritten" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Yemen" },
            { "nqo", metaValue_nqo },
            { "lmo", "Lombard" },
            { "fan", "Fang" },
            { "%%BALANKA", "Balanka dialect of Anii" },
            { "%%ROZAJ", "Resian" },
            { "fat", "Fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "ZA", "South Africa" },
            { "Deva", "Devanagari" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin Romanization" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Unknown Region" },
            { "Runr", "Runic" },
            { "lol", "Mongo" },
            { "nso", "Northern Sotho" },
            { "loz", "Lozi" },
            { "Nkgb", "Naxi Geba" },
            { "jmc", "Machame" },
            { "hif", "Fiji Hindi" },
            { "hil", "Hiligaynon" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "hit", "Hittite" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Mayan hieroglyphs" },
            { "lrc", "Northern Luri" },
            { "Copt", metaValue_cop },
            { "nwc", "Classical Newari" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "ltg", "Latgalian" },
            { "sam", "Samaritan Aramaic" },
            { "Aghb", "Caucasian Albanian" },
            { "%%SCOUSE", "Scouse" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Judeo-Persian" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Aluku dialect" },
            { "lua", "Luba-Lulua" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipino" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Mizo" },
            { "bal", "Baluchi" },
            { "den", "Slave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "Tornedalen Finnish" },
            { "luy", "Luyia" },
            { "bar", "Bavarian" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "%%ABL1943", "Orthographic formulation of 1943" },
            { "jrb", "Judeo-Arabic" },
            { "es_ES", "European Spanish" },
            { "nzi", "Nzima" },
            { "sco", "Scots" },
            { "scn", "Sicilian" },
            { "aa", "Afar" },
            { "ab", "Abkhazian" },
            { "bbc", "Batak Toba" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "bbj", "Ghomala" },
            { "am", "Amharic" },
            { "Arab", metaValue_ar },
            { "an", "Aragonese" },
            { "%%SOLBA", "Stolvizza/Solbica dialect" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Japanese syllabaries" },
            { "as", "Assamese" },
            { "sdc", "Sassarese Sardinian" },
            { "Lina", "Linear A" },
            { "av", "Avaric" },
            { "Linb", "Linear B" },
            { "sdh", "Southern Kurdish" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Oseacco/Osojane dialect" },
            { "%%UNIFON", "Unifon phonetic alphabet" },
            { "ba", "Bashkir" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "see", "Seneca" },
            { "Mymr", "Myanmar" },
            { "sei", "Seri" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkup" },
            { "ca", "Catalan" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Revised Orthography" },
            { "co", "Corsican" },
            { "Orya", metaValue_or },
            { "cr", "Cree" },
            { "cs", "Czech" },
            { "cu", "Church Slavic" },
            { "yrl", "Nheengatu" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "Yiii", "Yi" },
            { "da", "Danish" },
            { "pt_PT", "European Portuguese" },
            { "de", "German" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "jut", "Jutish" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Old Irish" },
            { "dv", "Divehi" },
            { "es_419", "Latin American Spanish" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "lzh", "Literary Chinese" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "sgs", "Samogitian" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "ro_MD", "Moldavian" },
            { "el", metaValue_el },
            { "en", "English" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Laz" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "eu", "Basque" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaritan" },
            { "shi", "Tachelhit" },
            { "hsb", "Upper Sorbian" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Persian" },
            { "Hans", "Simplified" },
            { "Hant", "Traditional" },
            { "ff", "Fulah" },
            { "shu", "Chadian Arabic" },
            { "hsn", "Xiang Chinese" },
            { "fi", "Finnish" },
            { "fj", "Fijian" },
            { "fon", "Fon" },
            { "bgn", "Western Balochi" },
            { "yue", "Cantonese" },
            { "fo", "Faroese" },
            { "umb", "Umbundu" },
            { "fr", "French" },
            { "sid", "Sidamo" },
            { "fy", "Western Frisian" },
            { "ga", "Irish" },
            { "gd", "Scottish Gaelic" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Unknown Language" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Croatian" },
            { "ht", "Haitian Creole" },
            { "hu", "Hungarian" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Cajun French" },
            { "%%FONIPA", "IPA Phonetics" },
            { "ia", "Interlingua" },
            { "id", "Indonesian" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "frm", "Middle French" },
            { "%%AO1990", "Portuguese Language Orthographic Agreement of 1990" },
            { "ik", "Inupiaq" },
            { "fro", "Old French" },
            { "frp", "Arpitan" },
            { "io", "Ido" },
            { "frs", "Eastern Frisian" },
            { "bjn", "Banjar" },
            { "frr", "Northern Frisian" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "sli", "Lower Silesian" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Old South Arabian" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "bkm", "Kom" },
            { "sma", "Southern Sami" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavian" },
            { "mad", "Madurese" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "wuu", "Wu Chinese" },
            { "sms", "Skolt Sami" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kyrgyz" },
            { "snk", "Soninke" },
            { "Mult", "Multani" },
            { "la", metaValue_la },
            { "Hatr", "Hatran" },
            { "lb", "Luxembourgish" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgish" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "lo", metaValue_lo },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "sog", "Sogdien" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "mi", "Maori" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Maltese" },
            { "Saur", metaValue_saz },
            { "my", "Burmese" },
            { "Armn", metaValue_hy },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "Lower Sorbian" },
            { "Armi", "Imperial Aramaic" },
            { "na", metaValue_NR },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "North Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "nv", "Navajo" },
            { "kaa", "Kara-Kalpak" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "%%POLYTON", "Polytonic" },
            { "oc", "Occitan" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "Early Modern English" },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Central Dusun" },
            { "or", metaValue_or },
            { "Modi", "Modi" },
            { "os", "Ossetic" },
            { "%%ALALC97", "ALA-LC Romanization, 1997 edition" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardian" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "The Lipovaz dialect of Resian" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bakhtiari" },
            { "pl", "Polish" },
            { "dum", "Middle Dutch" },
            { "ps", "Pashto" },
            { "pt", "Portuguese" },
            { "mga", "Middle Irish" },
            { "pt_BR", "Brazilian Portuguese" },
            { "%%BOHORIC", "Bohori\u010d alphabet" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "bra", "Braj" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u02bc" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "qu", "Quechua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "stq", "Saterland Frisian" },
            { "Ethi", "Ethiopic" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "ro", "Romanian" },
            { "%%SAAHO", metaValue_ssy },
            { "ru", "Russian" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "en_AU", "Australian English" },
            { "Dupl", "Duployan shorthand" },
            { "sa", "Sanskrit" },
            { "%%UCCOR", "Unified Orthography" },
            { "sc", "Sardinian" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Northern Sami" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croatian" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "Sumerian" },
            { "sk", "Slovak" },
            { "sl", "Slovenian" },
            { "Gran", "Grantha" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albanian" },
            { "sr", "Serbian" },
            { "ss", "Swati" },
            { "Java", metaValue_jv },
            { "st", "Southern Sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone dialect" },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "Buriat" },
            { "143", "Central Asia" },
            { "te", metaValue_te },
            { "145", "Western Asia" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "en_CA", "Canadian English" },
            { "tk", "Turkmen" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "swb", "Comorian" },
            { "Cakm", "Chakma" },
            { "tt", "Tatar" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Tahitian" },
            { "%%BISKE", "San Giorgio/Bila dialect" },
            { "150", "Europe" },
            { "151", "Eastern Europe" },
            { "154", "Northern Europe" },
            { "dzg", "Dazaga" },
            { "155", "Western Europe" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Ital", "Old Italic" },
            { "kgp", "Kaingang" },
            { "Zyyy", "Common" },
            { "uk", "Ukrainian" },
            { "zea", "Zeelandic" },
            { "ur", "Urdu" },
            { "%%1994", "Standardized Resian orthography" },
            { "xal", "Kalmyk" },
            { "zen", "Zenaga" },
            { "uz", "Uzbek" },
            { "kha", "Khasi" },
            { "%%1996", "German orthography of 1996" },
            { "nds_NL", "Low Saxon" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "vi", "Vietnamese" },
            { "kho", "Khotanese" },
            { "khq", "Koyra Chiini" },
            { "%%TARASK", "Taraskievica orthography" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "syc", "Classical Syriac" },
            { "Osma", "Osmanya" },
            { "quc", "K\u02bciche\u02bc" },
            { "qug", "Chimborazo Highland Quichua" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "Gan Chinese" },
            { "kiu", "Kirmanjki" },
            { "Lydi", "Lydian" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "wo", "Wolof" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "ar_001", "Modern Standard Arabic" },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Manchu" },
            { "Latf", "Fraktur Latin" },
            { "szl", "Silesian" },
            { "Hluw", "Anatolian Hieroglyphs" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "Gaelic Latin" },
            { "xh", "Xhosa" },
            { "byn", "Blin" },
            { "%%PAMAKA", "Pamaka dialect" },
            { "Lyci", "Lycian" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrian Dari" },
            { "Moon", "Moon" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Early Modern French" },
            { "Syrc", metaValue_syr },
            { "yi", "Yiddish" },
            { "mos", "Mossi" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "es_MX", "Mexican Spanish" },
            { "Syrj", "Western Syriac" },
            { "ota", "Ottoman Turkish" },
            { "Syre", "Estrangelo Syriac" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Carian" },
            { "kln", "Kalenjin" },
            { "zh", "Chinese" },
            { "Afak", "Afaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Old Permic" },
            { "zu", "Zulu" },
            { "%%MONOTON", "Monotonic" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "Cham", "Cham" },
            { "gez", "Geez" },
            { "mrj", "Western Mari" },
            { "Syrn", "Eastern Syriac" },
            { "Elba", "Elbasan" },
            { "Narb", "Old North Arabian" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Egyptian demotic" },
            { "Egyh", "Egyptian hieratic" },
            { "Palm", "Palmyrene" },
            { "ebu", "Embu" },
            { "Egyp", "Egyptian hieroglyphs" },
            { "Geok", "Georgian Khutsuri" },
            { "zh_Hans", "Simplified Chinese" },
            { "koi", "Komi-Permyak" },
            { "Hung", "Old Hungarian" },
            { "kok", "Konkani" },
            { "%%1901", "Traditional German orthography" },
            { "kos", "Kosraean" },
            { "vec", "Venetian" },
            { "zh_Hant", "Traditional Chinese" },
            { "Sund", metaValue_su },
            { "vep", "Veps" },
            { "kpe", metaValue_kpe },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valencian" },
            { "Cprt", "Cypriot" },
            { "%%BAKU1926", "Unified Turkic Latin Alphabet" },
            { "%%IJEKAVSK", "Serbian with Ijekavian pronunciation" },
            { "mua", "Mundang" },
            { "mul", "Multiple Languages" },
            { "cad", "Caddo" },
            { "mus", "Creek" },
            { "Glag", "Glagolitic" },
            { "gil", "Gilbertese" },
            { "%%KKCOR", "Common Orthography" },
            { "Cher", metaValue_chr },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "fa_AF", "Dari" },
            { "krl", "Karelian" },
            { "%%OXENDICT", "Oxford English Dictionary spelling" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
