/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.PerfCounter;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public abstract class ClassLoader {
    private final ClassLoader parent;
    private final ConcurrentHashMap<String, Object> parallelLockMap;
    private final Map<String, Certificate[]> package2certs;
    private static final Certificate[] nocerts;
    private final Vector<Class<?>> classes = new Vector();
    private final ProtectionDomain defaultDomain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, this, null);
    private final HashMap<String, Package> packages = new HashMap();
    private static ClassLoader scl;
    private static boolean sclSet;
    private static Vector<String> loadedLibraryNames;
    private static Vector<NativeLibrary> systemNativeLibraries;
    private Vector<NativeLibrary> nativeLibraries = new Vector();
    private static Stack<NativeLibrary> nativeLibraryContext;
    private static String[] usr_paths;
    private static volatile String[] sys_paths;
    final Object assertionLock;
    private boolean defaultAssertionStatus = false;
    private Map<String, Boolean> packageAssertionStatus = null;
    Map<String, Boolean> classAssertionStatus = null;

    private static native void registerNatives();

    void addClass(Class<?> clazz) {
        this.classes.addElement(clazz);
    }

    private static Void checkCreateClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        return null;
    }

    private ClassLoader(Void void_, ClassLoader classLoader) {
        this.parent = classLoader;
        if (ParallelLoaders.isRegistered(this.getClass())) {
            this.parallelLockMap = new ConcurrentHashMap();
            this.package2certs = new ConcurrentHashMap<String, Certificate[]>();
            this.assertionLock = new Object();
        } else {
            this.parallelLockMap = null;
            this.package2certs = new Hashtable<String, Certificate[]>();
            this.assertionLock = this;
        }
    }

    protected ClassLoader(ClassLoader classLoader) {
        this(ClassLoader.checkCreateClassLoader(), classLoader);
    }

    protected ClassLoader() {
        this(ClassLoader.checkCreateClassLoader(), ClassLoader.getSystemClassLoader());
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(string);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                long l = System.nanoTime();
                try {
                    clazz = this.parent != null ? this.parent.loadClass(string, false) : this.findBootstrapClassOrNull(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz == null) {
                    long l2 = System.nanoTime();
                    clazz = this.findClass(string);
                    PerfCounter.getParentDelegationTime().addTime(l2 - l);
                    PerfCounter.getFindClassTime().addElapsedTimeFrom(l2);
                    PerfCounter.getFindClasses().increment();
                }
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    protected Object getClassLoadingLock(String string) {
        Object object;
        Object object2 = this;
        if (this.parallelLockMap != null && (object2 = this.parallelLockMap.putIfAbsent(string, object = new Object())) == null) {
            object2 = object;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassInternal(String string) throws ClassNotFoundException {
        if (this.parallelLockMap == null) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.loadClass(string);
            }
        }
        return this.loadClass(string);
    }

    private void checkPackageAccess(Class<?> clazz, ProtectionDomain protectionDomain) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (ReflectUtil.isNonPublicProxyClass(clazz)) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    this.checkPackageAccess(clazz2, protectionDomain);
                }
                return;
            }
            final String string = clazz.getName();
            final int n = string.lastIndexOf(46);
            if (n != -1) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        securityManager.checkPackageAccess(string.substring(0, n));
                        return null;
                    }
                }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
            }
        }
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2, null);
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    private ProtectionDomain preDefineClass(String string, ProtectionDomain protectionDomain) {
        if (!this.checkName(string)) {
            throw new NoClassDefFoundError("IllegalName: " + string);
        }
        if (string != null && string.startsWith("java.")) {
            throw new SecurityException("Prohibited package name: " + string.substring(0, string.lastIndexOf(46)));
        }
        if (protectionDomain == null) {
            protectionDomain = this.defaultDomain;
        }
        if (string != null) {
            this.checkCerts(string, protectionDomain.getCodeSource());
        }
        return protectionDomain;
    }

    private String defineClassSourceLocation(ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        String string = null;
        if (codeSource != null && codeSource.getLocation() != null) {
            string = codeSource.getLocation().toString();
        }
        return string;
    }

    private void postDefineClass(Class<?> clazz, ProtectionDomain protectionDomain) {
        Object[] objectArray;
        if (protectionDomain.getCodeSource() != null && (objectArray = protectionDomain.getCodeSource().getCertificates()) != null) {
            this.setSigners(clazz, objectArray);
        }
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        protectionDomain = this.preDefineClass(string, protectionDomain);
        String string2 = this.defineClassSourceLocation(protectionDomain);
        Class<?> clazz = this.defineClass1(string, byArray, n, n2, protectionDomain, string2);
        this.postDefineClass(clazz, protectionDomain);
        return clazz;
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        int n = byteBuffer.remaining();
        if (!byteBuffer.isDirect()) {
            if (byteBuffer.hasArray()) {
                return this.defineClass(string, byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), n, protectionDomain);
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return this.defineClass(string, byArray, 0, n, protectionDomain);
        }
        protectionDomain = this.preDefineClass(string, protectionDomain);
        String string2 = this.defineClassSourceLocation(protectionDomain);
        Class<?> clazz = this.defineClass2(string, byteBuffer, byteBuffer.position(), n, protectionDomain, string2);
        this.postDefineClass(clazz, protectionDomain);
        return clazz;
    }

    private native Class<?> defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    private native Class<?> defineClass1(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    private native Class<?> defineClass2(String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    private boolean checkName(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.indexOf(47) == -1 && (VM.allowArraySyntax() || string.charAt(0) != '[');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCerts(String string, CodeSource codeSource) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        Certificate[] certificateArray = null;
        if (codeSource != null) {
            certificateArray = codeSource.getCertificates();
        }
        Certificate[] certificateArray2 = null;
        if (this.parallelLockMap == null) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                certificateArray2 = this.package2certs.get(string2);
                if (certificateArray2 == null) {
                    this.package2certs.put(string2, certificateArray == null ? nocerts : certificateArray);
                }
            }
        } else {
            certificateArray2 = ((ConcurrentHashMap)this.package2certs).putIfAbsent(string2, certificateArray == null ? nocerts : certificateArray);
        }
        if (certificateArray2 != null && !this.compareCerts(certificateArray2, certificateArray)) {
            throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        boolean bl;
        int n2;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        for (n2 = 0; n2 < certificateArray2.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray.length; ++n) {
                if (!certificateArray2[n2].equals(certificateArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray2.length; ++n) {
                if (!certificateArray[n2].equals(certificateArray2[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected final void resolveClass(Class<?> clazz) {
        this.resolveClass0(clazz);
    }

    private native void resolveClass0(Class<?> var1);

    protected final Class<?> findSystemClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            if (!this.checkName(string)) {
                throw new ClassNotFoundException(string);
            }
            Class<?> clazz = this.findBootstrapClass(string);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }
        return classLoader.loadClass(string);
    }

    private Class<?> findBootstrapClassOrNull(String string) {
        if (!this.checkName(string)) {
            return null;
        }
        return this.findBootstrapClass(string);
    }

    private native Class<?> findBootstrapClass(String var1);

    protected final Class<?> findLoadedClass(String string) {
        if (!this.checkName(string)) {
            return null;
        }
        return this.findLoadedClass0(string);
    }

    private final native Class<?> findLoadedClass0(String var1);

    protected final void setSigners(Class<?> clazz, Object[] objectArray) {
        clazz.setSigners(objectArray);
    }

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration<URL>(enumerationArray);
    }

    protected URL findResource(String string) {
        return null;
    }

    protected Enumeration<URL> findResources(String string) throws IOException {
        return Collections.emptyEnumeration();
    }

    @CallerSensitive
    protected static boolean registerAsParallelCapable() {
        Class<ClassLoader> clazz = Reflection.getCallerClass().asSubclass(ClassLoader.class);
        return ParallelLoaders.register(clazz);
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    public static Enumeration<URL> getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    private static Enumeration<URL> getBootstrapResources(String string) throws IOException {
        final Enumeration<Resource> enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        return Launcher.getBootstrapClassPath();
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @CallerSensitive
    public final ClassLoader getParent() {
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader.checkClassLoaderPermission(this.parent, Reflection.getCallerClass());
        }
        return this.parent;
    }

    @CallerSensitive
    public static ClassLoader getSystemClassLoader() {
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader.checkClassLoaderPermission(scl, Reflection.getCallerClass());
        }
        return scl;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive invocation");
            }
            Launcher launcher2 = Launcher.getLauncher();
            if (launcher2 != null) {
                Throwable throwable;
                block7: {
                    throwable = null;
                    scl = launcher2.getClassLoader();
                    try {
                        scl = AccessController.doPrivileged(new SystemClassLoaderAction(scl));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getCause();
                        if (!(throwable instanceof InvocationTargetException)) break block7;
                        throwable = throwable.getCause();
                    }
                }
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new Error(throwable);
                }
            }
            sclSet = true;
        }
    }

    static void initLibraryPaths() {
        usr_paths = ClassLoader.initializePath("java.library.path");
        sys_paths = ClassLoader.initializePath("sun.boot.library.path");
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    private static boolean needsClassLoaderPermissionCheck(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader == classLoader2) {
            return false;
        }
        if (classLoader == null) {
            return false;
        }
        return !classLoader2.isAncestor(classLoader);
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader0();
    }

    static void checkClassLoaderPermission(ClassLoader classLoader, Class<?> clazz) {
        ClassLoader classLoader2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && ClassLoader.needsClassLoaderPermissionCheck(classLoader2 = ClassLoader.getClassLoader(clazz), classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL, this);
            this.packages.put(string, package_);
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        Package package_;
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            package_ = this.packages.get(string);
        }
        if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
            hashMap = this.packages;
            synchronized (hashMap) {
                Package package_2 = this.packages.get(string);
                if (package_2 == null) {
                    this.packages.put(string, package_);
                } else {
                    package_ = package_2;
                }
            }
        }
        return package_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packageArray = this.packages;
        synchronized (this.packages) {
            HashMap<String, Package> hashMap = new HashMap<String, Package>(this.packages);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
            if (packageArray != null) {
                for (int i = 0; i < packageArray.length; ++i) {
                    String string = packageArray[i].getName();
                    if (hashMap.get(string) != null) continue;
                    hashMap.put(string, packageArray[i]);
                }
            }
            return hashMap.values().toArray(new Package[hashMap.size()]);
        }
    }

    protected String findLibrary(String string) {
        return null;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    static void loadLibrary(Class<?> clazz, String string, boolean bl) {
        File file;
        int n;
        String string2;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        assert (sys_paths != null) : "should be initialized at this point";
        assert (usr_paths != null) : "should be initialized at this point";
        if (bl) {
            if (ClassLoader.loadLibrary0(clazz, new File(string))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + string2);
            }
            if (ClassLoader.loadLibrary0(clazz, file2)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        for (n = 0; n < sys_paths.length; ++n) {
            file = new File(sys_paths[n], System.mapLibraryName(string));
            if (ClassLoader.loadLibrary0(clazz, file)) {
                return;
            }
            if ((file = ClassLoaderHelper.mapAlternativeName(file)) == null || !ClassLoader.loadLibrary0(clazz, file)) continue;
            return;
        }
        if (classLoader != null) {
            for (n = 0; n < usr_paths.length; ++n) {
                file = new File(usr_paths[n], System.mapLibraryName(string));
                if (ClassLoader.loadLibrary0(clazz, file)) {
                    return;
                }
                if ((file = ClassLoaderHelper.mapAlternativeName(file)) == null || !ClassLoader.loadLibrary0(clazz, file)) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + string + " in java.library.path");
    }

    private static native String findBuiltinLib(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibrary0(Class<?> clazz, final File file) {
        Vector<NativeLibrary> vector;
        boolean bl;
        String string = ClassLoader.findBuiltinLib(file.getName());
        boolean bl2 = bl = string != null;
        if (!bl) {
            boolean bl3;
            boolean bl4 = bl3 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return file.exists() ? Boolean.TRUE : null;
                }
            }) != null;
            if (!bl3) {
                return false;
            }
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector<NativeLibrary> vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = vector.elementAt(i);
                if (!string.equals(nativeLibrary.name)) continue;
                return true;
            }
            Vector<String> vector3 = loadedLibraryNames;
            synchronized (vector3) {
                if (loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n2 = nativeLibraryContext.size();
                for (int i = 0; i < n2; ++i) {
                    NativeLibrary nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(i);
                    if (!string.equals(nativeLibrary.name)) continue;
                    if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                        return true;
                    }
                    throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                }
                NativeLibrary nativeLibrary = new NativeLibrary(clazz, string, bl);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    nativeLibrary.load(string, bl);
                }
                finally {
                    nativeLibraryContext.pop();
                }
                if (nativeLibrary.loaded) {
                    loadedLibraryNames.addElement(string);
                    vector.addElement(nativeLibrary);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long findNative(ClassLoader classLoader, String string) {
        Vector<NativeLibrary> vector;
        Vector<NativeLibrary> vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = vector.elementAt(i);
                long l = nativeLibrary.find(string);
                if (l == 0L) continue;
                return l;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.defaultAssertionStatus = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String string, boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.packageAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.packageAssertionStatus.put(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String string, boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.classAssertionStatus.put(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            this.classAssertionStatus = new HashMap<String, Boolean>();
            this.packageAssertionStatus = new HashMap<String, Boolean>();
            this.defaultAssertionStatus = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean desiredAssertionStatus(String string) {
        Object object = this.assertionLock;
        synchronized (object) {
            Boolean bl = this.classAssertionStatus.get(string);
            if (bl != null) {
                return bl;
            }
            int n = string.lastIndexOf(".");
            if (n < 0 && (bl = this.packageAssertionStatus.get(null)) != null) {
                return bl;
            }
            while (n > 0) {
                bl = this.packageAssertionStatus.get(string = string.substring(0, n));
                if (bl != null) {
                    return bl;
                }
                n = string.lastIndexOf(".", n - 1);
            }
            return this.defaultAssertionStatus;
        }
    }

    private void initializeJavaAssertionMaps() {
        int n;
        this.classAssertionStatus = new HashMap<String, Boolean>();
        this.packageAssertionStatus = new HashMap<String, Boolean>();
        AssertionStatusDirectives assertionStatusDirectives = ClassLoader.retrieveDirectives();
        for (n = 0; n < assertionStatusDirectives.classes.length; ++n) {
            this.classAssertionStatus.put(assertionStatusDirectives.classes[n], assertionStatusDirectives.classEnabled[n]);
        }
        for (n = 0; n < assertionStatusDirectives.packages.length; ++n) {
            this.packageAssertionStatus.put(assertionStatusDirectives.packages[n], assertionStatusDirectives.packageEnabled[n]);
        }
        this.defaultAssertionStatus = assertionStatusDirectives.deflt;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    static {
        ClassLoader.registerNatives();
        nocerts = new Certificate[0];
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private final Class<?> fromClass;
        String name;
        boolean isBuiltin;
        boolean loaded;

        native void load(String var1, boolean var2);

        native long find(String var1);

        native void unload(String var1, boolean var2);

        public NativeLibrary(Class<?> clazz, String string, boolean bl) {
            this.name = string;
            this.fromClass = clazz;
            this.isBuiltin = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.loaded) {
                    int n = loadedLibraryNames.size();
                    for (int i = 0; i < n; ++i) {
                        if (!this.name.equals(loadedLibraryNames.elementAt(i))) continue;
                        loadedLibraryNames.removeElementAt(i);
                        break;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload(this.name, this.isBuiltin);
                    }
                    finally {
                        nativeLibraryContext.pop();
                    }
                }
            }
        }

        static Class<?> getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }

    private static class ParallelLoaders {
        private static final Set<Class<? extends ClassLoader>> loaderTypes;

        private ParallelLoaders() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean register(Class<? extends ClassLoader> clazz) {
            Set<Class<? extends ClassLoader>> set = loaderTypes;
            synchronized (set) {
                if (loaderTypes.contains(clazz.getSuperclass())) {
                    loaderTypes.add(clazz);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean isRegistered(Class<? extends ClassLoader> clazz) {
            Set<Class<? extends ClassLoader>> set = loaderTypes;
            synchronized (set) {
                return loaderTypes.contains(clazz);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            Set<Class<? extends ClassLoader>> set = loaderTypes = Collections.newSetFromMap(new WeakHashMap());
            synchronized (set) {
                loaderTypes.add(ClassLoader.class);
            }
        }
    }
}

