/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;

public class PCFinder {
    public static final int LOW_CONFIDENCE = 1;
    public static final int HIGH_CONFIDENCE = 2;

    public static Info findPC(Address pc, LoadObject lo, CDebugger dbg) {
        if (lo == null) {
            return new Info(null, -1L, 1);
        }
        BlockSym sym = lo.debugInfoForPC(pc);
        while (sym != null) {
            if (!sym.isFunction()) continue;
            return new Info(sym.toString(), pc.minus(sym.getAddress()), 2);
        }
        int confidence = 2;
        ClosestSymbol cs = lo.closestSymbolToPC(pc);
        if (cs != null) {
            return new Info(cs.getName() + "()", cs.getOffset(), 1);
        }
        return new Info(dbg.getNameOfFile(lo.getName()).toUpperCase() + "! " + pc + "()", -1L, 2);
    }

    public static class Info {
        private String name;
        private long offset;
        private int confidence;

        public Info(String name, long offset, int confidence) {
            this.name = name;
            this.offset = offset;
            this.confidence = confidence;
        }

        public String getName() {
            return this.name;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getConfidence() {
            return this.confidence;
        }
    }
}

