/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.net.URI;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.Extension;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.security.provider.certpath.CertPathChecker;

public abstract class PKIXRevocationChecker
extends PKIXCertPathChecker
implements CertPathChecker {
    private URI ocspResponder;
    private X509Certificate ocspResponderCert;
    private List<Extension> ocspExtensions = Collections.emptyList();
    private Map<X509Certificate, byte[]> ocspStapled = Collections.emptyMap();
    private Set<Option> options = Collections.emptySet();

    protected PKIXRevocationChecker() {
    }

    public void setOCSPResponder(URI uRI) {
        this.ocspResponder = uRI;
    }

    public URI getOCSPResponder() {
        return this.ocspResponder;
    }

    public void setOCSPResponderCert(X509Certificate x509Certificate) {
        this.ocspResponderCert = x509Certificate;
    }

    public X509Certificate getOCSPResponderCert() {
        return this.ocspResponderCert;
    }

    public void setOCSPExtensions(List<Extension> list) {
        this.ocspExtensions = list == null ? Collections.emptyList() : new ArrayList<Extension>(list);
    }

    public List<Extension> getOCSPExtensions() {
        return Collections.unmodifiableList(this.ocspExtensions);
    }

    public void setOCSPStapledResponses(Map<X509Certificate, byte[]> map) {
        if (map == null) {
            this.ocspStapled = Collections.emptyMap();
        } else {
            HashMap<X509Certificate, byte[]> hashMap = new HashMap<X509Certificate, byte[]>(map.size());
            for (Map.Entry<X509Certificate, byte[]> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), (byte[])entry.getValue().clone());
            }
            this.ocspStapled = hashMap;
        }
    }

    public Map<X509Certificate, byte[]> getOCSPStapledResponses() {
        HashMap<X509Certificate, byte[]> hashMap = new HashMap<X509Certificate, byte[]>(this.ocspStapled.size());
        for (Map.Entry<X509Certificate, byte[]> entry : this.ocspStapled.entrySet()) {
            hashMap.put(entry.getKey(), (byte[])entry.getValue().clone());
        }
        return hashMap;
    }

    public void setOptions(Set<Option> set) {
        this.options = set == null ? Collections.emptySet() : new HashSet<Option>(set);
    }

    public Set<Option> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    @Override
    public Object clone() {
        PKIXRevocationChecker pKIXRevocationChecker = (PKIXRevocationChecker)super.clone();
        pKIXRevocationChecker.ocspExtensions = new ArrayList<Extension>(this.ocspExtensions);
        pKIXRevocationChecker.ocspStapled = new HashMap<X509Certificate, byte[]>(this.ocspStapled);
        for (Map.Entry<X509Certificate, byte[]> entry : pKIXRevocationChecker.ocspStapled.entrySet()) {
            byte[] byArray = entry.getValue();
            entry.setValue((byte[])byArray.clone());
        }
        pKIXRevocationChecker.options = new HashSet<Option>(this.options);
        return pKIXRevocationChecker;
    }

    @Override
    public void check(Certificate certificate) throws CertPathValidatorException {
        this.check(certificate, Collections.emptySet());
    }

    public static enum Option {
        ONLY_END_ENTITY,
        PREFER_CRLS,
        SOFT_FAIL;

    }
}

