/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Calendar;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAEncTSEnc;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbAsReq {
    private ASReq asReqMessg;
    private boolean DEBUG = Krb5.DEBUG;

    public KrbAsReq(EncryptionKey encryptionKey, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses) throws KrbException, IOException {
        Cloneable cloneable;
        Object object;
        Object object2;
        if (kDCOptions == null) {
            kDCOptions = new KDCOptions();
        }
        if (kDCOptions.get(2) || kDCOptions.get(4) || kDCOptions.get(28) || kDCOptions.get(30) || kDCOptions.get(31)) {
            throw new KrbException(101);
        }
        if (!kDCOptions.get(6) && kerberosTime != null) {
            kerberosTime = null;
        }
        PAData[] pADataArray = null;
        if (encryptionKey != null) {
            object2 = new PAEncTSEnc();
            object = ((PAEncTSEnc)object2).asn1Encode();
            cloneable = new EncryptedData(encryptionKey, (byte[])object, 1);
            pADataArray = new PAData[]{new PAData(2, ((EncryptedData)cloneable).asn1Encode())};
        }
        if (principalName.getRealm() == null) {
            throw new RealmException(601, "default realm not specified ");
        }
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq creating message");
        }
        object2 = Config.getInstance();
        if (hostAddresses == null && ((Config)object2).useAddresses()) {
            hostAddresses = HostAddresses.getLocalAddresses();
        }
        if (principalName2 == null) {
            object = principalName.getRealmAsString();
            principalName2 = PrincipalName.tgsService((String)object, (String)object);
        }
        if (kerberosTime2 == null) {
            object = ((Config)object2).get("libdefaults", "ticket_lifetime");
            if (object != null) {
                cloneable = Calendar.getInstance();
                ((Calendar)cloneable).add(13, Config.duration((String)object));
                kerberosTime2 = new KerberosTime(((Calendar)cloneable).getTime());
            } else {
                kerberosTime2 = new KerberosTime(0L);
            }
        }
        if (kerberosTime3 == null && (object = (Object)((Config)object2).get("libdefaults", "renew_lifetime")) != null) {
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).add(13, Config.duration((String)object));
            kerberosTime3 = new KerberosTime(((Calendar)cloneable).getTime());
        }
        if (kerberosTime3 != null) {
            kDCOptions.set(8, true);
            if (kerberosTime2.greaterThan(kerberosTime3)) {
                kerberosTime3 = kerberosTime2;
            }
        }
        object = new KDCReqBody(kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, Nonce.value(), nArray, hostAddresses, null, null);
        this.asReqMessg = new ASReq(pADataArray, (KDCReqBody)object);
    }

    byte[] encoding() throws IOException, Asn1Exception {
        return this.asReqMessg.asn1Encode();
    }

    ASReq getMessage() {
        return this.asReqMessg;
    }
}

