/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.lwawt.macosx.CToolkitThreadBlockedHandler;
import sun.lwawt.macosx.HTMLDecodingInputStream;

public class CDataTransferer
extends DataTransferer {
    private static final Map<String, Long> predefinedClipboardNameMap;
    private static final Map<Long, String> predefinedClipboardFormatMap;
    private static final String[] predefinedClipboardNames;
    public static final int CF_UNSUPPORTED = 0;
    public static final int CF_STRING = 1;
    public static final int CF_FILE = 2;
    public static final int CF_TIFF = 3;
    public static final int CF_RICH_TEXT = 4;
    public static final int CF_HTML = 5;
    public static final int CF_PDF = 6;
    public static final int CF_URL = 7;
    public static final int CF_PNG = 10;
    public static final int CF_JPEG = 11;
    public static final Long L_CF_TIFF;
    private static final Long[] imageFormats;
    private static CDataTransferer fTransferer;
    private final ToolkitThreadBlockedHandler handler = new CToolkitThreadBlockedHandler();

    private CDataTransferer() {
    }

    public static synchronized CDataTransferer getInstanceImpl() {
        if (fTransferer == null) {
            fTransferer = new CDataTransferer();
        }
        return fTransferer;
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    @Override
    public boolean isLocaleDependentTextFormat(long l) {
        return l == 1L;
    }

    @Override
    public boolean isFileFormat(long l) {
        return l == 2L;
    }

    @Override
    public boolean isImageFormat(long l) {
        int n = (int)l;
        switch (n) {
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    protected Long[] getImageFormatsAsLongArray() {
        return imageFormats;
    }

    @Override
    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l) throws IOException {
        byte[] byArray = super.translateTransferable(transferable, dataFlavor, l);
        return byArray;
    }

    @Override
    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (l == 5L && dataFlavor.isFlavorTextType()) {
            if (inputStream == null) {
                inputStream = new ByteArrayInputStream(byArray);
                byArray = null;
            }
            inputStream = new HTMLDecodingInputStream(inputStream);
        }
        if (l == 7L && URL.class.equals(dataFlavor.getRepresentationClass())) {
            if (byArray == null) {
                byArray = CDataTransferer.inputStreamToByteArray(inputStream);
                inputStream = null;
            }
            String string = CDataTransferer.getDefaultTextCharset();
            if (transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return new URL(new String(byArray, string));
        }
        if (l == 1L) {
            byArray = Normalizer.normalize(new String(byArray, "UTF8"), Normalizer.Form.NFC).getBytes("UTF8");
        }
        return super.translateBytesOrStream(inputStream, byArray, dataFlavor, l, transferable);
    }

    @Override
    protected synchronized Long getFormatForNativeAsLong(String string) {
        Long l = predefinedClipboardNameMap.get(string);
        if (l == null) {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
                return new Long(-1L);
            }
            l = new Long(this.registerFormatWithPasteboard(string));
            predefinedClipboardNameMap.put(string, l);
            predefinedClipboardFormatMap.put(l, string);
        }
        return l;
    }

    private native long registerFormatWithPasteboard(String var1);

    private native String formatForIndex(long var1);

    @Override
    protected String getNativeForFormat(long l) {
        String string = null;
        if (l >= 0L && l < (long)predefinedClipboardNames.length) {
            string = predefinedClipboardNames[(int)l];
        } else {
            Long l2 = new Long(l);
            string = predefinedClipboardFormatMap.get(l2);
            if (string == null && (string = this.formatForIndex(l)) != null) {
                predefinedClipboardNameMap.put(string, l2);
                predefinedClipboardFormatMap.put(l2, string);
            }
        }
        if (string == null) {
            string = predefinedClipboardNames[0];
        }
        return string;
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    @Override
    protected byte[] imageToPlatformBytes(Image image, long l) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n, n2, null);
        graphics.dispose();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        return this.imageDataToPlatformImageBytes(((DataBufferInt)dataBuffer).getData(), writableRaster.getWidth(), writableRaster.getHeight());
    }

    private static native String[] nativeDragQueryFile(byte[] var0);

    @Override
    protected String[] dragQueryFile(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (new String(byArray).startsWith("Unsupported type")) {
            return null;
        }
        return CDataTransferer.nativeDragQueryFile(byArray);
    }

    private native byte[] imageDataToPlatformImageBytes(int[] var1, int var2, int var3);

    @Override
    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l) throws IOException {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = CDataTransferer.inputStreamToByteArray(inputStream);
        }
        return this.getImageForByteStream(byArray2);
    }

    private native Image getImageForByteStream(byte[] var1);

    @Override
    protected ByteArrayOutputStream convertFileListToBytes(ArrayList<String> arrayList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray = arrayList.get(i).getBytes();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byteArrayOutputStream.write(0);
        }
        return byteArrayOutputStream;
    }

    @Override
    protected boolean isURIListFormat(long l) {
        String string = this.getNativeForFormat(l);
        if (string == null) {
            return false;
        }
        try {
            DataFlavor dataFlavor = new DataFlavor(string);
            if (dataFlavor.getPrimaryType().equals("text") && dataFlavor.getSubType().equals("uri-list")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        predefinedClipboardNames = new String[]{"", "STRING", "FILE_NAME", "TIFF", "RICH_TEXT", "HTML", "PDF", "URL"};
        HashMap<String, Long> hashMap = new HashMap<String, Long>(predefinedClipboardNames.length, 1.0f);
        HashMap<Long, String> hashMap2 = new HashMap<Long, String>(predefinedClipboardNames.length, 1.0f);
        for (int i = 1; i < predefinedClipboardNames.length; ++i) {
            hashMap.put(predefinedClipboardNames[i], new Long(i));
            hashMap2.put(new Long(i), predefinedClipboardNames[i]);
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(hashMap);
        predefinedClipboardFormatMap = Collections.synchronizedMap(hashMap2);
        L_CF_TIFF = predefinedClipboardNameMap.get(predefinedClipboardNames[3]);
        imageFormats = new Long[]{L_CF_TIFF};
    }
}

