/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;

public abstract class LWCursorManager {
    private final AtomicBoolean updatePending = new AtomicBoolean(false);

    protected LWCursorManager() {
    }

    public final void updateCursor() {
        this.updatePending.set(false);
        this.updateCursorImpl();
    }

    public final void updateCursorLater(LWWindowPeer lWWindowPeer) {
        if (this.updatePending.compareAndSet(false, true)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LWCursorManager.this.updateCursor();
                }
            };
            SunToolkit.executeOnEventHandlerThread(lWWindowPeer.getTarget(), runnable);
        }
    }

    private void updateCursorImpl() {
        Cursor cursor;
        Point point = this.getCursorPosition();
        Component component = LWCursorManager.findComponent(point);
        Object object = LWToolkit.targetToPeer(component);
        if (object instanceof LWComponentPeer) {
            LWComponentPeer lWComponentPeer = (LWComponentPeer)object;
            Point point2 = lWComponentPeer.getLocationOnScreen();
            cursor = lWComponentPeer.getCursor(new Point(point.x - point2.x, point.y - point2.y));
        } else {
            cursor = component != null ? component.getCursor() : null;
        }
        this.setCursor(cursor);
    }

    private static final Component findComponent(Point point) {
        LWComponentPeer<?, ?> lWComponentPeer = LWWindowPeer.getPeerUnderCursor();
        Component component = null;
        if (lWComponentPeer != null && lWComponentPeer.getWindowPeerOrSelf().getBlocker() == null) {
            Object object;
            component = (Component)lWComponentPeer.getTarget();
            if (component instanceof Container) {
                object = lWComponentPeer.getLocationOnScreen();
                component = ((Container)component).findComponentAt(point.x - ((Point)object).x, point.y - ((Point)object).y);
            }
            while (component != null) {
                object = AWTAccessor.getComponentAccessor().getPeer(component);
                if (component.isVisible() && component.isEnabled() && object != null) break;
                component = component.getParent();
            }
        }
        return component;
    }

    protected abstract Point getCursorPosition();

    protected abstract void setCursor(Cursor var1);
}

