/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import sun.awt.CGraphicsConfig;
import sun.java2d.NullSurfaceData;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLSurfaceData;
import sun.java2d.opengl.OGLRenderQueue;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.macosx.CFRetainedResource;

public class CGLLayer
extends CFRetainedResource {
    private LWWindowPeer peer;
    private int scale = 1;
    private SurfaceData surfaceData;

    private native long nativeCreateLayer();

    private static native void nativeSetScale(long var0, double var2);

    private static native void validate(long var0, CGLSurfaceData var2);

    private static native void blitTexture(long var0);

    public CGLLayer(LWWindowPeer lWWindowPeer) {
        super(0L, true);
        this.setPtr(this.nativeCreateLayer());
        this.peer = lWWindowPeer;
    }

    public long getPointer() {
        return this.ptr;
    }

    public Rectangle getBounds() {
        return this.peer.getBounds();
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.peer.getGraphicsConfiguration();
    }

    public boolean isOpaque() {
        return !this.peer.isTranslucent();
    }

    public int getTransparency() {
        return this.isOpaque() ? 1 : 3;
    }

    public Object getDestination() {
        return this.peer;
    }

    public SurfaceData replaceSurfaceData() {
        if (this.getBounds().isEmpty()) {
            this.surfaceData = NullSurfaceData.theInstance;
            return this.surfaceData;
        }
        CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
        this.surfaceData = cGraphicsConfig.createSurfaceData(this);
        this.setScale(cGraphicsConfig.getDevice().getScaleFactor());
        if (this.surfaceData instanceof CGLSurfaceData) {
            this.validate((CGLSurfaceData)this.surfaceData);
        }
        return this.surfaceData;
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(final CGLSurfaceData cGLSurfaceData) {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            this.execute(new CFRetainedResource.CFNativeAction(){

                @Override
                public void run(long l) {
                    CGLLayer.validate(l, cGLSurfaceData);
                }
            });
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    @Override
    public void dispose() {
        this.validate(null);
        super.dispose();
    }

    private void setScale(int n) {
        if (this.scale != n) {
            this.scale = n;
            this.execute(new CFRetainedResource.CFNativeAction(){

                @Override
                public void run(long l) {
                    CGLLayer.nativeSetScale(l, CGLLayer.this.scale);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawInCGLContext() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            this.execute(new CFRetainedResource.CFNativeAction(){

                @Override
                public void run(long l) {
                    CGLLayer.blitTexture(l);
                }
            });
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }
}

