/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class VerifyAccess {
    private static final int PACKAGE_ONLY = 0;
    private static final int PACKAGE_ALLOWED = 8;
    private static final int PROTECTED_OR_PACKAGE_ALLOWED = 12;
    private static final int ALL_ACCESS_MODES = 7;
    private static final boolean ALLOW_NESTMATE_ACCESS = false;

    private VerifyAccess() {
    }

    public static boolean isMemberAccessible(Class<?> clazz, Class<?> clazz2, int n, Class<?> clazz3, int n2) {
        if (n2 == 0) {
            return false;
        }
        assert ((n2 & 1) != 0 && (n2 & 0xFFFFFFF0) == 0);
        if (!VerifyAccess.isClassAccessible(clazz, clazz3, n2)) {
            return false;
        }
        if (clazz2 == clazz3 && (n2 & 2) != 0) {
            return true;
        }
        switch (n & 7) {
            case 1: {
                return true;
            }
            case 4: {
                if ((n2 & 0xC) != 0 && VerifyAccess.isSamePackage(clazz2, clazz3)) {
                    return true;
                }
                if ((n2 & 4) == 0) {
                    return false;
                }
                if ((n & 8) != 0 && !VerifyAccess.isRelatedClass(clazz, clazz3)) {
                    return false;
                }
                return (n2 & 4) != 0 && VerifyAccess.isSuperClass(clazz2, clazz3);
            }
            case 0: {
                return (n2 & 8) != 0 && VerifyAccess.isSamePackage(clazz2, clazz3);
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("bad modifiers: " + Modifier.toString(n));
    }

    static boolean isRelatedClass(Class<?> clazz, Class<?> clazz2) {
        return clazz == clazz2 || clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz);
    }

    static boolean isSuperClass(Class<?> clazz, Class<?> clazz2) {
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean isClassAccessible(Class<?> clazz, Class<?> clazz2, int n) {
        if (n == 0) {
            return false;
        }
        assert ((n & 1) != 0 && (n & 0xFFFFFFF0) == 0);
        int n2 = clazz.getModifiers();
        if (Modifier.isPublic(n2)) {
            return true;
        }
        return (n & 8) != 0 && VerifyAccess.isSamePackage(clazz2, clazz);
    }

    public static boolean isTypeVisible(Class<?> clazz, Class<?> clazz2) {
        ClassLoader classLoader;
        if (clazz == clazz2) {
            return true;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive() || clazz == Object.class) {
            return true;
        }
        ClassLoader classLoader2 = clazz.getClassLoader();
        if (classLoader2 == (classLoader = clazz2.getClassLoader())) {
            return true;
        }
        if (classLoader == null && classLoader2 != null) {
            return false;
        }
        if (classLoader2 == null && clazz.getName().startsWith("java.")) {
            return true;
        }
        final String string = clazz.getName();
        Class clazz3 = AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(string, false, classLoader);
                }
                catch (ClassNotFoundException | LinkageError throwable) {
                    return null;
                }
            }
        });
        return clazz == clazz3;
    }

    public static boolean isTypeVisible(MethodType methodType, Class<?> clazz) {
        int n = methodType.parameterCount();
        for (int i = -1; i < n; ++i) {
            Class<?> clazz2;
            Class<?> clazz3 = clazz2 = i < 0 ? methodType.returnType() : methodType.parameterType(i);
            if (VerifyAccess.isTypeVisible(clazz2, clazz)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSamePackage(Class<?> clazz, Class<?> clazz2) {
        assert (!clazz.isArray() && !clazz2.isArray());
        if (clazz == clazz2) {
            return true;
        }
        if (clazz.getClassLoader() != clazz2.getClassLoader()) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        if (n != string2.lastIndexOf(46)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String getPackageName(Class<?> clazz) {
        assert (!clazz.isArray());
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static boolean isSamePackageMember(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (!VerifyAccess.isSamePackage(clazz, clazz2)) {
            return false;
        }
        return VerifyAccess.getOutermostEnclosingClass(clazz) == VerifyAccess.getOutermostEnclosingClass(clazz2);
    }

    private static Class<?> getOutermostEnclosingClass(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<?> clazz3 = clazz;
        while ((clazz3 = clazz3.getEnclosingClass()) != null) {
            clazz2 = clazz3;
        }
        return clazz2;
    }

    private static boolean loadersAreRelated(ClassLoader classLoader, ClassLoader classLoader2, boolean bl) {
        ClassLoader classLoader3;
        if (classLoader == classLoader2 || classLoader == null || classLoader2 == null && !bl) {
            return true;
        }
        for (classLoader3 = classLoader2; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader) continue;
            return true;
        }
        if (bl) {
            return false;
        }
        for (classLoader3 = classLoader; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader2) continue;
            return true;
        }
        return false;
    }

    public static boolean classLoaderIsAncestor(Class<?> clazz, Class<?> clazz2) {
        return VerifyAccess.loadersAreRelated(clazz.getClassLoader(), clazz2.getClassLoader(), true);
    }
}

