/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.lang.reflect.Method;

public abstract class Metrics {
    public static Metrics systemMetrics() {
        try {
            Class<?> clazz = Class.forName("jdk.internal.platform.cgroupv1.Metrics");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return (Metrics)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException.getMessage());
        }
    }

    public abstract String getProvider();

    public abstract long getCpuUsage();

    public abstract long[] getPerCpuUsage();

    public abstract long getCpuUserUsage();

    public abstract long getCpuSystemUsage();

    public abstract long getCpuPeriod();

    public abstract long getCpuQuota();

    public abstract long getCpuShares();

    public abstract long getCpuNumPeriods();

    public abstract long getCpuNumThrottled();

    public abstract long getCpuThrottledTime();

    public abstract long getEffectiveCpuCount();

    public abstract int[] getCpuSetCpus();

    public abstract int[] getEffectiveCpuSetCpus();

    public abstract int[] getCpuSetMems();

    public abstract int[] getEffectiveCpuSetMems();

    public abstract double getCpuSetMemoryPressure();

    public abstract boolean isCpuSetMemoryPressureEnabled();

    public abstract long getMemoryFailCount();

    public abstract long getMemoryLimit();

    public abstract long getMemoryMaxUsage();

    public abstract long getMemoryUsage();

    public abstract long getKernelMemoryFailCount();

    public abstract long getKernelMemoryLimit();

    public abstract long getKernelMemoryMaxUsage();

    public abstract long getKernelMemoryUsage();

    public abstract long getTcpMemoryFailCount();

    public abstract long getTcpMemoryLimit();

    public abstract long getTcpMemoryMaxUsage();

    public abstract long getTcpMemoryUsage();

    public abstract long getMemoryAndSwapFailCount();

    public abstract long getMemoryAndSwapLimit();

    public abstract long getMemoryAndSwapMaxUsage();

    public abstract long getMemoryAndSwapUsage();

    public abstract boolean isMemoryOOMKillEnabled();

    public abstract long getMemorySoftLimit();

    public abstract long getBlkIOServiceCount();

    public abstract long getBlkIOServiced();
}

