/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.WeakCache;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.ProxyGenerator;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Class<?>[] constructorParams = new Class[]{InvocationHandler.class};
    private static final WeakCache<ClassLoader, Class<?>[], Class<?>> proxyClassCache = new WeakCache(new KeyFactory(), new ProxyClassFactory());
    protected InvocationHandler h;
    private static final Object key0 = new Object();

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.doNewInstanceCheck();
        this.h = invocationHandler;
    }

    private void doNewInstanceCheck() {
        SecurityManager securityManager = System.getSecurityManager();
        Class<?> clazz = this.getClass();
        if (securityManager != null && ProxyAccessHelper.needsNewInstanceCheck(clazz)) {
            try {
                securityManager.checkPermission(ProxyAccessHelper.PROXY_PERMISSION);
            }
            catch (SecurityException securityException) {
                throw new SecurityException("Not allowed to construct a Proxy instance that implements a non-public interface", securityException);
            }
        }
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) throws IllegalArgumentException {
        Class[] classArray2 = (Class[])classArray.clone();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), classLoader, classArray2);
        }
        return Proxy.getProxyClass0(classLoader, classArray2);
    }

    private static void checkProxyAccess(Class<?> clazz, ClassLoader classLoader, Class<?> ... classArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader classLoader2 = clazz.getClassLoader();
            if (classLoader == null && classLoader2 != null && !ProxyAccessHelper.allowNullLoader) {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            ReflectUtil.checkProxyPackageAccess(classLoader2, classArray);
        }
    }

    private static Class<?> getProxyClass0(ClassLoader classLoader, Class<?> ... classArray) {
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        return proxyClassCache.get(classLoader, classArray);
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        Class[] classArray2 = (Class[])classArray.clone();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), classLoader, classArray2);
        }
        Class<?> clazz = Proxy.getProxyClass0(classLoader, classArray2);
        try {
            final Constructor<?> constructor = clazz.getConstructor(constructorParams);
            final InvocationHandler invocationHandler2 = invocationHandler;
            if (securityManager != null && ProxyAccessHelper.needsNewInstanceCheck(clazz)) {
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return Proxy.newInstance(constructor, invocationHandler2);
                    }
                });
            }
            return Proxy.newInstance(constructor, invocationHandler2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
    }

    private static Object newInstance(Constructor<?> constructor, InvocationHandler invocationHandler) {
        try {
            return constructor.newInstance(invocationHandler);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InternalError(throwable.toString());
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return Proxy.class.isAssignableFrom(clazz) && proxyClassCache.containsValue(clazz);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        InvocationHandler invocationHandler = proxy.h;
        if (System.getSecurityManager() != null) {
            Class<?> clazz = invocationHandler.getClass();
            Class clazz2 = Reflection.getCallerClass();
            if (ReflectUtil.needsPackageAccessCheck(clazz2.getClassLoader(), clazz.getClassLoader())) {
                ReflectUtil.checkPackageAccess(clazz);
            }
        }
        return invocationHandler;
    }

    private static native Class<?> defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    private static final class ProxyClassFactory
    implements WeakCache.BiFunction<ClassLoader, Class<?>[], Class<?>> {
        private static final String proxyClassNamePrefix = "$Proxy";
        private static final AtomicLong nextUniqueNumber = new AtomicLong();

        private ProxyClassFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> apply(ClassLoader classLoader, Class<?>[] classArray) {
            void var4_9;
            void var4_6;
            Class<?> clazz3;
            IdentityHashMap identityHashMap = new IdentityHashMap(classArray.length);
            for (Class<?> clazz2 : classArray) {
                clazz3 = null;
                try {
                    clazz3 = Class.forName(clazz2.getName(), false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz3 != clazz2) {
                    throw new IllegalArgumentException(clazz2 + " is not visible from class loader");
                }
                if (!clazz3.isInterface()) {
                    throw new IllegalArgumentException(clazz3.getName() + " is not an interface");
                }
                if (identityHashMap.put(clazz3, Boolean.TRUE) == null) continue;
                throw new IllegalArgumentException("repeated interface: " + clazz3.getName());
            }
            Object var4_5 = null;
            for (Class<?> clazz3 : classArray) {
                String string;
                int n = clazz3.getModifiers();
                if (Modifier.isPublic(n)) continue;
                String string2 = clazz3.getName();
                int n2 = string2.lastIndexOf(46);
                String string3 = string = n2 == -1 ? "" : string2.substring(0, n2 + 1);
                if (var4_6 == null) {
                    String string4 = string;
                    continue;
                }
                if (string.equals(var4_6)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (var4_6 == null) {
                String string = "com.sun.proxy.";
            }
            long l = nextUniqueNumber.getAndIncrement();
            String string = (String)var4_9 + proxyClassNamePrefix + l;
            clazz3 = (Class<?>)ProxyGenerator.generateProxyClass(string, classArray);
            try {
                return Proxy.defineClass0(classLoader, string, (byte[])clazz3, 0, ((Object)clazz3).length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
        }
    }

    private static final class KeyFactory
    implements WeakCache.BiFunction<ClassLoader, Class<?>[], Object> {
        private KeyFactory() {
        }

        @Override
        public Object apply(ClassLoader classLoader, Class<?>[] classArray) {
            switch (classArray.length) {
                case 1: {
                    return new Key1(classArray[0]);
                }
                case 2: {
                    return new Key2(classArray[0], classArray[1]);
                }
                case 0: {
                    return key0;
                }
            }
            return new KeyX(classArray);
        }
    }

    private static final class KeyX {
        private final int hash;
        private final WeakReference<Class<?>>[] refs;

        KeyX(Class<?>[] classArray) {
            this.hash = Arrays.hashCode(classArray);
            this.refs = new WeakReference[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                this.refs[i] = new WeakReference(classArray[i]);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return this == object || object != null && object.getClass() == KeyX.class && KeyX.equals(this.refs, ((KeyX)object).refs);
        }

        private static boolean equals(WeakReference<Class<?>>[] weakReferenceArray, WeakReference<Class<?>>[] weakReferenceArray2) {
            if (weakReferenceArray.length != weakReferenceArray2.length) {
                return false;
            }
            for (int i = 0; i < weakReferenceArray.length; ++i) {
                Class clazz = (Class)weakReferenceArray[i].get();
                if (clazz != null && clazz == weakReferenceArray2[i].get()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Key2
    extends WeakReference<Class<?>> {
        private final int hash;
        private final WeakReference<Class<?>> ref2;

        Key2(Class<?> clazz, Class<?> clazz2) {
            super(clazz);
            this.hash = 31 * clazz.hashCode() + clazz2.hashCode();
            this.ref2 = new WeakReference(clazz2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Class clazz;
            Class clazz2;
            return this == object || object != null && object.getClass() == Key2.class && (clazz2 = (Class)this.get()) != null && clazz2 == ((Key2)object).get() && (clazz = (Class)this.ref2.get()) != null && clazz == ((Key2)object).ref2.get();
        }
    }

    private static final class Key1
    extends WeakReference<Class<?>> {
        private final int hash;

        Key1(Class<?> clazz) {
            super(clazz);
            this.hash = clazz.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Class clazz;
            return this == object || object != null && object.getClass() == Key1.class && (clazz = (Class)this.get()) != null && clazz == ((Key1)object).get();
        }
    }

    private static class ProxyAccessHelper {
        static final Permission PROXY_PERMISSION = new ReflectPermission("proxyConstructorNewInstance");
        static final boolean allowNewInstance = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNewInstance");
        static final boolean allowNullLoader = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNullLoader");

        private ProxyAccessHelper() {
        }

        private static boolean getBooleanProperty(final String string) {
            String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(string);
                }
            });
            return Boolean.valueOf(string2);
        }

        static boolean needsNewInstanceCheck(Class<?> clazz) {
            if (!Proxy.isProxyClass(clazz) || allowNewInstance) {
                return false;
            }
            if (ReflectUtil.isNonPublicProxyClass(clazz)) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (Modifier.isPublic(clazz2.getModifiers())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

