/*
 * Copyright (C) 2021 Tai Chi Minh Ralph Eastwood
 * All rights reserved
 *
 * This file is part of zsv/lib, distributed under the license defined at
 * https://opensource.org/licenses/MIT
 */

#ifndef ZSV_UTILS_COMPILER
#define ZSV_UTILS_COMPILER

#ifndef LIKELY
# define LIKELY(x) __builtin_expect(x, 1)
#endif

#ifndef UNLIKELY
# define UNLIKELY(x) __builtin_expect(x, 0)
#endif

#ifndef VERY_LIKELY
# ifdef NO___BUILTIN_EXPECT_WITH_PROBABILITY
#  define VERY_LIKELY(x) LIKELY(x)
# else
#  define VERY_LIKELY(x) __builtin_expect_with_probability(x, 1, 0.999)
# endif
#endif

#ifndef VERY_UNLIKELY
# ifdef NO___BUILTIN_EXPECT_WITH_PROBABILITY
#  define VERY_UNLIKELY(x) UNLIKELY(x)
# else
#  define VERY_UNLIKELY(x) __builtin_expect_with_probability(x, 0, 0.999)
# endif
#endif

#endif
