/*
 * Copyright 2006-2008 The FLWOR Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once
#ifndef SYNCHRONOUS_LOGGER
#define SYNCHRONOUS_LOGGER

#include "zorba/config.h"
#include "zorba/zorba_string.h"
#include "zorbautils/lock.h"

#include <iostream>
#include <string>

namespace zorba {

class ZORBA_DLL_PUBLIC SynchronousLogger {

  public:
    SynchronousLogger(std::ostream &stream);

    SynchronousLogger& operator<<(const long input);
    SynchronousLogger& operator<<(const zorba::String input);

  private:
    std::ostream &m_stream;
};

SYNC_CODE(static Lock m_lock;)
static SynchronousLogger cerr(std::cerr);
static SynchronousLogger clog(std::clog);
static SynchronousLogger cout(std::cout);

}

#endif // SYNCHRONOUS_LOGGER

/* vim:set et sw=2 ts=2: */
