/**
 * Copyright 2006-2013 The FLWOR Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 /*
  * THIS FILE IS GENERATED.
  * PLEASE DO NOT EDIT.
  */

#include "stdafx.h"
#include "zorba/config.h"
#include "diagnostics/dict_impl.h"

namespace zorba {
namespace diagnostic {
namespace dict {

extern entry const dict_en[] = {
  { "csv:EXTRA_VALUE", "\"$1\": extra value detected on line $2" },
  { "csv:INVALID_OPTION", "${\"1\": }invalid value for \"$2\" option${; 3}" },
  { "csv:INVALID_VALUE", "\"$1\": invalid type for value of key \"$2\"" },
  { "csv:MISSING_VALUE", "$1" },
  { "dt:INCOMPLETE_DATE_OR_TIME", "'$1': incomplete date, time, or dateTime format" },
  { "dt:INSUFFICIENT_BUFFER", "\"$1\": insufficient value to parse for \"$2\"" },
  { "dt:INVALID_LOCALE", "\"$1\": invalid locale" },
  { "dt:INVALID_SPECIFICATION", "'$1': invalid % conversion specification" },
  { "dt:INVALID_VALUE", "\"$1\": invalid value for conversion specification(s) %$2" },
  { "dt:LITERAL_MISMATCH", "'$1': literal character mismatched '$2'" },
  { "dt:UNKNOWN_LOCALE", "\"$1\": unknown locale" },
  { "dt:UNSUPPORTED_LOCALE", "\"$1\": unsupported locale" },
  { "err:FOAR0001", "division by zero" },
  { "err:FOAR0002", "numeric operation overflow/underflow${: 1}" },
  { "err:FOCA0001", "\"$1\": value too large for decimal" },
  { "err:FOCA0002", "$1" },
  { "err:FOCA0003", "\"$1\": value${ of type 2} too large for $3?3:{integer}" },
  { "err:FOCA0005", "NaN supplied as float/double value" },
  { "err:FOCA0006", "\"$1\": string to be cast to decimal has too many digits of precision" },
  { "err:FOCH0001", "\"$1\": invalid code point" },
  { "err:FOCH0002", "\"$1\": unsuported collation${: 2}" },
  { "err:FOCH0003", "\"$1\": unsupported normalization form" },
  { "err:FOCH0004", "\"$1\": collation does not support collation units" },
  { "err:FOCZ0001", "invalid content passed to $1: $2" },
  { "err:FODC0001", "no context document for $1() function" },
  { "err:FODC0002", "\"$1\": error retrieving resource${: 2}" },
  { "err:FODC0003", "$1 function result not guaranteed deterministic" },
  { "err:FODC0004", "\"$1\": invalid argument to fn:collection()${: 2}" },
  { "err:FODC0005", "\"$1\": invalid argument to fn:doc() or fn:doc-available()" },
  { "err:FODC0006", "invalid content passed to $1: $2" },
  { "err:FODC0007", "\"$1\": base URI passed to fn:parse() is not a valid absolute URI" },
  { "err:FODF1280", "\"$1\": invalid decimal format name for fn:format-number()" },
  { "err:FODF1310", "\"$1\": invalid picture string for decimal/integer${: 2}" },
  { "err:FODT0001", "overflow/underflow in date/time operation${: 1}" },
  { "err:FODT0002", "overflow/underflow in duration operation${: 1}" },
  { "err:FODT0003", "\"$1\": invalid timezone value (in seconds)" },
  { "err:FOER0000", "unidentifier error" },
  { "err:FOFD1340", "\"$1\": invalid \\$$2 argument for date/time${: 3}" },
  { "err:FOFD1350", "\"$1\": component specifier not available" },
  { "err:FOFL0001", "dynamic call on context-dependent function item" },
  { "err:FONS0004", "\"$1\": no namespace found for prefix" },
  { "err:FONS0005", "base-URI not defined in the static context" },
  { "err:FORG0001", "$1" },
  { "err:FORG0002", "\"$1\": invalid argument to fn:resolve-uri()${: 2}" },
  { "err:FORG0003", "fn:zero-or-one() called with a sequnce containing more than one item" },
  { "err:FORG0004", "fn:one-or-more() called with a sequence containing no items" },
  { "err:FORG0005", "fn:exactly-one() called with a sequence containing zero or more than one item" },
  { "err:FORG0006", "$1" },
  { "err:FORG0008", "\"$1\" and \"$2\": two arguments to fn:dateTime() have inconsistent timezones" },
  { "err:FORG0009", "error resolving a relative URI against a base URI in fn:resolve-uri()${: 1}" },
  { "err:FORX0001", "'$1': invalid regular expression flag" },
  { "err:FORX0002", "\"$1\": invalid regular expression${: 2}" },
  { "err:FORX0003", "\"$1\": regular expression matches zero-length string" },
  { "err:FORX0004", "\"$1\": invalid replacement string${: 2}" },
  { "err:FOTY0012", "\"$1\": element node of type $2 does not have a typed value" },
  { "err:FOTY0013", "\"$1\": function item passed as argument to fn:data()" },
  { "err:FOTY0014", "\"$1\": argument to fn:string() is a function item" },
  { "err:FOTY0015", "\"$1\": argument to fn:deep-equal() contains a function item" },
  { "err:FOUP0001", "first operand of fn:put() is not a node of a supported kind" },
  { "err:FOUP0002", "second operand of fn:put() is not a valid lexical representation of the xs:anyURI type" },
  { "err:FOUT1170", "\"$1\": error retrieving resource containing text" },
  { "err:FOUT1190", "\"$1\": can not decode resource retrieved" },
#if !defined(ZORBA_NO_FULL_TEXT)
  { "err:FTDY0016", "\"$1\": invalid weight: absolute value must be in [0,1000]" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "err:FTDY0017", "mild-not contains StringExclude" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "err:FTDY0020", "${\"1\": }invalid wildcard syntax${: 2}" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "err:FTST0008", "\"$1\": unknown stop-word list" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "err:FTST0009", "\"$1\": unsupported language${ 2}" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "err:FTST0018", "\"$1\": unknown thesaurus" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "err:FTST0019", "\"$1\": match option specified more than once" },
#endif
  { "err:SENR0001", "\"$1\": can not serialize $2" },
  { "err:SEPM0004", "doctype-system parameter, or standalone parameter with a value other than \"omit\", specified" },
  { "err:SEPM0009", "omit-xml-declaration parameter is \"yes\" and $1" },
  { "err:SEPM0010", "the output method is \"xml\", the value of the undeclare-prefixes parameter is \"yes\", and the value of the version parameter is \"1.0\"" },
  { "err:SEPM0016", "\"$1\": value for parameter \"$2\" invalid${; 3}" },
  { "err:SERE0003", "serializer can't satisfy the rules for either a well-formed XML document entity or a well-formed XML external general parsed entity" },
  { "err:SERE0005", "invalid NCName character" },
  { "err:SERE0006", "\"$1\": invalid character for XML version $2" },
  { "err:SERE0008", "\"$1\": can not encode character as character reference here" },
  { "err:SERE0012", "normalization-form parameter value is fully-normalized and any relevant construct of the result begins with a combining character" },
  { "err:SERE0014", "\"#$1\": character not allowed for HTML output method" },
  { "err:SERE0015", "can not use '>' within processing instruction for HTML output method" },
  { "err:SESU0007", "\"$1\": unsupported encoding" },
  { "err:SESU0011", "\"$1\": unsupported normalization form" },
  { "err:SESU0013", "\"$1\": unsupported $2 version; supported versions are: $3" },
  { "err:XPDY0002", "$1" },
  { "err:XPDY0050", "\"$1\" cannot be treated as type $2" },
  { "err:XPST0001", "${\"1\": }undefined value${: 2}" },
  { "err:XPST0003", "invalid expression${: 1}" },
  { "err:XPST0005", "static type must not be empty-sequence()" },
  { "err:XPST0008", "$1" },
  { "err:XPST0017", "\"$1\": $2" },
  { "err:XPST0051", "$1" },
  { "err:XPST0080", "\"$1\": invalid type for \"cast\" or \"castable\" exression" },
  { "err:XPST0081", "\"$1\": can not expand prefix of lexical QName to namespace URI" },
  { "err:XPST0083", "\"$1\": not a string literal" },
  { "err:XPTY0004", "$1" },
  { "err:XPTY0018", "path expression last step must not have nodes and atomic values" },
  { "err:XPTY0019", "a non-last axis step produces non-node items" },
  { "err:XPTY0020", "context item in axis step is not a node" },
  { "err:XPTY0117", "$1" },
  { "err:XQDY0025", "\"$1\": duplicate attribute name" },
  { "err:XQDY0026", "computed processing instrucion must not contain \"?>\"" },
  { "err:XQDY0027", "\"$1\": unexpected validity property${: 2}" },
  { "err:XQDY0041", "can not cast to xs:NCName" },
  { "err:XQDY0044", "\"$1\": invalid attibute node-name" },
  { "err:XQDY0054", "${\"1\": }variable must not depend on itself" },
  { "err:XQDY0061", "invalid validate expression operand${: 1}" },
  { "err:XQDY0064", "\"XML\": invalid name expression" },
  { "err:XQDY0072", "comment must not contain \"--\" or end with \"-\"" },
  { "err:XQDY0074", "$1" },
  { "err:XQDY0084", "validated element does not have a top-level element declaration in the in-scope element declarations${: 1}" },
  { "err:XQDY0091", "\"xml:id\" encountered" },
  { "err:XQDY0092", "\"$1\": must be either \"preserve\" or \"default\"" },
  { "err:XQDY0096", "\"$1\": invalid node-name" },
  { "err:XQDY0101", "Invalid prefix and/or uri in computed namespace constructor: prefix = $1, namespace URI = $2." },
  { "err:XQDY0102", "\"$1\": uri causes namespace binding conflict: prefix $2 already bound to $3" },
  { "err:XQST0009", "schema import not supported" },
  { "err:XQST0012", "invalid schema definitions" },
  { "err:XQST0013", "invalid pragma content" },
  { "err:XQST0022", "namespace declaration attribute is not a URI literal" },
  { "err:XQST0031", "$1" },
  { "err:XQST0032", "multiple base URI declarations" },
  { "err:XQST0033", "\"$1\": namespace prefix already bound to \"$2\"" },
  { "err:XQST0034", "\"$1\": duplicate function declaration" },
  { "err:XQST0035", "\"$1\": name previosly imported" },
  { "err:XQST0036", "$1" },
  { "err:XQST0038", "multiple default collation declarations" },
  { "err:XQST0039", "\"$1\": duplicate parameter name" },
  { "err:XQST0040", "\"$1\": non-distinct expanded attribute QName" },
  { "err:XQST0045", "$1" },
  { "err:XQST0046", "${\"1\": }invalid URI literal${: 2}" },
  { "err:XQST0047", "\"$1\": duplicate target namespace" },
  { "err:XQST0048", "\"$1\": QName not in library namespace" },
  { "err:XQST0049", "\"$1\": duplicate variable declaration" },
  { "err:XQST0052", "\"$1\": not defined as simple type" },
  { "err:XQST0054", "${\"1\": }variable must not depend on itself" },
  { "err:XQST0055", "multiple copy-namespaces declarations" },
  { "err:XQST0057", "schema import with empty target namespace" },
  { "err:XQST0058", "duplicate import of schema with target namespace \"$1\"" },
  { "err:XQST0059", "$1" },
  { "err:XQST0060", "\"$1\": function name is in no namespace" },
  { "err:XQST0065", "multiple ordering mode declarations" },
  { "err:XQST0066", "multiple element/type/function namespace declarations" },
  { "err:XQST0067", "multiple construction declarations" },
  { "err:XQST0068", "multiple boundary-space declarations" },
  { "err:XQST0069", "multiple empty order declarations" },
  { "err:XQST0070", "$1" },
  { "err:XQST0071", "\"$1\": duplicate namespace declaration attribute" },
  { "err:XQST0076", "\"$1\": unknown collation" },
  { "err:XQST0079", "unknown pragma or empty expression" },
  { "err:XQST0085", "namespace URI is empty" },
  { "err:XQST0087", "\"$1\": invalid encoding" },
  { "err:XQST0088", "empty target namespace in module import or module declaration" },
  { "err:XQST0089", "\"$1\": duplicate variable name" },
  { "err:XQST0090", "\"$1\": invalid character reference in XML $2" },
  { "err:XQST0093", "\"$1\": module must not depend on itself" },
  { "err:XQST0094", "\"$1\": grouping variable not defined in the same flwor expression as the group-by clause" },
  { "err:XQST0097", "\"$1\": illegal value for decimal format property \"$2\"${: 3}" },
  { "err:XQST0098", "\"$1\": value of properties \"$1\" and \"$2\" for characters used a in picture string is the same but must be distinct" },
  { "err:XQST0099", "module contains more than one context item declaration" },
  { "err:XQST0103", "$1: non-distinct variable in window clause" },
  { "err:XQST0106", "$1" },
  { "err:XQST0111", "$1" },
  { "err:XQST0113", "context item declaration with initializing expression not allowed in library module" },
  { "err:XQST0114", "\"$1\": duplicate decimal format property" },
  { "err:XQST0116", "$1" },
  { "err:XQST0120", "\"$1\": feature not supported" },
  { "err:XQST0122", "$1" },
  { "err:XQST0123", "$1" },
  { "err:XQST0126", "impossible to require all extension features" },
  { "err:XQST0127", "$1 : impossible to require and prohibit at the same time" },
  { "err:XQST0128", "\"$1\": unable to disable a supported feature" },
  { "err:XQTY0024", "element constructor content sequence must not have an attribute node following a non-attribute node" },
  { "err:XQTY0030", "validate argument must be exactly one document or element node" },
  { "err:XQTY0086", "typed value of copied element or attribute node is namespace-sensitive when construction mode is preserve and copy-namespaces mode is no-preserve" },
  { "err:XQTY0105", "element constructor must not contain a function item" },
  { "err:XTDE1310", "\"$1\": picture string does not satisfy format-number() function rules" },
  { "err:XUDY0009", "node has no parent in \"replace\" expression (without \"value of\")" },
  { "err:XUDY0014", "\"modify\" can not modify node not created by \"copy\"" },
  { "err:XUDY0015", "node is target of multiple \"rename\" expressions in same query" },
  { "err:XUDY0016", "node is target of multiple \"replace\" expressions (without \"value of\") in same query" },
  { "err:XUDY0017", "node is target of multiple \"replace value of\" expressions in same query" },
  { "err:XUDY0018", "\"$1\": function declared external, non-updating returns non-empty pending update list" },
  { "err:XUDY0019", "\"$1\": function declared external, updating returns non-empty data model instance" },
  { "err:XUDY0021", "$1${ 2}" },
  { "err:XUDY0023", "\"$1\": uri causes namespace binding conflict: prefix $2 already bound to $3" },
  { "err:XUDY0024", "\"$1\": uri causes namespace binding conflict: prefix $2 already bound to $3" },
  { "err:XUDY0027", "target expression is empty sequence" },
  { "err:XUDY0029", "node has no parent in \"insert\" expression (with \"before\" or \"after\")" },
  { "err:XUDY0030", "insertion of attrhbute node before or after document node child" },
  { "err:XUDY0031", "\"$1\": same URI used in multiple calls to fn:put() in same snapshot" },
  { "err:XUST0001", "$1" },
  { "err:XUST0002", "simple expression not allowed here" },
  { "err:XUST0003", "multiple revalidation declarations" },
  { "err:XUST0028", "\"$1\": function can not be updating with a return type" },
  { "err:XUTY0004", "attribute node follows non-attribute node" },
  { "err:XUTY0005", "target expression not a single element or document node" },
  { "err:XUTY0006", "target expression not a single element, text, comment, or processing instruction node" },
  { "err:XUTY0007", "target expression does not return a sequence of zero or more nodes" },
  { "err:XUTY0008", "target expression not a single element, attribute, text, comment, or processing instruction node" },
  { "err:XUTY0010", "replacement sequence does not consist of zero or more element, text, comment, or processing instruction nodes" },
  { "err:XUTY0011", "replacement sequence does not consist of zero or more attribute nodes" },
  { "err:XUTY0012", "multiple elements, attributes, or processing-instruction nodes returned" },
  { "err:XUTY0013", "source expression of \"copy\" clause must return a single node or json-item" },
  { "err:XUTY0022", "insertion of attribute node into document node" },
  { "jerr:JNDY0003", "\"$1\": pair with the same name already exists in object" },
  { "jerr:JNDY0021", "$1" },
  { "jerr:JNSE0012", "can not serialize multiple top-level items as JSON" },
  { "jerr:JNSE0013", "can not serialize value as JSON: $1" },
  { "jerr:JNSE0014", "can not serialize a node or function item as JSON" },
  { "jerr:JNSE0022", "\"$1\": invalid serialization method for item type ($2)" },
  { "jerr:JNTY0002", "pair value returns no, or more than one, item" },
  { "jerr:JNTY0004", "can not atomize an $1 item: an $1 has probably been passed where an atomic value is expected (e.g., as a key, or to a function expecting an atomic item)" },
  { "jerr:JNTY0011", "JSON item cannot appear in content sequence of node constructor or updating expression" },
  { "jerr:JNTY0018", "object or array selection needs zero or one parameter" },
  { "jerr:JNTY0020", "$1: invalid option type for option $2 (expected $3)" },
  { "jerr:JNTY0021", "$1: invalid json-item() type (expected $2)" },
  { "jerr:JNTY0023", "$1: value of \"$2\" is not a $3" },
  { "jerr:JNTY0024", "$1 items do not have string value" },
  { "jerr:JNUP0005", "\"$1\": duplicate pair to insert" },
  { "jerr:JNUP0006", "\"$1\": pair to insert already exists in object" },
  { "jerr:JNUP0007", "\"$1\": wrong type for object/array selector in update expression" },
  { "jerr:JNUP0008", "$1" },
  { "jerr:JNUP0009", "\"$1\": duplicate pair to replace" },
  { "jerr:JNUP0010", "\"$1\": duplicate pair to rename" },
  { "jerr:JNUP0016", "$1" },
  { "jerr:JNUP0017", "can not replace with less or more than an item" },
  { "jerr:JNUP0019", "\"$1\": invalid type (content of insert expression must evaluate to a sequence of objects)" },
  { "jse:DUPLICATE_PREFIX", "\"$1\": duplicate prefix" },
  { "jse:DUPLICATE_TYPE", "\"$1\": duplicate type name" },
  { "jse:FACET_VIOLATION", "$1" },
  { "jse:ILLEGAL_ARRAY_SIZE", "\\$content facet for \\$array must be array with exactly 1 element" },
  { "jse:ILLEGAL_BASE_TYPE", "\"$1\": illegal base-type${ for \"2\"}$3" },
  { "jse:ILLEGAL_FACET", "\"$1\": illegal facet for $2" },
  { "jse:ILLEGAL_FACET_VALUE", "\"$1\": illegal value for facet $2: $3" },
  { "jse:ILLEGAL_KEY", "\"$1\": illegal key for $2" },
  { "jse:ILLEGAL_NAMESPACE", "\"$1\": illegal explicit namespace for \\$name; if given, must match schema namespace \"$2\"" },
  { "jse:ILLEGAL_PREFIX", "\"$1\": illegal prefix (must not include ':')" },
  { "jse:ILLEGAL_SCHEMA", "\"$1\": illegal schema${ at location \"2\"}: [$3]: $4" },
  { "jse:ILLEGAL_TYPE", "\"$1\": illegal type for $2; must be $3${ or 4}" },
  { "jse:INVALID_OPTION", "${\"1\": }invalid value for \"$2\" option${; 3}" },
  { "jse:MISSING_KEY", "\"$1\": missing key${ for type \"2\"} required" },
  { "jse:NEW_KEY_NOT_ALLOWED", "\"$1\": new key not allowed since \\$open of base-type $2 is false" },
  { "jse:SCHEMA_NOT_FOUND", "\"$1\": could not find schema${ at location \"2\"}${: 3}" },
  { "jse:TYPE_MISMATCH", "\"$1\": type does not match required type of $2${ for 3}" },
  { "jse:TYPE_VIOLATION", "\"$1\": invalid value type; must be $2" },
  { "jse:UNKNOWN_PREFIX", "\"$1\": unknown prefix" },
  { "jse:UNKNOWN_TYPE", "\"$1\": unknown type" },
  { "zerr:XSST0001", "\"$1\": function cannot be declared as both updating and sequential" },
  { "zerr:XSST0002", "\"$1\": function declared sequential but has updating body" },
  { "zerr:XSST0003", "\"$1\": function declared updating but has sequential body" },
  { "zerr:XSST0004", "\"$1\": function declared nonsequential but has sequential body" },
  { "zerr:XSST0005", "expression cannot be both updating and sequential" },
  { "zerr:XSST0006", "sequential expression not allowed here" },
  { "zerr:XSST0007", "\"$1\": variable not assignable" },
  { "zerr:XSST0008", "\"while\" statement with non-sequential body" },
  { "zerr:XSST0009", "\"break loop\" statement not inside while statement" },
  { "zerr:XSST0010", "\"continue loop\" statement not inside while statement" },
  { "zerr:ZAPI0002", "XQuery compilation failed${: 1}" },
  { "zerr:ZAPI0003", "XQuery not compiled" },
  { "zerr:ZAPI0004", "XQuery already compiled" },
  { "zerr:ZAPI0005", "XQuery already executing" },
  { "zerr:ZAPI0006", "XQuery already closed" },
  { "zerr:ZAPI0007", "cannot serialize pul" },
  { "zerr:ZAPI0008", "can not execute a non-updating XQuery" },
  { "zerr:ZAPI0009", "XQuery not compiled in debug mode" },
  { "zerr:ZAPI0011", "\"$1\": undeclared variable" },
  { "zerr:ZAPI0014", "\"$1\": invalid argument${: 2}" },
  { "zerr:ZAPI0015", "\"$1\": createModule() function not found${: 2}" },
  { "zerr:ZAPI0019", "\"$1\": external module already registered" },
  { "zerr:ZAPI0020", "\"$1\": document already exists in store" },
  { "zerr:ZAPI0021", "\"$1\": item to add to the store is not an XML document node" },
  { "zerr:ZAPI0023", "non-atomic value can not be assigned to the context size" },
  { "zerr:ZAPI0024", "\"$1\": wrong type for context size value (must be integer)" },
  { "zerr:ZAPI0025", "non-atomic value can not be assigned to the context position" },
  { "zerr:ZAPI0026", "\"$1\": wrong type for context position value (must be integer)" },
  { "zerr:ZAPI0027", "cannot update dynamic context with iterators" },
  { "zerr:ZAPI0028", "\"$1\": invalid node URI" },
  { "zerr:ZAPI0029", "\"$1\": reference already present in the store" },
  { "zerr:ZAPI0030", "node has no current reference" },
  { "zerr:ZAPI0039", "XQuery has iterator already" },
  { "zerr:ZAPI0040", "iterator is not open" },
  { "zerr:ZAPI0041", "iterator is already open" },
  { "zerr:ZAPI0042", "iterator is closed" },
  { "zerr:ZAPI0043", "cannot serialize JSON item using current output method" },
  { "zerr:ZAPI0045", "cannot serialize sequence containing both JSON and XML items" },
  { "zerr:ZAPI0070", "\"$1\": invalid serialization method for SAX" },
  { "zerr:ZAPI0080", "can not retrieve reference for a JSON object or array that is not in a collection" },
  { "zerr:ZAPI0090", "non root element cannot be validated in place" },
  { "zerr:ZCSE0001", "\"$1\": nonexistent input field" },
  { "zerr:ZCSE0002", "\"$1\": incompatible input field${: type=2}${, class=3}" },
  { "zerr:ZCSE0003", "\"$1\": unrecognized class field" },
  { "zerr:ZCSE0004", "\"$1\": unresolved field reference" },
  { "zerr:ZCSE0005", "class version for \"$1\" ($2) is too new; supported version is $3" },
  { "zerr:ZCSE0006", "class version for \"$1\" ($2) is too old; minimum supported version is $3; use Zorba 0x$4 instead" },
  { "zerr:ZCSE0007", "input archive used for out serialization" },
  { "zerr:ZCSE0008", "output archive used for in serialization" },
  { "zerr:ZCSE0009", "\"$1\": class not serializable" },
  { "zerr:ZCSE0010", "\"$1\": item type not serializable; only atomic, node, function, and error items are supported" },
  { "zerr:ZCSE0011", "input archive not Zorba archive" },
  { "zerr:ZCSE0012", "\"$1\": incompatible archive version; expected \"$2\"" },
  { "zerr:ZCSE0013", "failed to load pre-compiled query${: 1}" },
  { "zerr:ZCSE0014", "cannot save execution plan: infinite circular dependencies" },
  { "zerr:ZCSE0015", "cannot load execution plan: incompatible between 32/64 bits or little/big-endian" },
  { "zerr:ZCSE0016", "cannot load execution plan saved from release mode Zorba into debug mode Zorba" },
  { "zerr:ZCSE0017", "cannot load execution plan saved from debug mode Zorba into release mode Zorba" },
  { "zerr:ZDDY0001", "\"$1\": collection not declared" },
  { "zerr:ZDDY0002", "\"$1\": collection already exists" },
  { "zerr:ZDDY0003", "\"$1\": collection does not exist" },
  { "zerr:ZDDY0004", "\"$1\": can not update constant collection" },
  { "zerr:ZDDY0005", "\"$1\": illegal insert into append-only collection" },
  { "zerr:ZDDY0006", "\"$1\": illegal insert into queue collection" },
  { "zerr:ZDDY0007", "\"$1\": illegal delete from append-only collection" },
  { "zerr:ZDDY0008", "\"$1\": illegal delete from queue collection" },
  { "zerr:ZDDY0009", "\"$1\": not all nodes to delete are at the beginning of this queue collection" },
  { "zerr:ZDDY0010", "\"$1\": illegal update of read-only nodes" },
  { "zerr:ZDDY0011", "\"$1\": collection does not contain node" },
  { "zerr:ZDDY0012", "\"$1\": illegal $2 into unordered collection" },
  { "zerr:ZDDY0013", "\"$1\": can not delete collection because indexes reference it" },
  { "zerr:ZDDY0014", "\"$1\": can not delete collection because integrity constraints reference it" },
  { "zerr:ZDDY0015", "\"$1\": can not delete collection because there are references to its nodes" },
  { "zerr:ZDDY0016", "\"$1\": multiple attemps to create a collection in the same snapshot" },
  { "zerr:ZDDY0017", "node does not belong to any collection" },
  { "zerr:ZDDY0018", "all nodes must be in same collection" },
  { "zerr:ZDDY0019", "\"$1\": iterator on collection is not open" },
  { "zerr:ZDDY0020", "\"$1\": index domain expression yields nodes that are not in collection" },
  { "zerr:ZDDY0021", "\"$1\": undeclared index" },
  { "zerr:ZDDY0022", "\"$1\": index already exists" },
  { "zerr:ZDDY0023", "\"$1\": index does not exist" },
  { "zerr:ZDDY0024", "\"$1\": index uniqueness violation" },
  { "zerr:ZDDY0025", "\"$1\": invalid number of arguments to $2 operation; given $3 expected $4" },
  { "zerr:ZDDY0026", "\"$1\": index range probe not allowed" },
  { "zerr:ZDDY0027", "\"$1\": index multiple creates" },
  { "zerr:ZDDY0028", "\"$1\": index domain has duplicate nodes" },
  { "zerr:ZDDY0029", "\"$1\": index point-general probe not allowed" },
  { "zerr:ZDDY0030", "\"$1\": index range-general probe not allowed" },
  { "zerr:ZDDY0031", "\"$1\": integrity constraint is not declared" },
  { "zerr:ZDDY0032", "\"$1\": integrity constraint is not activated" },
  { "zerr:ZDDY0033", "\"$1\": integrity constraint not met for collection \"$2\"" },
  { "zerr:ZDDY0034", "\"$1\": index range-value probe has search keys with incompatible types" },
  { "zerr:ZDDY0035", "\"$1\": index inserting more than one key not allowed for general index" },
  { "zerr:ZDDY0036", "attempt to delete non-root node from collection \"$1\"" },
  { "zerr:ZDDY0037", "\"$1\": illegal edit in append-only collection" },
  { "zerr:ZDDY0038", "\"$1\": illegal edit from queue collection" },
  { "zerr:ZDDY0039", "attempt to edit non-root node in collection \"$1\"" },
  { "zerr:ZDDY0040", "attempt to edit an item with a template of a different kind (for example an object with a node)." },
  { "zerr:ZDDY0041", "\"$1\": collection was modified while reading" },
  { "zerr:ZDDY0042", "\"$1\": map insertion requires $2 to belong to a collection" },
  { "zerr:ZDDY0043", "\"$1\": invalid type for option \"$2\"" },
  { "zerr:ZDST0001", "\"$1\": collection already declared" },
  { "zerr:ZDST0002", "\"$1\": collection already imported into module \"$2\"" },
  { "zerr:ZDST0003", "\"$1\": collection declaration not allowed in main module" },
  { "zerr:ZDST0004", "collection multiple property values" },
  { "zerr:ZDST0006", "\"$1\": invalid annotation for collection \"$2\"" },
  { "zerr:ZDST0007", "\"$1\": collection declaration in foreign module" },
  { "zerr:ZDST0021", "\"$1\": index already declared" },
  { "zerr:ZDST0022", "\"$1\": index already imported into module \"$2\"" },
  { "zerr:ZDST0023", "\"$1\": index declaration not allowed in main module" },
  { "zerr:ZDST0024", "index multiple property values" },
  { "zerr:ZDST0025", "\"$1\": index cannot be declared as unique" },
  { "zerr:ZDST0026", "index invalid property value" },
  { "zerr:ZDST0027", "\"$1\": $2" },
  { "zerr:ZDST0028", "\"$1\": index not deterministic" },
  { "zerr:ZDST0029", "\"$1\": index invalid data source" },
  { "zerr:ZDST0030", "\"$1\": index non-constant data source" },
  { "zerr:ZDST0031", "\"$1\": index has free vars" },
  { "zerr:ZDST0032", "\"$1\": index references context item" },
  { "zerr:ZDST0033", "\"$1\": index non-simple expression" },
  { "zerr:ZDST0034", "\"$1\": index can not do automatic maintenance" },
  { "zerr:ZDST0035", "\"$1\": number of key expressions for general indexes is restricted to one expression" },
  { "zerr:ZDST0036", "\"$1\": index declaration in foreign module" },
  { "zerr:ZDST0041", "\"$1\": integrity constraint already declared" },
  { "zerr:ZDST0044", "\"$1\": integrity constraint declaration not allowed in main module" },
  { "zerr:ZDST0048", "\"$1\": integrity constraint declaration in foreign module" },
  { "zerr:ZDST0060", "\"$1\": feature not supported; $2" },
  { "zerr:ZDTY0001", "\"$1\": invalid item type in collection \"$2\"" },
  { "zerr:ZDTY0010", "non-node item in domain expression of index $1" },
  { "zerr:ZDTY0011", "item type \"$1\" does not match declared type \"$2\" for key expression of index $3" },
  { "zerr:ZDTY0012", "\"$1\": general range index key item has type for which no ordering relationship exists" },
#if defined(ZORBA_WITH_DEBUGGER)
  { "zerr:ZGDB0001", "" },
#endif
  { "zerr:ZJ2X0001", "JsonML (array form) $1" },
  { "zerr:ZJ2X0002", "JsonML (object form) $1" },
  { "zerr:ZJPE0001", "'$1': illegal JSON character" },
  { "zerr:ZJPE0002", "\"$1\": illegal Unicode code-point" },
  { "zerr:ZJPE0003", "'\\\\$1': illegal JSON character escape" },
  { "zerr:ZJPE0004", "illegal JSON literal" },
  { "zerr:ZJPE0005", "illegal JSON number" },
  { "zerr:ZJPE0006", "\"$1\": unexpected JSON token" },
  { "zerr:ZJPE0007", "unterminated JSON string" },
  { "zerr:ZJPE0008", "\"$1\": illegal QName" },
  { "zerr:ZJPE0009", "illegal empty string" },
  { "zerr:ZJPE0010", "JsonML (array form) must start with '['" },
  { "zerr:ZJSE0001", "JSON serialization requires an element node" },
  { "zerr:ZJSE0002", "\"$1\" element missing required \"$2\" attribute" },
  { "zerr:ZJSE0003", "\"$1\": illegal value for attribute \"$2\"" },
  { "zerr:ZJSE0004", "\"$1\": illegal $2?{child }element/node${ of JSON type \"2\"}${; must be \"3\"}" },
  { "zerr:ZJSE0005", "\"$1\": illegal XML prefix (must be NCName)" },
  { "zerr:ZJSE0007", "\"$1\" element missing required \"$2\" value" },
  { "zerr:ZJSE0008", "\"$1\": illegal value for JSON type \"$2\"" },
  { "zerr:ZJSE0009", "\"$1\": JSON type \"$2\" can not have multiple child nodes" },
  { "zerr:ZOSE0001", "\"$1\": file not found" },
  { "zerr:ZOSE0002", "\"$1\": not plain file" },
  { "zerr:ZOSE0003", "stream read failure" },
  { "zerr:ZOSE0004", "${\"1\": }I/O error${: 2}" },
  { "zerr:ZOSE0005", "\"$1\": error loading dynamic library${: 2}" },
  { "zerr:ZOSE0006", "stream transcoding error ($1)" },
  { "zerr:ZOSE0007", "\"$1\": unsupported locale" },
  { "zerr:ZSTR0001", "\"$1\": index already exists" },
  { "zerr:ZSTR0002", "\"$1\": index does not exist" },
  { "zerr:ZSTR0003", "\"$1\": partial key insertion into index \"$2\"" },
  { "zerr:ZSTR0004", "\"$1\": partial key deletion from index \"$2\"" },
  { "zerr:ZSTR0007", "\"$1\": unsupported probe condition for index \"$2\"" },
  { "zerr:ZSTR0008", "\"$1\": collection already exists" },
  { "zerr:ZSTR0009", "\"$1\": collection not found" },
  { "zerr:ZSTR0010", "can not insert node into colletion \"$1\" because it already belongs to collection \"$2\"" },
  { "zerr:ZSTR0011", "non-root node can not be inserted into collection \"$1\"" },
  { "zerr:ZSTR0012", "non-node item used with collection \"$1\"" },
  { "zerr:ZSTR0013", "an item that is not a node, object, or array is used with collection \"$1\"" },
  { "zerr:ZSTR0015", "\"$1\": integrity constraint already exists" },
  { "zerr:ZSTR0016", "\"$1\": integrity constraint does not exist" },
  { "zerr:ZSTR0020", "loader I/O error${: 1}" },
  { "zerr:ZSTR0021", "\"$1\":$2,$3: loader parsing error${: 4}" },
  { "zerr:ZSTR0030", "NodeID error${: 1}" },
  { "zerr:ZSTR0040", "type error${: 1}" },
  { "zerr:ZSTR0041", "NaN comparison" },
  { "zerr:ZSTR0045", "duplicate node found in sequence" },
  { "zerr:ZSTR0050", "\"$1\" not implemented for item type \"$2\"" },
  { "zerr:ZSTR0055", "streamable string has already been consumed" },
  { "zerr:ZSTR0060", "\"$1\": value out of range${ 2}" },
  { "zerr:ZSTR0065", "Zorba did not close properly, objects may still in memory.\\n$1 referenced URI(s) remain in the string pool.\\nFor help avoiding this message please refer to http://www.zorba-xquery.com/html/documentation in section General Architecture -> Memory Leaks." },
  { "zerr:ZSTR0066", "$1: does not reference a node in collection $2" },
  { "zerr:ZXQD0001", "\"$1\": prefix not declared when calling function \"$2\" from $3" },
  { "zerr:ZXQD0002", "\"$1\": $2" },
  { "zerr:ZXQD0003", "inconsistent options to the parse-xml() function: $1" },
  { "zerr:ZXQD0004", "invalid parameter: $1" },
  { "zerr:ZXQD0005", "key with type $1 not subtype or castable to target type $2 of map ($3)" },
  { "zerr:ZXQD0006", "\"$1\": invalid UTF-8 byte sequence" },
  { "zerr:ZXQP0000", "no error" },
  { "zerr:ZXQP0001", "dynamic runtime error${: 1}" },
  { "zerr:ZXQP0002", "\"$1\": assertion failed${ with the message: 2}" },
  { "zerr:ZXQP0003", "internal error${: 1}" },
  { "zerr:ZXQP0004", "not yet implemented: $1" },
  { "zerr:ZXQP0005", "\"$1\": feature not enabled" },
  { "zerr:ZXQP0006", "\"$1\": unknown character encoding" },
  { "zerr:ZXQP0007", "\"$1\": function signature does not match declaration" },
  { "zerr:ZXQP0008", "\"$1\": function implementation not found" },
  { "zerr:ZXQP0009", "\"$1\": function referred to by this local-name has the local-name \"$2\" instead" },
  { "zerr:ZXQP0010", "\"$1\": builtin sequential function not implemented as sequential" },
  { "zerr:ZXQP0011", "\"$1\": invalid locale" },
  { "zerr:ZXQP0012", "\"$1\": unknown locale" },
  { "zerr:ZXQP0013", "FxCharHeap error: $1 ($2)" },
  { "zerr:ZXQP0014", "${\"1\": }out of memory${: 2}" },
  { "zerr:ZXQP0016", "\"$1\": reserved module target namespace" },
  { "zerr:ZXQP0017", "file access disabled" },
  { "zerr:ZXQP0020", "\"$1\": invalid URI${: 2}" },
  { "zerr:ZXQP0021", "user error" },
  { "zerr:ZXQP0024", "XML does not match schema${: \"1\"}${ 2}" },
  { "zerr:ZXQP0025", "\"$1\": could not fetch resource${; reason: 2}" },
  { "zerr:ZXQP0026", "\"$1\": invalid enumerated value for $2" },
  { "zerr:ZXQP0028", "\"$1\": target namespace not provided by module from $2" },
  { "zerr:ZXQP0029", "\"$1\": URI access not allowed" },
  { "zerr:ZXQP0030", "deadlock" },
  { "zerr:ZXQP0031", "malformed XQueryX XML input${: 1}" },
  { "zerr:ZXQP0032", "error transforming XQueryX to XQuery${: 1}" },
  { "zerr:ZXQP0033", "${\"1\": }XML error in schema${: 2}" },
  { "zerr:ZXQP0035", "${\"1\": }unexpected error in schema${: 2}" },
  { "zerr:ZXQP0036", "BreakIterator creation failed" },
  { "zerr:ZXQP0037", "\"$1\": loaded module version \"$2\" does not match import version specification" },
  { "zerr:ZXQP0038", "Query requires Zorba version \"$1\"; you are running Zorba \"$2\"" },
  { "zerr:ZXQP0039", "\"$1\": invalid version specification" },
  { "zerr:ZXQP0040", "\"$1\": function invokes a nondeterministic function but is missing the nondeterministic annotation" },
  { "zerr:ZXQP0050", "\"$1\": feature not available" },
  { "zerr:ZXQP0060", "\"$1\": unknown option" },
  { "zerr:ZXQP0061", "\"$1\": this option cannot be specified in a query, it must be set via C++ API or command-line parameter" },
  { "zerr:ZXQP0062", "\"$1\": annotation $2" },
  { "zerr:ZXQP0063", "\"$1\": is not a valid annotation literal for annotation \"$2\", literal has type $3, whereas the allowed types are: $4" },
  { "zerr:ZXQP0064", "\"$1\": is not a valid argument index for function \"$2\", valid indexes are in the range [1-$3]" },
  { "zerr:ZXQP0065", "\"$1\": is not a valid annotation for function \"$2\", $3" },
  { "zerr:ZXQP0066", "\"$1\": is not a valid annotation literal for annotation \"$2\", $3" },
#if !defined(ZORBA_NO_FULL_TEXT)
  { "zerr:ZXQP8401", "\"$1\": wrong WordNet file version; should be \"$2\"" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "zerr:ZXQP8402", "thesaurus data endianness does not match CPU" },
#endif
#if !defined(ZORBA_NO_FULL_TEXT)
  { "zerr:ZXQP8403", "thesaurus data error${: 1}" },
#endif
  { "zuri:CHARSET_UNKNOWN", "\"$1\": unknown or invalid character set" },
  { "zuri:INVALID_ABSOLUTE_PATH", "path component of absolute URI must begin with /" },
  { "zuri:OPAQUE_COMB_NOT_VALID", "cannot specify opaque-part in conjunction with host/port/path/user-info/query" },
  { "zuri:OPAQUE_WITHOUT_SCHEME", "scheme required when specifying opaque-part" },
  { "zuri:URI_UNRESOLVED_OR_NOSTREAM", "\"$1\": stream is unresolved or it is not a stream - \"$2\"" },
  { "zwarn:ZWST0002", "\"$1\": unknown or unsupported annotation" },
  { "zwarn:ZWST0003", "\"$1\": function declared sequential, but has non-sequential body" },
  { "zwarn:ZWST0004", "sequential FLWOR expr may not have the semantics you expect" },
  { "zwarn:ZWST0005", "\"$1\": function caching not possible; $2" },
  { "zwarn:ZWST0006", "\"$1\": function caching might not give the intended result because the function is declared as $2" },
  { "zwarn:ZWST0007", "\"$1\":$2,$3: loader parsing warning${: 4}" },
  { "zwarn:ZWST0008", "\"$1\": has been deprecated; use \"$2\" instead" },
  { "zwarn:ZWST0009", "feature not supported by the common language grammar${: 1}" },
  { "~AllMatchesHasExcludes", "AllMatches contains StringExclude" },
  { "~AlreadySpecified", "already specified" },
  { "~AppendStringValue", "append string value" },
  { "~AppliedAt", "applied at" },
  { "~ArithOpNotDefinedBetween_23", "arithmetic operation not defined between types \"$2\" and \"$3\"" },
  { "~AtomizationHasMoreThanOneValue", "atomization has more than one value" },
  { "~AttributeName", "attribute name" },
#if !defined(ZORBA_NO_ICU)
  { "~BackRef0Illegal", "\"0\": illegal backreference" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~BackRefIllegalInCharClass", "backreference illegal in character class" },
#endif
  { "~BadAnyURI", "invalid xs:anyURI" },
  { "~BadArgTypeForFn_2o34o", "${\"2\": }invalid argument type for function $3()${: 4}" },
  { "~BadCharAfter_34", "'$3': illegal character after '$4'" },
  { "~BadCharInBraces_3", "'$3': illegal character within { }" },
  { "~BadDecDigit_3", "'$3': invalid decimal digit" },
  { "~BadEndCharInRange_34", "'$3': invalid end character in range (less than '$4' start character)" },
  { "~BadHexSequence", "invalid hexedecimal sequence" },
  { "~BadItem", "invalid item" },
  { "~BadIterator", "invalid iterator" },
  { "~BadLibraryModule", "invalid library module" },
  { "~BadPath", "invalid path" },
#if !defined(ZORBA_NO_ICU)
  { "~BadQuantifierHere_3", "'$3': quantifier illegal here" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~BadRegexEscape_3", "\"$3\": illegal escape character" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~BadRegexParen_3", "\"$3\": illegal character after \"(?\"" },
#endif
  { "~BadStreamState", "bad I/O stream state" },
  { "~BadTokenInBraces_3", "\"$3\": illegal token within { }" },
  { "~BadTraceStream", "trace stream not retrievable using SerializationCallback" },
  { "~BadTypeFor_23", "\"$2\": invalid type for $3" },
  { "~BadType_23o", "\"$2\": invalid type${: 3}" },
  { "~BadURIScheme_3", "\"$3\": unknown URI scheme" },
  { "~BadURISyntaxForScheme_3", "invalid URI syntax for \"$3\" scheme" },
  { "~BadUnicodeChar_3", "\"$3\": invalid character code-point" },
  { "~BadWordNetPartOfSpeech_2", "\"$2\": invalid part-of-speech" },
  { "~BadWordNetPtr_2", "\"$2\": invalid pointer type" },
  { "~BadXMLDocument_2o", "malformed XML document${ at \"2\"}" },
  { "~BadXMLForXQDoc_3", "can not parse as XML for xqdoc: $3" },
  { "~BadXMLNoOpeningTag", "closing tag without matching opening tag" },
  { "~BaseURI", "base URI" },
  { "~BoxCondTooManyColumns", "box condition has more columns than index" },
  { "~CharExpected_3", "'$3' expected" },
  { "~CharExpected_4", "'$4' expected" },
  { "~CloneNotImplemented", "clone() not implemented for expression" },
  { "~ClosingBraceWithoutOpen", "'}' encountered without '{' first" },
  { "~CollectionIteratorNotOpen", "collection iterator not open" },
  { "~DefaultCollation", "default collation" },
  { "~DefaultCollection", "default collection" },
  { "~DivisionNoINF", "division can not have +-INF dividend" },
  { "~DivisionNoNaN", "division can not involve NaN" },
  { "~DocNodeMultipleElements", "document node has more than one element" },
  { "~DocNodeNoElements", "document node doesn't contain any elements, must contain exactly one element" },
  { "~EBVNotDefSeq_5", "effective boolean value not defined for sequence of more than one item that starts with \"$5\"" },
  { "~EffectiveBooleanValue", "effective boolean value" },
  { "~ElementName", "element name" },
  { "~ElementNode", "element node" },
  { "~EmptyPath", "empty path" },
  { "~EmptySeqNoCastToQName", "empty sequence can not be cast to QName" },
  { "~EmptySeqNoCastToTypeWithQuantOne", "empty sequence can not be cast to type with quantifier '1'" },
  { "~EmptySeqNoFnRemoveArg", "empty sequence not allowed as 2nd argument of fn:remove()" },
  { "~EmptySeqNoSearchItem", "empty sequence not allowed as search item of fn:index-of()" },
  { "~EmptySequence", "empty sequence" },
  { "~ErrorCodeMessage_12", "error $1: $2" },
  { "~ExpectedNumericOrDurationType", "expected numeric or duration type" },
  { "~ExpectedNumericType", "expected numeric type" },
  { "~ExpectedType_5", "expected type \"$5\"" },
  { "~ExprNoReturnUpdateList", "expression does not return a pending update list" },
  { "~ExprReturnsTooManyUpdateLists", "expression does not return a pending update list" },
  { "~ExternFnDeterministic", "only external functions may be declared deterministic" },
  { "~ExternFnNondeterministic", "only external functions may be declared nondeterministic" },
  { "~FACET_VIOLATION_BadConstraint_23o4o5o", "value violates \\$constraints facet \"$2\" of type${ 3}${: [4]}${: 5}" },
  { "~FACET_VIOLATION_BadKey_23o", "\"$2\": new key violates \"false\" value of \\$open facet of type${ 3}" },
  { "~FACET_VIOLATION_BadValue_23o", "value violates $2 facet of type${ 3}" },
  { "~FOCA0002_BadLexicalQName_2", "\"$2\": value is not a valid lexical QName" },
  { "~FOCA0002_NoCastTo_234", "\"$2\": value of type $3 is not castable to type $4" },
  { "~FOCA0002_NoURIforPrefix_2", "no namespace URI provided for prefix in lexical QName \"$2\"" },
  { "~FODF1310_BadCharacter_3", "'$3': invalid character" },
  { "~FODF1310_BadFormatModifierHere_3", "'$3': valid format modifier invalid here" },
  { "~FODF1310_BadFormatModifier_3", "'$3': invalid format modifier" },
  { "~FODF1310_DigitNotSameFamily_34", "\"$3\": digit not from same digit family as $4" },
  { "~FODF1310_DupFormatModifier_3", "\"$3\": duplicate format modifier" },
  { "~FODF1310_EmptyFormat", "empty primary format" },
  { "~FODF1310_MultipleSign_3", "\"$3\": multiple such signs are illegal" },
  { "~FODF1310_MustHaveOptOrMandatoryDigit", "sub-picture must contain at least one optional or mandatory digit" },
  { "~FODF1310_NoActivePassiveActive", "\"$3\": active character may not follow passive that follows active" },
  { "~FODF1310_NoAdjacentGroupSep_3", "\"$3\": grouping separator must not be adjacent to others" },
  { "~FODF1310_NoDecimalGroupingAdjacent_34", "decimal-separator-sign ('$3') and grouping-separator-sign ('$4') may not be adjacent" },
  { "~FODF1310_NoGroupSepAtEnd_3", "\"$3\": grouping separator illegal at end of decimal-digit-pattern" },
  { "~FODF1310_NoGroupSepAtStart_3", "\"$3\": grouping separator illegal at start of decimal-digit-pattern" },
  { "~FODF1310_NoMandatoryDigitAfterOpt_3", "'$3': member of decimal-digit-family in fractional part of a sub-picture may not follow an optional-digit-sign" },
  { "~FODF1310_NoOptDigitAfterMandatory", "\"#\": optional-digit-sign must precede all mandatory-digit-signs" },
  { "~FODF1310_NoOptDigitAfterMandatory_3", "'$3': optional-digit-sign in integer part of sub-picture may not follow a member of the decimal-digit-family" },
  { "~FODF1310_NoPercentPermille", "sub-picture must not contain more than one percent-sign or per-mille-sign or one of each" },
  { "~FOFD1340_Bad2ndModifierHere_4", "'$4': valid second presentation modifier invalid here" },
  { "~FOFD1340_Bad2ndModifier_4", "'$4': invalid second presentation modifier" },
  { "~FOFD1340_BadCalendarDesignator", "unknown designator" },
  { "~FOFD1340_BadComponent_4", "'$4': invalid component specifier" },
  { "~FOFD1340_BadWidthModifier", "invalid width modifier" },
  { "~FOFD1340_Calendar", "calendar" },
  { "~FOFD1340_DigitNotSameFamily_45", "\"$4\": digit not from same digit family as $5" },
  { "~FOFD1340_Dup2ndModifier_4", "\"$4\": duplicate second presentation modifier" },
  { "~FOFD1340_Language", "language" },
  { "~FOFD1340_MultipleComponent_4", "'$4': multiple component specifiers between []" },
  { "~FOFD1340_MustBeOneMandatoryDigit", "there must be at least one mandatory-digit-sign" },
  { "~FOFD1340_NoAdjacentGroupSep_4", "\"$4\": grouping separator must not be adjacent to others" },
  { "~FOFD1340_NoComponent", "component specifier expected between []" },
  { "~FOFD1340_NoGroupSepAtEnd_4", "\"$4\": grouping separator illegal at end of decimal-digit-pattern" },
  { "~FOFD1340_NoGroupSepAtStart_4", "\"$4\": grouping separator illegal at start of decimal-digit-pattern" },
  { "~FOFD1340_NoOptDigitAfterMandatory", "\"#\": optional-digit-sign must precede all mandatory-digit-signs" },
  { "~FOFD1340_Picture", "picture" },
  { "~FOFD1340_Place", "place" },
  { "~FORG0001_BadHexDigit_2", "'$2': invalid hexedecimal digit" },
  { "~FORG0001_Base64BadChar_2", "'$2': invalid Base64 character" },
  { "~FORG0001_Base64Multiple4", "Base64 data must be a multiple of 4 bytes" },
  { "~FORG0001_HexBinaryMustBeEven", "hexBinary value must contain an even number of bytes" },
  { "~FORG0001_LocalNotNCName_2", "\"$2\": local name in qname is not an xs:NCName" },
  { "~FORG0001_NameNotNCName_2", "\"$2\": name is not an xs:NCName" },
  { "~FORG0001_NoCastTo_234", "\"$2\": value of type $3 is not castable to type $4" },
  { "~FORG0001_NoCastTo_234o", "\"$2\": value is not castable to type $3${: 4}" },
  { "~FORG0001_NoTypeInCtx_2", "\"$2\": type no defined in current context" },
  { "~FORG0001_PrefixNotBound_2", "\"$2\": prefix has no known namespace binding" },
  { "~FORG0001_PrefixNotNCName_2", "\"$2\": prefix in qname is not an xs:NCName" },
  { "~FTST0009_BadStemmerLang", "for current stemmer" },
  { "~FTST0009_BadStopWordsLang", "for current stop words" },
  { "~FTST0009_BadThesaurusLang", "for given thesaurus" },
  { "~FTST0009_BadTokenizerLang", "for current tokenizer" },
  { "~FileNotFoundOrReadable", "file not found or readable" },
  { "~FnNilledArgNotNode", "fn:nilled() argument not a node" },
  { "~FnOnlyInXQueryVersion_3", "function only available in XQuery $3" },
  { "~FullTextNotEnabled", "full-text was not enabled in this build" },
  { "~FunctionFailedErrorCodeMessage_123", "$1 failed (error $2): $3" },
  { "~FunctionFailed_12o", "$1 failed${: 2}" },
  { "~FunctionUndeclared_3", "function with arity $3 not declared" },
  { "~GoodValuesAreUTF8Etc", "valid values include: UTF-8, UTF-16, UTF-16LE, UTF-16BE, UTF-32, ISO-8859-1" },
  { "~GoodValuesAreXMLEtc", "valid values are: xml, html, xhtml, text, binary, json, jsoniq" },
  { "~GoodValuesAreYesNo", "valid values are: yes, no" },
  { "~GoodValuesAreYesNoOmit", "valid values are: yes, no, omit" },
  { "~ILLEGAL_BASE_TYPE_BecauseOfKey_45", " because of key \"$4\": $5" },
  { "~ILLEGAL_BASE_TYPE_IncompatibleFacets_4", ": incompatible facet values for \"$4\"" },
  { "~ILLEGAL_BASE_TYPE_MustBeX_4", ": must be \"$4\"" },
  { "~ILLEGAL_BASE_TYPE_NotSubtype_45", ": \"$4\" is not a subtype of \"$5\"" },
  { "~ILLEGAL_FACET_VALUE_BadConstraint_45", "[$4]: $5" },
  { "~ILLEGAL_FACET_VALUE_BadPattern_45", "[$4]: $5" },
  { "~ILLEGAL_FACET_VALUE_IncompatibleWith_45", "incompatible with $4 facet value of \"$5\"" },
  { "~ILLEGAL_FACET_VALUE_LocationMismatch_45", "does not match location \"$4\" given for previous import of schema \"$5\"" },
  { "~ILLEGAL_FACET_VALUE_MustBeAAOU", "must be one of \"array\", \"atomic\", \"object\", or \"union\"" },
  { "~ILLEGAL_FACET_VALUE_MustBeGE0", "must be >= 0" },
  { "~ILLEGAL_FACET_VALUE_MustBeOPR", "must be one of \"optional\", \"prohibited\", or \"required\"" },
  { "~ILLEGAL_FACET_VALUE_NoAddEnum_4", "can not add value to enumeration of base-type $4" },
  { "~ILLEGAL_FACET_VALUE_NoOverrideBase_4", "can not override base-type value of \"$4\"" },
  { "~ILLEGAL_KEY_FieldDescriptor", "field descriptor" },
  { "~ILLEGAL_KEY_Type_34o", "$3 type${ \"4\"}" },
  { "~ILLEGAL_KEY_UnionNoBaseType", "union type: unions may not have base types" },
  { "~INVALID_OPTION_ArrayElementsMustBeString", "array elements must be string" },
  { "~INVALID_OPTION_MustBeASCIIChar", "must be single ASCII character" },
  { "~INVALID_OPTION_MustBeArray", "must be JSON array" },
  { "~INVALID_OPTION_MustBeBoolean", "must be boolean" },
  { "~INVALID_OPTION_MustBeString", "must be string" },
  { "~INVALID_OPTION_MustBeTrueFalse", "must be sub-object with \"true\" and \"false\" keys" },
  { "~INVALID_OPTION_jse_MustBeBoolean", "must be boolean" },
  { "~InData", "in data" },
  { "~IncompleteKeyInIndexBuild", "incomplete key during index build" },
  { "~IncompleteKeyInIndexRefresh", "incomplete key during index refresh" },
  { "~JNDY0021_IllegalCharacter_2", "'$2': illegal JSON character" },
  { "~JNDY0021_IllegalCodepoint_2", "\"$2\": illegal Unicode code-point" },
  { "~JNDY0021_IllegalEscape_2", "'\\\\$2': illegal JSON character escape" },
  { "~JNDY0021_IllegalLiteral", "illegal JSON literal" },
  { "~JNDY0021_IllegalNumber", "illegal JSON number" },
  { "~JNDY0021_UnexpectedExtraContent", "unexpected extra content at the end of the document (consider using the jsoniq-multiple-top-level-items option)" },
  { "~JNDY0021_UnexpectedToken_2", "\"$2\": unexpected JSON token" },
  { "~JNDY0021_UnterminatedString", "unterminated JSON string" },
  { "~JNUP0007_Array", "\"$2\": can not be promoted to type xs:integer" },
  { "~JNUP0007_Object", "\"$2\": can not be promoted to type xs:string" },
  { "~JNUP0007_ObjectArray", "\"$2\": can not be promoted to type xs:anyAtomicType" },
  { "~JNUP0008_Array", "\"$2\": target of an appending expression or of a position-inserting expression is not an array" },
  { "~JNUP0008_Object", "\"$2\": target of a renaming expression or of a non-position-inserting expression is not an object" },
  { "~JNUP0008_ObjectArray", "\"$2\": target of a deleting or replacing expression is not a JSON item" },
  { "~JNUP0016_Array", "\"$2\": selector cannot be resolved against supplied array" },
  { "~JNUP0016_Object", "\"$2\": selector cannot be resolved against supplied object" },
  { "~LibModVersionMismatch_3", "XQuery library version can not be imported by a $3 version module" },
  { "~MISSING_VALUE_Default", "\"$2\": missing value detected for this field on line $3" },
  { "~MISSING_VALUE_EmptyHeader", "empty header value detected on line 1" },
  { "~ModuleNotFound", "module not found" },
  { "~MustBeAbsoluteURI", "must be absolute" },
  { "~NoAttrNodesInDocument", "document node must not contain attribute nodes" },
  { "~NoBindURI", "namespace URI can not be bound to prefix" },
  { "~NoCastToCInt_2", "\"$2\": 2nd operand can not be cast from \"xs:integer\" to C++ \"int\"" },
  { "~NoCastTo_34o", "can not cast to \"$3\"${: 4}" },
  { "~NoCastTo_45o", "can not cast to \"$4\"${: 5}" },
  { "~NoCompareTypes_23", "can not compare item of type $2 with item of type $3" },
  { "~NoCompareWithType_4", "can not compare for equality to type \"$4\"" },
  { "~NoDriveSpecification", "missing drive specification" },
  { "~NoEmptySeqAsBaseURI", "can't treat empty sequence as base URI" },
  { "~NoEmptySeqAsCollationParam", "empty-sequence not allowed as collation parameter" },
  { "~NoExternalFunction_2", "\"$2\": external function not found" },
  { "~NoExternalModuleFromDLL_2", "required external module \"$2\" not found" },
  { "~NoHashItemOfType_2", "can not hash item of type \"$2\"" },
  { "~NoInputData", "no input data" },
  { "~NoModuleURIResolver", "no module URI resolver could be retrieved using SerializationCallback" },
  { "~NoMultiKeyNodeValues_2", "node with more than one key value found during probe on index \"$2\"" },
  { "~NoParseFnArity", "could not parse function arity (maybe it's too large)" },
  { "~NoRegisteredSerializationCallback_2", "external module \"$2\" not available using registered SerializationCallback" },
  { "~NoResolveRelativeURI", "could not resolve relative URI" },
  { "~NoSeqAsArithOp", "sequence of more than one item can not be operand for arithmetic operation" },
  { "~NoSeqAsCollationParam", "sequence of more than one item not allowed as collation parameter" },
  { "~NoSeqCastToTypeWithQuantOneOrQuestion", "sequence of more than one item can not be cast to type with quantifier '1' or '?'" },
  { "~NoSeqForConcat", "multi-item sequence can not be operand for concatenation" },
  { "~NoSeqForFnOp_2", "sequence of more than one item can not be operand for function \"$2()\"" },
  { "~NoSeqInValueComp", "sequnce of more than one item can not be in value comparisons" },
  { "~NoSeqTestedForAtomicEquiv", "sequence of more than one item can not be tested for atomic value equivalence" },
  { "~NoSerializationCallbackForDocColMod", "document, collection, or module resolver required but no SerializationCallback given" },
  { "~NoSerializationCallbackForModule", "no SerializationCallback for required external module \"$2\"" },
  { "~NoSerializationCallbackForTraceStream", "no SerializationCallback for required trace stream" },
  { "~NoSourceURI", "no URI" },
  { "~NoStrictCompareWithType_4", "can not compare for strict inequality to type \"$4\"" },
  { "~NoTreatAs_4", "can not treat as \"$4\"" },
  { "~NoURIAuthority", "no authority" },
  { "~NoURIInStore", "URI for document not found in store" },
  { "~NoURIScheme", "no URI scheme" },
  { "~NoUntypedKeyNodeValue_2", "node with untyped key value found during probe on index \"$2\"" },
  { "~NodeIDNeedsBytes_2", "nodeid requires more than $2 bytes" },
  { "~NodeIDTooBig", "nodeid component too big for encoding" },
#if !defined(ZORBA_NO_ICU)
  { "~NonClosedBackRef_3", "'\\$$3': non-closed backreference" },
#endif
  { "~NonFileThesaurusURI", "non-file thesaurus URI" },
  { "~NonLocalhostAuthority", "non-localhost authority" },
#if !defined(ZORBA_NO_ICU)
  { "~NonexistentBackRef_3", "'\\$$3': non-existent backreference" },
#endif
  { "~NotAllowedForTypeName", "not allowed for typeName (use xsd:untyped instead)" },
  { "~NotAmongInScopeSchemaTypes", "not among in-scope schema types" },
  { "~NotDefInDynamicCtx", "not defined in dynamic context" },
  { "~NotDocOrElementNode", "not a document or element node" },
  { "~NotInStaticCtx", "not found in static context" },
  { "~NotPlainFile", "not plain file" },
#if !defined(ZORBA_NO_ICU)
  { "~NotSingleCharEsc_3", "\"\\\\$3\": multi-character and category escapes not permitted in character range" },
#endif
  { "~NotSpecified", "not specified" },
  { "~OpIsSameNodeMustHaveNodes", "op:is-same-node() must have nodes as parameters" },
  { "~OpNodeAfterMustHaveNodes", "op:node-after() must have nodes as parameters" },
  { "~OpNodeBeforeMustHaveNodes", "op:node-before() must have nodes as parameters" },
  { "~OperationNotDef_23", "$2 not defined for type \"$3\"" },
  { "~OperationNotPossibleWithTypes_234", "\"$2\": operation not possible with parameters of type \"$3\" and \"$4\"" },
  { "~ParseFragmentDoctypeNotAllowed", "a DOCTYPE declaration is not allowed" },
  { "~ParseFragmentDoctypeNotAllowedHere", "a DOCTYPE declaration must appear before any element or text node, and at most once" },
  { "~ParseFragmentInvalidOptions", "invalid options passed to the parse-xml:parse() function, the element must be in the schema target namespace" },
  { "~ParseFragmentOptionCombinationNotAllowed", "only one of the <schema-validate/>, <DTD-validate/> or <parse-external-parsed-entity/> options can be specified" },
  { "~PromotionImpossible", "promotion not possible" },
#if defined(ZORBA_NO_ICU)
  { "~REGEX_BROKEN_PIs_CONSTRUCT", "broken \\\\p{Is} construct; valid characters are [a-zA-Z0-9-]" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_BROKEN_P_CONSTRUCT", "broken \\\\p construct" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_INVALID_ATOM_CHAR", "'$3': invalid character for an atom; forbidden characters are: [{}?*+|^]" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_INVALID_BACK_REF", "\\\\$3 backreference to a non-existent capture group ($4 groups so far)" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_INVALID_SUBCLASS", "malformed class subtraction" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_INVALID_UNICODE_CODEPOINT_u", "invalid unicode hex, should be in form \\\\uXXXX or \\\\UXXXXXXXX" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_INVALID_USE_OF_SUBCLASS", "improper use of class subtraction: it must be the last construct in a class group [xxx-[yyy]]" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_MAX_LT_MIN", "in {min,max}, max is less than min" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_MISMATCHED_PAREN", "incorrectly nested parentheses" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_MISSING_CLOSE_BRACKET", "missing ']' in character group" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_MULTICHAR_IN_CHAR_RANGE", "multichars or char categories cannot be part of a char range" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNIMPLEMENTED", "use of regular expression feature that is not yet implemented" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_ESC_CHAR", "unknown \\\\? escape char; supported escapes are: \\\\[nrt\\\\|.?*+(){}[]-^$] for char escapes, \\\\[pP] for categories and \\\\[sSiIcCdDwW] for multichar groups" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PC_CONSTRUCT", "unknown \\\\p{C?} category; supported categories: C, Cc, Cf, Co, Cn(for not assigned)" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PIs_CONSTRUCT", "unknown \\\\p{Is} category block; see supported block escapes here: http://www.w3.org/TR/xmlschema-2/#charcter-classes" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PL_CONSTRUCT", "unknown \\\\p{L?} category; supported categories: L, Lu, Ll, Lt, Lm, Lo" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PM_CONSTRUCT", "unknown \\\\p{M?} category; supported categories: M, Mn, Mc, Me" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PN_CONSTRUCT", "unknown \\\\p{N?} category; supported categories: N, Nd, Nl, No" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PP_CONSTRUCT", "unknown \\\\p{P?} category; supported categories: P, Pc, Pd, Ps, Pe, Pi, Pf, Po" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PS_CONSTRUCT", "unknown \\\\p{S?} category; supported categories: S, Sm, Sc, Sk, So" },
#endif
#if defined(ZORBA_NO_ICU)
  { "~REGEX_UNKNOWN_PZ_CONSTRUCT", "unknown \\\\p{Z?} category; supported categories: Z, Zs, Zl, Zp" },
#endif
  { "~SENR0001_AttributeNode", "attribute node" },
  { "~SENR0001_NamespaceNode", "namespace node" },
  { "~SEPM0009_Not10", "the version parameter has a value other than \"1.0\" and the doctype-system parameter is specified" },
  { "~SEPM0009_NotOmit", "the standalone attribute has a value other than \"omit\"" },
  { "~SchemaUnexpected", "unexpected exception during parsing" },
  { "~SearchKeyTypeMismatch_234", "\"$2\": search key type for index \"$3\" does not match expected type \"$4\"" },
  { "~SearchKeyTypeNoProbeIndex_23", "\"$2\": search key type can not probe index \"$3\"" },
  { "~SeqFnBody", "only a function declared sequential can have a body that is a sequential expression" },
  { "~SeqNoCastToQName", "sequence of more than one item can not be cast to QName" },
  { "~SingletonExpected_2o", "singleton expected${ (2)}" },
  { "~StackOverflow", "stack overflow" },
  { "~StingLiteral", "string literal" },
  { "~StringValue", "string value" },
  { "~SumImpossibleWithTypes_23", "sum not possible with parameters of type \"$2\" and \"$3\"" },
  { "~TYPE_VIOLATION_UnionMemberType", "a union member type" },
  { "~TrailingChar_3", "trailing '$3'" },
  { "~TwoDecimalFormatsSameName_2", "\"$2\": two decimal formats with this name" },
  { "~TwoDefaultDecimalFormats", "two default decimal formats" },
  { "~TypeIsNotSubtype", "item type is not a subtype of \"$3\"" },
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_BAD_ESCAPE_SEQUENCE", "unrecognized backslash escape sequence" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_BAD_INTERVAL", "error in {min,max} interval" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_INTERNAL_ERROR", "an internal ICU error (bug) was detected" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_INVALID_BACK_REF", "backreference to a non-existent capture group" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_INVALID_FLAG", "invalid value for match mode flags" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_INVALID_RANGE", "in character range [x-y], x is greater than y" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_INVALID_STATE", "RegexMatcher in invalid state for requested operation" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_LOOK_BEHIND_LIMIT", "look-behind pattern matches must have a bounded maximum length" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_MAX_LT_MIN", "in {min,max}, max is less than min" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_MISMATCHED_PAREN", "incorrectly nested parentheses" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_MISSING_CLOSE_BRACKET", "missing ']'" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_NUMBER_TOO_BIG", "decimal number is too large" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_OCTAL_TOO_BIG", "octal character constants must be <= 0377" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_PROPERTY_SYNTAX", "incorrect Unicode property" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_RULE_SYNTAX", "syntax error" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_SET_CONTAINS_STRING", "can not have UnicodeSets containing strings" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_STACK_OVERFLOW", "backtrack stack overflow" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_STOPPED_BY_CALLER", "matching operation aborted by user callback fn" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_TIME_OUT", "maximum allowed match time exceeded" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~U_REGEX_UNIMPLEMENTED", "use of regular expression feature that is not yet implemented" },
#endif
  { "~UnaryArithOp", "unary arithmetic operator" },
#if !defined(ZORBA_NO_ICU)
  { "~UnbalancedChar_3", "unbalanced '$3'" },
#endif
#if !defined(ZORBA_NO_ICU)
  { "~UnescapedChar_3", "character '$3' must be escaped here" },
#endif
  { "~UnexpectedElement", "unexpected element" },
  { "~VarValMustBeSingleItem_2", "\"$2\": variable value must be single item" },
  { "~XMLParserInitFailed", "XML parser initialization failed" },
  { "~XMLParserNoCreateTree", "XML tree creation failed" },
  { "~XMLSchema", "XML schema" },
  { "~XPDY0002_ContextUndeclared_2", "$2 not declared" },
  { "~XPDY0002_VariableHasNoValue_2", "\"$2\": variable has no value" },
  { "~XPDY0002_VariableUndeclared_2", "\"$2\": undeclared variable" },
  { "~XPST0003_Annotations", "function and variable annotations only available in XQuery 3.0 or later" },
  { "~XPST0003_CompNS", "computed namespace constructors only available in XQuery 3.0 or later" },
  { "~XPST0003_CountClause30", "\"count\" clause only available in XQuery 3.0 or later" },
  { "~XPST0003_ExternalVar", "initializing expressions for external variables only available in XQuery 3.0 or later" },
  { "~XPST0003_ModuleDeclNotInMain", "module declaration must not be in main module" },
  { "~XPST0003_OuterForClause30", "\"outer-for\" clause only available in XQuery 3.0 or later" },
  { "~XPST0003_PiTarget", "\"XML\" not allowed as target of a direct processing-instruction constructor" },
  { "~XPST0003_Scripting", "scripting feature not available" },
  { "~XPST0003_StartEndTagMismatch_23", "start tag \"$2\" does not match end tag \"$3\"" },
  { "~XPST0003_SwitchExpr30", "\"switch\" expressions only available in XQuery 3.0 or later" },
  { "~XPST0003_TryCatchExpr30", "\"try/catch\" expressions only available in XQuery 3.0 or later" },
  { "~XPST0003_TypeSwitchExpr30", "union of types in typeswitch clause is only available in XQuery 3.0 or later" },
  { "~XPST0003_WindowClause30", "\"window\" clause only available in XQuery 3.0 or later" },
  { "~XPST0003_XQueryVersionAtLeast30_2", "\"$2\": XQuery version must be at least 3.0" },
  { "~XPST0008_SchemaAttributeName_2", "\"$2\": undefined schema-attribute name" },
  { "~XPST0008_SchemaElementName_2", "\"$2\": undefined schema-element name" },
  { "~XPST0008_VariableName_2", "\"$2\": undeclared variable" },
  { "~XPST0051_Atomic_2", "\"$2\": not defined an atomic type" },
  { "~XPST0051_GenAtomic_2", "\"$2\": not defined a generalized atomic type" },
  { "~XPTY0004_JSONIQ_SELECTOR", "can not atomize and/or cast value of type $2 to string" },
  { "~XPTY0004_MultiValuedGroupingKey", "atomization of grouping variable produces more than one item" },
  { "~XPTY0004_NoMultiSeqTypePromotion_2", "sequence of more than one item can not be promoted to type $2" },
  { "~XPTY0004_NoParamTypePromote_234", "$2 can not be promoted to parameter type $3 of function $4()" },
  { "~XPTY0004_NoReturnTypePromote_234", "$2 can not be promoted to return type $3 of function $4()" },
  { "~XPTY0004_NoTreatAs_23", "$2 can not be treated as type $3" },
  { "~XPTY0004_NoTypePromote_23", "$2 can not be promoted to type $3" },
  { "~XPTY0004_NoVarTypeInMainModule_23", "\"$2\": type of variable \"$3\" is not among the in-scope types of the main module" },
  { "~XPTY0004_NoVarTypeInModule_234", "\"$2\": type of variable \"$3\" is not among the in-scope types of module \"$4\"" },
  { "~XPTY0004_PiTarget_2", "$2: type of processing instruction target is not xs:NCName, or xs:string, or xs:untypedAtomic" },
  { "~XPTY0004_ValueNoCastTo_23", "$2: value can not be cast to type $3" },
  { "~XPTY0117_NodeCast", "Cannot cast node to xs:QName" },
  { "~XPTY0117_NotationParam_23", "$2 can not be promoted to parameter type xs:NOTATION of function $3()" },
  { "~XQDY0027_InvalidValue", "\"$2\": invalid value for type${: 3}${: 4}" },
  { "~XQDY0027_NoTypeInCtx_2", "\"$2\": type no defined in current context" },
  { "~XQDY0027_PrefixNotBound", "\"$2\": prefix not bound" },
  { "~XQDY0027_SerializationElementName_2", "\"$2\": invalid serialization parameters; element name must be \"serialization-parameters\"" },
  { "~XQDY0027_SerializationElementNs_2", "\"$2\": invalid namespace for the \"serialization-parameters\" element; must be \"http://www.w3.org/2010/xslt-xquery-serialization\"" },
  { "~XQDY0074_NameSapceConstructor", "$2: cannot cast prefix to xs:NCName" },
  { "~XQDY0074_NoEmptyLocalname", "can not convert empty local name to xs:QName" },
  { "~XQDY0074_NotCastToQName", "$2: can not convert to xs:QName" },
  { "~XQST0031_BadXQueryVersion_2", "\"$2\": unsupported XQuery version" },
  { "~XQST0036_NoParamTypeInMainModule_23", "\"$2\": parameter type of function \"$3\" is not among the in-scope types of the main module" },
  { "~XQST0036_NoParamTypeInModule_234", "\"$2\": parameter type of function \"$3\" is not among the in-scope types of module \"$4\"" },
  { "~XQST0036_NoRetTypeInMainModule_23", "\"$2\": return type of function \"$3\" is not among the in-scope types of the main module" },
  { "~XQST0036_NoRetTypeInModule_234", "\"$2\": return type of function \"$3\" is not among the in-scope types of module \"$4\"" },
  { "~XQST0036_NoVarTypeInMainModule_23", "\"$2\": type of variable \"$3\" is not among the in-scope types of the main module" },
  { "~XQST0036_NoVarTypeInModule_234", "\"$2\": type of variable \"$3\" is not among the in-scope types of module \"$4\"" },
  { "~XQST0045_ANNOTATION_23", "\"$2\": annotation name in reserved namespace \"$3\"" },
  { "~XQST0045_FUNCTION_23", "\"$2\": function name in reserved namespace \"$3\"" },
  { "~XQST0046_BadFileURIAuthority_3", "\"$3\": invalid authority for \"file\" scheme" },
  { "~XQST0046_BadHexDigit_3", "'$3': invalid hexedecimal digit" },
  { "~XQST0059_BadModule_23", "module \"$2\" at location \"$3\" is not library module" },
  { "~XQST0059_UnknownModule_234o", "module \"$2\" not found at location \"$3\"${ : 4}" },
  { "~XQST0059_UnknownSchema_23o", "no schema found for target namespace \"$2\"${ : 3}" },
  { "~XQST0059_WrongModule_234", "attempt to import module \"$2\" at location \"$3\" actually imports module \"$4\"" },
  { "~XQST0059_XercesMessage", "$2,$3: error in schema${ with System ID \"4\"}${ with Public ID \"5\"}${: 6}" },
  { "~XQST0070_ReservedPrefixInDecl_2", "\"$2\": reserved prefix can not appear in namespace declaration" },
  { "~XQST0070_ReservedPrefixInImport_2", "\"$2\": reserved prefix can not appear in schema or module import" },
  { "~XQST0070_ReservedPrefixInModule_2", "\"$2\": reserved prefix can not appear in module declaration" },
  { "~XQST0070_ReservedPrefix_23", "\"$2\": can not rebind reserved prefix to namespace URI \"$3\"" },
  { "~XQST0070_ReservedURI_23", "\"$2\": can not bind prefix to reserved namespace URI \"$3\"" },
  { "~XQST0070_xmlnsInAttrDecl", "\"xmlns\" prefix can not be bound in namespace declaration attribute" },
  { "~XQST0097_MustBeChar", "must be a single character" },
  { "~XQST0097_MustBeZeroDigit", "must be a digit (Unicode category Nd) and represent zero" },
  { "~XQST0106_Conflicting", "$2: conflicting annotations in declaration" },
  { "~XQST0106_Duplicate", "$2: annotation appears more than once in declaration" },
  { "~XQST0106_Requirement", "$2: annotation requires one of the following annotations: $3" },
  { "~XQST0116_Conflicting", "$2: conflicting annotations in declaration" },
  { "~XQST0116_Duplicate", "$2: annotation appears more than once in declaration" },
  { "~XQST0116_Requirement", "$2: annotation requires one of the following annotations: $3" },
  { "~XQST0123_UnrecognizedRequiredFeature_2", "\"$2\": unrecognized required feature" },
  { "~XQST0123_UnrecognizedXQueryOption_2", "\"$2\": unrecognized option in XQuery namespace" },
  { "~XUDY0021_AttributeName", "\"$3\": attribute with the same name already exists" },
  { "~XUST0001_CONCAT", "comma expression with updating and non-updating branches" },
  { "~XUST0001_Generic", "updating expression illegal here" },
  { "~XUST0001_IF", "conditional expression with updating and non-updating branch" },
  { "~XUST0001_TRYCATCH", "try-catch expression with updating and non-updating clauses" },
  { "~XUST0001_UDF_2", "\"$2\": function declared simple but body is updating" },
  { "~XUST0002_Transform", "transform expression witn non-updating or vacuous modify clause" },
  { "~XUST0002_UDF_2", "\"$2\": function declared updating but body is not updating or vacuous" },
  { "~ZAPI0014_BadType_3", "invalid type: must be $3" },
  { "~ZDST0027_MULTI_VALUED_KEY_TYPE_DECL", "value index can not have a key type declaration with * or + quantifier" },
  { "~ZDST0027_NON_ATOMIC_KEY_TYPE", "index has non-atomic key type declaration" },
  { "~ZDST0027_NON_ORDERED_KEY_TYPE", "range index can not have type $3 in key type declaration" },
  { "~ZDST0027_NON_SPECIFIC_KEY_TYPE_DECL", "value index can not have xs:untypedAtomic or xs:anyAtomicType in key type declaration" },
  { "~ZDST0027_NO_KEY_TYPE_DECL", "value index missing key type declaration" },
  { "~ZDST0060_unknown_localname", "unknown localname ($3)" },
  { "~ZDST0060_unknown_namespace", "unknown namespace ($3)" },
  { "~ZJ2X0001_ArrayRequired", "must start with array" },
  { "~ZJ2X0001_Bad1stElement", "array must start with string element" },
  { "~ZJ2X0001_BadElement", "array must not have a \"$2\" element" },
  { "~ZJ2X0001_EmptyArray", "array must not be empty" },
  { "~ZJ2X0001_UnexpectedObject", "allows an object only for the 2nd element" },
  { "~ZJ2X0002_BadElement", "array must not have a \"$2\" element" },
  { "~ZJ2X0002_ObjectRequired", "must start with object" },
  { "~ZJ2X0002_childNodesArrayRequired", "\"childNodes\" key must have array value" },
  { "~ZJ2X0002_tagNameRequired", "must contain a \"tagName\" key" },
  { "~ZSTR0060_ForCollection_3", "for collection \"$3\"" },
  { "~ZSTR0060_ForSequence", "for sequence" },
  { "~ZWST0005_SEQUENTIAL", "function is sequential" },
  { "~ZWST0005_UPDATING", "function is updating" },
  { "~ZWST0005_VARIADIC", "function is variadic" },
  { "~ZWST0009_APOS_STRING", "single-quote (apostrophe) quoted strings" },
  { "~ZWST0009_AXIS_STEP", "axis step at the beginning of a path expression" },
  { "~ZWST0009_CHAR_REF", "standalone slash \"/\" or XML character or entity reference in string literal" },
  { "~ZWST0009_CONTEXT_ITEM_EXPR", "context item expression; use zorba-util:context-item() instead" },
  { "~ZWST0009_DOT_IN_QNAME", "dot \".\" character in QName" },
  { "~ZWST0009_EMPTY_BLOCK", "empty block; use {;} instead" },
  { "~ZWST0009_EMPTY_OBJECT", "empty object; use {| |} instead" },
  { "~ZWST0009_JSONIQ_EMPTY_SEQUENCE", "JSONiq abbreviated empty sequence \"()\"; use \"empty-sequence()\" instead" },
  { "~ZWST0009_JSONIQ_TYPE_KEYWORDS", "JSONiq type keywords; add \"()\" after type" },
  { "~ZWST0009_JSON_ESCAPE", "standalone ampersand \"&\" or JSON character escape sequence in string literal" },
  { "~ZWST0009_JSON_KEYWORD_OPTIONAL", "optional \"json\" keyword in updates" },
  { "~ZWST0009_JSON_OBJECT_LOOKUP", "JSONiq dot object lookup" },
  { "~ZWST0009_NO_PREFIX_IN_TYPE", "no namespace prefix for built-in JSONiq types; add \"xs\" prefix" },
  { "~ZWST0009_OBJECT_KEY_NOT_QUOTED", "JSONiq object key without quotes" },
  { "~ZWST0009_TRUE_FALSE_NULL_KEYWORDS", "true/false/null JSONiq keywords" },
  { "~ZWST0009_VERSION_DECL", "version declaration" },
  { "~ZXQD0004_NON_NEGATIVE", "given value must be non-negative ($2)" },
  { "~ZXQD0004_NOT_WITHIN_RANGE", "not within allowed range ($2)" },
  { "~ZXQP0004_TypeOps_is_in_scope_ForFunctionItemTypes", "TypeOps::is_in_scope() for function-item types" },
  { "~ZXQP0025_RESOURCE_NOT_FOUND", "resource not found" },
  { "~ZXQP0062_NO_LITERALS", "allows no literals" },
  { "~ZXQP0062_ONE_LITERAL", "requires exactly one literal" },
  { "~ZXQP0062_ONE_OR_MORE_LITERALS", "requires one or more literals" },
  { "~ZXQP0062_ZERO_OR_ONE_LITERALS", "allows at most one literal" },
  { "~ZXQP0065_NO_ARGUMENTS", "function has no arguments" },
  { "~ZeroLenURI", "zero-length URI (and no base URI given)" },
  { "~dynamic error", "dynamic error" },
  { "~dynamic warning", "dynamic warning" },
  { "~error", "error" },
  { "~libxml_1", "libxml internal error${: 9}" },
  { "~libxml_100", "xmlns$6?{:5}\\: URI \"$6?6:5\": invalid URI" },
  { "~libxml_101", "encoding expected in text declaration" },
  { "~libxml_102", "\"$5\": invalid value for \"xml:space\"; either \"default\" or \"preserve\" expected" },
  { "~libxml_103", "\"$5\": entity marked standalone but requires external subset" },
  { "~libxml_104", "\"$5\": failed to process entity or called while not in subset" },
  { "~libxml_105", "\"$5\": external or public ID missing or called while not in subset" },
  { "~libxml_106", "\"$5\": avoid attribute ending with ':'" },
  { "~libxml_107", "\"$5\": entity already defined in the internal subset" },
  { "~libxml_108", "\"$5\": unsupprted XML version" },
  { "~libxml_109", "document/entity version mismatch" },
  { "~libxml_110", "$5 too long (use XML_PARSE_HUGE option)" },
  { "~libxml_18", "PE reference at end of XML document" },
  { "~libxml_19", "PE reference in prolog" },
  { "~libxml_2", "out of memory${: 9}" },
  { "~libxml_20", "PE reference in epilog" },
  { "~libxml_200", "${\"5\": }invalid namespace or prefix" },
  { "~libxml_201", "${\"5\": }namespace prefix${ for \"7?6\"}${ on \"7?7:6\"} not defined" },
  { "~libxml_202", "\"$5${:6}\": invalid XML QName" },
  { "~libxml_203", "\"$5\": attribute in namespace \"$6\" redefined" },
  { "~libxml_204", "empty namespace for prefix \"$5\"" },
  { "~libxml_205", "\"$5\": colon is forbidden in entity, notation, and processing instruction names" },
  { "~libxml_21", "PE reference forbidden within markup declaration in internal subset" },
  { "~libxml_23", "';' expected at end of character entity reference" },
  { "~libxml_24", "PE reference: no name" },
  { "~libxml_25", "PE reference: ';' expected" },
  { "~libxml_26", "${\"5\": }undeclared entity reference" },
  { "~libxml_27", "${\"5\": }undeclared entity reference" },
  { "~libxml_28", "${\"5\": }entity reference to unparsed entity" },
  { "~libxml_29", "${\"5\": }external entity referenced by attribute" },
  { "~libxml_30", "${\"5\": }parameter entity attempted reference" },
  { "~libxml_31", "${\"5\": }unknown character encoding" },
  { "~libxml_32", "${\"5\": }unsupported character encoding" },
  { "~libxml_33", "string not started (' or \" expected)" },
  { "~libxml_34", "string not ended (' or \" expected)" },
  { "~libxml_35", "${\"5\": }invalid namespace declaration" },
  { "~libxml_36", "entity value not started (' or \" expected)" },
  { "~libxml_37", "${\"5\": }entity value not ended (' or \" expected)" },
  { "~libxml_38", "unescaped '<' not allowed in attribute values" },
  { "~libxml_39", "attribute value not started (' or \" expected)" },
  { "~libxml_4", "empty XML document ('<' expected)" },
  { "~libxml_40", "attribute value not ended (' or \" expected) or too big" },
  { "~libxml_41", "${\"5\": }attribute must have a value" },
  { "~libxml_42", "\"$6?{5:}$6?6:5\" attribute redefined" },
  { "~libxml_43", "' or \" expected" },
  { "~libxml_44", "' or \" expected to end System or Public ID literal" },
  { "~libxml_45", "comment not ended (\"-->\" expected) or too big" },
  { "~libxml_46", "processing instruction not started correctly (missing target name?)" },
  { "~libxml_47", "processing instruction \"$5\" not ended (\"?>\" expected) or too big" },
  { "~libxml_48", "notation name expected" },
  { "~libxml_49", "'>' expected to end notation declaration" },
  { "~libxml_5", "extra content at end of XML document" },
  { "~libxml_50", "'(' expected to start ATTLIST enumeration" },
  { "~libxml_500", "\"$5\": invalid attribute value" },
  { "~libxml_501", "\"$5\": attribute of element \"$6\" already defined" },
  { "~libxml_502", "\"$5\": invalid attribute value" },
  { "~libxml_503", "\"$5\": defintion has duplicate references to \"$6\"" },
  { "~libxml_504", "${\"5:\" }element content does not follow DTD" },
  { "~libxml_505", "\"$5\": content model is not deteministic" },
  { "~libxml_506", "element \"$5\" required attribute \"$6:$7\" has different prefix" },
  { "~libxml_507", "\"$5\": element namespace name for default namespace does not match DTD" },
  { "~libxml_508", "\"$7?6:5\": invalid attribute value or element namespace name does not match DTD" },
  { "~libxml_509", "\"$5\": element redefined" },
  { "~libxml_51", "')' expected to end ATTLIST enumeration" },
  { "~libxml_510", "\"$5\": notation attribute declared \"EMPTY\" for element \"$6\"" },
  { "~libxml_511", "\"$5\": ENTITY attribute references an entity \"$6\" of wrong type" },
  { "~libxml_512", "\"$5\": invalid ID attribute of \"$6\" (\"#IMPLIED\" or \"#REQUIRED\" expected)" },
  { "~libxml_513", "\"$5\": ID already defined" },
  { "~libxml_514", "\"$5\": element has${ 8} attribute(s) defined in the internal subset: \"$6\"" },
  { "~libxml_515", "\"$5\": element not declared in list of possible children of \"$6\"" },
  { "~libxml_516", "\"xmlns$6?{:5}\" invalid attribute of \"$6?6:5\"" },
  { "~libxml_517", "\"$5\": could not load external subset" },
  { "~libxml_518", "\"$7?{6:}$7?7:6\": attribute not carried by element \"$5\"" },
  { "~libxml_519", "internal MIXED struct corrupted" },
  { "~libxml_52", "'|' or \")*\" expected for mixed content declaration" },
  { "~libxml_520", "\"$5\": element has too many ID attributes defined: \"$6\"" },
  { "~libxml_521", "document is null" },
  { "~libxml_522", "document without internal/external subset or no DTD found" },
  { "~libxml_524", "\"$6:$7\": required attribute of element \"$5\" has no prefix" },
  { "~libxml_525", "no root element" },
  { "~libxml_526", "\"$5\": notation already defined" },
  { "~libxml_527", "\"$5\": value for attribute \"xmlns$7?{:6}\" of element \"$7?7:6\" is not among the enumerated notations" },
  { "~libxml_528", "\"$5\": element declared empty but has content" },
  { "~libxml_529", "\"$5\": element declared \"#PCDATA\" but has non-text nodes" },
  { "~libxml_530", "\"$5\" on \"$6\" value has to be normalized based on external subset declaration" },
  { "~libxml_531", "\"$5\"/\"$6\": root/DTD name mismatch" },
  { "~libxml_532", "\"$5\": element declared in external subset contains whitespace nodes" },
  { "~libxml_533", "\"$6?5:{xmlns}\": attribute not declared for element \"$6?6:5\"" },
  { "~libxml_534", "\"$6?6:5\": undeclared element$6?{ for attribute \"5\"}" },
  { "~libxml_535", "$5?{\"6\": unknown entity referenced by attribute \"5\"}:{unknown entity type}" },
  { "~libxml_536", "\"$5\": attribute references an unknown ID \"$6\"${ on line 8}\"" },
  { "~libxml_537", "\"$5\": unknown notation" },
  { "~libxml_538", "\"$5\": attribute on \"$7\" defaulted from external subset" },
  { "~libxml_539", "\"$5\": xml:id attribute value is not an NCName" },
  { "~libxml_54", "$5?5:{name or} '(' expected for content declaration" },
  { "~libxml_540", "\"$5\": xml:id attribute type must be ID" },
  { "~libxml_541", "\"$5\": duplicate attribute enumeration value token" },
  { "~libxml_55", "',', '|', or ')' expected in content declaration${ or depth 8 too deep}" },
  { "~libxml_56", "\"<?xml\" required to start XML declaration" },
  { "~libxml_57", "\"?>\" expected to end XML declaration" },
  { "~libxml_59", "XML conditional section not ended" },
  { "~libxml_6", "${\"5\": }invalid hexedecimal value for character reference" },
  { "~libxml_60", "content error in external subset" },
  { "~libxml_61", "DOCTYPE improperly ended" },
  { "~libxml_62", "\"]]>\" not allowed in content" },
  { "~libxml_63", "CDATA not ended (\"]]>\" expected) or too big" },
  { "~libxml_64", "\"xml\": reserved XML prefix" },
  { "~libxml_65", "space required here" },
  { "~libxml_66", "'$8' expected" },
  { "~libxml_67", "NMTOKEN expected in ATTLIST enumeration" },
  { "~libxml_68", "name expected" },
  { "~libxml_69", "\"#PCDATA\" expected" },
  { "~libxml_7", "${\"5\": }invalid decimal value for character reference" },
  { "~libxml_70", "URI expected for SYSTEM or PUBLIC" },
  { "~libxml_71", "PUBLIC identifier expected" },
  { "~libxml_72", "'<' expected" },
  { "~libxml_73", "'>' expected" },
  { "~libxml_74", "\"</\" expected" },
  { "~libxml_75", "'=' expected" },
  { "~libxml_76", "\"</$6>\": closing tag mismatch for \"<$5>\"" },
  { "~libxml_77", "\"$5\": premature end of content for tag starting on line $8" },
  { "~libxml_78", "\"yes\" or \"no\" expected for \"standalone\"" },
  { "~libxml_79", "invalid XML encoding name" },
  { "~libxml_8", "${\"5\": }invalid value for character reference" },
  { "~libxml_80", "\"--\" forbidden within XML comment" },
  { "~libxml_81", "document labelled UTF-16 but has UTF-8 content" },
  { "~libxml_83", "'[' expected in XML condition section" },
  { "~libxml_84", "entity value expected" },
  { "~libxml_85", "XML chunk is not well-balanced" },
  { "~libxml_86", "extra content at end of well-balanced chunk" },
  { "~libxml_87", "'$8' forbidden except for entity references" },
  { "~libxml_88", "invalid entity type" },
  { "~libxml_89", "entity reference loop" },
  { "~libxml_9", "${\"&#8;\": }invalid XML character value" },
  { "~libxml_90", "declaration must start and end in the same entity" },
  { "~libxml_91", "\"$5\": invalid URI" },
  { "~libxml_92", "URI fragment not allowed" },
  { "~libxml_93", "\"$5\": catalog processing instruction syntax error" },
  { "~libxml_94", "validation failed: no DTD found" },
  { "~libxml_95", "\"IGNORE\" or \"INCLUDE\" expected" },
  { "~libxml_96", "XML version expected" },
  { "~libxml_97", "\"$5\": unsupported XML version" },
  { "~libxml_98", "\"$5\": malformed xml:lang value" },
  { "~libxml_99", "xmlns$6?{:5}\\: URI \"$6?6:5\": invalid URI" },
  { "~libxml_99", "xmlns$6?{:5}\\: URI \"$6?6:5\": invalid URI" },
  { "~static error", "static error" },
  { "~static warning", "static warning" },
  { "~type error", "type error" },
  { "~type warning", "type warning" },
  { "~warning", "warning" },
  { "~xqueryx_empty_content", "xqueryx content is empty" },
};
DEF_DICT_END(en);

} // namespace dict
} // namespace diagnostic
} // namespace zorba
/*
 * Local variables:
 * mode: c++
 * End:
 */ 
