/*
 * Copyright 2006-2008 The FLWOR Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once
#ifndef ZORBA_JSONIQ_SCANNER_H
#define ZORBA_JSONIQ_SCANNER_H

// Flex expects the signature of yylex to be defined in the macro YY_DECL, and
// the C++ parser expects it to be declared. We can factor both as follows.

#ifdef YY_DECL
#undef YY_DECL
#endif

#define YY_DECL                                            \
  zorba::jsoniq_parser::token_type                         \
  zorba::jsoniq_scanner::lex(                              \
    zorba::jsoniq_parser::semantic_type* yylval,           \
    zorba::jsoniq_parser::location_type* yylloc            \
    )

#ifndef YY_USER_ACTION
#define YY_USER_ACTION    YY_USER_ACTION_func(yylloc);
#endif


#ifndef yyFlexLexer
#  define yyFlexLexer ZorbaJSONiqFlexLexer
#  define ZORBAJSONIQFLEXLEXER_DEFINED
#  if defined(ZORBA_HAVE_FLEXLEXER_H) && defined(FLEX_FILES_REGENERATED)
#    include <FlexLexer.h>
#  else
#    include "compiler/parser/FlexLexer.h"
#  endif
#endif


#ifdef __GNUC__
  // disable a warning in location.hh which comes with bison
  // position.hh:141: warning: suggest parentheses around && within ||
#  pragma GCC diagnostic ignored "-Wparentheses"
#endif

#include "compiler/parser/jsoniq_parser.hpp"

#ifdef __GNUC__
#  pragma GCC diagnostic warning "-Wparentheses"
#endif


namespace zorba {

class xquery_driver;

class jsoniq_scanner : public ZorbaJSONiqFlexLexer
{
protected:
  xquery_driver* theDriver;
  int cond_stk_depth;
  std::string yy_comp_constr_qname; // used by the scanner to temporarely save the qname of a computed constructor expression

public:
  /** Create a new scanner object. The streams arg_yyin and arg_yyout default
   * to cin and cout, but that assignment is only made when initializing in
   * yylex(). */
  jsoniq_scanner(xquery_driver* aDriver, std::istream* arg_yyin = 0, std::ostream* arg_yyout = 0);

  /** Required for virtual functions */
  virtual ~jsoniq_scanner();

  /** This is the main lexing function. It is generated by flex according to
   * the macro declaration YY_DECL above. The generated bison parser then
   * calls this virtual function to fetch new tokens. */
  virtual
  zorba::jsoniq_parser::token_type lex (
    zorba::jsoniq_parser::semantic_type* yylval,
    zorba::jsoniq_parser::location_type* yylloc
  );

  xquery_driver* getDriver() const { return theDriver; }
  void set_yy_flex_debug(bool aBool);

  int interpretAsLessThan();

  void YY_USER_ACTION_func(zorba::jsoniq_parser::location_type* yylloc);

protected:
  int yy_get_start_stack_ptr(void) const;
};

}

#endif // EXAMPLE_SCANNER_H
/* vim:set et sw=2 ts=2: */
