declare namespace opt = "http://zorba.io/options/optimizer";

declare option opt:enable "for-serialization-only";

declare variable $input-context external;

let $auction := doc($input-context) 
return
  let $ca := $auction/site/closed_auctions/closed_auction 
  return
    let $ei := $auction/site/regions/europe/item
    for $p in $auction/site/people/person
    let $a := for $t in $ca
              where $p/@id = $t/buyer/@person
              return
                let $n := for $t2 in $ei
                          where $t/itemref/@item = $t2/@id
                          return $t2
                return <item>{$n/name/text()}</item>
    return <person name="{$p/name/text()}">{$a}</person>
