const ctz = @import("count0bits.zig");
const testing = @import("std").testing;

fn test__ctzsi2(a: u32, expected: i32) !void {
    var x = @bitCast(i32, a);
    var result = ctz.__ctzsi2(x);
    try testing.expectEqual(expected, result);
}

test "ctzsi2" {
    try test__ctzsi2(0x00000001, 0);
    try test__ctzsi2(0x00000002, 1);
    try test__ctzsi2(0x00000003, 0);
    try test__ctzsi2(0x00000004, 2);
    try test__ctzsi2(0x00000005, 0);
    try test__ctzsi2(0x00000006, 1);
    try test__ctzsi2(0x00000007, 0);
    try test__ctzsi2(0x00000008, 3);
    try test__ctzsi2(0x00000009, 0);
    try test__ctzsi2(0x0000000A, 1);
    try test__ctzsi2(0x0000000B, 0);
    try test__ctzsi2(0x0000000C, 2);
    try test__ctzsi2(0x0000000D, 0);
    try test__ctzsi2(0x0000000E, 1);
    try test__ctzsi2(0x0000000F, 0);
    try test__ctzsi2(0x00000010, 4);
    try test__ctzsi2(0x00000011, 0);
    try test__ctzsi2(0x00000012, 1);
    try test__ctzsi2(0x00000013, 0);
    try test__ctzsi2(0x00000014, 2);
    try test__ctzsi2(0x00000015, 0);
    try test__ctzsi2(0x00000016, 1);
    try test__ctzsi2(0x00000017, 0);
    try test__ctzsi2(0x00000018, 3);
    try test__ctzsi2(0x00000019, 0);
    try test__ctzsi2(0x0000001A, 1);
    try test__ctzsi2(0x0000001B, 0);
    try test__ctzsi2(0x0000001C, 2);
    try test__ctzsi2(0x0000001D, 0);
    try test__ctzsi2(0x0000001E, 1);
    try test__ctzsi2(0x0000001F, 0);
    try test__ctzsi2(0x00000020, 5);
    try test__ctzsi2(0x00000021, 0);
    try test__ctzsi2(0x00000022, 1);
    try test__ctzsi2(0x00000023, 0);
    try test__ctzsi2(0x00000024, 2);
    try test__ctzsi2(0x00000025, 0);
    try test__ctzsi2(0x00000026, 1);
    try test__ctzsi2(0x00000027, 0);
    try test__ctzsi2(0x00000028, 3);
    try test__ctzsi2(0x00000029, 0);
    try test__ctzsi2(0x0000002A, 1);
    try test__ctzsi2(0x0000002B, 0);
    try test__ctzsi2(0x0000002C, 2);
    try test__ctzsi2(0x0000002D, 0);
    try test__ctzsi2(0x0000002E, 1);
    try test__ctzsi2(0x0000002F, 0);
    try test__ctzsi2(0x00000030, 4);
    try test__ctzsi2(0x00000031, 0);
    try test__ctzsi2(0x00000032, 1);
    try test__ctzsi2(0x00000033, 0);
    try test__ctzsi2(0x00000034, 2);
    try test__ctzsi2(0x00000035, 0);
    try test__ctzsi2(0x00000036, 1);
    try test__ctzsi2(0x00000037, 0);
    try test__ctzsi2(0x00000038, 3);
    try test__ctzsi2(0x00000039, 0);
    try test__ctzsi2(0x0000003A, 1);
    try test__ctzsi2(0x0000003B, 0);
    try test__ctzsi2(0x0000003C, 2);
    try test__ctzsi2(0x0000003D, 0);
    try test__ctzsi2(0x0000003E, 1);
    try test__ctzsi2(0x0000003F, 0);
    try test__ctzsi2(0x00000040, 6);
    try test__ctzsi2(0x00000041, 0);
    try test__ctzsi2(0x00000042, 1);
    try test__ctzsi2(0x00000043, 0);
    try test__ctzsi2(0x00000044, 2);
    try test__ctzsi2(0x00000045, 0);
    try test__ctzsi2(0x00000046, 1);
    try test__ctzsi2(0x00000047, 0);
    try test__ctzsi2(0x00000048, 3);
    try test__ctzsi2(0x00000049, 0);
    try test__ctzsi2(0x0000004A, 1);
    try test__ctzsi2(0x0000004B, 0);
    try test__ctzsi2(0x0000004C, 2);
    try test__ctzsi2(0x0000004D, 0);
    try test__ctzsi2(0x0000004E, 1);
    try test__ctzsi2(0x0000004F, 0);
    try test__ctzsi2(0x00000050, 4);
    try test__ctzsi2(0x00000051, 0);
    try test__ctzsi2(0x00000052, 1);
    try test__ctzsi2(0x00000053, 0);
    try test__ctzsi2(0x00000054, 2);
    try test__ctzsi2(0x00000055, 0);
    try test__ctzsi2(0x00000056, 1);
    try test__ctzsi2(0x00000057, 0);
    try test__ctzsi2(0x00000058, 3);
    try test__ctzsi2(0x00000059, 0);
    try test__ctzsi2(0x0000005A, 1);
    try test__ctzsi2(0x0000005B, 0);
    try test__ctzsi2(0x0000005C, 2);
    try test__ctzsi2(0x0000005D, 0);
    try test__ctzsi2(0x0000005E, 1);
    try test__ctzsi2(0x0000005F, 0);
    try test__ctzsi2(0x00000060, 5);
    try test__ctzsi2(0x00000061, 0);
    try test__ctzsi2(0x00000062, 1);
    try test__ctzsi2(0x00000063, 0);
    try test__ctzsi2(0x00000064, 2);
    try test__ctzsi2(0x00000065, 0);
    try test__ctzsi2(0x00000066, 1);
    try test__ctzsi2(0x00000067, 0);
    try test__ctzsi2(0x00000068, 3);
    try test__ctzsi2(0x00000069, 0);
    try test__ctzsi2(0x0000006A, 1);
    try test__ctzsi2(0x0000006B, 0);
    try test__ctzsi2(0x0000006C, 2);
    try test__ctzsi2(0x0000006D, 0);
    try test__ctzsi2(0x0000006E, 1);
    try test__ctzsi2(0x0000006F, 0);
    try test__ctzsi2(0x00000070, 4);
    try test__ctzsi2(0x00000071, 0);
    try test__ctzsi2(0x00000072, 1);
    try test__ctzsi2(0x00000073, 0);
    try test__ctzsi2(0x00000074, 2);
    try test__ctzsi2(0x00000075, 0);
    try test__ctzsi2(0x00000076, 1);
    try test__ctzsi2(0x00000077, 0);
    try test__ctzsi2(0x00000078, 3);
    try test__ctzsi2(0x00000079, 0);
    try test__ctzsi2(0x0000007A, 1);
    try test__ctzsi2(0x0000007B, 0);
    try test__ctzsi2(0x0000007C, 2);
    try test__ctzsi2(0x0000007D, 0);
    try test__ctzsi2(0x0000007E, 1);
    try test__ctzsi2(0x0000007F, 0);
    try test__ctzsi2(0x00000080, 7);
    try test__ctzsi2(0x00000081, 0);
    try test__ctzsi2(0x00000082, 1);
    try test__ctzsi2(0x00000083, 0);
    try test__ctzsi2(0x00000084, 2);
    try test__ctzsi2(0x00000085, 0);
    try test__ctzsi2(0x00000086, 1);
    try test__ctzsi2(0x00000087, 0);
    try test__ctzsi2(0x00000088, 3);
    try test__ctzsi2(0x00000089, 0);
    try test__ctzsi2(0x0000008A, 1);
    try test__ctzsi2(0x0000008B, 0);
    try test__ctzsi2(0x0000008C, 2);
    try test__ctzsi2(0x0000008D, 0);
    try test__ctzsi2(0x0000008E, 1);
    try test__ctzsi2(0x0000008F, 0);
    try test__ctzsi2(0x00000090, 4);
    try test__ctzsi2(0x00000091, 0);
    try test__ctzsi2(0x00000092, 1);
    try test__ctzsi2(0x00000093, 0);
    try test__ctzsi2(0x00000094, 2);
    try test__ctzsi2(0x00000095, 0);
    try test__ctzsi2(0x00000096, 1);
    try test__ctzsi2(0x00000097, 0);
    try test__ctzsi2(0x00000098, 3);
    try test__ctzsi2(0x00000099, 0);
    try test__ctzsi2(0x0000009A, 1);
    try test__ctzsi2(0x0000009B, 0);
    try test__ctzsi2(0x0000009C, 2);
    try test__ctzsi2(0x0000009D, 0);
    try test__ctzsi2(0x0000009E, 1);
    try test__ctzsi2(0x0000009F, 0);
    try test__ctzsi2(0x000000A0, 5);
    try test__ctzsi2(0x000000A1, 0);
    try test__ctzsi2(0x000000A2, 1);
    try test__ctzsi2(0x000000A3, 0);
    try test__ctzsi2(0x000000A4, 2);
    try test__ctzsi2(0x000000A5, 0);
    try test__ctzsi2(0x000000A6, 1);
    try test__ctzsi2(0x000000A7, 0);
    try test__ctzsi2(0x000000A8, 3);
    try test__ctzsi2(0x000000A9, 0);
    try test__ctzsi2(0x000000AA, 1);
    try test__ctzsi2(0x000000AB, 0);
    try test__ctzsi2(0x000000AC, 2);
    try test__ctzsi2(0x000000AD, 0);
    try test__ctzsi2(0x000000AE, 1);
    try test__ctzsi2(0x000000AF, 0);
    try test__ctzsi2(0x000000B0, 4);
    try test__ctzsi2(0x000000B1, 0);
    try test__ctzsi2(0x000000B2, 1);
    try test__ctzsi2(0x000000B3, 0);
    try test__ctzsi2(0x000000B4, 2);
    try test__ctzsi2(0x000000B5, 0);
    try test__ctzsi2(0x000000B6, 1);
    try test__ctzsi2(0x000000B7, 0);
    try test__ctzsi2(0x000000B8, 3);
    try test__ctzsi2(0x000000B9, 0);
    try test__ctzsi2(0x000000BA, 1);
    try test__ctzsi2(0x000000BB, 0);
    try test__ctzsi2(0x000000BC, 2);
    try test__ctzsi2(0x000000BD, 0);
    try test__ctzsi2(0x000000BE, 1);
    try test__ctzsi2(0x000000BF, 0);
    try test__ctzsi2(0x000000C0, 6);
    try test__ctzsi2(0x000000C1, 0);
    try test__ctzsi2(0x000000C2, 1);
    try test__ctzsi2(0x000000C3, 0);
    try test__ctzsi2(0x000000C4, 2);
    try test__ctzsi2(0x000000C5, 0);
    try test__ctzsi2(0x000000C6, 1);
    try test__ctzsi2(0x000000C7, 0);
    try test__ctzsi2(0x000000C8, 3);
    try test__ctzsi2(0x000000C9, 0);
    try test__ctzsi2(0x000000CA, 1);
    try test__ctzsi2(0x000000CB, 0);
    try test__ctzsi2(0x000000CC, 2);
    try test__ctzsi2(0x000000CD, 0);
    try test__ctzsi2(0x000000CE, 1);
    try test__ctzsi2(0x000000CF, 0);
    try test__ctzsi2(0x000000D0, 4);
    try test__ctzsi2(0x000000D1, 0);
    try test__ctzsi2(0x000000D2, 1);
    try test__ctzsi2(0x000000D3, 0);
    try test__ctzsi2(0x000000D4, 2);
    try test__ctzsi2(0x000000D5, 0);
    try test__ctzsi2(0x000000D6, 1);
    try test__ctzsi2(0x000000D7, 0);
    try test__ctzsi2(0x000000D8, 3);
    try test__ctzsi2(0x000000D9, 0);
    try test__ctzsi2(0x000000DA, 1);
    try test__ctzsi2(0x000000DB, 0);
    try test__ctzsi2(0x000000DC, 2);
    try test__ctzsi2(0x000000DD, 0);
    try test__ctzsi2(0x000000DE, 1);
    try test__ctzsi2(0x000000DF, 0);
    try test__ctzsi2(0x000000E0, 5);
    try test__ctzsi2(0x000000E1, 0);
    try test__ctzsi2(0x000000E2, 1);
    try test__ctzsi2(0x000000E3, 0);
    try test__ctzsi2(0x000000E4, 2);
    try test__ctzsi2(0x000000E5, 0);
    try test__ctzsi2(0x000000E6, 1);
    try test__ctzsi2(0x000000E7, 0);
    try test__ctzsi2(0x000000E8, 3);
    try test__ctzsi2(0x000000E9, 0);
    try test__ctzsi2(0x000000EA, 1);
    try test__ctzsi2(0x000000EB, 0);
    try test__ctzsi2(0x000000EC, 2);
    try test__ctzsi2(0x000000ED, 0);
    try test__ctzsi2(0x000000EE, 1);
    try test__ctzsi2(0x000000EF, 0);
    try test__ctzsi2(0x000000F0, 4);
    try test__ctzsi2(0x000000F1, 0);
    try test__ctzsi2(0x000000F2, 1);
    try test__ctzsi2(0x000000F3, 0);
    try test__ctzsi2(0x000000F4, 2);
    try test__ctzsi2(0x000000F5, 0);
    try test__ctzsi2(0x000000F6, 1);
    try test__ctzsi2(0x000000F7, 0);
    try test__ctzsi2(0x000000F8, 3);
    try test__ctzsi2(0x000000F9, 0);
    try test__ctzsi2(0x000000FA, 1);
    try test__ctzsi2(0x000000FB, 0);
    try test__ctzsi2(0x000000FC, 2);
    try test__ctzsi2(0x000000FD, 0);
    try test__ctzsi2(0x000000FE, 1);
    try test__ctzsi2(0x000000FF, 0);

    try test__ctzsi2(0x00000000, 32);
    try test__ctzsi2(0x80000000, 31);
    try test__ctzsi2(0x40000000, 30);
    try test__ctzsi2(0x20000000, 29);
    try test__ctzsi2(0x10000000, 28);
    try test__ctzsi2(0x08000000, 27);
    try test__ctzsi2(0x04000000, 26);
    try test__ctzsi2(0x02000000, 25);
    try test__ctzsi2(0x01000000, 24);
    try test__ctzsi2(0x00800000, 23);
    try test__ctzsi2(0x00400000, 22);
    try test__ctzsi2(0x00200000, 21);
    try test__ctzsi2(0x00100000, 20);
    try test__ctzsi2(0x00080000, 19);
    try test__ctzsi2(0x00040000, 18);
    try test__ctzsi2(0x00020000, 17);
    try test__ctzsi2(0x00010000, 16);
    try test__ctzsi2(0x00008000, 15);
    try test__ctzsi2(0x00004000, 14);
    try test__ctzsi2(0x00002000, 13);
    try test__ctzsi2(0x00001000, 12);
    try test__ctzsi2(0x00000800, 11);
    try test__ctzsi2(0x00000400, 10);
    try test__ctzsi2(0x00000200, 9);
    try test__ctzsi2(0x00000100, 8);
}
