const builtin = @import("builtin");

pub const struct_ZigClangAPSInt = @OpaqueType();
pub const struct_ZigClangAPFloat = @OpaqueType();
pub const struct_ZigClangASTContext = @OpaqueType();
pub const struct_ZigClangASTUnit = @OpaqueType();
pub const struct_ZigClangArraySubscriptExpr = @OpaqueType();
pub const struct_ZigClangArrayType = @OpaqueType();
pub const struct_ZigClangAttributedType = @OpaqueType();
pub const struct_ZigClangBinaryOperator = @OpaqueType();
pub const struct_ZigClangBreakStmt = @OpaqueType();
pub const struct_ZigClangBuiltinType = @OpaqueType();
pub const struct_ZigClangCStyleCastExpr = @OpaqueType();
pub const struct_ZigClangCallExpr = @OpaqueType();
pub const struct_ZigClangCaseStmt = @OpaqueType();
pub const struct_ZigClangCompoundAssignOperator = @OpaqueType();
pub const struct_ZigClangCompoundStmt = @OpaqueType();
pub const struct_ZigClangConditionalOperator = @OpaqueType();
pub const struct_ZigClangConstantArrayType = @OpaqueType();
pub const struct_ZigClangContinueStmt = @OpaqueType();
pub const struct_ZigClangDecayedType = @OpaqueType();
pub const struct_ZigClangDecl = @OpaqueType();
pub const struct_ZigClangDeclRefExpr = @OpaqueType();
pub const struct_ZigClangDeclStmt = @OpaqueType();
pub const struct_ZigClangDefaultStmt = @OpaqueType();
pub const struct_ZigClangDiagnosticOptions = @OpaqueType();
pub const struct_ZigClangDiagnosticsEngine = @OpaqueType();
pub const struct_ZigClangDoStmt = @OpaqueType();
pub const struct_ZigClangElaboratedType = @OpaqueType();
pub const struct_ZigClangEnumConstantDecl = @OpaqueType();
pub const struct_ZigClangEnumDecl = @OpaqueType();
pub const struct_ZigClangEnumType = @OpaqueType();
pub const struct_ZigClangExpr = @OpaqueType();
pub const struct_ZigClangFieldDecl = @OpaqueType();
pub const struct_ZigClangFileID = @OpaqueType();
pub const struct_ZigClangForStmt = @OpaqueType();
pub const struct_ZigClangFullSourceLoc = @OpaqueType();
pub const struct_ZigClangFunctionDecl = @OpaqueType();
pub const struct_ZigClangFunctionProtoType = @OpaqueType();
pub const struct_ZigClangIfStmt = @OpaqueType();
pub const struct_ZigClangImplicitCastExpr = @OpaqueType();
pub const struct_ZigClangIncompleteArrayType = @OpaqueType();
pub const struct_ZigClangIntegerLiteral = @OpaqueType();
pub const struct_ZigClangMacroDefinitionRecord = @OpaqueType();
pub const struct_ZigClangMemberExpr = @OpaqueType();
pub const struct_ZigClangNamedDecl = @OpaqueType();
pub const struct_ZigClangNone = @OpaqueType();
pub const struct_ZigClangPCHContainerOperations = @OpaqueType();
pub const struct_ZigClangParenExpr = @OpaqueType();
pub const struct_ZigClangParenType = @OpaqueType();
pub const struct_ZigClangParmVarDecl = @OpaqueType();
pub const struct_ZigClangPointerType = @OpaqueType();
pub const struct_ZigClangPreprocessedEntity = @OpaqueType();
pub const struct_ZigClangRecordDecl = @OpaqueType();
pub const struct_ZigClangRecordType = @OpaqueType();
pub const struct_ZigClangReturnStmt = @OpaqueType();
pub const struct_ZigClangSkipFunctionBodiesScope = @OpaqueType();
pub const struct_ZigClangSourceManager = @OpaqueType();
pub const struct_ZigClangSourceRange = @OpaqueType();
pub const struct_ZigClangStmt = @OpaqueType();
pub const struct_ZigClangStringLiteral = @OpaqueType();
pub const struct_ZigClangStringRef = @OpaqueType();
pub const struct_ZigClangSwitchStmt = @OpaqueType();
pub const struct_ZigClangTagDecl = @OpaqueType();
pub const struct_ZigClangType = @OpaqueType();
pub const struct_ZigClangTypedefNameDecl = @OpaqueType();
pub const struct_ZigClangTypedefType = @OpaqueType();
pub const struct_ZigClangUnaryExprOrTypeTraitExpr = @OpaqueType();
pub const struct_ZigClangUnaryOperator = @OpaqueType();
pub const struct_ZigClangValueDecl = @OpaqueType();
pub const struct_ZigClangVarDecl = @OpaqueType();
pub const struct_ZigClangWhileStmt = @OpaqueType();
pub const struct_ZigClangFunctionType = @OpaqueType();
pub const struct_ZigClangPredefinedExpr = @OpaqueType();

pub const ZigClangBO = extern enum {
    PtrMemD,
    PtrMemI,
    Mul,
    Div,
    Rem,
    Add,
    Sub,
    Shl,
    Shr,
    Cmp,
    LT,
    GT,
    LE,
    GE,
    EQ,
    NE,
    And,
    Xor,
    Or,
    LAnd,
    LOr,
    Assign,
    MulAssign,
    DivAssign,
    RemAssign,
    AddAssign,
    SubAssign,
    ShlAssign,
    ShrAssign,
    AndAssign,
    XorAssign,
    OrAssign,
    Comma,
};

pub const ZigClangUO = extern enum {
    PostInc,
    PostDec,
    PreInc,
    PreDec,
    AddrOf,
    Deref,
    Plus,
    Minus,
    Not,
    LNot,
    Real,
    Imag,
    Extension,
    Coawait,
};

pub const ZigClangTypeClass = extern enum {
    Builtin,
    Complex,
    Pointer,
    BlockPointer,
    LValueReference,
    RValueReference,
    MemberPointer,
    ConstantArray,
    IncompleteArray,
    VariableArray,
    DependentSizedArray,
    DependentSizedExtVector,
    DependentAddressSpace,
    Vector,
    DependentVector,
    ExtVector,
    FunctionProto,
    FunctionNoProto,
    UnresolvedUsing,
    Paren,
    Typedef,
    MacroQualified,
    Adjusted,
    Decayed,
    TypeOfExpr,
    TypeOf,
    Decltype,
    UnaryTransform,
    Record,
    Enum,
    Elaborated,
    Attributed,
    TemplateTypeParm,
    SubstTemplateTypeParm,
    SubstTemplateTypeParmPack,
    TemplateSpecialization,
    Auto,
    DeducedTemplateSpecialization,
    InjectedClassName,
    DependentName,
    DependentTemplateSpecialization,
    PackExpansion,
    ObjCTypeParam,
    ObjCObject,
    ObjCInterface,
    ObjCObjectPointer,
    Pipe,
    Atomic,
};

const ZigClangStmtClass = extern enum {
    NoStmtClass,
    GCCAsmStmtClass,
    MSAsmStmtClass,
    BreakStmtClass,
    CXXCatchStmtClass,
    CXXForRangeStmtClass,
    CXXTryStmtClass,
    CapturedStmtClass,
    CompoundStmtClass,
    ContinueStmtClass,
    CoreturnStmtClass,
    CoroutineBodyStmtClass,
    DeclStmtClass,
    DoStmtClass,
    ForStmtClass,
    GotoStmtClass,
    IfStmtClass,
    IndirectGotoStmtClass,
    MSDependentExistsStmtClass,
    NullStmtClass,
    OMPAtomicDirectiveClass,
    OMPBarrierDirectiveClass,
    OMPCancelDirectiveClass,
    OMPCancellationPointDirectiveClass,
    OMPCriticalDirectiveClass,
    OMPFlushDirectiveClass,
    OMPDistributeDirectiveClass,
    OMPDistributeParallelForDirectiveClass,
    OMPDistributeParallelForSimdDirectiveClass,
    OMPDistributeSimdDirectiveClass,
    OMPForDirectiveClass,
    OMPForSimdDirectiveClass,
    OMPParallelForDirectiveClass,
    OMPParallelForSimdDirectiveClass,
    OMPSimdDirectiveClass,
    OMPTargetParallelForSimdDirectiveClass,
    OMPTargetSimdDirectiveClass,
    OMPTargetTeamsDistributeDirectiveClass,
    OMPTargetTeamsDistributeParallelForDirectiveClass,
    OMPTargetTeamsDistributeParallelForSimdDirectiveClass,
    OMPTargetTeamsDistributeSimdDirectiveClass,
    OMPTaskLoopDirectiveClass,
    OMPTaskLoopSimdDirectiveClass,
    OMPTeamsDistributeDirectiveClass,
    OMPTeamsDistributeParallelForDirectiveClass,
    OMPTeamsDistributeParallelForSimdDirectiveClass,
    OMPTeamsDistributeSimdDirectiveClass,
    OMPMasterDirectiveClass,
    OMPOrderedDirectiveClass,
    OMPParallelDirectiveClass,
    OMPParallelSectionsDirectiveClass,
    OMPSectionDirectiveClass,
    OMPSectionsDirectiveClass,
    OMPSingleDirectiveClass,
    OMPTargetDataDirectiveClass,
    OMPTargetDirectiveClass,
    OMPTargetEnterDataDirectiveClass,
    OMPTargetExitDataDirectiveClass,
    OMPTargetParallelDirectiveClass,
    OMPTargetParallelForDirectiveClass,
    OMPTargetTeamsDirectiveClass,
    OMPTargetUpdateDirectiveClass,
    OMPTaskDirectiveClass,
    OMPTaskgroupDirectiveClass,
    OMPTaskwaitDirectiveClass,
    OMPTaskyieldDirectiveClass,
    OMPTeamsDirectiveClass,
    ObjCAtCatchStmtClass,
    ObjCAtFinallyStmtClass,
    ObjCAtSynchronizedStmtClass,
    ObjCAtThrowStmtClass,
    ObjCAtTryStmtClass,
    ObjCAutoreleasePoolStmtClass,
    ObjCForCollectionStmtClass,
    ReturnStmtClass,
    SEHExceptStmtClass,
    SEHFinallyStmtClass,
    SEHLeaveStmtClass,
    SEHTryStmtClass,
    CaseStmtClass,
    DefaultStmtClass,
    SwitchStmtClass,
    AttributedStmtClass,
    BinaryConditionalOperatorClass,
    ConditionalOperatorClass,
    AddrLabelExprClass,
    ArrayInitIndexExprClass,
    ArrayInitLoopExprClass,
    ArraySubscriptExprClass,
    ArrayTypeTraitExprClass,
    AsTypeExprClass,
    AtomicExprClass,
    BinaryOperatorClass,
    CompoundAssignOperatorClass,
    BlockExprClass,
    CXXBindTemporaryExprClass,
    CXXBoolLiteralExprClass,
    CXXConstructExprClass,
    CXXTemporaryObjectExprClass,
    CXXDefaultArgExprClass,
    CXXDefaultInitExprClass,
    CXXDeleteExprClass,
    CXXDependentScopeMemberExprClass,
    CXXFoldExprClass,
    CXXInheritedCtorInitExprClass,
    CXXNewExprClass,
    CXXNoexceptExprClass,
    CXXNullPtrLiteralExprClass,
    CXXPseudoDestructorExprClass,
    CXXScalarValueInitExprClass,
    CXXStdInitializerListExprClass,
    CXXThisExprClass,
    CXXThrowExprClass,
    CXXTypeidExprClass,
    CXXUnresolvedConstructExprClass,
    CXXUuidofExprClass,
    CallExprClass,
    CUDAKernelCallExprClass,
    CXXMemberCallExprClass,
    CXXOperatorCallExprClass,
    UserDefinedLiteralClass,
    BuiltinBitCastExprClass,
    CStyleCastExprClass,
    CXXFunctionalCastExprClass,
    CXXConstCastExprClass,
    CXXDynamicCastExprClass,
    CXXReinterpretCastExprClass,
    CXXStaticCastExprClass,
    ObjCBridgedCastExprClass,
    ImplicitCastExprClass,
    CharacterLiteralClass,
    ChooseExprClass,
    CompoundLiteralExprClass,
    ConvertVectorExprClass,
    CoawaitExprClass,
    CoyieldExprClass,
    DeclRefExprClass,
    DependentCoawaitExprClass,
    DependentScopeDeclRefExprClass,
    DesignatedInitExprClass,
    DesignatedInitUpdateExprClass,
    ExpressionTraitExprClass,
    ExtVectorElementExprClass,
    FixedPointLiteralClass,
    FloatingLiteralClass,
    ConstantExprClass,
    ExprWithCleanupsClass,
    FunctionParmPackExprClass,
    GNUNullExprClass,
    GenericSelectionExprClass,
    ImaginaryLiteralClass,
    ImplicitValueInitExprClass,
    InitListExprClass,
    IntegerLiteralClass,
    LambdaExprClass,
    MSPropertyRefExprClass,
    MSPropertySubscriptExprClass,
    MaterializeTemporaryExprClass,
    MemberExprClass,
    NoInitExprClass,
    OMPArraySectionExprClass,
    ObjCArrayLiteralClass,
    ObjCAvailabilityCheckExprClass,
    ObjCBoolLiteralExprClass,
    ObjCBoxedExprClass,
    ObjCDictionaryLiteralClass,
    ObjCEncodeExprClass,
    ObjCIndirectCopyRestoreExprClass,
    ObjCIsaExprClass,
    ObjCIvarRefExprClass,
    ObjCMessageExprClass,
    ObjCPropertyRefExprClass,
    ObjCProtocolExprClass,
    ObjCSelectorExprClass,
    ObjCStringLiteralClass,
    ObjCSubscriptRefExprClass,
    OffsetOfExprClass,
    OpaqueValueExprClass,
    UnresolvedLookupExprClass,
    UnresolvedMemberExprClass,
    PackExpansionExprClass,
    ParenExprClass,
    ParenListExprClass,
    PredefinedExprClass,
    PseudoObjectExprClass,
    ShuffleVectorExprClass,
    SizeOfPackExprClass,
    SourceLocExprClass,
    StmtExprClass,
    StringLiteralClass,
    SubstNonTypeTemplateParmExprClass,
    SubstNonTypeTemplateParmPackExprClass,
    TypeTraitExprClass,
    TypoExprClass,
    UnaryExprOrTypeTraitExprClass,
    UnaryOperatorClass,
    VAArgExprClass,
    LabelStmtClass,
    WhileStmtClass,
};

pub const ZigClangCK = extern enum {
    Dependent,
    BitCast,
    LValueBitCast,
    LValueToRValueBitCast,
    LValueToRValue,
    NoOp,
    BaseToDerived,
    DerivedToBase,
    UncheckedDerivedToBase,
    Dynamic,
    ToUnion,
    ArrayToPointerDecay,
    FunctionToPointerDecay,
    NullToPointer,
    NullToMemberPointer,
    BaseToDerivedMemberPointer,
    DerivedToBaseMemberPointer,
    MemberPointerToBoolean,
    ReinterpretMemberPointer,
    UserDefinedConversion,
    ConstructorConversion,
    IntegralToPointer,
    PointerToIntegral,
    PointerToBoolean,
    ToVoid,
    VectorSplat,
    IntegralCast,
    IntegralToBoolean,
    IntegralToFloating,
    FixedPointCast,
    FixedPointToIntegral,
    IntegralToFixedPoint,
    FixedPointToBoolean,
    FloatingToIntegral,
    FloatingToBoolean,
    BooleanToSignedIntegral,
    FloatingCast,
    CPointerToObjCPointerCast,
    BlockPointerToObjCPointerCast,
    AnyPointerToBlockPointerCast,
    ObjCObjectLValueCast,
    FloatingRealToComplex,
    FloatingComplexToReal,
    FloatingComplexToBoolean,
    FloatingComplexCast,
    FloatingComplexToIntegralComplex,
    IntegralRealToComplex,
    IntegralComplexToReal,
    IntegralComplexToBoolean,
    IntegralComplexCast,
    IntegralComplexToFloatingComplex,
    ARCProduceObject,
    ARCConsumeObject,
    ARCReclaimReturnedObject,
    ARCExtendBlockObject,
    AtomicToNonAtomic,
    NonAtomicToAtomic,
    CopyAndAutoreleaseBlockObject,
    BuiltinFnToFnPtr,
    ZeroToOCLOpaqueType,
    AddressSpaceConversion,
    IntToOCLSampler,
};

pub const ZigClangAPValueKind = extern enum {
    None,
    Indeterminate,
    Int,
    Float,
    FixedPoint,
    ComplexInt,
    ComplexFloat,
    LValue,
    Vector,
    Array,
    Struct,
    Union,
    MemberPointer,
    AddrLabelDiff,
};

pub const ZigClangDeclKind = extern enum {
    AccessSpec,
    Block,
    Captured,
    ClassScopeFunctionSpecialization,
    Empty,
    Export,
    ExternCContext,
    FileScopeAsm,
    Friend,
    FriendTemplate,
    Import,
    LinkageSpec,
    Label,
    Namespace,
    NamespaceAlias,
    ObjCCompatibleAlias,
    ObjCCategory,
    ObjCCategoryImpl,
    ObjCImplementation,
    ObjCInterface,
    ObjCProtocol,
    ObjCMethod,
    ObjCProperty,
    BuiltinTemplate,
    Concept,
    ClassTemplate,
    FunctionTemplate,
    TypeAliasTemplate,
    VarTemplate,
    TemplateTemplateParm,
    Enum,
    Record,
    CXXRecord,
    ClassTemplateSpecialization,
    ClassTemplatePartialSpecialization,
    TemplateTypeParm,
    ObjCTypeParam,
    TypeAlias,
    Typedef,
    UnresolvedUsingTypename,
    Using,
    UsingDirective,
    UsingPack,
    UsingShadow,
    ConstructorUsingShadow,
    Binding,
    Field,
    ObjCAtDefsField,
    ObjCIvar,
    Function,
    CXXDeductionGuide,
    CXXMethod,
    CXXConstructor,
    CXXConversion,
    CXXDestructor,
    MSProperty,
    NonTypeTemplateParm,
    Var,
    Decomposition,
    ImplicitParam,
    OMPCapturedExpr,
    ParmVar,
    VarTemplateSpecialization,
    VarTemplatePartialSpecialization,
    EnumConstant,
    IndirectField,
    OMPDeclareMapper,
    OMPDeclareReduction,
    UnresolvedUsingValue,
    OMPAllocate,
    OMPRequires,
    OMPThreadPrivate,
    ObjCPropertyImpl,
    PragmaComment,
    PragmaDetectMismatch,
    StaticAssert,
    TranslationUnit,
};

pub const ZigClangBuiltinTypeKind = extern enum {
    OCLImage1dRO,
    OCLImage1dArrayRO,
    OCLImage1dBufferRO,
    OCLImage2dRO,
    OCLImage2dArrayRO,
    OCLImage2dDepthRO,
    OCLImage2dArrayDepthRO,
    OCLImage2dMSAARO,
    OCLImage2dArrayMSAARO,
    OCLImage2dMSAADepthRO,
    OCLImage2dArrayMSAADepthRO,
    OCLImage3dRO,
    OCLImage1dWO,
    OCLImage1dArrayWO,
    OCLImage1dBufferWO,
    OCLImage2dWO,
    OCLImage2dArrayWO,
    OCLImage2dDepthWO,
    OCLImage2dArrayDepthWO,
    OCLImage2dMSAAWO,
    OCLImage2dArrayMSAAWO,
    OCLImage2dMSAADepthWO,
    OCLImage2dArrayMSAADepthWO,
    OCLImage3dWO,
    OCLImage1dRW,
    OCLImage1dArrayRW,
    OCLImage1dBufferRW,
    OCLImage2dRW,
    OCLImage2dArrayRW,
    OCLImage2dDepthRW,
    OCLImage2dArrayDepthRW,
    OCLImage2dMSAARW,
    OCLImage2dArrayMSAARW,
    OCLImage2dMSAADepthRW,
    OCLImage2dArrayMSAADepthRW,
    OCLImage3dRW,
    OCLIntelSubgroupAVCMcePayload,
    OCLIntelSubgroupAVCImePayload,
    OCLIntelSubgroupAVCRefPayload,
    OCLIntelSubgroupAVCSicPayload,
    OCLIntelSubgroupAVCMceResult,
    OCLIntelSubgroupAVCImeResult,
    OCLIntelSubgroupAVCRefResult,
    OCLIntelSubgroupAVCSicResult,
    OCLIntelSubgroupAVCImeResultSingleRefStreamout,
    OCLIntelSubgroupAVCImeResultDualRefStreamout,
    OCLIntelSubgroupAVCImeSingleRefStreamin,
    OCLIntelSubgroupAVCImeDualRefStreamin,
    Void,
    Bool,
    Char_U,
    UChar,
    WChar_U,
    Char8,
    Char16,
    Char32,
    UShort,
    UInt,
    ULong,
    ULongLong,
    UInt128,
    Char_S,
    SChar,
    WChar_S,
    Short,
    Int,
    Long,
    LongLong,
    Int128,
    ShortAccum,
    Accum,
    LongAccum,
    UShortAccum,
    UAccum,
    ULongAccum,
    ShortFract,
    Fract,
    LongFract,
    UShortFract,
    UFract,
    ULongFract,
    SatShortAccum,
    SatAccum,
    SatLongAccum,
    SatUShortAccum,
    SatUAccum,
    SatULongAccum,
    SatShortFract,
    SatFract,
    SatLongFract,
    SatUShortFract,
    SatUFract,
    SatULongFract,
    Half,
    Float,
    Double,
    LongDouble,
    Float16,
    Float128,
    NullPtr,
    ObjCId,
    ObjCClass,
    ObjCSel,
    OCLSampler,
    OCLEvent,
    OCLClkEvent,
    OCLQueue,
    OCLReserveID,
    Dependent,
    Overload,
    BoundMember,
    PseudoObject,
    UnknownAny,
    BuiltinFn,
    ARCUnbridgedCast,
    OMPArraySection,
};

pub const ZigClangCallingConv = extern enum {
    C,
    X86StdCall,
    X86FastCall,
    X86ThisCall,
    X86VectorCall,
    X86Pascal,
    Win64,
    X86_64SysV,
    X86RegCall,
    AAPCS,
    AAPCS_VFP,
    IntelOclBicc,
    SpirFunction,
    OpenCLKernel,
    Swift,
    PreserveMost,
    PreserveAll,
    AArch64VectorCall,
};

pub const ZigClangStorageClass = extern enum {
    None,
    Extern,
    Static,
    PrivateExtern,
    Auto,
    Register,
};

pub const ZigClangAPFloat_roundingMode = extern enum {
    NearestTiesToEven,
    TowardPositive,
    TowardNegative,
    TowardZero,
    NearestTiesToAway,
};

pub const ZigClangStringLiteral_StringKind = extern enum {
    Ascii,
    Wide,
    UTF8,
    UTF16,
    UTF32,
};

pub extern fn ZigClangSourceManager_getSpellingLoc(self: ?*const struct_ZigClangSourceManager, Loc: struct_ZigClangSourceLocation) struct_ZigClangSourceLocation;
pub extern fn ZigClangSourceManager_getFilename(self: *const struct_ZigClangSourceManager, SpellingLoc: struct_ZigClangSourceLocation) ?[*]const u8;
pub extern fn ZigClangSourceManager_getSpellingLineNumber(self: ?*const struct_ZigClangSourceManager, Loc: struct_ZigClangSourceLocation) c_uint;
pub extern fn ZigClangSourceManager_getSpellingColumnNumber(self: ?*const struct_ZigClangSourceManager, Loc: struct_ZigClangSourceLocation) c_uint;
pub extern fn ZigClangSourceManager_getCharacterData(self: ?*const struct_ZigClangSourceManager, SL: struct_ZigClangSourceLocation) [*c]const u8;
pub extern fn ZigClangASTContext_getPointerType(self: ?*const struct_ZigClangASTContext, T: struct_ZigClangQualType) struct_ZigClangQualType;
pub extern fn ZigClangASTUnit_getASTContext(self: ?*struct_ZigClangASTUnit) ?*struct_ZigClangASTContext;
pub extern fn ZigClangASTUnit_getSourceManager(self: *struct_ZigClangASTUnit) *struct_ZigClangSourceManager;
pub extern fn ZigClangASTUnit_visitLocalTopLevelDecls(self: *struct_ZigClangASTUnit, context: ?*c_void, Fn: ?extern fn (?*c_void, *const struct_ZigClangDecl) bool) bool;
pub extern fn ZigClangRecordType_getDecl(record_ty: ?*const struct_ZigClangRecordType) ?*const struct_ZigClangRecordDecl;
pub extern fn ZigClangEnumType_getDecl(record_ty: ?*const struct_ZigClangEnumType) ?*const struct_ZigClangEnumDecl;
pub extern fn ZigClangRecordDecl_getCanonicalDecl(record_decl: ?*const struct_ZigClangRecordDecl) ?*const struct_ZigClangTagDecl;
pub extern fn ZigClangEnumDecl_getCanonicalDecl(self: ?*const struct_ZigClangEnumDecl) ?*const struct_ZigClangTagDecl;
pub extern fn ZigClangTypedefNameDecl_getCanonicalDecl(self: ?*const struct_ZigClangTypedefNameDecl) ?*const struct_ZigClangTypedefNameDecl;
pub extern fn ZigClangRecordDecl_getDefinition(self: ?*const struct_ZigClangRecordDecl) ?*const struct_ZigClangRecordDecl;
pub extern fn ZigClangEnumDecl_getDefinition(self: ?*const struct_ZigClangEnumDecl) ?*const struct_ZigClangEnumDecl;
pub extern fn ZigClangRecordDecl_getLocation(self: ?*const struct_ZigClangRecordDecl) struct_ZigClangSourceLocation;
pub extern fn ZigClangEnumDecl_getLocation(self: ?*const struct_ZigClangEnumDecl) struct_ZigClangSourceLocation;
pub extern fn ZigClangTypedefNameDecl_getLocation(self: ?*const struct_ZigClangTypedefNameDecl) struct_ZigClangSourceLocation;
pub extern fn ZigClangDecl_getLocation(self: *const ZigClangDecl) ZigClangSourceLocation;
pub extern fn ZigClangRecordDecl_isUnion(record_decl: ?*const struct_ZigClangRecordDecl) bool;
pub extern fn ZigClangRecordDecl_isStruct(record_decl: ?*const struct_ZigClangRecordDecl) bool;
pub extern fn ZigClangRecordDecl_isAnonymousStructOrUnion(record_decl: ?*const struct_ZigClangRecordDecl) bool;
pub extern fn ZigClangEnumDecl_getIntegerType(self: ?*const struct_ZigClangEnumDecl) struct_ZigClangQualType;
pub extern fn ZigClangDecl_getName_bytes_begin(decl: ?*const struct_ZigClangDecl) [*c]const u8;
pub extern fn ZigClangSourceLocation_eq(a: struct_ZigClangSourceLocation, b: struct_ZigClangSourceLocation) bool;
pub extern fn ZigClangTypedefType_getDecl(self: ?*const struct_ZigClangTypedefType) ?*const struct_ZigClangTypedefNameDecl;
pub extern fn ZigClangTypedefNameDecl_getUnderlyingType(self: ?*const struct_ZigClangTypedefNameDecl) struct_ZigClangQualType;
pub extern fn ZigClangQualType_getCanonicalType(self: struct_ZigClangQualType) struct_ZigClangQualType;
pub extern fn ZigClangQualType_getTypeClass(self: struct_ZigClangQualType) ZigClangTypeClass;
pub extern fn ZigClangQualType_getTypePtr(self: struct_ZigClangQualType) *const struct_ZigClangType;
pub extern fn ZigClangQualType_addConst(self: [*c]struct_ZigClangQualType) void;
pub extern fn ZigClangQualType_eq(self: struct_ZigClangQualType, arg1: struct_ZigClangQualType) bool;
pub extern fn ZigClangQualType_isConstQualified(self: struct_ZigClangQualType) bool;
pub extern fn ZigClangQualType_isVolatileQualified(self: struct_ZigClangQualType) bool;
pub extern fn ZigClangQualType_isRestrictQualified(self: struct_ZigClangQualType) bool;
pub extern fn ZigClangType_getTypeClass(self: ?*const struct_ZigClangType) ZigClangTypeClass;
pub extern fn ZigClangType_getPointeeType(self: ?*const struct_ZigClangType) struct_ZigClangQualType;
pub extern fn ZigClangType_isVoidType(self: ?*const struct_ZigClangType) bool;
pub extern fn ZigClangType_getTypeClassName(self: *const struct_ZigClangType) [*]const u8;
pub extern fn ZigClangStmt_getBeginLoc(self: *const struct_ZigClangStmt) struct_ZigClangSourceLocation;
pub extern fn ZigClangStmt_getStmtClass(self: ?*const struct_ZigClangStmt) ZigClangStmtClass;
pub extern fn ZigClangStmt_classof_Expr(self: ?*const struct_ZigClangStmt) bool;
pub extern fn ZigClangExpr_getStmtClass(self: ?*const struct_ZigClangExpr) ZigClangStmtClass;
pub extern fn ZigClangExpr_getType(self: ?*const struct_ZigClangExpr) struct_ZigClangQualType;
pub extern fn ZigClangExpr_getBeginLoc(self: *const struct_ZigClangExpr) struct_ZigClangSourceLocation;
pub extern fn ZigClangAPValue_getKind(self: ?*const struct_ZigClangAPValue) ZigClangAPValueKind;
pub extern fn ZigClangAPValue_getInt(self: ?*const struct_ZigClangAPValue) ?*const struct_ZigClangAPSInt;
pub extern fn ZigClangAPValue_getArrayInitializedElts(self: ?*const struct_ZigClangAPValue) c_uint;
pub extern fn ZigClangAPValue_getArrayInitializedElt(self: ?*const struct_ZigClangAPValue, i: c_uint) ?*const struct_ZigClangAPValue;
pub extern fn ZigClangAPValue_getArrayFiller(self: ?*const struct_ZigClangAPValue) ?*const struct_ZigClangAPValue;
pub extern fn ZigClangAPValue_getArraySize(self: ?*const struct_ZigClangAPValue) c_uint;
pub extern fn ZigClangAPValue_getLValueBase(self: ?*const struct_ZigClangAPValue) struct_ZigClangAPValueLValueBase;
pub extern fn ZigClangAPSInt_isSigned(self: ?*const struct_ZigClangAPSInt) bool;
pub extern fn ZigClangAPSInt_isNegative(self: ?*const struct_ZigClangAPSInt) bool;
pub extern fn ZigClangAPSInt_negate(self: ?*const struct_ZigClangAPSInt) ?*const struct_ZigClangAPSInt;
pub extern fn ZigClangAPSInt_free(self: ?*const struct_ZigClangAPSInt) void;
pub extern fn ZigClangAPSInt_getRawData(self: ?*const struct_ZigClangAPSInt) [*c]const u64;
pub extern fn ZigClangAPSInt_getNumWords(self: ?*const struct_ZigClangAPSInt) c_uint;
pub extern fn ZigClangAPValueLValueBase_dyn_cast_Expr(self: struct_ZigClangAPValueLValueBase) ?*const struct_ZigClangExpr;
pub extern fn ZigClangASTUnit_delete(self: ?*struct_ZigClangASTUnit) void;

pub extern fn ZigClangFunctionDecl_getType(self: *const ZigClangFunctionDecl) struct_ZigClangQualType;
pub extern fn ZigClangFunctionDecl_getLocation(self: *const ZigClangFunctionDecl) struct_ZigClangSourceLocation;
pub extern fn ZigClangFunctionDecl_hasBody(self: *const ZigClangFunctionDecl) bool;
pub extern fn ZigClangFunctionDecl_getStorageClass(self: *const ZigClangFunctionDecl) ZigClangStorageClass;
pub extern fn ZigClangFunctionDecl_getParamDecl(self: *const ZigClangFunctionDecl, i: c_uint) *const struct_ZigClangParmVarDecl;
pub extern fn ZigClangFunctionDecl_getBody(self: *const ZigClangFunctionDecl) *const struct_ZigClangStmt;

pub extern fn ZigClangBuiltinType_getKind(self: *const struct_ZigClangBuiltinType) ZigClangBuiltinTypeKind;

pub extern fn ZigClangFunctionType_getNoReturnAttr(self: *const ZigClangFunctionType) bool;
pub extern fn ZigClangFunctionType_getCallConv(self: *const ZigClangFunctionType) ZigClangCallingConv;
pub extern fn ZigClangFunctionType_getReturnType(self: *const ZigClangFunctionType) ZigClangQualType;

pub extern fn ZigClangFunctionProtoType_isVariadic(self: *const struct_ZigClangFunctionProtoType) bool;
pub extern fn ZigClangFunctionProtoType_getNumParams(self: *const struct_ZigClangFunctionProtoType) c_uint;
pub extern fn ZigClangFunctionProtoType_getParamType(self: *const struct_ZigClangFunctionProtoType, i: c_uint) ZigClangQualType;

pub const ZigClangSourceLocation = struct_ZigClangSourceLocation;
pub const ZigClangQualType = struct_ZigClangQualType;
pub const ZigClangAPValueLValueBase = struct_ZigClangAPValueLValueBase;
pub const ZigClangAPValue = struct_ZigClangAPValue;
pub const ZigClangAPSInt = struct_ZigClangAPSInt;
pub const ZigClangAPFloat = struct_ZigClangAPFloat;
pub const ZigClangASTContext = struct_ZigClangASTContext;
pub const ZigClangASTUnit = struct_ZigClangASTUnit;
pub const ZigClangArraySubscriptExpr = struct_ZigClangArraySubscriptExpr;
pub const ZigClangArrayType = struct_ZigClangArrayType;
pub const ZigClangAttributedType = struct_ZigClangAttributedType;
pub const ZigClangBinaryOperator = struct_ZigClangBinaryOperator;
pub const ZigClangBreakStmt = struct_ZigClangBreakStmt;
pub const ZigClangBuiltinType = struct_ZigClangBuiltinType;
pub const ZigClangCStyleCastExpr = struct_ZigClangCStyleCastExpr;
pub const ZigClangCallExpr = struct_ZigClangCallExpr;
pub const ZigClangCaseStmt = struct_ZigClangCaseStmt;
pub const ZigClangCompoundAssignOperator = struct_ZigClangCompoundAssignOperator;
pub const ZigClangCompoundStmt = struct_ZigClangCompoundStmt;
pub const ZigClangConditionalOperator = struct_ZigClangConditionalOperator;
pub const ZigClangConstantArrayType = struct_ZigClangConstantArrayType;
pub const ZigClangContinueStmt = struct_ZigClangContinueStmt;
pub const ZigClangDecayedType = struct_ZigClangDecayedType;
pub const ZigClangDecl = struct_ZigClangDecl;
pub const ZigClangDeclRefExpr = struct_ZigClangDeclRefExpr;
pub const ZigClangDeclStmt = struct_ZigClangDeclStmt;
pub const ZigClangDefaultStmt = struct_ZigClangDefaultStmt;
pub const ZigClangDiagnosticOptions = struct_ZigClangDiagnosticOptions;
pub const ZigClangDiagnosticsEngine = struct_ZigClangDiagnosticsEngine;
pub const ZigClangDoStmt = struct_ZigClangDoStmt;
pub const ZigClangElaboratedType = struct_ZigClangElaboratedType;
pub const ZigClangEnumConstantDecl = struct_ZigClangEnumConstantDecl;
pub const ZigClangEnumDecl = struct_ZigClangEnumDecl;
pub const ZigClangEnumType = struct_ZigClangEnumType;
pub const ZigClangExpr = struct_ZigClangExpr;
pub const ZigClangFieldDecl = struct_ZigClangFieldDecl;
pub const ZigClangFileID = struct_ZigClangFileID;
pub const ZigClangForStmt = struct_ZigClangForStmt;
pub const ZigClangFullSourceLoc = struct_ZigClangFullSourceLoc;
pub const ZigClangFunctionDecl = struct_ZigClangFunctionDecl;
pub const ZigClangFunctionProtoType = struct_ZigClangFunctionProtoType;
pub const ZigClangIfStmt = struct_ZigClangIfStmt;
pub const ZigClangImplicitCastExpr = struct_ZigClangImplicitCastExpr;
pub const ZigClangIncompleteArrayType = struct_ZigClangIncompleteArrayType;
pub const ZigClangIntegerLiteral = struct_ZigClangIntegerLiteral;
pub const ZigClangMacroDefinitionRecord = struct_ZigClangMacroDefinitionRecord;
pub const ZigClangMemberExpr = struct_ZigClangMemberExpr;
pub const ZigClangNamedDecl = struct_ZigClangNamedDecl;
pub const ZigClangNone = struct_ZigClangNone;
pub const ZigClangPCHContainerOperations = struct_ZigClangPCHContainerOperations;
pub const ZigClangParenExpr = struct_ZigClangParenExpr;
pub const ZigClangParenType = struct_ZigClangParenType;
pub const ZigClangParmVarDecl = struct_ZigClangParmVarDecl;
pub const ZigClangPointerType = struct_ZigClangPointerType;
pub const ZigClangPreprocessedEntity = struct_ZigClangPreprocessedEntity;
pub const ZigClangRecordDecl = struct_ZigClangRecordDecl;
pub const ZigClangRecordType = struct_ZigClangRecordType;
pub const ZigClangReturnStmt = struct_ZigClangReturnStmt;
pub const ZigClangSkipFunctionBodiesScope = struct_ZigClangSkipFunctionBodiesScope;
pub const ZigClangSourceManager = struct_ZigClangSourceManager;
pub const ZigClangSourceRange = struct_ZigClangSourceRange;
pub const ZigClangStmt = struct_ZigClangStmt;
pub const ZigClangStringLiteral = struct_ZigClangStringLiteral;
pub const ZigClangStringRef = struct_ZigClangStringRef;
pub const ZigClangSwitchStmt = struct_ZigClangSwitchStmt;
pub const ZigClangTagDecl = struct_ZigClangTagDecl;
pub const ZigClangType = struct_ZigClangType;
pub const ZigClangTypedefNameDecl = struct_ZigClangTypedefNameDecl;
pub const ZigClangTypedefType = struct_ZigClangTypedefType;
pub const ZigClangUnaryExprOrTypeTraitExpr = struct_ZigClangUnaryExprOrTypeTraitExpr;
pub const ZigClangUnaryOperator = struct_ZigClangUnaryOperator;
pub const ZigClangValueDecl = struct_ZigClangValueDecl;
pub const ZigClangVarDecl = struct_ZigClangVarDecl;
pub const ZigClangWhileStmt = struct_ZigClangWhileStmt;
pub const ZigClangFunctionType = struct_ZigClangFunctionType;
pub const ZigClangPredefinedExpr = struct_ZigClangPredefinedExpr;

pub const struct_ZigClangSourceLocation = extern struct {
    ID: c_uint,
};

pub const Stage2ErrorMsg = extern struct {
    filename_ptr: ?[*]const u8,
    filename_len: usize,
    msg_ptr: [*]const u8,
    msg_len: usize,
    // valid until the ASTUnit is freed
    source: ?[*]const u8,
    // 0 based
    line: c_uint,
    // 0 based
    column: c_uint,
    // byte offset into source
    offset: c_uint,
};

pub const struct_ZigClangQualType = extern struct {
    ptr: ?*c_void,
};

pub const struct_ZigClangAPValueLValueBase = extern struct {
    Ptr: ?*c_void,
    CallIndex: c_uint,
    Version: c_uint,
};

pub extern fn ZigClangErrorMsg_delete(ptr: [*c]Stage2ErrorMsg, len: usize) void;

pub extern fn ZigClangLoadFromCommandLine(
    args_begin: [*]?[*]const u8,
    args_end: [*]?[*]const u8,
    errors_ptr: *[*]Stage2ErrorMsg,
    errors_len: *usize,
    resources_path: [*c]const u8,
) ?*ZigClangASTUnit;

pub extern fn ZigClangDecl_getKind(decl: *const ZigClangDecl) ZigClangDeclKind;
pub extern fn ZigClangDecl_getDeclKindName(decl: *const struct_ZigClangDecl) [*]const u8;

pub const ZigClangCompoundStmt_const_body_iterator = [*c]const *struct_ZigClangStmt;

pub extern fn ZigClangCompoundStmt_body_begin(self: *const ZigClangCompoundStmt) ZigClangCompoundStmt_const_body_iterator;
pub extern fn ZigClangCompoundStmt_body_end(self: *const ZigClangCompoundStmt) ZigClangCompoundStmt_const_body_iterator;

pub const ZigClangDeclStmt_const_decl_iterator = [*c]const *struct_ZigClangDecl;

pub extern fn ZigClangDeclStmt_decl_begin(self: *const ZigClangDeclStmt) ZigClangDeclStmt_const_decl_iterator;
pub extern fn ZigClangDeclStmt_decl_end(self: *const ZigClangDeclStmt) ZigClangDeclStmt_const_decl_iterator;

pub extern fn ZigClangVarDecl_getType(self: ?*const struct_ZigClangVarDecl) struct_ZigClangQualType;
pub extern fn ZigClangVarDecl_getInit(*const ZigClangVarDecl) ?*const ZigClangExpr;
pub extern fn ZigClangVarDecl_getTLSKind(self: ?*const struct_ZigClangVarDecl) ZigClangVarDecl_TLSKind;
pub const ZigClangVarDecl_TLSKind = extern enum {
    None,
    Static,
    Dynamic,
};

pub extern fn ZigClangImplicitCastExpr_getBeginLoc(*const ZigClangImplicitCastExpr) ZigClangSourceLocation;
pub extern fn ZigClangImplicitCastExpr_getCastKind(*const ZigClangImplicitCastExpr) ZigClangCK;
pub extern fn ZigClangImplicitCastExpr_getSubExpr(*const ZigClangImplicitCastExpr) *const ZigClangExpr;

pub extern fn ZigClangArrayType_getElementType(*const ZigClangArrayType) ZigClangQualType;

pub extern fn ZigClangDeclRefExpr_getDecl(*const ZigClangDeclRefExpr) *const ZigClangValueDecl;

pub extern fn ZigClangParenType_getInnerType(*const ZigClangParenType) ZigClangQualType;

pub extern fn ZigClangElaboratedType_getNamedType(*const ZigClangElaboratedType) ZigClangQualType;

pub extern fn ZigClangAttributedType_getEquivalentType(*const ZigClangAttributedType) ZigClangQualType;

pub extern fn ZigClangCStyleCastExpr_getBeginLoc(*const ZigClangCStyleCastExpr) ZigClangSourceLocation;
pub extern fn ZigClangCStyleCastExpr_getSubExpr(*const ZigClangCStyleCastExpr) *const ZigClangExpr;
pub extern fn ZigClangCStyleCastExpr_getType(*const ZigClangCStyleCastExpr) ZigClangQualType;

pub const ZigClangExprEvalResult = struct_ZigClangExprEvalResult;
pub const struct_ZigClangExprEvalResult = extern struct {
    HasSideEffects: bool,
    HasUndefinedBehavior: bool,
    SmallVectorImpl: ?*c_void,
    Val: ZigClangAPValue,
};

pub const struct_ZigClangAPValue = extern struct {
    Kind: ZigClangAPValueKind,
    Data: if (builtin.os == .windows and builtin.abi == .msvc) [52]u8 else [68]u8,
};

pub extern fn ZigClangIntegerLiteral_EvaluateAsInt(*const ZigClangIntegerLiteral, *ZigClangExprEvalResult, *const ZigClangASTContext) bool;
pub extern fn ZigClangIntegerLiteral_getBeginLoc(*const ZigClangIntegerLiteral) ZigClangSourceLocation;

pub extern fn ZigClangReturnStmt_getRetValue(*const ZigClangReturnStmt) ?*const ZigClangExpr;

pub extern fn ZigClangBinaryOperator_getOpcode(*const ZigClangBinaryOperator) ZigClangBO;
pub extern fn ZigClangBinaryOperator_getBeginLoc(*const ZigClangBinaryOperator) ZigClangSourceLocation;
pub extern fn ZigClangBinaryOperator_getLHS(*const ZigClangBinaryOperator) *const ZigClangExpr;
pub extern fn ZigClangBinaryOperator_getRHS(*const ZigClangBinaryOperator) *const ZigClangExpr;
pub extern fn ZigClangBinaryOperator_getType(*const ZigClangBinaryOperator) ZigClangQualType;

pub extern fn ZigClangStringLiteral_getKind(*const ZigClangStringLiteral) ZigClangStringLiteral_StringKind;
pub extern fn ZigClangStringLiteral_getString_bytes_begin_size(*const ZigClangStringLiteral, *usize) [*c]const u8;
