//! This file is auto-generated by tools/gen_spirv_spec.zig.

const Version = @import("std").SemanticVersion;

pub const Word = u32;
pub const IdResult = struct {
    id: Word,
};
pub const IdResultType = IdResult;
pub const IdRef = IdResult;

pub const IdMemorySemantics = IdRef;
pub const IdScope = IdRef;

pub const LiteralInteger = Word;
pub const LiteralString = []const u8;
pub const LiteralContextDependentNumber = union(enum) {
    int32: i32,
    uint32: u32,
    int64: i64,
    uint64: u64,
    float32: f32,
    float64: f64,
};
pub const LiteralExtInstInteger = struct { inst: Word };
pub const LiteralSpecConstantOpInteger = struct { opcode: Opcode };
pub const PairLiteralIntegerIdRef = struct { value: LiteralInteger, label: IdRef };
pub const PairIdRefLiteralInteger = struct { target: IdRef, member: LiteralInteger };
pub const PairIdRefIdRef = [2]IdRef;

pub const Quantifier = enum {
    required,
    optional,
    variadic,
};

pub const Operand = struct {
    kind: OperandKind,
    quantifier: Quantifier,
};

pub const OperandCategory = enum {
    bit_enum,
    value_enum,
    id,
    literal,
    composite,
};

pub const Enumerant = struct {
    name: []const u8,
    value: Word,
    parameters: []const OperandKind,
};

pub const version = Version{ .major = 1, .minor = 6, .patch = 1 };
pub const magic_number: Word = 0x07230203;

pub const Class = enum {
    Miscellaneous,
    Debug,
    Extension,
    ModeSetting,
    TypeDeclaration,
    ConstantCreation,
    Function,
    Memory,
    Annotation,
    Composite,
    Image,
    Conversion,
    Arithmetic,
    RelationalAndLogical,
    Bit,
    Derivative,
    Primitive,
    Barrier,
    Atomic,
    ControlFlow,
    Group,
    Pipe,
    DeviceSideEnqueue,
    NonUniform,
    Reserved,
};
pub const OperandKind = enum {
    ImageOperands,
    FPFastMathMode,
    SelectionControl,
    LoopControl,
    FunctionControl,
    MemorySemantics,
    MemoryAccess,
    KernelProfilingInfo,
    RayFlags,
    FragmentShadingRate,
    SourceLanguage,
    ExecutionModel,
    AddressingModel,
    MemoryModel,
    ExecutionMode,
    StorageClass,
    Dim,
    SamplerAddressingMode,
    SamplerFilterMode,
    ImageFormat,
    ImageChannelOrder,
    ImageChannelDataType,
    FPRoundingMode,
    FPDenormMode,
    QuantizationModes,
    FPOperationMode,
    OverflowModes,
    LinkageType,
    AccessQualifier,
    FunctionParameterAttribute,
    Decoration,
    BuiltIn,
    Scope,
    GroupOperation,
    KernelEnqueueFlags,
    Capability,
    RayQueryIntersection,
    RayQueryCommittedIntersectionType,
    RayQueryCandidateIntersectionType,
    PackedVectorFormat,
    IdResultType,
    IdResult,
    IdMemorySemantics,
    IdScope,
    IdRef,
    LiteralInteger,
    LiteralString,
    LiteralContextDependentNumber,
    LiteralExtInstInteger,
    LiteralSpecConstantOpInteger,
    PairLiteralIntegerIdRef,
    PairIdRefLiteralInteger,
    PairIdRefIdRef,

    pub fn category(self: OperandKind) OperandCategory {
        return switch (self) {
            .ImageOperands => .bit_enum,
            .FPFastMathMode => .bit_enum,
            .SelectionControl => .bit_enum,
            .LoopControl => .bit_enum,
            .FunctionControl => .bit_enum,
            .MemorySemantics => .bit_enum,
            .MemoryAccess => .bit_enum,
            .KernelProfilingInfo => .bit_enum,
            .RayFlags => .bit_enum,
            .FragmentShadingRate => .bit_enum,
            .SourceLanguage => .value_enum,
            .ExecutionModel => .value_enum,
            .AddressingModel => .value_enum,
            .MemoryModel => .value_enum,
            .ExecutionMode => .value_enum,
            .StorageClass => .value_enum,
            .Dim => .value_enum,
            .SamplerAddressingMode => .value_enum,
            .SamplerFilterMode => .value_enum,
            .ImageFormat => .value_enum,
            .ImageChannelOrder => .value_enum,
            .ImageChannelDataType => .value_enum,
            .FPRoundingMode => .value_enum,
            .FPDenormMode => .value_enum,
            .QuantizationModes => .value_enum,
            .FPOperationMode => .value_enum,
            .OverflowModes => .value_enum,
            .LinkageType => .value_enum,
            .AccessQualifier => .value_enum,
            .FunctionParameterAttribute => .value_enum,
            .Decoration => .value_enum,
            .BuiltIn => .value_enum,
            .Scope => .value_enum,
            .GroupOperation => .value_enum,
            .KernelEnqueueFlags => .value_enum,
            .Capability => .value_enum,
            .RayQueryIntersection => .value_enum,
            .RayQueryCommittedIntersectionType => .value_enum,
            .RayQueryCandidateIntersectionType => .value_enum,
            .PackedVectorFormat => .value_enum,
            .IdResultType => .id,
            .IdResult => .id,
            .IdMemorySemantics => .id,
            .IdScope => .id,
            .IdRef => .id,
            .LiteralInteger => .literal,
            .LiteralString => .literal,
            .LiteralContextDependentNumber => .literal,
            .LiteralExtInstInteger => .literal,
            .LiteralSpecConstantOpInteger => .literal,
            .PairLiteralIntegerIdRef => .composite,
            .PairIdRefLiteralInteger => .composite,
            .PairIdRefIdRef => .composite,
        };
    }
    pub fn enumerants(self: OperandKind) []const Enumerant {
        return switch (self) {
            .ImageOperands => &[_]Enumerant{
                .{ .name = "Bias", .value = 0x0001, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Lod", .value = 0x0002, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Grad", .value = 0x0004, .parameters = &[_]OperandKind{ .IdRef, .IdRef } },
                .{ .name = "ConstOffset", .value = 0x0008, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Offset", .value = 0x0010, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "ConstOffsets", .value = 0x0020, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Sample", .value = 0x0040, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "MinLod", .value = 0x0080, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "MakeTexelAvailable", .value = 0x0100, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakeTexelAvailableKHR", .value = 0x0100, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakeTexelVisible", .value = 0x0200, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakeTexelVisibleKHR", .value = 0x0200, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "NonPrivateTexel", .value = 0x0400, .parameters = &[_]OperandKind{} },
                .{ .name = "NonPrivateTexelKHR", .value = 0x0400, .parameters = &[_]OperandKind{} },
                .{ .name = "VolatileTexel", .value = 0x0800, .parameters = &[_]OperandKind{} },
                .{ .name = "VolatileTexelKHR", .value = 0x0800, .parameters = &[_]OperandKind{} },
                .{ .name = "SignExtend", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "ZeroExtend", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "Nontemporal", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "Offsets", .value = 0x10000, .parameters = &[_]OperandKind{.IdRef} },
            },
            .FPFastMathMode => &[_]Enumerant{
                .{ .name = "NotNaN", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "NotInf", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "NSZ", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowRecip", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "Fast", .value = 0x0010, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowContractFastINTEL", .value = 0x10000, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowReassocINTEL", .value = 0x20000, .parameters = &[_]OperandKind{} },
            },
            .SelectionControl => &[_]Enumerant{
                .{ .name = "Flatten", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "DontFlatten", .value = 0x0002, .parameters = &[_]OperandKind{} },
            },
            .LoopControl => &[_]Enumerant{
                .{ .name = "Unroll", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "DontUnroll", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "DependencyInfinite", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "DependencyLength", .value = 0x0008, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MinIterations", .value = 0x0010, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxIterations", .value = 0x0020, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "IterationMultiple", .value = 0x0040, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PeelCount", .value = 0x0080, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PartialCount", .value = 0x0100, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "InitiationIntervalINTEL", .value = 0x10000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxConcurrencyINTEL", .value = 0x20000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DependencyArrayINTEL", .value = 0x40000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PipelineEnableINTEL", .value = 0x80000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "LoopCoalesceINTEL", .value = 0x100000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxInterleavingINTEL", .value = 0x200000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SpeculatedIterationsINTEL", .value = 0x400000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "NoFusionINTEL", .value = 0x800000, .parameters = &[_]OperandKind{.LiteralInteger} },
            },
            .FunctionControl => &[_]Enumerant{
                .{ .name = "Inline", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "DontInline", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "Pure", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "Const", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "OptNoneINTEL", .value = 0x10000, .parameters = &[_]OperandKind{} },
            },
            .MemorySemantics => &[_]Enumerant{
                .{ .name = "Relaxed", .value = 0x0000, .parameters = &[_]OperandKind{} },
                .{ .name = "Acquire", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "Release", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "AcquireRelease", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "SequentiallyConsistent", .value = 0x0010, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformMemory", .value = 0x0040, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupMemory", .value = 0x0080, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemory", .value = 0x0100, .parameters = &[_]OperandKind{} },
                .{ .name = "CrossWorkgroupMemory", .value = 0x0200, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicCounterMemory", .value = 0x0400, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageMemory", .value = 0x0800, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputMemory", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputMemoryKHR", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeAvailable", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeAvailableKHR", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeVisible", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeVisibleKHR", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "Volatile", .value = 0x8000, .parameters = &[_]OperandKind{} },
            },
            .MemoryAccess => &[_]Enumerant{
                .{ .name = "Volatile", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "Aligned", .value = 0x0002, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Nontemporal", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "MakePointerAvailable", .value = 0x0008, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakePointerAvailableKHR", .value = 0x0008, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakePointerVisible", .value = 0x0010, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakePointerVisibleKHR", .value = 0x0010, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "NonPrivatePointer", .value = 0x0020, .parameters = &[_]OperandKind{} },
                .{ .name = "NonPrivatePointerKHR", .value = 0x0020, .parameters = &[_]OperandKind{} },
            },
            .KernelProfilingInfo => &[_]Enumerant{
                .{ .name = "CmdExecTime", .value = 0x0001, .parameters = &[_]OperandKind{} },
            },
            .RayFlags => &[_]Enumerant{
                .{ .name = "NoneKHR", .value = 0x0000, .parameters = &[_]OperandKind{} },
                .{ .name = "OpaqueKHR", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "NoOpaqueKHR", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "TerminateOnFirstHitKHR", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "SkipClosestHitShaderKHR", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "CullBackFacingTrianglesKHR", .value = 0x0010, .parameters = &[_]OperandKind{} },
                .{ .name = "CullFrontFacingTrianglesKHR", .value = 0x0020, .parameters = &[_]OperandKind{} },
                .{ .name = "CullOpaqueKHR", .value = 0x0040, .parameters = &[_]OperandKind{} },
                .{ .name = "CullNoOpaqueKHR", .value = 0x0080, .parameters = &[_]OperandKind{} },
                .{ .name = "SkipTrianglesKHR", .value = 0x0100, .parameters = &[_]OperandKind{} },
                .{ .name = "SkipAABBsKHR", .value = 0x0200, .parameters = &[_]OperandKind{} },
            },
            .FragmentShadingRate => &[_]Enumerant{
                .{ .name = "Vertical2Pixels", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "Vertical4Pixels", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "Horizontal2Pixels", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "Horizontal4Pixels", .value = 0x0008, .parameters = &[_]OperandKind{} },
            },
            .SourceLanguage => &[_]Enumerant{
                .{ .name = "Unknown", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ESSL", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "GLSL", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "OpenCL_C", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "OpenCL_CPP", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "HLSL", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "CPP_for_OpenCL", .value = 6, .parameters = &[_]OperandKind{} },
            },
            .ExecutionModel => &[_]Enumerant{
                .{ .name = "Vertex", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "TessellationControl", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "TessellationEvaluation", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Geometry", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Fragment", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "GLCompute", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Kernel", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "TaskNV", .value = 5267, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshNV", .value = 5268, .parameters = &[_]OperandKind{} },
                .{ .name = "RayGenerationNV", .value = 5313, .parameters = &[_]OperandKind{} },
                .{ .name = "RayGenerationKHR", .value = 5313, .parameters = &[_]OperandKind{} },
                .{ .name = "IntersectionNV", .value = 5314, .parameters = &[_]OperandKind{} },
                .{ .name = "IntersectionKHR", .value = 5314, .parameters = &[_]OperandKind{} },
                .{ .name = "AnyHitNV", .value = 5315, .parameters = &[_]OperandKind{} },
                .{ .name = "AnyHitKHR", .value = 5315, .parameters = &[_]OperandKind{} },
                .{ .name = "ClosestHitNV", .value = 5316, .parameters = &[_]OperandKind{} },
                .{ .name = "ClosestHitKHR", .value = 5316, .parameters = &[_]OperandKind{} },
                .{ .name = "MissNV", .value = 5317, .parameters = &[_]OperandKind{} },
                .{ .name = "MissKHR", .value = 5317, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableNV", .value = 5318, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableKHR", .value = 5318, .parameters = &[_]OperandKind{} },
            },
            .AddressingModel => &[_]Enumerant{
                .{ .name = "Logical", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Physical32", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Physical64", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBuffer64", .value = 5348, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBuffer64EXT", .value = 5348, .parameters = &[_]OperandKind{} },
            },
            .MemoryModel => &[_]Enumerant{
                .{ .name = "Simple", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "GLSL450", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "OpenCL", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Vulkan", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanKHR", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .ExecutionMode => &[_]Enumerant{
                .{ .name = "Invocations", .value = 0, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SpacingEqual", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "SpacingFractionalEven", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "SpacingFractionalOdd", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexOrderCw", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexOrderCcw", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "PixelCenterInteger", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "OriginUpperLeft", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "OriginLowerLeft", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "EarlyFragmentTests", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "PointMode", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Xfb", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthReplacing", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthGreater", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthLess", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthUnchanged", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "LocalSize", .value = 17, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger, .LiteralInteger } },
                .{ .name = "LocalSizeHint", .value = 18, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger, .LiteralInteger } },
                .{ .name = "InputPoints", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "InputLines", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "InputLinesAdjacency", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Triangles", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "InputTrianglesAdjacency", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "Quads", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "Isolines", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputVertices", .value = 26, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "OutputPoints", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputLineStrip", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputTriangleStrip", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "VecTypeHint", .value = 30, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "ContractionOff", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "Initializer", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "Finalizer", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupSize", .value = 35, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SubgroupsPerWorkgroup", .value = 36, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SubgroupsPerWorkgroupId", .value = 37, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "LocalSizeId", .value = 38, .parameters = &[_]OperandKind{ .IdRef, .IdRef, .IdRef } },
                .{ .name = "LocalSizeHintId", .value = 39, .parameters = &[_]OperandKind{ .IdRef, .IdRef, .IdRef } },
                .{ .name = "SubgroupUniformControlFlowKHR", .value = 4421, .parameters = &[_]OperandKind{} },
                .{ .name = "PostDepthCoverage", .value = 4446, .parameters = &[_]OperandKind{} },
                .{ .name = "DenormPreserve", .value = 4459, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DenormFlushToZero", .value = 4460, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SignedZeroInfNanPreserve", .value = 4461, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTE", .value = 4462, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTZ", .value = 4463, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "StencilRefReplacingEXT", .value = 5027, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputLinesNV", .value = 5269, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputPrimitivesNV", .value = 5270, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DerivativeGroupQuadsNV", .value = 5289, .parameters = &[_]OperandKind{} },
                .{ .name = "DerivativeGroupLinearNV", .value = 5290, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputTrianglesNV", .value = 5298, .parameters = &[_]OperandKind{} },
                .{ .name = "PixelInterlockOrderedEXT", .value = 5366, .parameters = &[_]OperandKind{} },
                .{ .name = "PixelInterlockUnorderedEXT", .value = 5367, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleInterlockOrderedEXT", .value = 5368, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleInterlockUnorderedEXT", .value = 5369, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateInterlockOrderedEXT", .value = 5370, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateInterlockUnorderedEXT", .value = 5371, .parameters = &[_]OperandKind{} },
                .{ .name = "SharedLocalMemorySizeINTEL", .value = 5618, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTPINTEL", .value = 5620, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTNINTEL", .value = 5621, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FloatingPointModeALTINTEL", .value = 5622, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FloatingPointModeIEEEINTEL", .value = 5623, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxWorkgroupSizeINTEL", .value = 5893, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger, .LiteralInteger } },
                .{ .name = "MaxWorkDimINTEL", .value = 5894, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "NoGlobalOffsetINTEL", .value = 5895, .parameters = &[_]OperandKind{} },
                .{ .name = "NumSIMDWorkitemsINTEL", .value = 5896, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SchedulerTargetFmaxMhzINTEL", .value = 5903, .parameters = &[_]OperandKind{.LiteralInteger} },
            },
            .StorageClass => &[_]Enumerant{
                .{ .name = "UniformConstant", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Input", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Uniform", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Output", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Workgroup", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "CrossWorkgroup", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Private", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "Function", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Generic", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "PushConstant", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicCounter", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Image", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBuffer", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableDataNV", .value = 5328, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableDataKHR", .value = 5328, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingCallableDataNV", .value = 5329, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingCallableDataKHR", .value = 5329, .parameters = &[_]OperandKind{} },
                .{ .name = "RayPayloadNV", .value = 5338, .parameters = &[_]OperandKind{} },
                .{ .name = "RayPayloadKHR", .value = 5338, .parameters = &[_]OperandKind{} },
                .{ .name = "HitAttributeNV", .value = 5339, .parameters = &[_]OperandKind{} },
                .{ .name = "HitAttributeKHR", .value = 5339, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayPayloadNV", .value = 5342, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayPayloadKHR", .value = 5342, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderRecordBufferNV", .value = 5343, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderRecordBufferKHR", .value = 5343, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBuffer", .value = 5349, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBufferEXT", .value = 5349, .parameters = &[_]OperandKind{} },
                .{ .name = "CodeSectionINTEL", .value = 5605, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceOnlyINTEL", .value = 5936, .parameters = &[_]OperandKind{} },
                .{ .name = "HostOnlyINTEL", .value = 5937, .parameters = &[_]OperandKind{} },
            },
            .Dim => &[_]Enumerant{
                .{ .name = "1D", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "2D", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "3D", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Cube", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Rect", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "Buffer", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "SubpassData", .value = 6, .parameters = &[_]OperandKind{} },
            },
            .SamplerAddressingMode => &[_]Enumerant{
                .{ .name = "None", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ClampToEdge", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Clamp", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Repeat", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RepeatMirrored", .value = 4, .parameters = &[_]OperandKind{} },
            },
            .SamplerFilterMode => &[_]Enumerant{
                .{ .name = "Nearest", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Linear", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .ImageFormat => &[_]Enumerant{
                .{ .name = "Unknown", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba32f", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16f", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "R32f", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8Snorm", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg32f", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16f", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "R11fG11fB10f", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "R16f", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgb10A2", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "R16", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "R8", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16Snorm", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16Snorm", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8Snorm", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "R16Snorm", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "R8Snorm", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba32i", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16i", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8i", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "R32i", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg32i", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16i", .value = 26, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8i", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "R16i", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "R8i", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba32ui", .value = 30, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16ui", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8ui", .value = 32, .parameters = &[_]OperandKind{} },
                .{ .name = "R32ui", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgb10a2ui", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg32ui", .value = 35, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16ui", .value = 36, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8ui", .value = 37, .parameters = &[_]OperandKind{} },
                .{ .name = "R16ui", .value = 38, .parameters = &[_]OperandKind{} },
                .{ .name = "R8ui", .value = 39, .parameters = &[_]OperandKind{} },
                .{ .name = "R64ui", .value = 40, .parameters = &[_]OperandKind{} },
                .{ .name = "R64i", .value = 41, .parameters = &[_]OperandKind{} },
            },
            .ImageChannelOrder => &[_]Enumerant{
                .{ .name = "R", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "A", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RG", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "RA", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RGB", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "RGBA", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "BGRA", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "ARGB", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Intensity", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "Luminance", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "Rx", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "RGx", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "RGBx", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "Depth", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthStencil", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "sRGB", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "sRGBx", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "sRGBA", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "sBGRA", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "ABGR", .value = 19, .parameters = &[_]OperandKind{} },
            },
            .ImageChannelDataType => &[_]Enumerant{
                .{ .name = "SnormInt8", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "SnormInt16", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt8", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt16", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormShort565", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormShort555", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt101010", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedInt8", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedInt16", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedInt32", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedInt8", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedInt16", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedInt32", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "HalfFloat", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "Float", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt24", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt101010_2", .value = 16, .parameters = &[_]OperandKind{} },
            },
            .FPRoundingMode => &[_]Enumerant{
                .{ .name = "RTE", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RTZ", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RTP", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "RTN", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .FPDenormMode => &[_]Enumerant{
                .{ .name = "Preserve", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "FlushToZero", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .QuantizationModes => &[_]Enumerant{
                .{ .name = "TRN", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "TRN_ZERO", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RND", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_ZERO", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_INF", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_MIN_INF", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_CONV", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_CONV_ODD", .value = 7, .parameters = &[_]OperandKind{} },
            },
            .FPOperationMode => &[_]Enumerant{
                .{ .name = "IEEE", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ALT", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .OverflowModes => &[_]Enumerant{
                .{ .name = "WRAP", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "SAT", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "SAT_ZERO", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "SAT_SYM", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .LinkageType => &[_]Enumerant{
                .{ .name = "Export", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Import", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "LinkOnceODR", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .AccessQualifier => &[_]Enumerant{
                .{ .name = "ReadOnly", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "WriteOnly", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ReadWrite", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .FunctionParameterAttribute => &[_]Enumerant{
                .{ .name = "Zext", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Sext", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ByVal", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Sret", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "NoAlias", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "NoCapture", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "NoWrite", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "NoReadWrite", .value = 7, .parameters = &[_]OperandKind{} },
            },
            .Decoration => &[_]Enumerant{
                .{ .name = "RelaxedPrecision", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "SpecId", .value = 1, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Block", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "BufferBlock", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RowMajor", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "ColMajor", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "ArrayStride", .value = 6, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MatrixStride", .value = 7, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "GLSLShared", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "GLSLPacked", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "CPacked", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "BuiltIn", .value = 11, .parameters = &[_]OperandKind{.BuiltIn} },
                .{ .name = "NoPerspective", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "Flat", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "Patch", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "Centroid", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "Sample", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "Invariant", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "Restrict", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "Aliased", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "Volatile", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Constant", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "Coherent", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "NonWritable", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "NonReadable", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "Uniform", .value = 26, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformId", .value = 27, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "SaturatedConversion", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "Stream", .value = 29, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Location", .value = 30, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Component", .value = 31, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Index", .value = 32, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Binding", .value = 33, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DescriptorSet", .value = 34, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Offset", .value = 35, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "XfbBuffer", .value = 36, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "XfbStride", .value = 37, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FuncParamAttr", .value = 38, .parameters = &[_]OperandKind{.FunctionParameterAttribute} },
                .{ .name = "FPRoundingMode", .value = 39, .parameters = &[_]OperandKind{.FPRoundingMode} },
                .{ .name = "FPFastMathMode", .value = 40, .parameters = &[_]OperandKind{.FPFastMathMode} },
                .{ .name = "LinkageAttributes", .value = 41, .parameters = &[_]OperandKind{ .LiteralString, .LinkageType } },
                .{ .name = "NoContraction", .value = 42, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentIndex", .value = 43, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Alignment", .value = 44, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxByteOffset", .value = 45, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "AlignmentId", .value = 46, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "MaxByteOffsetId", .value = 47, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "NoSignedWrap", .value = 4469, .parameters = &[_]OperandKind{} },
                .{ .name = "NoUnsignedWrap", .value = 4470, .parameters = &[_]OperandKind{} },
                .{ .name = "ExplicitInterpAMD", .value = 4999, .parameters = &[_]OperandKind{} },
                .{ .name = "OverrideCoverageNV", .value = 5248, .parameters = &[_]OperandKind{} },
                .{ .name = "PassthroughNV", .value = 5250, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportRelativeNV", .value = 5252, .parameters = &[_]OperandKind{} },
                .{ .name = "SecondaryViewportRelativeNV", .value = 5256, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PerPrimitiveNV", .value = 5271, .parameters = &[_]OperandKind{} },
                .{ .name = "PerViewNV", .value = 5272, .parameters = &[_]OperandKind{} },
                .{ .name = "PerTaskNV", .value = 5273, .parameters = &[_]OperandKind{} },
                .{ .name = "PerVertexKHR", .value = 5285, .parameters = &[_]OperandKind{} },
                .{ .name = "PerVertexNV", .value = 5285, .parameters = &[_]OperandKind{} },
                .{ .name = "NonUniform", .value = 5300, .parameters = &[_]OperandKind{} },
                .{ .name = "NonUniformEXT", .value = 5300, .parameters = &[_]OperandKind{} },
                .{ .name = "RestrictPointer", .value = 5355, .parameters = &[_]OperandKind{} },
                .{ .name = "RestrictPointerEXT", .value = 5355, .parameters = &[_]OperandKind{} },
                .{ .name = "AliasedPointer", .value = 5356, .parameters = &[_]OperandKind{} },
                .{ .name = "AliasedPointerEXT", .value = 5356, .parameters = &[_]OperandKind{} },
                .{ .name = "BindlessSamplerNV", .value = 5398, .parameters = &[_]OperandKind{} },
                .{ .name = "BindlessImageNV", .value = 5399, .parameters = &[_]OperandKind{} },
                .{ .name = "BoundSamplerNV", .value = 5400, .parameters = &[_]OperandKind{} },
                .{ .name = "BoundImageNV", .value = 5401, .parameters = &[_]OperandKind{} },
                .{ .name = "SIMTCallINTEL", .value = 5599, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "ReferencedIndirectlyINTEL", .value = 5602, .parameters = &[_]OperandKind{} },
                .{ .name = "ClobberINTEL", .value = 5607, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "SideEffectsINTEL", .value = 5608, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorComputeVariableINTEL", .value = 5624, .parameters = &[_]OperandKind{} },
                .{ .name = "FuncParamIOKindINTEL", .value = 5625, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "VectorComputeFunctionINTEL", .value = 5626, .parameters = &[_]OperandKind{} },
                .{ .name = "StackCallINTEL", .value = 5627, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalVariableOffsetINTEL", .value = 5628, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "CounterBuffer", .value = 5634, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "HlslCounterBufferGOOGLE", .value = 5634, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "UserSemantic", .value = 5635, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "HlslSemanticGOOGLE", .value = 5635, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "UserTypeGOOGLE", .value = 5636, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "FunctionRoundingModeINTEL", .value = 5822, .parameters = &[_]OperandKind{ .LiteralInteger, .FPRoundingMode } },
                .{ .name = "FunctionDenormModeINTEL", .value = 5823, .parameters = &[_]OperandKind{ .LiteralInteger, .FPDenormMode } },
                .{ .name = "RegisterINTEL", .value = 5825, .parameters = &[_]OperandKind{} },
                .{ .name = "MemoryINTEL", .value = 5826, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "NumbanksINTEL", .value = 5827, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "BankwidthINTEL", .value = 5828, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxPrivateCopiesINTEL", .value = 5829, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SinglepumpINTEL", .value = 5830, .parameters = &[_]OperandKind{} },
                .{ .name = "DoublepumpINTEL", .value = 5831, .parameters = &[_]OperandKind{} },
                .{ .name = "MaxReplicatesINTEL", .value = 5832, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SimpleDualPortINTEL", .value = 5833, .parameters = &[_]OperandKind{} },
                .{ .name = "MergeINTEL", .value = 5834, .parameters = &[_]OperandKind{ .LiteralString, .LiteralString } },
                .{ .name = "BankBitsINTEL", .value = 5835, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "ForcePow2DepthINTEL", .value = 5836, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "BurstCoalesceINTEL", .value = 5899, .parameters = &[_]OperandKind{} },
                .{ .name = "CacheSizeINTEL", .value = 5900, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DontStaticallyCoalesceINTEL", .value = 5901, .parameters = &[_]OperandKind{} },
                .{ .name = "PrefetchINTEL", .value = 5902, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "StallEnableINTEL", .value = 5905, .parameters = &[_]OperandKind{} },
                .{ .name = "FuseLoopsInFunctionINTEL", .value = 5907, .parameters = &[_]OperandKind{} },
                .{ .name = "BufferLocationINTEL", .value = 5921, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "IOPipeStorageINTEL", .value = 5944, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FunctionFloatingPointModeINTEL", .value = 6080, .parameters = &[_]OperandKind{ .LiteralInteger, .FPOperationMode } },
                .{ .name = "SingleElementVectorINTEL", .value = 6085, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorComputeCallableFunctionINTEL", .value = 6087, .parameters = &[_]OperandKind{} },
                .{ .name = "MediaBlockIOINTEL", .value = 6140, .parameters = &[_]OperandKind{} },
            },
            .BuiltIn => &[_]Enumerant{
                .{ .name = "Position", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "PointSize", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ClipDistance", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "CullDistance", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexId", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceId", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveId", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "InvocationId", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "Layer", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportIndex", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "TessLevelOuter", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "TessLevelInner", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "TessCoord", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "PatchVertices", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "FragCoord", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "PointCoord", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "FrontFacing", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleId", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "SamplePosition", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleMask", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "FragDepth", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "HelperInvocation", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "NumWorkgroups", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupSize", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupId", .value = 26, .parameters = &[_]OperandKind{} },
                .{ .name = "LocalInvocationId", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalInvocationId", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "LocalInvocationIndex", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkDim", .value = 30, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalSize", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "EnqueuedWorkgroupSize", .value = 32, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalOffset", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalLinearId", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupSize", .value = 36, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupMaxSize", .value = 37, .parameters = &[_]OperandKind{} },
                .{ .name = "NumSubgroups", .value = 38, .parameters = &[_]OperandKind{} },
                .{ .name = "NumEnqueuedSubgroups", .value = 39, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupId", .value = 40, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLocalInvocationId", .value = 41, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexIndex", .value = 42, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceIndex", .value = 43, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupEqMask", .value = 4416, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupEqMaskKHR", .value = 4416, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGeMask", .value = 4417, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGeMaskKHR", .value = 4417, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGtMask", .value = 4418, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGtMaskKHR", .value = 4418, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLeMask", .value = 4419, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLeMaskKHR", .value = 4419, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLtMask", .value = 4420, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLtMaskKHR", .value = 4420, .parameters = &[_]OperandKind{} },
                .{ .name = "BaseVertex", .value = 4424, .parameters = &[_]OperandKind{} },
                .{ .name = "BaseInstance", .value = 4425, .parameters = &[_]OperandKind{} },
                .{ .name = "DrawIndex", .value = 4426, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveShadingRateKHR", .value = 4432, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceIndex", .value = 4438, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewIndex", .value = 4440, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateKHR", .value = 4444, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspAMD", .value = 4992, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspCentroidAMD", .value = 4993, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspSampleAMD", .value = 4994, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordSmoothAMD", .value = 4995, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordSmoothCentroidAMD", .value = 4996, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordSmoothSampleAMD", .value = 4997, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordPullModelAMD", .value = 4998, .parameters = &[_]OperandKind{} },
                .{ .name = "FragStencilRefEXT", .value = 5014, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportMaskNV", .value = 5253, .parameters = &[_]OperandKind{} },
                .{ .name = "SecondaryPositionNV", .value = 5257, .parameters = &[_]OperandKind{} },
                .{ .name = "SecondaryViewportMaskNV", .value = 5258, .parameters = &[_]OperandKind{} },
                .{ .name = "PositionPerViewNV", .value = 5261, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportMaskPerViewNV", .value = 5262, .parameters = &[_]OperandKind{} },
                .{ .name = "FullyCoveredEXT", .value = 5264, .parameters = &[_]OperandKind{} },
                .{ .name = "TaskCountNV", .value = 5274, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveCountNV", .value = 5275, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveIndicesNV", .value = 5276, .parameters = &[_]OperandKind{} },
                .{ .name = "ClipDistancePerViewNV", .value = 5277, .parameters = &[_]OperandKind{} },
                .{ .name = "CullDistancePerViewNV", .value = 5278, .parameters = &[_]OperandKind{} },
                .{ .name = "LayerPerViewNV", .value = 5279, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshViewCountNV", .value = 5280, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshViewIndicesNV", .value = 5281, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordKHR", .value = 5286, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNV", .value = 5286, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspKHR", .value = 5287, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspNV", .value = 5287, .parameters = &[_]OperandKind{} },
                .{ .name = "FragSizeEXT", .value = 5292, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentSizeNV", .value = 5292, .parameters = &[_]OperandKind{} },
                .{ .name = "FragInvocationCountEXT", .value = 5293, .parameters = &[_]OperandKind{} },
                .{ .name = "InvocationsPerPixelNV", .value = 5293, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchIdNV", .value = 5319, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchIdKHR", .value = 5319, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchSizeNV", .value = 5320, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchSizeKHR", .value = 5320, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayOriginNV", .value = 5321, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayOriginKHR", .value = 5321, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayDirectionNV", .value = 5322, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayDirectionKHR", .value = 5322, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayOriginNV", .value = 5323, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayOriginKHR", .value = 5323, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayDirectionNV", .value = 5324, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayDirectionKHR", .value = 5324, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTminNV", .value = 5325, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTminKHR", .value = 5325, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTmaxNV", .value = 5326, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTmaxKHR", .value = 5326, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceCustomIndexNV", .value = 5327, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceCustomIndexKHR", .value = 5327, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectToWorldNV", .value = 5330, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectToWorldKHR", .value = 5330, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldToObjectNV", .value = 5331, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldToObjectKHR", .value = 5331, .parameters = &[_]OperandKind{} },
                .{ .name = "HitTNV", .value = 5332, .parameters = &[_]OperandKind{} },
                .{ .name = "HitKindNV", .value = 5333, .parameters = &[_]OperandKind{} },
                .{ .name = "HitKindKHR", .value = 5333, .parameters = &[_]OperandKind{} },
                .{ .name = "CurrentRayTimeNV", .value = 5334, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayFlagsNV", .value = 5351, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayFlagsKHR", .value = 5351, .parameters = &[_]OperandKind{} },
                .{ .name = "RayGeometryIndexKHR", .value = 5352, .parameters = &[_]OperandKind{} },
                .{ .name = "WarpsPerSMNV", .value = 5374, .parameters = &[_]OperandKind{} },
                .{ .name = "SMCountNV", .value = 5375, .parameters = &[_]OperandKind{} },
                .{ .name = "WarpIDNV", .value = 5376, .parameters = &[_]OperandKind{} },
                .{ .name = "SMIDNV", .value = 5377, .parameters = &[_]OperandKind{} },
            },
            .Scope => &[_]Enumerant{
                .{ .name = "CrossDevice", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Device", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Workgroup", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Subgroup", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Invocation", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "QueueFamily", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "QueueFamilyKHR", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderCallKHR", .value = 6, .parameters = &[_]OperandKind{} },
            },
            .GroupOperation => &[_]Enumerant{
                .{ .name = "Reduce", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "InclusiveScan", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ExclusiveScan", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "ClusteredReduce", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "PartitionedReduceNV", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "PartitionedInclusiveScanNV", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "PartitionedExclusiveScanNV", .value = 8, .parameters = &[_]OperandKind{} },
            },
            .KernelEnqueueFlags => &[_]Enumerant{
                .{ .name = "NoWait", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "WaitKernel", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "WaitWorkGroup", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .Capability => &[_]Enumerant{
                .{ .name = "Matrix", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Shader", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Geometry", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Tessellation", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Addresses", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "Linkage", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Kernel", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "Vector16", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Float16Buffer", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "Float16", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "Float64", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Int64", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "Int64Atomics", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageBasic", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageReadWrite", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageMipmap", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "Pipes", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "Groups", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceEnqueue", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "LiteralSampler", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicStorage", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Int16", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "TessellationPointSize", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "GeometryPointSize", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageGatherExtended", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageMultisample", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformBufferArrayDynamicIndexing", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledImageArrayDynamicIndexing", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBufferArrayDynamicIndexing", .value = 30, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageArrayDynamicIndexing", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "ClipDistance", .value = 32, .parameters = &[_]OperandKind{} },
                .{ .name = "CullDistance", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageCubeArray", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleRateShading", .value = 35, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageRect", .value = 36, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledRect", .value = 37, .parameters = &[_]OperandKind{} },
                .{ .name = "GenericPointer", .value = 38, .parameters = &[_]OperandKind{} },
                .{ .name = "Int8", .value = 39, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachment", .value = 40, .parameters = &[_]OperandKind{} },
                .{ .name = "SparseResidency", .value = 41, .parameters = &[_]OperandKind{} },
                .{ .name = "MinLod", .value = 42, .parameters = &[_]OperandKind{} },
                .{ .name = "Sampled1D", .value = 43, .parameters = &[_]OperandKind{} },
                .{ .name = "Image1D", .value = 44, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledCubeArray", .value = 45, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledBuffer", .value = 46, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageBuffer", .value = 47, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageMSArray", .value = 48, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageExtendedFormats", .value = 49, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageQuery", .value = 50, .parameters = &[_]OperandKind{} },
                .{ .name = "DerivativeControl", .value = 51, .parameters = &[_]OperandKind{} },
                .{ .name = "InterpolationFunction", .value = 52, .parameters = &[_]OperandKind{} },
                .{ .name = "TransformFeedback", .value = 53, .parameters = &[_]OperandKind{} },
                .{ .name = "GeometryStreams", .value = 54, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageReadWithoutFormat", .value = 55, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageWriteWithoutFormat", .value = 56, .parameters = &[_]OperandKind{} },
                .{ .name = "MultiViewport", .value = 57, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupDispatch", .value = 58, .parameters = &[_]OperandKind{} },
                .{ .name = "NamedBarrier", .value = 59, .parameters = &[_]OperandKind{} },
                .{ .name = "PipeStorage", .value = 60, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniform", .value = 61, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformVote", .value = 62, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformArithmetic", .value = 63, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformBallot", .value = 64, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformShuffle", .value = 65, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformShuffleRelative", .value = 66, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformClustered", .value = 67, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformQuad", .value = 68, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderLayer", .value = 69, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportIndex", .value = 70, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformDecoration", .value = 71, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShadingRateKHR", .value = 4422, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupBallotKHR", .value = 4423, .parameters = &[_]OperandKind{} },
                .{ .name = "DrawParameters", .value = 4427, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemoryExplicitLayoutKHR", .value = 4428, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemoryExplicitLayout8BitAccessKHR", .value = 4429, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemoryExplicitLayout16BitAccessKHR", .value = 4430, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupVoteKHR", .value = 4431, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBuffer16BitAccess", .value = 4433, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageUniformBufferBlock16", .value = 4433, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformAndStorageBuffer16BitAccess", .value = 4434, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageUniform16", .value = 4434, .parameters = &[_]OperandKind{} },
                .{ .name = "StoragePushConstant16", .value = 4435, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageInputOutput16", .value = 4436, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceGroup", .value = 4437, .parameters = &[_]OperandKind{} },
                .{ .name = "MultiView", .value = 4439, .parameters = &[_]OperandKind{} },
                .{ .name = "VariablePointersStorageBuffer", .value = 4441, .parameters = &[_]OperandKind{} },
                .{ .name = "VariablePointers", .value = 4442, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicStorageOps", .value = 4445, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleMaskPostDepthCoverage", .value = 4447, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBuffer8BitAccess", .value = 4448, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformAndStorageBuffer8BitAccess", .value = 4449, .parameters = &[_]OperandKind{} },
                .{ .name = "StoragePushConstant8", .value = 4450, .parameters = &[_]OperandKind{} },
                .{ .name = "DenormPreserve", .value = 4464, .parameters = &[_]OperandKind{} },
                .{ .name = "DenormFlushToZero", .value = 4465, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedZeroInfNanPreserve", .value = 4466, .parameters = &[_]OperandKind{} },
                .{ .name = "RoundingModeRTE", .value = 4467, .parameters = &[_]OperandKind{} },
                .{ .name = "RoundingModeRTZ", .value = 4468, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryProvisionalKHR", .value = 4471, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryKHR", .value = 4472, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTraversalPrimitiveCullingKHR", .value = 4478, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingKHR", .value = 4479, .parameters = &[_]OperandKind{} },
                .{ .name = "Float16ImageAMD", .value = 5008, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageGatherBiasLodAMD", .value = 5009, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentMaskAMD", .value = 5010, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilExportEXT", .value = 5013, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageReadWriteLodAMD", .value = 5015, .parameters = &[_]OperandKind{} },
                .{ .name = "Int64ImageEXT", .value = 5016, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderClockKHR", .value = 5055, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleMaskOverrideCoverageNV", .value = 5249, .parameters = &[_]OperandKind{} },
                .{ .name = "GeometryShaderPassthroughNV", .value = 5251, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportIndexLayerEXT", .value = 5254, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportIndexLayerNV", .value = 5254, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportMaskNV", .value = 5255, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderStereoViewNV", .value = 5259, .parameters = &[_]OperandKind{} },
                .{ .name = "PerViewAttributesNV", .value = 5260, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentFullyCoveredEXT", .value = 5265, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshShadingNV", .value = 5266, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageFootprintNV", .value = 5282, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentBarycentricKHR", .value = 5284, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentBarycentricNV", .value = 5284, .parameters = &[_]OperandKind{} },
                .{ .name = "ComputeDerivativeGroupQuadsNV", .value = 5288, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentDensityEXT", .value = 5291, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateNV", .value = 5291, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformPartitionedNV", .value = 5297, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderNonUniform", .value = 5301, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderNonUniformEXT", .value = 5301, .parameters = &[_]OperandKind{} },
                .{ .name = "RuntimeDescriptorArray", .value = 5302, .parameters = &[_]OperandKind{} },
                .{ .name = "RuntimeDescriptorArrayEXT", .value = 5302, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayDynamicIndexing", .value = 5303, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayDynamicIndexingEXT", .value = 5303, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayDynamicIndexing", .value = 5304, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayDynamicIndexingEXT", .value = 5304, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayDynamicIndexing", .value = 5305, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayDynamicIndexingEXT", .value = 5305, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformBufferArrayNonUniformIndexing", .value = 5306, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformBufferArrayNonUniformIndexingEXT", .value = 5306, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledImageArrayNonUniformIndexing", .value = 5307, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledImageArrayNonUniformIndexingEXT", .value = 5307, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBufferArrayNonUniformIndexing", .value = 5308, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBufferArrayNonUniformIndexingEXT", .value = 5308, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageArrayNonUniformIndexing", .value = 5309, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageArrayNonUniformIndexingEXT", .value = 5309, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayNonUniformIndexing", .value = 5310, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayNonUniformIndexingEXT", .value = 5310, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayNonUniformIndexing", .value = 5311, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayNonUniformIndexingEXT", .value = 5311, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayNonUniformIndexing", .value = 5312, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayNonUniformIndexingEXT", .value = 5312, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingNV", .value = 5340, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingMotionBlurNV", .value = 5341, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModel", .value = 5345, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModelKHR", .value = 5345, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModelDeviceScope", .value = 5346, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModelDeviceScopeKHR", .value = 5346, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBufferAddresses", .value = 5347, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBufferAddressesEXT", .value = 5347, .parameters = &[_]OperandKind{} },
                .{ .name = "ComputeDerivativeGroupLinearNV", .value = 5350, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingProvisionalKHR", .value = 5353, .parameters = &[_]OperandKind{} },
                .{ .name = "CooperativeMatrixNV", .value = 5357, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShaderSampleInterlockEXT", .value = 5363, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShaderShadingRateInterlockEXT", .value = 5372, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderSMBuiltinsNV", .value = 5373, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShaderPixelInterlockEXT", .value = 5378, .parameters = &[_]OperandKind{} },
                .{ .name = "DemoteToHelperInvocation", .value = 5379, .parameters = &[_]OperandKind{} },
                .{ .name = "DemoteToHelperInvocationEXT", .value = 5379, .parameters = &[_]OperandKind{} },
                .{ .name = "BindlessTextureNV", .value = 5390, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupShuffleINTEL", .value = 5568, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupBufferBlockIOINTEL", .value = 5569, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupImageBlockIOINTEL", .value = 5570, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupImageMediaBlockIOINTEL", .value = 5579, .parameters = &[_]OperandKind{} },
                .{ .name = "RoundToInfinityINTEL", .value = 5582, .parameters = &[_]OperandKind{} },
                .{ .name = "FloatingPointModeINTEL", .value = 5583, .parameters = &[_]OperandKind{} },
                .{ .name = "IntegerFunctions2INTEL", .value = 5584, .parameters = &[_]OperandKind{} },
                .{ .name = "FunctionPointersINTEL", .value = 5603, .parameters = &[_]OperandKind{} },
                .{ .name = "IndirectReferencesINTEL", .value = 5604, .parameters = &[_]OperandKind{} },
                .{ .name = "AsmINTEL", .value = 5606, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat32MinMaxEXT", .value = 5612, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat64MinMaxEXT", .value = 5613, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat16MinMaxEXT", .value = 5616, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorComputeINTEL", .value = 5617, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorAnyINTEL", .value = 5619, .parameters = &[_]OperandKind{} },
                .{ .name = "ExpectAssumeKHR", .value = 5629, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupAvcMotionEstimationINTEL", .value = 5696, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupAvcMotionEstimationIntraINTEL", .value = 5697, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupAvcMotionEstimationChromaINTEL", .value = 5698, .parameters = &[_]OperandKind{} },
                .{ .name = "VariableLengthArrayINTEL", .value = 5817, .parameters = &[_]OperandKind{} },
                .{ .name = "FunctionFloatControlINTEL", .value = 5821, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAMemoryAttributesINTEL", .value = 5824, .parameters = &[_]OperandKind{} },
                .{ .name = "FPFastMathModeINTEL", .value = 5837, .parameters = &[_]OperandKind{} },
                .{ .name = "ArbitraryPrecisionIntegersINTEL", .value = 5844, .parameters = &[_]OperandKind{} },
                .{ .name = "ArbitraryPrecisionFloatingPointINTEL", .value = 5845, .parameters = &[_]OperandKind{} },
                .{ .name = "UnstructuredLoopControlsINTEL", .value = 5886, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGALoopControlsINTEL", .value = 5888, .parameters = &[_]OperandKind{} },
                .{ .name = "KernelAttributesINTEL", .value = 5892, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAKernelAttributesINTEL", .value = 5897, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAMemoryAccessesINTEL", .value = 5898, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAClusterAttributesINTEL", .value = 5904, .parameters = &[_]OperandKind{} },
                .{ .name = "LoopFuseINTEL", .value = 5906, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGABufferLocationINTEL", .value = 5920, .parameters = &[_]OperandKind{} },
                .{ .name = "ArbitraryPrecisionFixedPointINTEL", .value = 5922, .parameters = &[_]OperandKind{} },
                .{ .name = "USMStorageClassesINTEL", .value = 5935, .parameters = &[_]OperandKind{} },
                .{ .name = "IOPipesINTEL", .value = 5943, .parameters = &[_]OperandKind{} },
                .{ .name = "BlockingPipesINTEL", .value = 5945, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGARegINTEL", .value = 5948, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInputAll", .value = 6016, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInputAllKHR", .value = 6016, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8Bit", .value = 6017, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8BitKHR", .value = 6017, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8BitPacked", .value = 6018, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8BitPackedKHR", .value = 6018, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProduct", .value = 6019, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductKHR", .value = 6019, .parameters = &[_]OperandKind{} },
                .{ .name = "BitInstructions", .value = 6025, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat32AddEXT", .value = 6033, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat64AddEXT", .value = 6034, .parameters = &[_]OperandKind{} },
                .{ .name = "LongConstantCompositeINTEL", .value = 6089, .parameters = &[_]OperandKind{} },
                .{ .name = "OptNoneINTEL", .value = 6094, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat16AddEXT", .value = 6095, .parameters = &[_]OperandKind{} },
                .{ .name = "DebugInfoModuleINTEL", .value = 6114, .parameters = &[_]OperandKind{} },
            },
            .RayQueryIntersection => &[_]Enumerant{
                .{ .name = "RayQueryCandidateIntersectionKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCommittedIntersectionKHR", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .RayQueryCommittedIntersectionType => &[_]Enumerant{
                .{ .name = "RayQueryCommittedIntersectionNoneKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCommittedIntersectionTriangleKHR", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCommittedIntersectionGeneratedKHR", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .RayQueryCandidateIntersectionType => &[_]Enumerant{
                .{ .name = "RayQueryCandidateIntersectionTriangleKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCandidateIntersectionAABBKHR", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .PackedVectorFormat => &[_]Enumerant{
                .{ .name = "PackedVectorFormat4x8Bit", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "PackedVectorFormat4x8BitKHR", .value = 0, .parameters = &[_]OperandKind{} },
            },
            .IdResultType => unreachable,
            .IdResult => unreachable,
            .IdMemorySemantics => unreachable,
            .IdScope => unreachable,
            .IdRef => unreachable,
            .LiteralInteger => unreachable,
            .LiteralString => unreachable,
            .LiteralContextDependentNumber => unreachable,
            .LiteralExtInstInteger => unreachable,
            .LiteralSpecConstantOpInteger => unreachable,
            .PairLiteralIntegerIdRef => unreachable,
            .PairIdRefLiteralInteger => unreachable,
            .PairIdRefIdRef => unreachable,
        };
    }
};
pub const Opcode = enum(u16) {
    OpNop = 0,
    OpUndef = 1,
    OpSourceContinued = 2,
    OpSource = 3,
    OpSourceExtension = 4,
    OpName = 5,
    OpMemberName = 6,
    OpString = 7,
    OpLine = 8,
    OpExtension = 10,
    OpExtInstImport = 11,
    OpExtInst = 12,
    OpMemoryModel = 14,
    OpEntryPoint = 15,
    OpExecutionMode = 16,
    OpCapability = 17,
    OpTypeVoid = 19,
    OpTypeBool = 20,
    OpTypeInt = 21,
    OpTypeFloat = 22,
    OpTypeVector = 23,
    OpTypeMatrix = 24,
    OpTypeImage = 25,
    OpTypeSampler = 26,
    OpTypeSampledImage = 27,
    OpTypeArray = 28,
    OpTypeRuntimeArray = 29,
    OpTypeStruct = 30,
    OpTypeOpaque = 31,
    OpTypePointer = 32,
    OpTypeFunction = 33,
    OpTypeEvent = 34,
    OpTypeDeviceEvent = 35,
    OpTypeReserveId = 36,
    OpTypeQueue = 37,
    OpTypePipe = 38,
    OpTypeForwardPointer = 39,
    OpConstantTrue = 41,
    OpConstantFalse = 42,
    OpConstant = 43,
    OpConstantComposite = 44,
    OpConstantSampler = 45,
    OpConstantNull = 46,
    OpSpecConstantTrue = 48,
    OpSpecConstantFalse = 49,
    OpSpecConstant = 50,
    OpSpecConstantComposite = 51,
    OpSpecConstantOp = 52,
    OpFunction = 54,
    OpFunctionParameter = 55,
    OpFunctionEnd = 56,
    OpFunctionCall = 57,
    OpVariable = 59,
    OpImageTexelPointer = 60,
    OpLoad = 61,
    OpStore = 62,
    OpCopyMemory = 63,
    OpCopyMemorySized = 64,
    OpAccessChain = 65,
    OpInBoundsAccessChain = 66,
    OpPtrAccessChain = 67,
    OpArrayLength = 68,
    OpGenericPtrMemSemantics = 69,
    OpInBoundsPtrAccessChain = 70,
    OpDecorate = 71,
    OpMemberDecorate = 72,
    OpDecorationGroup = 73,
    OpGroupDecorate = 74,
    OpGroupMemberDecorate = 75,
    OpVectorExtractDynamic = 77,
    OpVectorInsertDynamic = 78,
    OpVectorShuffle = 79,
    OpCompositeConstruct = 80,
    OpCompositeExtract = 81,
    OpCompositeInsert = 82,
    OpCopyObject = 83,
    OpTranspose = 84,
    OpSampledImage = 86,
    OpImageSampleImplicitLod = 87,
    OpImageSampleExplicitLod = 88,
    OpImageSampleDrefImplicitLod = 89,
    OpImageSampleDrefExplicitLod = 90,
    OpImageSampleProjImplicitLod = 91,
    OpImageSampleProjExplicitLod = 92,
    OpImageSampleProjDrefImplicitLod = 93,
    OpImageSampleProjDrefExplicitLod = 94,
    OpImageFetch = 95,
    OpImageGather = 96,
    OpImageDrefGather = 97,
    OpImageRead = 98,
    OpImageWrite = 99,
    OpImage = 100,
    OpImageQueryFormat = 101,
    OpImageQueryOrder = 102,
    OpImageQuerySizeLod = 103,
    OpImageQuerySize = 104,
    OpImageQueryLod = 105,
    OpImageQueryLevels = 106,
    OpImageQuerySamples = 107,
    OpConvertFToU = 109,
    OpConvertFToS = 110,
    OpConvertSToF = 111,
    OpConvertUToF = 112,
    OpUConvert = 113,
    OpSConvert = 114,
    OpFConvert = 115,
    OpQuantizeToF16 = 116,
    OpConvertPtrToU = 117,
    OpSatConvertSToU = 118,
    OpSatConvertUToS = 119,
    OpConvertUToPtr = 120,
    OpPtrCastToGeneric = 121,
    OpGenericCastToPtr = 122,
    OpGenericCastToPtrExplicit = 123,
    OpBitcast = 124,
    OpSNegate = 126,
    OpFNegate = 127,
    OpIAdd = 128,
    OpFAdd = 129,
    OpISub = 130,
    OpFSub = 131,
    OpIMul = 132,
    OpFMul = 133,
    OpUDiv = 134,
    OpSDiv = 135,
    OpFDiv = 136,
    OpUMod = 137,
    OpSRem = 138,
    OpSMod = 139,
    OpFRem = 140,
    OpFMod = 141,
    OpVectorTimesScalar = 142,
    OpMatrixTimesScalar = 143,
    OpVectorTimesMatrix = 144,
    OpMatrixTimesVector = 145,
    OpMatrixTimesMatrix = 146,
    OpOuterProduct = 147,
    OpDot = 148,
    OpIAddCarry = 149,
    OpISubBorrow = 150,
    OpUMulExtended = 151,
    OpSMulExtended = 152,
    OpAny = 154,
    OpAll = 155,
    OpIsNan = 156,
    OpIsInf = 157,
    OpIsFinite = 158,
    OpIsNormal = 159,
    OpSignBitSet = 160,
    OpLessOrGreater = 161,
    OpOrdered = 162,
    OpUnordered = 163,
    OpLogicalEqual = 164,
    OpLogicalNotEqual = 165,
    OpLogicalOr = 166,
    OpLogicalAnd = 167,
    OpLogicalNot = 168,
    OpSelect = 169,
    OpIEqual = 170,
    OpINotEqual = 171,
    OpUGreaterThan = 172,
    OpSGreaterThan = 173,
    OpUGreaterThanEqual = 174,
    OpSGreaterThanEqual = 175,
    OpULessThan = 176,
    OpSLessThan = 177,
    OpULessThanEqual = 178,
    OpSLessThanEqual = 179,
    OpFOrdEqual = 180,
    OpFUnordEqual = 181,
    OpFOrdNotEqual = 182,
    OpFUnordNotEqual = 183,
    OpFOrdLessThan = 184,
    OpFUnordLessThan = 185,
    OpFOrdGreaterThan = 186,
    OpFUnordGreaterThan = 187,
    OpFOrdLessThanEqual = 188,
    OpFUnordLessThanEqual = 189,
    OpFOrdGreaterThanEqual = 190,
    OpFUnordGreaterThanEqual = 191,
    OpShiftRightLogical = 194,
    OpShiftRightArithmetic = 195,
    OpShiftLeftLogical = 196,
    OpBitwiseOr = 197,
    OpBitwiseXor = 198,
    OpBitwiseAnd = 199,
    OpNot = 200,
    OpBitFieldInsert = 201,
    OpBitFieldSExtract = 202,
    OpBitFieldUExtract = 203,
    OpBitReverse = 204,
    OpBitCount = 205,
    OpDPdx = 207,
    OpDPdy = 208,
    OpFwidth = 209,
    OpDPdxFine = 210,
    OpDPdyFine = 211,
    OpFwidthFine = 212,
    OpDPdxCoarse = 213,
    OpDPdyCoarse = 214,
    OpFwidthCoarse = 215,
    OpEmitVertex = 218,
    OpEndPrimitive = 219,
    OpEmitStreamVertex = 220,
    OpEndStreamPrimitive = 221,
    OpControlBarrier = 224,
    OpMemoryBarrier = 225,
    OpAtomicLoad = 227,
    OpAtomicStore = 228,
    OpAtomicExchange = 229,
    OpAtomicCompareExchange = 230,
    OpAtomicCompareExchangeWeak = 231,
    OpAtomicIIncrement = 232,
    OpAtomicIDecrement = 233,
    OpAtomicIAdd = 234,
    OpAtomicISub = 235,
    OpAtomicSMin = 236,
    OpAtomicUMin = 237,
    OpAtomicSMax = 238,
    OpAtomicUMax = 239,
    OpAtomicAnd = 240,
    OpAtomicOr = 241,
    OpAtomicXor = 242,
    OpPhi = 245,
    OpLoopMerge = 246,
    OpSelectionMerge = 247,
    OpLabel = 248,
    OpBranch = 249,
    OpBranchConditional = 250,
    OpSwitch = 251,
    OpKill = 252,
    OpReturn = 253,
    OpReturnValue = 254,
    OpUnreachable = 255,
    OpLifetimeStart = 256,
    OpLifetimeStop = 257,
    OpGroupAsyncCopy = 259,
    OpGroupWaitEvents = 260,
    OpGroupAll = 261,
    OpGroupAny = 262,
    OpGroupBroadcast = 263,
    OpGroupIAdd = 264,
    OpGroupFAdd = 265,
    OpGroupFMin = 266,
    OpGroupUMin = 267,
    OpGroupSMin = 268,
    OpGroupFMax = 269,
    OpGroupUMax = 270,
    OpGroupSMax = 271,
    OpReadPipe = 274,
    OpWritePipe = 275,
    OpReservedReadPipe = 276,
    OpReservedWritePipe = 277,
    OpReserveReadPipePackets = 278,
    OpReserveWritePipePackets = 279,
    OpCommitReadPipe = 280,
    OpCommitWritePipe = 281,
    OpIsValidReserveId = 282,
    OpGetNumPipePackets = 283,
    OpGetMaxPipePackets = 284,
    OpGroupReserveReadPipePackets = 285,
    OpGroupReserveWritePipePackets = 286,
    OpGroupCommitReadPipe = 287,
    OpGroupCommitWritePipe = 288,
    OpEnqueueMarker = 291,
    OpEnqueueKernel = 292,
    OpGetKernelNDrangeSubGroupCount = 293,
    OpGetKernelNDrangeMaxSubGroupSize = 294,
    OpGetKernelWorkGroupSize = 295,
    OpGetKernelPreferredWorkGroupSizeMultiple = 296,
    OpRetainEvent = 297,
    OpReleaseEvent = 298,
    OpCreateUserEvent = 299,
    OpIsValidEvent = 300,
    OpSetUserEventStatus = 301,
    OpCaptureEventProfilingInfo = 302,
    OpGetDefaultQueue = 303,
    OpBuildNDRange = 304,
    OpImageSparseSampleImplicitLod = 305,
    OpImageSparseSampleExplicitLod = 306,
    OpImageSparseSampleDrefImplicitLod = 307,
    OpImageSparseSampleDrefExplicitLod = 308,
    OpImageSparseSampleProjImplicitLod = 309,
    OpImageSparseSampleProjExplicitLod = 310,
    OpImageSparseSampleProjDrefImplicitLod = 311,
    OpImageSparseSampleProjDrefExplicitLod = 312,
    OpImageSparseFetch = 313,
    OpImageSparseGather = 314,
    OpImageSparseDrefGather = 315,
    OpImageSparseTexelsResident = 316,
    OpNoLine = 317,
    OpAtomicFlagTestAndSet = 318,
    OpAtomicFlagClear = 319,
    OpImageSparseRead = 320,
    OpSizeOf = 321,
    OpTypePipeStorage = 322,
    OpConstantPipeStorage = 323,
    OpCreatePipeFromPipeStorage = 324,
    OpGetKernelLocalSizeForSubgroupCount = 325,
    OpGetKernelMaxNumSubgroups = 326,
    OpTypeNamedBarrier = 327,
    OpNamedBarrierInitialize = 328,
    OpMemoryNamedBarrier = 329,
    OpModuleProcessed = 330,
    OpExecutionModeId = 331,
    OpDecorateId = 332,
    OpGroupNonUniformElect = 333,
    OpGroupNonUniformAll = 334,
    OpGroupNonUniformAny = 335,
    OpGroupNonUniformAllEqual = 336,
    OpGroupNonUniformBroadcast = 337,
    OpGroupNonUniformBroadcastFirst = 338,
    OpGroupNonUniformBallot = 339,
    OpGroupNonUniformInverseBallot = 340,
    OpGroupNonUniformBallotBitExtract = 341,
    OpGroupNonUniformBallotBitCount = 342,
    OpGroupNonUniformBallotFindLSB = 343,
    OpGroupNonUniformBallotFindMSB = 344,
    OpGroupNonUniformShuffle = 345,
    OpGroupNonUniformShuffleXor = 346,
    OpGroupNonUniformShuffleUp = 347,
    OpGroupNonUniformShuffleDown = 348,
    OpGroupNonUniformIAdd = 349,
    OpGroupNonUniformFAdd = 350,
    OpGroupNonUniformIMul = 351,
    OpGroupNonUniformFMul = 352,
    OpGroupNonUniformSMin = 353,
    OpGroupNonUniformUMin = 354,
    OpGroupNonUniformFMin = 355,
    OpGroupNonUniformSMax = 356,
    OpGroupNonUniformUMax = 357,
    OpGroupNonUniformFMax = 358,
    OpGroupNonUniformBitwiseAnd = 359,
    OpGroupNonUniformBitwiseOr = 360,
    OpGroupNonUniformBitwiseXor = 361,
    OpGroupNonUniformLogicalAnd = 362,
    OpGroupNonUniformLogicalOr = 363,
    OpGroupNonUniformLogicalXor = 364,
    OpGroupNonUniformQuadBroadcast = 365,
    OpGroupNonUniformQuadSwap = 366,
    OpCopyLogical = 400,
    OpPtrEqual = 401,
    OpPtrNotEqual = 402,
    OpPtrDiff = 403,
    OpTerminateInvocation = 4416,
    OpSubgroupBallotKHR = 4421,
    OpSubgroupFirstInvocationKHR = 4422,
    OpSubgroupAllKHR = 4428,
    OpSubgroupAnyKHR = 4429,
    OpSubgroupAllEqualKHR = 4430,
    OpSubgroupReadInvocationKHR = 4432,
    OpTraceRayKHR = 4445,
    OpExecuteCallableKHR = 4446,
    OpConvertUToAccelerationStructureKHR = 4447,
    OpIgnoreIntersectionKHR = 4448,
    OpTerminateRayKHR = 4449,
    OpSDot = 4450,
    OpUDot = 4451,
    OpSUDot = 4452,
    OpSDotAccSat = 4453,
    OpUDotAccSat = 4454,
    OpSUDotAccSat = 4455,
    OpTypeRayQueryKHR = 4472,
    OpRayQueryInitializeKHR = 4473,
    OpRayQueryTerminateKHR = 4474,
    OpRayQueryGenerateIntersectionKHR = 4475,
    OpRayQueryConfirmIntersectionKHR = 4476,
    OpRayQueryProceedKHR = 4477,
    OpRayQueryGetIntersectionTypeKHR = 4479,
    OpGroupIAddNonUniformAMD = 5000,
    OpGroupFAddNonUniformAMD = 5001,
    OpGroupFMinNonUniformAMD = 5002,
    OpGroupUMinNonUniformAMD = 5003,
    OpGroupSMinNonUniformAMD = 5004,
    OpGroupFMaxNonUniformAMD = 5005,
    OpGroupUMaxNonUniformAMD = 5006,
    OpGroupSMaxNonUniformAMD = 5007,
    OpFragmentMaskFetchAMD = 5011,
    OpFragmentFetchAMD = 5012,
    OpReadClockKHR = 5056,
    OpImageSampleFootprintNV = 5283,
    OpGroupNonUniformPartitionNV = 5296,
    OpWritePackedPrimitiveIndices4x8NV = 5299,
    OpReportIntersectionKHR = 5334,
    OpIgnoreIntersectionNV = 5335,
    OpTerminateRayNV = 5336,
    OpTraceNV = 5337,
    OpTraceMotionNV = 5338,
    OpTraceRayMotionNV = 5339,
    OpTypeAccelerationStructureKHR = 5341,
    OpExecuteCallableNV = 5344,
    OpTypeCooperativeMatrixNV = 5358,
    OpCooperativeMatrixLoadNV = 5359,
    OpCooperativeMatrixStoreNV = 5360,
    OpCooperativeMatrixMulAddNV = 5361,
    OpCooperativeMatrixLengthNV = 5362,
    OpBeginInvocationInterlockEXT = 5364,
    OpEndInvocationInterlockEXT = 5365,
    OpDemoteToHelperInvocation = 5380,
    OpIsHelperInvocationEXT = 5381,
    OpConvertUToImageNV = 5391,
    OpConvertUToSamplerNV = 5392,
    OpConvertImageToUNV = 5393,
    OpConvertSamplerToUNV = 5394,
    OpConvertUToSampledImageNV = 5395,
    OpConvertSampledImageToUNV = 5396,
    OpSamplerImageAddressingModeNV = 5397,
    OpSubgroupShuffleINTEL = 5571,
    OpSubgroupShuffleDownINTEL = 5572,
    OpSubgroupShuffleUpINTEL = 5573,
    OpSubgroupShuffleXorINTEL = 5574,
    OpSubgroupBlockReadINTEL = 5575,
    OpSubgroupBlockWriteINTEL = 5576,
    OpSubgroupImageBlockReadINTEL = 5577,
    OpSubgroupImageBlockWriteINTEL = 5578,
    OpSubgroupImageMediaBlockReadINTEL = 5580,
    OpSubgroupImageMediaBlockWriteINTEL = 5581,
    OpUCountLeadingZerosINTEL = 5585,
    OpUCountTrailingZerosINTEL = 5586,
    OpAbsISubINTEL = 5587,
    OpAbsUSubINTEL = 5588,
    OpIAddSatINTEL = 5589,
    OpUAddSatINTEL = 5590,
    OpIAverageINTEL = 5591,
    OpUAverageINTEL = 5592,
    OpIAverageRoundedINTEL = 5593,
    OpUAverageRoundedINTEL = 5594,
    OpISubSatINTEL = 5595,
    OpUSubSatINTEL = 5596,
    OpIMul32x16INTEL = 5597,
    OpUMul32x16INTEL = 5598,
    OpAtomicFMinEXT = 5614,
    OpAtomicFMaxEXT = 5615,
    OpAssumeTrueKHR = 5630,
    OpExpectKHR = 5631,
    OpDecorateString = 5632,
    OpMemberDecorateString = 5633,
    OpLoopControlINTEL = 5887,
    OpReadPipeBlockingINTEL = 5946,
    OpWritePipeBlockingINTEL = 5947,
    OpFPGARegINTEL = 5949,
    OpRayQueryGetRayTMinKHR = 6016,
    OpRayQueryGetRayFlagsKHR = 6017,
    OpRayQueryGetIntersectionTKHR = 6018,
    OpRayQueryGetIntersectionInstanceCustomIndexKHR = 6019,
    OpRayQueryGetIntersectionInstanceIdKHR = 6020,
    OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR = 6021,
    OpRayQueryGetIntersectionGeometryIndexKHR = 6022,
    OpRayQueryGetIntersectionPrimitiveIndexKHR = 6023,
    OpRayQueryGetIntersectionBarycentricsKHR = 6024,
    OpRayQueryGetIntersectionFrontFaceKHR = 6025,
    OpRayQueryGetIntersectionCandidateAABBOpaqueKHR = 6026,
    OpRayQueryGetIntersectionObjectRayDirectionKHR = 6027,
    OpRayQueryGetIntersectionObjectRayOriginKHR = 6028,
    OpRayQueryGetWorldRayDirectionKHR = 6029,
    OpRayQueryGetWorldRayOriginKHR = 6030,
    OpRayQueryGetIntersectionObjectToWorldKHR = 6031,
    OpRayQueryGetIntersectionWorldToObjectKHR = 6032,
    OpAtomicFAddEXT = 6035,
    OpTypeBufferSurfaceINTEL = 6086,
    OpTypeStructContinuedINTEL = 6090,
    OpConstantCompositeContinuedINTEL = 6091,
    OpSpecConstantCompositeContinuedINTEL = 6092,

    pub const OpSDotKHR = Opcode.OpSDot;
    pub const OpUDotKHR = Opcode.OpUDot;
    pub const OpSUDotKHR = Opcode.OpSUDot;
    pub const OpSDotAccSatKHR = Opcode.OpSDotAccSat;
    pub const OpUDotAccSatKHR = Opcode.OpUDotAccSat;
    pub const OpSUDotAccSatKHR = Opcode.OpSUDotAccSat;
    pub const OpReportIntersectionNV = Opcode.OpReportIntersectionKHR;
    pub const OpTypeAccelerationStructureNV = Opcode.OpTypeAccelerationStructureKHR;
    pub const OpDemoteToHelperInvocationEXT = Opcode.OpDemoteToHelperInvocation;
    pub const OpDecorateStringGOOGLE = Opcode.OpDecorateString;
    pub const OpMemberDecorateStringGOOGLE = Opcode.OpMemberDecorateString;

    pub fn Operands(comptime self: Opcode) type {
        return switch (self) {
            .OpNop => void,
            .OpUndef => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSourceContinued => struct { continued_source: LiteralString },
            .OpSource => struct { source_language: SourceLanguage, version: LiteralInteger, file: ?IdRef = null, source: ?LiteralString = null },
            .OpSourceExtension => struct { extension: LiteralString },
            .OpName => struct { target: IdRef, name: LiteralString },
            .OpMemberName => struct { type: IdRef, member: LiteralInteger, name: LiteralString },
            .OpString => struct { id_result: IdResult, string: LiteralString },
            .OpLine => struct { file: IdRef, line: LiteralInteger, column: LiteralInteger },
            .OpExtension => struct { name: LiteralString },
            .OpExtInstImport => struct { id_result: IdResult, name: LiteralString },
            .OpExtInst => struct { id_result_type: IdResultType, id_result: IdResult, set: IdRef, instruction: LiteralExtInstInteger, id_ref_4: []const IdRef = &.{} },
            .OpMemoryModel => struct { addressing_model: AddressingModel, memory_model: MemoryModel },
            .OpEntryPoint => struct { execution_model: ExecutionModel, entry_point: IdRef, name: LiteralString, interface: []const IdRef = &.{} },
            .OpExecutionMode => struct { entry_point: IdRef, mode: ExecutionMode.Extended },
            .OpCapability => struct { capability: Capability },
            .OpTypeVoid => struct { id_result: IdResult },
            .OpTypeBool => struct { id_result: IdResult },
            .OpTypeInt => struct { id_result: IdResult, width: LiteralInteger, signedness: LiteralInteger },
            .OpTypeFloat => struct { id_result: IdResult, width: LiteralInteger },
            .OpTypeVector => struct { id_result: IdResult, component_type: IdRef, component_count: LiteralInteger },
            .OpTypeMatrix => struct { id_result: IdResult, column_type: IdRef, column_count: LiteralInteger },
            .OpTypeImage => struct { id_result: IdResult, sampled_type: IdRef, dim: Dim, depth: LiteralInteger, arrayed: LiteralInteger, ms: LiteralInteger, sampled: LiteralInteger, image_format: ImageFormat, access_qualifier: ?AccessQualifier = null },
            .OpTypeSampler => struct { id_result: IdResult },
            .OpTypeSampledImage => struct { id_result: IdResult, image_type: IdRef },
            .OpTypeArray => struct { id_result: IdResult, element_type: IdRef, length: IdRef },
            .OpTypeRuntimeArray => struct { id_result: IdResult, element_type: IdRef },
            .OpTypeStruct => struct { id_result: IdResult, id_ref: []const IdRef = &.{} },
            .OpTypeOpaque => struct { id_result: IdResult, literal_string: LiteralString },
            .OpTypePointer => struct { id_result: IdResult, storage_class: StorageClass, type: IdRef },
            .OpTypeFunction => struct { id_result: IdResult, return_type: IdRef, id_ref_2: []const IdRef = &.{} },
            .OpTypeEvent => struct { id_result: IdResult },
            .OpTypeDeviceEvent => struct { id_result: IdResult },
            .OpTypeReserveId => struct { id_result: IdResult },
            .OpTypeQueue => struct { id_result: IdResult },
            .OpTypePipe => struct { id_result: IdResult, qualifier: AccessQualifier },
            .OpTypeForwardPointer => struct { pointer_type: IdRef, storage_class: StorageClass },
            .OpConstantTrue => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpConstantFalse => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpConstant => struct { id_result_type: IdResultType, id_result: IdResult, value: LiteralContextDependentNumber },
            .OpConstantComposite => struct { id_result_type: IdResultType, id_result: IdResult, constituents: []const IdRef = &.{} },
            .OpConstantSampler => struct { id_result_type: IdResultType, id_result: IdResult, sampler_addressing_mode: SamplerAddressingMode, param: LiteralInteger, sampler_filter_mode: SamplerFilterMode },
            .OpConstantNull => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSpecConstantTrue => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSpecConstantFalse => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSpecConstant => struct { id_result_type: IdResultType, id_result: IdResult, value: LiteralContextDependentNumber },
            .OpSpecConstantComposite => struct { id_result_type: IdResultType, id_result: IdResult, constituents: []const IdRef = &.{} },
            .OpSpecConstantOp => struct { id_result_type: IdResultType, id_result: IdResult, opcode: LiteralSpecConstantOpInteger },
            .OpFunction => struct { id_result_type: IdResultType, id_result: IdResult, function_control: FunctionControl, function_type: IdRef },
            .OpFunctionParameter => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpFunctionEnd => void,
            .OpFunctionCall => struct { id_result_type: IdResultType, id_result: IdResult, function: IdRef, id_ref_3: []const IdRef = &.{} },
            .OpVariable => struct { id_result_type: IdResultType, id_result: IdResult, storage_class: StorageClass, initializer: ?IdRef = null },
            .OpImageTexelPointer => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, sample: IdRef },
            .OpLoad => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpStore => struct { pointer: IdRef, object: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpCopyMemory => struct { target: IdRef, source: IdRef, memory_access_2: ?MemoryAccess.Extended = null, memory_access_3: ?MemoryAccess.Extended = null },
            .OpCopyMemorySized => struct { target: IdRef, source: IdRef, size: IdRef, memory_access_3: ?MemoryAccess.Extended = null, memory_access_4: ?MemoryAccess.Extended = null },
            .OpAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, indexes: []const IdRef = &.{} },
            .OpInBoundsAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, indexes: []const IdRef = &.{} },
            .OpPtrAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, element: IdRef, indexes: []const IdRef = &.{} },
            .OpArrayLength => struct { id_result_type: IdResultType, id_result: IdResult, structure: IdRef, array_member: LiteralInteger },
            .OpGenericPtrMemSemantics => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpInBoundsPtrAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, element: IdRef, indexes: []const IdRef = &.{} },
            .OpDecorate => struct { target: IdRef, decoration: Decoration.Extended },
            .OpMemberDecorate => struct { structure_type: IdRef, member: LiteralInteger, decoration: Decoration.Extended },
            .OpDecorationGroup => struct { id_result: IdResult },
            .OpGroupDecorate => struct { decoration_group: IdRef, targets: []const IdRef = &.{} },
            .OpGroupMemberDecorate => struct { decoration_group: IdRef, targets: []const PairIdRefLiteralInteger = &.{} },
            .OpVectorExtractDynamic => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, index: IdRef },
            .OpVectorInsertDynamic => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, component: IdRef, index: IdRef },
            .OpVectorShuffle => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, components: []const LiteralInteger = &.{} },
            .OpCompositeConstruct => struct { id_result_type: IdResultType, id_result: IdResult, constituents: []const IdRef = &.{} },
            .OpCompositeExtract => struct { id_result_type: IdResultType, id_result: IdResult, composite: IdRef, indexes: []const LiteralInteger = &.{} },
            .OpCompositeInsert => struct { id_result_type: IdResultType, id_result: IdResult, object: IdRef, composite: IdRef, indexes: []const LiteralInteger = &.{} },
            .OpCopyObject => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpTranspose => struct { id_result_type: IdResultType, id_result: IdResult, matrix: IdRef },
            .OpSampledImage => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, sampler: IdRef },
            .OpImageSampleImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSampleDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSampleProjImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleProjExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSampleProjDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleProjDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageFetch => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, component: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageDrefGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageRead => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageWrite => struct { image: IdRef, coordinate: IdRef, texel: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImage => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef },
            .OpImageQueryFormat => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQueryOrder => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQuerySizeLod => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, level_of_detail: IdRef },
            .OpImageQuerySize => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQueryLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef },
            .OpImageQueryLevels => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQuerySamples => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpConvertFToU => struct { id_result_type: IdResultType, id_result: IdResult, float_value: IdRef },
            .OpConvertFToS => struct { id_result_type: IdResultType, id_result: IdResult, float_value: IdRef },
            .OpConvertSToF => struct { id_result_type: IdResultType, id_result: IdResult, signed_value: IdRef },
            .OpConvertUToF => struct { id_result_type: IdResultType, id_result: IdResult, unsigned_value: IdRef },
            .OpUConvert => struct { id_result_type: IdResultType, id_result: IdResult, unsigned_value: IdRef },
            .OpSConvert => struct { id_result_type: IdResultType, id_result: IdResult, signed_value: IdRef },
            .OpFConvert => struct { id_result_type: IdResultType, id_result: IdResult, float_value: IdRef },
            .OpQuantizeToF16 => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef },
            .OpConvertPtrToU => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpSatConvertSToU => struct { id_result_type: IdResultType, id_result: IdResult, signed_value: IdRef },
            .OpSatConvertUToS => struct { id_result_type: IdResultType, id_result: IdResult, unsigned_value: IdRef },
            .OpConvertUToPtr => struct { id_result_type: IdResultType, id_result: IdResult, integer_value: IdRef },
            .OpPtrCastToGeneric => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpGenericCastToPtr => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpGenericCastToPtrExplicit => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, storage: StorageClass },
            .OpBitcast => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpSNegate => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpFNegate => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpIAdd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFAdd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpISub => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFSub => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIMul => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFMul => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUDiv => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSDiv => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFDiv => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUMod => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSRem => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSMod => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFRem => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFMod => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpVectorTimesScalar => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, scalar: IdRef },
            .OpMatrixTimesScalar => struct { id_result_type: IdResultType, id_result: IdResult, matrix: IdRef, scalar: IdRef },
            .OpVectorTimesMatrix => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, matrix: IdRef },
            .OpMatrixTimesVector => struct { id_result_type: IdResultType, id_result: IdResult, matrix: IdRef, vector: IdRef },
            .OpMatrixTimesMatrix => struct { id_result_type: IdResultType, id_result: IdResult, leftmatrix: IdRef, rightmatrix: IdRef },
            .OpOuterProduct => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef },
            .OpDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef },
            .OpIAddCarry => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpISubBorrow => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUMulExtended => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSMulExtended => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpAny => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef },
            .OpAll => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef },
            .OpIsNan => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpIsInf => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpIsFinite => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpIsNormal => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpSignBitSet => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpLessOrGreater => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef, y: IdRef },
            .OpOrdered => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef, y: IdRef },
            .OpUnordered => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef, y: IdRef },
            .OpLogicalEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalOr => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalAnd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalNot => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpSelect => struct { id_result_type: IdResultType, id_result: IdResult, condition: IdRef, object_1: IdRef, object_2: IdRef },
            .OpIEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpINotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpULessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSLessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpULessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSLessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdLessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordLessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdLessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordLessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpShiftRightLogical => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, shift: IdRef },
            .OpShiftRightArithmetic => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, shift: IdRef },
            .OpShiftLeftLogical => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, shift: IdRef },
            .OpBitwiseOr => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpBitwiseXor => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpBitwiseAnd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpNot => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpBitFieldInsert => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, insert: IdRef, offset: IdRef, count: IdRef },
            .OpBitFieldSExtract => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, offset: IdRef, count: IdRef },
            .OpBitFieldUExtract => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, offset: IdRef, count: IdRef },
            .OpBitReverse => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef },
            .OpBitCount => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef },
            .OpDPdx => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdy => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpFwidth => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdxFine => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdyFine => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpFwidthFine => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdxCoarse => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdyCoarse => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpFwidthCoarse => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpEmitVertex => void,
            .OpEndPrimitive => void,
            .OpEmitStreamVertex => struct { stream: IdRef },
            .OpEndStreamPrimitive => struct { stream: IdRef },
            .OpControlBarrier => struct { execution: IdScope, memory: IdScope, semantics: IdMemorySemantics },
            .OpMemoryBarrier => struct { memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicLoad => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicStore => struct { pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicExchange => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicCompareExchange => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, equal: IdMemorySemantics, unequal: IdMemorySemantics, value: IdRef, comparator: IdRef },
            .OpAtomicCompareExchangeWeak => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, equal: IdMemorySemantics, unequal: IdMemorySemantics, value: IdRef, comparator: IdRef },
            .OpAtomicIIncrement => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicIDecrement => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicIAdd => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicISub => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicSMin => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicUMin => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicSMax => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicUMax => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicAnd => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicOr => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicXor => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpPhi => struct { id_result_type: IdResultType, id_result: IdResult, pair_id_ref_id_ref: []const PairIdRefIdRef = &.{} },
            .OpLoopMerge => struct { merge_block: IdRef, continue_target: IdRef, loop_control: LoopControl.Extended },
            .OpSelectionMerge => struct { merge_block: IdRef, selection_control: SelectionControl },
            .OpLabel => struct { id_result: IdResult },
            .OpBranch => struct { target_label: IdRef },
            .OpBranchConditional => struct { condition: IdRef, true_label: IdRef, false_label: IdRef, branch_weights: []const LiteralInteger = &.{} },
            .OpSwitch => struct { selector: IdRef, default: IdRef, target: []const PairLiteralIntegerIdRef = &.{} },
            .OpKill => void,
            .OpReturn => void,
            .OpReturnValue => struct { value: IdRef },
            .OpUnreachable => void,
            .OpLifetimeStart => struct { pointer: IdRef, size: LiteralInteger },
            .OpLifetimeStop => struct { pointer: IdRef, size: LiteralInteger },
            .OpGroupAsyncCopy => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, destination: IdRef, source: IdRef, num_elements: IdRef, stride: IdRef, event: IdRef },
            .OpGroupWaitEvents => struct { execution: IdScope, num_events: IdRef, events_list: IdRef },
            .OpGroupAll => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupAny => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupBroadcast => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, localid: IdRef },
            .OpGroupIAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpReadPipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpWritePipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReservedReadPipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, reserve_id: IdRef, index: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReservedWritePipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, reserve_id: IdRef, index: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReserveReadPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReserveWritePipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpCommitReadPipe => struct { pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpCommitWritePipe => struct { pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpIsValidReserveId => struct { id_result_type: IdResultType, id_result: IdResult, reserve_id: IdRef },
            .OpGetNumPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGetMaxPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupReserveReadPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupReserveWritePipePackets => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupCommitReadPipe => struct { execution: IdScope, pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupCommitWritePipe => struct { execution: IdScope, pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpEnqueueMarker => struct { id_result_type: IdResultType, id_result: IdResult, queue: IdRef, num_events: IdRef, wait_events: IdRef, ret_event: IdRef },
            .OpEnqueueKernel => struct { id_result_type: IdResultType, id_result: IdResult, queue: IdRef, flags: IdRef, nd_range: IdRef, num_events: IdRef, wait_events: IdRef, ret_event: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef, local_size: []const IdRef = &.{} },
            .OpGetKernelNDrangeSubGroupCount => struct { id_result_type: IdResultType, id_result: IdResult, nd_range: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelNDrangeMaxSubGroupSize => struct { id_result_type: IdResultType, id_result: IdResult, nd_range: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelWorkGroupSize => struct { id_result_type: IdResultType, id_result: IdResult, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelPreferredWorkGroupSizeMultiple => struct { id_result_type: IdResultType, id_result: IdResult, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpRetainEvent => struct { event: IdRef },
            .OpReleaseEvent => struct { event: IdRef },
            .OpCreateUserEvent => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpIsValidEvent => struct { id_result_type: IdResultType, id_result: IdResult, event: IdRef },
            .OpSetUserEventStatus => struct { event: IdRef, status: IdRef },
            .OpCaptureEventProfilingInfo => struct { event: IdRef, profiling_info: IdRef, value: IdRef },
            .OpGetDefaultQueue => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpBuildNDRange => struct { id_result_type: IdResultType, id_result: IdResult, globalworksize: IdRef, localworksize: IdRef, globalworkoffset: IdRef },
            .OpImageSparseSampleImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleProjImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleProjExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleProjDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleProjDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseFetch => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, component: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseDrefGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseTexelsResident => struct { id_result_type: IdResultType, id_result: IdResult, resident_code: IdRef },
            .OpNoLine => void,
            .OpAtomicFlagTestAndSet => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicFlagClear => struct { pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpImageSparseRead => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpSizeOf => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpTypePipeStorage => struct { id_result: IdResult },
            .OpConstantPipeStorage => struct { id_result_type: IdResultType, id_result: IdResult, packet_size: LiteralInteger, packet_alignment: LiteralInteger, capacity: LiteralInteger },
            .OpCreatePipeFromPipeStorage => struct { id_result_type: IdResultType, id_result: IdResult, pipe_storage: IdRef },
            .OpGetKernelLocalSizeForSubgroupCount => struct { id_result_type: IdResultType, id_result: IdResult, subgroup_count: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelMaxNumSubgroups => struct { id_result_type: IdResultType, id_result: IdResult, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpTypeNamedBarrier => struct { id_result: IdResult },
            .OpNamedBarrierInitialize => struct { id_result_type: IdResultType, id_result: IdResult, subgroup_count: IdRef },
            .OpMemoryNamedBarrier => struct { named_barrier: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpModuleProcessed => struct { process: LiteralString },
            .OpExecutionModeId => struct { entry_point: IdRef, mode: ExecutionMode.Extended },
            .OpDecorateId => struct { target: IdRef, decoration: Decoration.Extended },
            .OpGroupNonUniformElect => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope },
            .OpGroupNonUniformAll => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupNonUniformAny => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupNonUniformAllEqual => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBroadcast => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, id: IdRef },
            .OpGroupNonUniformBroadcastFirst => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBallot => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupNonUniformInverseBallot => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBallotBitExtract => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, index: IdRef },
            .OpGroupNonUniformBallotBitCount => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef },
            .OpGroupNonUniformBallotFindLSB => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBallotFindMSB => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformShuffle => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, id: IdRef },
            .OpGroupNonUniformShuffleXor => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, mask: IdRef },
            .OpGroupNonUniformShuffleUp => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, delta: IdRef },
            .OpGroupNonUniformShuffleDown => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, delta: IdRef },
            .OpGroupNonUniformIAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformIMul => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFMul => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformSMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformUMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformSMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformUMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformBitwiseAnd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformBitwiseOr => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformBitwiseXor => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformLogicalAnd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformLogicalOr => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformLogicalXor => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformQuadBroadcast => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, index: IdRef },
            .OpGroupNonUniformQuadSwap => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, direction: IdRef },
            .OpCopyLogical => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpPtrEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpPtrNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpPtrDiff => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpTerminateInvocation => void,
            .OpSubgroupBallotKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpSubgroupFirstInvocationKHR => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef },
            .OpSubgroupAllKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpSubgroupAnyKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpSubgroupAllEqualKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpSubgroupReadInvocationKHR => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef, index: IdRef },
            .OpTraceRayKHR => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, payload: IdRef },
            .OpExecuteCallableKHR => struct { sbt_index: IdRef, callable_data: IdRef },
            .OpConvertUToAccelerationStructureKHR => struct { id_result_type: IdResultType, id_result: IdResult, accel: IdRef },
            .OpIgnoreIntersectionKHR => void,
            .OpTerminateRayKHR => void,
            .OpSDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpUDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpSUDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpSDotAccSat => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, accumulator: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpUDotAccSat => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, accumulator: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpSUDotAccSat => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, accumulator: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpTypeRayQueryKHR => struct { id_result: IdResult },
            .OpRayQueryInitializeKHR => struct { rayquery: IdRef, accel: IdRef, rayflags: IdRef, cullmask: IdRef, rayorigin: IdRef, raytmin: IdRef, raydirection: IdRef, raytmax: IdRef },
            .OpRayQueryTerminateKHR => struct { rayquery: IdRef },
            .OpRayQueryGenerateIntersectionKHR => struct { rayquery: IdRef, hitt: IdRef },
            .OpRayQueryConfirmIntersectionKHR => struct { rayquery: IdRef },
            .OpRayQueryProceedKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionTypeKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpGroupIAddNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFAddNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMinNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMinNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMinNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMaxNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMaxNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMaxNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpFragmentMaskFetchAMD => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef },
            .OpFragmentFetchAMD => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, fragment_index: IdRef },
            .OpReadClockKHR => struct { id_result_type: IdResultType, id_result: IdResult, scope: IdScope },
            .OpImageSampleFootprintNV => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, granularity: IdRef, coarse: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpGroupNonUniformPartitionNV => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef },
            .OpWritePackedPrimitiveIndices4x8NV => struct { index_offset: IdRef, packed_indices: IdRef },
            .OpReportIntersectionKHR => struct { id_result_type: IdResultType, id_result: IdResult, hit: IdRef, hitkind: IdRef },
            .OpIgnoreIntersectionNV => void,
            .OpTerminateRayNV => void,
            .OpTraceNV => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, payloadid: IdRef },
            .OpTraceMotionNV => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, time: IdRef, payloadid: IdRef },
            .OpTraceRayMotionNV => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, time: IdRef, payload: IdRef },
            .OpTypeAccelerationStructureKHR => struct { id_result: IdResult },
            .OpExecuteCallableNV => struct { sbt_index: IdRef, callable_dataid: IdRef },
            .OpTypeCooperativeMatrixNV => struct { id_result: IdResult, component_type: IdRef, execution: IdScope, rows: IdRef, columns: IdRef },
            .OpCooperativeMatrixLoadNV => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, stride: IdRef, column_major: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixStoreNV => struct { pointer: IdRef, object: IdRef, stride: IdRef, column_major: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixMulAddNV => struct { id_result_type: IdResultType, id_result: IdResult, a: IdRef, b: IdRef, c: IdRef },
            .OpCooperativeMatrixLengthNV => struct { id_result_type: IdResultType, id_result: IdResult, type: IdRef },
            .OpBeginInvocationInterlockEXT => void,
            .OpEndInvocationInterlockEXT => void,
            .OpDemoteToHelperInvocation => void,
            .OpIsHelperInvocationEXT => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpConvertUToImageNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertUToSamplerNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertImageToUNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertSamplerToUNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertUToSampledImageNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertSampledImageToUNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpSamplerImageAddressingModeNV => struct { bit_width: LiteralInteger },
            .OpSubgroupShuffleINTEL => struct { id_result_type: IdResultType, id_result: IdResult, data: IdRef, invocationid: IdRef },
            .OpSubgroupShuffleDownINTEL => struct { id_result_type: IdResultType, id_result: IdResult, current: IdRef, next: IdRef, delta: IdRef },
            .OpSubgroupShuffleUpINTEL => struct { id_result_type: IdResultType, id_result: IdResult, previous: IdRef, current: IdRef, delta: IdRef },
            .OpSubgroupShuffleXorINTEL => struct { id_result_type: IdResultType, id_result: IdResult, data: IdRef, value: IdRef },
            .OpSubgroupBlockReadINTEL => struct { id_result_type: IdResultType, id_result: IdResult, ptr: IdRef },
            .OpSubgroupBlockWriteINTEL => struct { ptr: IdRef, data: IdRef },
            .OpSubgroupImageBlockReadINTEL => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef },
            .OpSubgroupImageBlockWriteINTEL => struct { image: IdRef, coordinate: IdRef, data: IdRef },
            .OpSubgroupImageMediaBlockReadINTEL => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, width: IdRef, height: IdRef },
            .OpSubgroupImageMediaBlockWriteINTEL => struct { image: IdRef, coordinate: IdRef, width: IdRef, height: IdRef, data: IdRef },
            .OpUCountLeadingZerosINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpUCountTrailingZerosINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpAbsISubINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpAbsUSubINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIAddSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUAddSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIAverageINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUAverageINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIAverageRoundedINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUAverageRoundedINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpISubSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUSubSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIMul32x16INTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUMul32x16INTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpAtomicFMinEXT => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicFMaxEXT => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAssumeTrueKHR => struct { condition: IdRef },
            .OpExpectKHR => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef, expectedvalue: IdRef },
            .OpDecorateString => struct { target: IdRef, decoration: Decoration.Extended },
            .OpMemberDecorateString => struct { struct_type: IdRef, member: LiteralInteger, decoration: Decoration.Extended },
            .OpLoopControlINTEL => struct { loop_control_parameters: []const LiteralInteger = &.{} },
            .OpReadPipeBlockingINTEL => struct { id_result_type: IdResultType, id_result: IdResult, packet_size: IdRef, packet_alignment: IdRef },
            .OpWritePipeBlockingINTEL => struct { id_result_type: IdResultType, id_result: IdResult, packet_size: IdRef, packet_alignment: IdRef },
            .OpFPGARegINTEL => struct { id_result_type: IdResultType, id_result: IdResult, result: IdRef, input: IdRef },
            .OpRayQueryGetRayTMinKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetRayFlagsKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionTKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionInstanceCustomIndexKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionInstanceIdKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionGeometryIndexKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionPrimitiveIndexKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionBarycentricsKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionFrontFaceKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionCandidateAABBOpaqueKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionObjectRayDirectionKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionObjectRayOriginKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetWorldRayDirectionKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetWorldRayOriginKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionObjectToWorldKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionWorldToObjectKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpAtomicFAddEXT => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpTypeBufferSurfaceINTEL => struct { id_result: IdResult, accessqualifier: AccessQualifier },
            .OpTypeStructContinuedINTEL => struct { id_ref: []const IdRef = &.{} },
            .OpConstantCompositeContinuedINTEL => struct { constituents: []const IdRef = &.{} },
            .OpSpecConstantCompositeContinuedINTEL => struct { constituents: []const IdRef = &.{} },
        };
    }
    pub fn operands(self: Opcode) []const Operand {
        return switch (self) {
            .OpNop => &[_]Operand{},
            .OpUndef => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpSourceContinued => &[_]Operand{
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpSource => &[_]Operand{
                .{ .kind = .SourceLanguage, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
                .{ .kind = .LiteralString, .quantifier = .optional },
            },
            .OpSourceExtension => &[_]Operand{
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpName => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpMemberName => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpString => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpLine => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpExtension => &[_]Operand{
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpExtInstImport => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpExtInst => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralExtInstInteger, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpMemoryModel => &[_]Operand{
                .{ .kind = .AddressingModel, .quantifier = .required },
                .{ .kind = .MemoryModel, .quantifier = .required },
            },
            .OpEntryPoint => &[_]Operand{
                .{ .kind = .ExecutionModel, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralString, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpExecutionMode => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ExecutionMode, .quantifier = .required },
            },
            .OpCapability => &[_]Operand{
                .{ .kind = .Capability, .quantifier = .required },
            },
            .OpTypeVoid => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpTypeBool => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpTypeInt => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpTypeFloat => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpTypeVector => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpTypeMatrix => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpTypeImage => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .Dim, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .ImageFormat, .quantifier = .required },
                .{ .kind = .AccessQualifier, .quantifier = .optional },
            },
            .OpTypeSampler => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpTypeSampledImage => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeArray => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeRuntimeArray => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeStruct => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpTypeOpaque => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpTypePointer => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .StorageClass, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeFunction => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpTypeEvent => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpTypeDeviceEvent => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpTypeReserveId => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpTypeQueue => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpTypePipe => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .AccessQualifier, .quantifier = .required },
            },
            .OpTypeForwardPointer => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .StorageClass, .quantifier = .required },
            },
            .OpConstantTrue => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpConstantFalse => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpConstant => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralContextDependentNumber, .quantifier = .required },
            },
            .OpConstantComposite => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpConstantSampler => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .SamplerAddressingMode, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .SamplerFilterMode, .quantifier = .required },
            },
            .OpConstantNull => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpSpecConstantTrue => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpSpecConstantFalse => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpSpecConstant => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralContextDependentNumber, .quantifier = .required },
            },
            .OpSpecConstantComposite => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpSpecConstantOp => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralSpecConstantOpInteger, .quantifier = .required },
            },
            .OpFunction => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .FunctionControl, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFunctionParameter => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpFunctionEnd => &[_]Operand{},
            .OpFunctionCall => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpVariable => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .StorageClass, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpImageTexelPointer => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpLoad => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
            },
            .OpStore => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
            },
            .OpCopyMemory => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
            },
            .OpCopyMemorySized => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
            },
            .OpAccessChain => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpInBoundsAccessChain => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpPtrAccessChain => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpArrayLength => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpGenericPtrMemSemantics => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpInBoundsPtrAccessChain => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpDecorate => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .Decoration, .quantifier = .required },
            },
            .OpMemberDecorate => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .Decoration, .quantifier = .required },
            },
            .OpDecorationGroup => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpGroupDecorate => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpGroupMemberDecorate => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PairIdRefLiteralInteger, .quantifier = .variadic },
            },
            .OpVectorExtractDynamic => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpVectorInsertDynamic => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpVectorShuffle => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .variadic },
            },
            .OpCompositeConstruct => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpCompositeExtract => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .variadic },
            },
            .OpCompositeInsert => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .variadic },
            },
            .OpCopyObject => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTranspose => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSampledImage => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageSampleImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSampleExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageSampleDrefImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSampleDrefExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageSampleProjImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSampleProjExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageSampleProjDrefImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSampleProjDrefExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageFetch => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageGather => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageDrefGather => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageRead => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageWrite => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImage => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageQueryFormat => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageQueryOrder => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageQuerySizeLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageQuerySize => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageQueryLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageQueryLevels => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageQuerySamples => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertFToU => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertFToS => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertSToF => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertUToF => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUConvert => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSConvert => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFConvert => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpQuantizeToF16 => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertPtrToU => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSatConvertSToU => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSatConvertUToS => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertUToPtr => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpPtrCastToGeneric => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGenericCastToPtr => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGenericCastToPtrExplicit => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .StorageClass, .quantifier = .required },
            },
            .OpBitcast => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSNegate => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFNegate => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIAdd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFAdd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpISub => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFSub => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIMul => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFMul => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUDiv => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSDiv => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFDiv => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUMod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSRem => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSMod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFRem => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFMod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpVectorTimesScalar => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpMatrixTimesScalar => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpVectorTimesMatrix => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpMatrixTimesVector => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpMatrixTimesMatrix => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpOuterProduct => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIAddCarry => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpISubBorrow => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUMulExtended => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSMulExtended => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAny => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAll => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIsNan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIsInf => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIsFinite => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIsNormal => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSignBitSet => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpLessOrGreater => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpOrdered => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUnordered => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpLogicalEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpLogicalNotEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpLogicalOr => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpLogicalAnd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpLogicalNot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSelect => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpINotEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUGreaterThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSGreaterThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUGreaterThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSGreaterThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpULessThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSLessThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpULessThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSLessThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFOrdEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFUnordEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFOrdNotEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFUnordNotEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFOrdLessThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFUnordLessThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFOrdGreaterThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFUnordGreaterThan => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFOrdLessThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFUnordLessThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFOrdGreaterThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFUnordGreaterThanEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpShiftRightLogical => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpShiftRightArithmetic => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpShiftLeftLogical => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitwiseOr => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitwiseXor => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitwiseAnd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpNot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitFieldInsert => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitFieldSExtract => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitFieldUExtract => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitReverse => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBitCount => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDPdx => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDPdy => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFwidth => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDPdxFine => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDPdyFine => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFwidthFine => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDPdxCoarse => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDPdyCoarse => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFwidthCoarse => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpEmitVertex => &[_]Operand{},
            .OpEndPrimitive => &[_]Operand{},
            .OpEmitStreamVertex => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpEndStreamPrimitive => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpControlBarrier => &[_]Operand{
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpMemoryBarrier => &[_]Operand{
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpAtomicLoad => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpAtomicStore => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicExchange => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicCompareExchange => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicCompareExchangeWeak => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicIIncrement => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpAtomicIDecrement => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpAtomicIAdd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicISub => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicSMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicUMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicSMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicUMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicAnd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicOr => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicXor => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpPhi => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .PairIdRefIdRef, .quantifier = .variadic },
            },
            .OpLoopMerge => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LoopControl, .quantifier = .required },
            },
            .OpSelectionMerge => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .SelectionControl, .quantifier = .required },
            },
            .OpLabel => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpBranch => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBranchConditional => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .variadic },
            },
            .OpSwitch => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PairLiteralIntegerIdRef, .quantifier = .variadic },
            },
            .OpKill => &[_]Operand{},
            .OpReturn => &[_]Operand{},
            .OpReturnValue => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUnreachable => &[_]Operand{},
            .OpLifetimeStart => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpLifetimeStop => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpGroupAsyncCopy => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupWaitEvents => &[_]Operand{
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupAll => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupAny => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupBroadcast => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupIAdd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupFAdd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupFMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupUMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupSMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupFMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupUMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupSMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReadPipe => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpWritePipe => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReservedReadPipe => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReservedWritePipe => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReserveReadPipePackets => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReserveWritePipePackets => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpCommitReadPipe => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpCommitWritePipe => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIsValidReserveId => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetNumPipePackets => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetMaxPipePackets => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupReserveReadPipePackets => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupReserveWritePipePackets => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupCommitReadPipe => &[_]Operand{
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupCommitWritePipe => &[_]Operand{
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpEnqueueMarker => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpEnqueueKernel => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpGetKernelNDrangeSubGroupCount => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetKernelNDrangeMaxSubGroupSize => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetKernelWorkGroupSize => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetKernelPreferredWorkGroupSizeMultiple => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRetainEvent => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReleaseEvent => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpCreateUserEvent => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpIsValidEvent => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSetUserEventStatus => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpCaptureEventProfilingInfo => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetDefaultQueue => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpBuildNDRange => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpImageSparseSampleImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSparseSampleExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageSparseSampleDrefImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSparseSampleDrefExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageSparseSampleProjImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSparseSampleProjExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageSparseSampleProjDrefImplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSparseSampleProjDrefExplicitLod => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .required },
            },
            .OpImageSparseFetch => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSparseGather => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSparseDrefGather => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpImageSparseTexelsResident => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpNoLine => &[_]Operand{},
            .OpAtomicFlagTestAndSet => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpAtomicFlagClear => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpImageSparseRead => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpSizeOf => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypePipeStorage => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpConstantPipeStorage => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpCreatePipeFromPipeStorage => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetKernelLocalSizeForSubgroupCount => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGetKernelMaxNumSubgroups => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeNamedBarrier => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpNamedBarrierInitialize => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpMemoryNamedBarrier => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
            },
            .OpModuleProcessed => &[_]Operand{
                .{ .kind = .LiteralString, .quantifier = .required },
            },
            .OpExecutionModeId => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ExecutionMode, .quantifier = .required },
            },
            .OpDecorateId => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .Decoration, .quantifier = .required },
            },
            .OpGroupNonUniformElect => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
            },
            .OpGroupNonUniformAll => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformAny => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformAllEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformBroadcast => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformBroadcastFirst => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformBallot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformInverseBallot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformBallotBitExtract => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformBallotBitCount => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformBallotFindLSB => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformBallotFindMSB => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformShuffle => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformShuffleXor => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformShuffleUp => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformShuffleDown => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformIAdd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformFAdd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformIMul => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformFMul => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformSMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformUMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformFMin => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformSMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformUMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformFMax => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformBitwiseAnd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformBitwiseOr => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformBitwiseXor => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformLogicalAnd => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformLogicalOr => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformLogicalXor => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .optional },
            },
            .OpGroupNonUniformQuadBroadcast => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupNonUniformQuadSwap => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpCopyLogical => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpPtrEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpPtrNotEqual => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpPtrDiff => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTerminateInvocation => &[_]Operand{},
            .OpSubgroupBallotKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupFirstInvocationKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupAllKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupAnyKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupAllEqualKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupReadInvocationKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTraceRayKHR => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpExecuteCallableKHR => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertUToAccelerationStructureKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIgnoreIntersectionKHR => &[_]Operand{},
            .OpTerminateRayKHR => &[_]Operand{},
            .OpSDot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PackedVectorFormat, .quantifier = .optional },
            },
            .OpUDot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PackedVectorFormat, .quantifier = .optional },
            },
            .OpSUDot => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PackedVectorFormat, .quantifier = .optional },
            },
            .OpSDotAccSat => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PackedVectorFormat, .quantifier = .optional },
            },
            .OpUDotAccSat => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PackedVectorFormat, .quantifier = .optional },
            },
            .OpSUDotAccSat => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .PackedVectorFormat, .quantifier = .optional },
            },
            .OpTypeRayQueryKHR => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpRayQueryInitializeKHR => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryTerminateKHR => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGenerateIntersectionKHR => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryConfirmIntersectionKHR => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryProceedKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionTypeKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupIAddNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupFAddNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupFMinNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupUMinNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupSMinNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupFMaxNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupUMaxNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpGroupSMaxNonUniformAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .GroupOperation, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFragmentMaskFetchAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFragmentFetchAMD => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReadClockKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
            },
            .OpImageSampleFootprintNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .ImageOperands, .quantifier = .optional },
            },
            .OpGroupNonUniformPartitionNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpWritePackedPrimitiveIndices4x8NV => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpReportIntersectionKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIgnoreIntersectionNV => &[_]Operand{},
            .OpTerminateRayNV => &[_]Operand{},
            .OpTraceNV => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTraceMotionNV => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTraceRayMotionNV => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeAccelerationStructureKHR => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpExecuteCallableNV => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeCooperativeMatrixNV => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpCooperativeMatrixLoadNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
            },
            .OpCooperativeMatrixStoreNV => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .MemoryAccess, .quantifier = .optional },
            },
            .OpCooperativeMatrixMulAddNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpCooperativeMatrixLengthNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpBeginInvocationInterlockEXT => &[_]Operand{},
            .OpEndInvocationInterlockEXT => &[_]Operand{},
            .OpDemoteToHelperInvocation => &[_]Operand{},
            .OpIsHelperInvocationEXT => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
            },
            .OpConvertUToImageNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertUToSamplerNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertImageToUNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertSamplerToUNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertUToSampledImageNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpConvertSampledImageToUNV => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSamplerImageAddressingModeNV => &[_]Operand{
                .{ .kind = .LiteralInteger, .quantifier = .required },
            },
            .OpSubgroupShuffleINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupShuffleDownINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupShuffleUpINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupShuffleXorINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupBlockReadINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupBlockWriteINTEL => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupImageBlockReadINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupImageBlockWriteINTEL => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupImageMediaBlockReadINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpSubgroupImageMediaBlockWriteINTEL => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUCountLeadingZerosINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUCountTrailingZerosINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAbsISubINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAbsUSubINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIAddSatINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUAddSatINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIAverageINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUAverageINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIAverageRoundedINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUAverageRoundedINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpISubSatINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUSubSatINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpIMul32x16INTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpUMul32x16INTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicFMinEXT => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicFMaxEXT => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAssumeTrueKHR => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpExpectKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpDecorateString => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .Decoration, .quantifier = .required },
            },
            .OpMemberDecorateString => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .LiteralInteger, .quantifier = .required },
                .{ .kind = .Decoration, .quantifier = .required },
            },
            .OpLoopControlINTEL => &[_]Operand{
                .{ .kind = .LiteralInteger, .quantifier = .variadic },
            },
            .OpReadPipeBlockingINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpWritePipeBlockingINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpFPGARegINTEL => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetRayTMinKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetRayFlagsKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionTKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionInstanceCustomIndexKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionInstanceIdKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionGeometryIndexKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionPrimitiveIndexKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionBarycentricsKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionFrontFaceKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionCandidateAABBOpaqueKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionObjectRayDirectionKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionObjectRayOriginKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetWorldRayDirectionKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetWorldRayOriginKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionObjectToWorldKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpRayQueryGetIntersectionWorldToObjectKHR => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpAtomicFAddEXT => &[_]Operand{
                .{ .kind = .IdResultType, .quantifier = .required },
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
                .{ .kind = .IdScope, .quantifier = .required },
                .{ .kind = .IdMemorySemantics, .quantifier = .required },
                .{ .kind = .IdRef, .quantifier = .required },
            },
            .OpTypeBufferSurfaceINTEL => &[_]Operand{
                .{ .kind = .IdResult, .quantifier = .required },
                .{ .kind = .AccessQualifier, .quantifier = .required },
            },
            .OpTypeStructContinuedINTEL => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpConstantCompositeContinuedINTEL => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
            .OpSpecConstantCompositeContinuedINTEL => &[_]Operand{
                .{ .kind = .IdRef, .quantifier = .variadic },
            },
        };
    }
    pub fn class(self: Opcode) Class {
        return switch (self) {
            .OpNop => .Miscellaneous,
            .OpUndef => .Miscellaneous,
            .OpSourceContinued => .Debug,
            .OpSource => .Debug,
            .OpSourceExtension => .Debug,
            .OpName => .Debug,
            .OpMemberName => .Debug,
            .OpString => .Debug,
            .OpLine => .Debug,
            .OpExtension => .Extension,
            .OpExtInstImport => .Extension,
            .OpExtInst => .Extension,
            .OpMemoryModel => .ModeSetting,
            .OpEntryPoint => .ModeSetting,
            .OpExecutionMode => .ModeSetting,
            .OpCapability => .ModeSetting,
            .OpTypeVoid => .TypeDeclaration,
            .OpTypeBool => .TypeDeclaration,
            .OpTypeInt => .TypeDeclaration,
            .OpTypeFloat => .TypeDeclaration,
            .OpTypeVector => .TypeDeclaration,
            .OpTypeMatrix => .TypeDeclaration,
            .OpTypeImage => .TypeDeclaration,
            .OpTypeSampler => .TypeDeclaration,
            .OpTypeSampledImage => .TypeDeclaration,
            .OpTypeArray => .TypeDeclaration,
            .OpTypeRuntimeArray => .TypeDeclaration,
            .OpTypeStruct => .TypeDeclaration,
            .OpTypeOpaque => .TypeDeclaration,
            .OpTypePointer => .TypeDeclaration,
            .OpTypeFunction => .TypeDeclaration,
            .OpTypeEvent => .TypeDeclaration,
            .OpTypeDeviceEvent => .TypeDeclaration,
            .OpTypeReserveId => .TypeDeclaration,
            .OpTypeQueue => .TypeDeclaration,
            .OpTypePipe => .TypeDeclaration,
            .OpTypeForwardPointer => .TypeDeclaration,
            .OpConstantTrue => .ConstantCreation,
            .OpConstantFalse => .ConstantCreation,
            .OpConstant => .ConstantCreation,
            .OpConstantComposite => .ConstantCreation,
            .OpConstantSampler => .ConstantCreation,
            .OpConstantNull => .ConstantCreation,
            .OpSpecConstantTrue => .ConstantCreation,
            .OpSpecConstantFalse => .ConstantCreation,
            .OpSpecConstant => .ConstantCreation,
            .OpSpecConstantComposite => .ConstantCreation,
            .OpSpecConstantOp => .ConstantCreation,
            .OpFunction => .Function,
            .OpFunctionParameter => .Function,
            .OpFunctionEnd => .Function,
            .OpFunctionCall => .Function,
            .OpVariable => .Memory,
            .OpImageTexelPointer => .Memory,
            .OpLoad => .Memory,
            .OpStore => .Memory,
            .OpCopyMemory => .Memory,
            .OpCopyMemorySized => .Memory,
            .OpAccessChain => .Memory,
            .OpInBoundsAccessChain => .Memory,
            .OpPtrAccessChain => .Memory,
            .OpArrayLength => .Memory,
            .OpGenericPtrMemSemantics => .Memory,
            .OpInBoundsPtrAccessChain => .Memory,
            .OpDecorate => .Annotation,
            .OpMemberDecorate => .Annotation,
            .OpDecorationGroup => .Annotation,
            .OpGroupDecorate => .Annotation,
            .OpGroupMemberDecorate => .Annotation,
            .OpVectorExtractDynamic => .Composite,
            .OpVectorInsertDynamic => .Composite,
            .OpVectorShuffle => .Composite,
            .OpCompositeConstruct => .Composite,
            .OpCompositeExtract => .Composite,
            .OpCompositeInsert => .Composite,
            .OpCopyObject => .Composite,
            .OpTranspose => .Composite,
            .OpSampledImage => .Image,
            .OpImageSampleImplicitLod => .Image,
            .OpImageSampleExplicitLod => .Image,
            .OpImageSampleDrefImplicitLod => .Image,
            .OpImageSampleDrefExplicitLod => .Image,
            .OpImageSampleProjImplicitLod => .Image,
            .OpImageSampleProjExplicitLod => .Image,
            .OpImageSampleProjDrefImplicitLod => .Image,
            .OpImageSampleProjDrefExplicitLod => .Image,
            .OpImageFetch => .Image,
            .OpImageGather => .Image,
            .OpImageDrefGather => .Image,
            .OpImageRead => .Image,
            .OpImageWrite => .Image,
            .OpImage => .Image,
            .OpImageQueryFormat => .Image,
            .OpImageQueryOrder => .Image,
            .OpImageQuerySizeLod => .Image,
            .OpImageQuerySize => .Image,
            .OpImageQueryLod => .Image,
            .OpImageQueryLevels => .Image,
            .OpImageQuerySamples => .Image,
            .OpConvertFToU => .Conversion,
            .OpConvertFToS => .Conversion,
            .OpConvertSToF => .Conversion,
            .OpConvertUToF => .Conversion,
            .OpUConvert => .Conversion,
            .OpSConvert => .Conversion,
            .OpFConvert => .Conversion,
            .OpQuantizeToF16 => .Conversion,
            .OpConvertPtrToU => .Conversion,
            .OpSatConvertSToU => .Conversion,
            .OpSatConvertUToS => .Conversion,
            .OpConvertUToPtr => .Conversion,
            .OpPtrCastToGeneric => .Conversion,
            .OpGenericCastToPtr => .Conversion,
            .OpGenericCastToPtrExplicit => .Conversion,
            .OpBitcast => .Conversion,
            .OpSNegate => .Arithmetic,
            .OpFNegate => .Arithmetic,
            .OpIAdd => .Arithmetic,
            .OpFAdd => .Arithmetic,
            .OpISub => .Arithmetic,
            .OpFSub => .Arithmetic,
            .OpIMul => .Arithmetic,
            .OpFMul => .Arithmetic,
            .OpUDiv => .Arithmetic,
            .OpSDiv => .Arithmetic,
            .OpFDiv => .Arithmetic,
            .OpUMod => .Arithmetic,
            .OpSRem => .Arithmetic,
            .OpSMod => .Arithmetic,
            .OpFRem => .Arithmetic,
            .OpFMod => .Arithmetic,
            .OpVectorTimesScalar => .Arithmetic,
            .OpMatrixTimesScalar => .Arithmetic,
            .OpVectorTimesMatrix => .Arithmetic,
            .OpMatrixTimesVector => .Arithmetic,
            .OpMatrixTimesMatrix => .Arithmetic,
            .OpOuterProduct => .Arithmetic,
            .OpDot => .Arithmetic,
            .OpIAddCarry => .Arithmetic,
            .OpISubBorrow => .Arithmetic,
            .OpUMulExtended => .Arithmetic,
            .OpSMulExtended => .Arithmetic,
            .OpAny => .RelationalAndLogical,
            .OpAll => .RelationalAndLogical,
            .OpIsNan => .RelationalAndLogical,
            .OpIsInf => .RelationalAndLogical,
            .OpIsFinite => .RelationalAndLogical,
            .OpIsNormal => .RelationalAndLogical,
            .OpSignBitSet => .RelationalAndLogical,
            .OpLessOrGreater => .RelationalAndLogical,
            .OpOrdered => .RelationalAndLogical,
            .OpUnordered => .RelationalAndLogical,
            .OpLogicalEqual => .RelationalAndLogical,
            .OpLogicalNotEqual => .RelationalAndLogical,
            .OpLogicalOr => .RelationalAndLogical,
            .OpLogicalAnd => .RelationalAndLogical,
            .OpLogicalNot => .RelationalAndLogical,
            .OpSelect => .RelationalAndLogical,
            .OpIEqual => .RelationalAndLogical,
            .OpINotEqual => .RelationalAndLogical,
            .OpUGreaterThan => .RelationalAndLogical,
            .OpSGreaterThan => .RelationalAndLogical,
            .OpUGreaterThanEqual => .RelationalAndLogical,
            .OpSGreaterThanEqual => .RelationalAndLogical,
            .OpULessThan => .RelationalAndLogical,
            .OpSLessThan => .RelationalAndLogical,
            .OpULessThanEqual => .RelationalAndLogical,
            .OpSLessThanEqual => .RelationalAndLogical,
            .OpFOrdEqual => .RelationalAndLogical,
            .OpFUnordEqual => .RelationalAndLogical,
            .OpFOrdNotEqual => .RelationalAndLogical,
            .OpFUnordNotEqual => .RelationalAndLogical,
            .OpFOrdLessThan => .RelationalAndLogical,
            .OpFUnordLessThan => .RelationalAndLogical,
            .OpFOrdGreaterThan => .RelationalAndLogical,
            .OpFUnordGreaterThan => .RelationalAndLogical,
            .OpFOrdLessThanEqual => .RelationalAndLogical,
            .OpFUnordLessThanEqual => .RelationalAndLogical,
            .OpFOrdGreaterThanEqual => .RelationalAndLogical,
            .OpFUnordGreaterThanEqual => .RelationalAndLogical,
            .OpShiftRightLogical => .Bit,
            .OpShiftRightArithmetic => .Bit,
            .OpShiftLeftLogical => .Bit,
            .OpBitwiseOr => .Bit,
            .OpBitwiseXor => .Bit,
            .OpBitwiseAnd => .Bit,
            .OpNot => .Bit,
            .OpBitFieldInsert => .Bit,
            .OpBitFieldSExtract => .Bit,
            .OpBitFieldUExtract => .Bit,
            .OpBitReverse => .Bit,
            .OpBitCount => .Bit,
            .OpDPdx => .Derivative,
            .OpDPdy => .Derivative,
            .OpFwidth => .Derivative,
            .OpDPdxFine => .Derivative,
            .OpDPdyFine => .Derivative,
            .OpFwidthFine => .Derivative,
            .OpDPdxCoarse => .Derivative,
            .OpDPdyCoarse => .Derivative,
            .OpFwidthCoarse => .Derivative,
            .OpEmitVertex => .Primitive,
            .OpEndPrimitive => .Primitive,
            .OpEmitStreamVertex => .Primitive,
            .OpEndStreamPrimitive => .Primitive,
            .OpControlBarrier => .Barrier,
            .OpMemoryBarrier => .Barrier,
            .OpAtomicLoad => .Atomic,
            .OpAtomicStore => .Atomic,
            .OpAtomicExchange => .Atomic,
            .OpAtomicCompareExchange => .Atomic,
            .OpAtomicCompareExchangeWeak => .Atomic,
            .OpAtomicIIncrement => .Atomic,
            .OpAtomicIDecrement => .Atomic,
            .OpAtomicIAdd => .Atomic,
            .OpAtomicISub => .Atomic,
            .OpAtomicSMin => .Atomic,
            .OpAtomicUMin => .Atomic,
            .OpAtomicSMax => .Atomic,
            .OpAtomicUMax => .Atomic,
            .OpAtomicAnd => .Atomic,
            .OpAtomicOr => .Atomic,
            .OpAtomicXor => .Atomic,
            .OpPhi => .ControlFlow,
            .OpLoopMerge => .ControlFlow,
            .OpSelectionMerge => .ControlFlow,
            .OpLabel => .ControlFlow,
            .OpBranch => .ControlFlow,
            .OpBranchConditional => .ControlFlow,
            .OpSwitch => .ControlFlow,
            .OpKill => .ControlFlow,
            .OpReturn => .ControlFlow,
            .OpReturnValue => .ControlFlow,
            .OpUnreachable => .ControlFlow,
            .OpLifetimeStart => .ControlFlow,
            .OpLifetimeStop => .ControlFlow,
            .OpGroupAsyncCopy => .Group,
            .OpGroupWaitEvents => .Group,
            .OpGroupAll => .Group,
            .OpGroupAny => .Group,
            .OpGroupBroadcast => .Group,
            .OpGroupIAdd => .Group,
            .OpGroupFAdd => .Group,
            .OpGroupFMin => .Group,
            .OpGroupUMin => .Group,
            .OpGroupSMin => .Group,
            .OpGroupFMax => .Group,
            .OpGroupUMax => .Group,
            .OpGroupSMax => .Group,
            .OpReadPipe => .Pipe,
            .OpWritePipe => .Pipe,
            .OpReservedReadPipe => .Pipe,
            .OpReservedWritePipe => .Pipe,
            .OpReserveReadPipePackets => .Pipe,
            .OpReserveWritePipePackets => .Pipe,
            .OpCommitReadPipe => .Pipe,
            .OpCommitWritePipe => .Pipe,
            .OpIsValidReserveId => .Pipe,
            .OpGetNumPipePackets => .Pipe,
            .OpGetMaxPipePackets => .Pipe,
            .OpGroupReserveReadPipePackets => .Pipe,
            .OpGroupReserveWritePipePackets => .Pipe,
            .OpGroupCommitReadPipe => .Pipe,
            .OpGroupCommitWritePipe => .Pipe,
            .OpEnqueueMarker => .DeviceSideEnqueue,
            .OpEnqueueKernel => .DeviceSideEnqueue,
            .OpGetKernelNDrangeSubGroupCount => .DeviceSideEnqueue,
            .OpGetKernelNDrangeMaxSubGroupSize => .DeviceSideEnqueue,
            .OpGetKernelWorkGroupSize => .DeviceSideEnqueue,
            .OpGetKernelPreferredWorkGroupSizeMultiple => .DeviceSideEnqueue,
            .OpRetainEvent => .DeviceSideEnqueue,
            .OpReleaseEvent => .DeviceSideEnqueue,
            .OpCreateUserEvent => .DeviceSideEnqueue,
            .OpIsValidEvent => .DeviceSideEnqueue,
            .OpSetUserEventStatus => .DeviceSideEnqueue,
            .OpCaptureEventProfilingInfo => .DeviceSideEnqueue,
            .OpGetDefaultQueue => .DeviceSideEnqueue,
            .OpBuildNDRange => .DeviceSideEnqueue,
            .OpImageSparseSampleImplicitLod => .Image,
            .OpImageSparseSampleExplicitLod => .Image,
            .OpImageSparseSampleDrefImplicitLod => .Image,
            .OpImageSparseSampleDrefExplicitLod => .Image,
            .OpImageSparseSampleProjImplicitLod => .Image,
            .OpImageSparseSampleProjExplicitLod => .Image,
            .OpImageSparseSampleProjDrefImplicitLod => .Image,
            .OpImageSparseSampleProjDrefExplicitLod => .Image,
            .OpImageSparseFetch => .Image,
            .OpImageSparseGather => .Image,
            .OpImageSparseDrefGather => .Image,
            .OpImageSparseTexelsResident => .Image,
            .OpNoLine => .Debug,
            .OpAtomicFlagTestAndSet => .Atomic,
            .OpAtomicFlagClear => .Atomic,
            .OpImageSparseRead => .Image,
            .OpSizeOf => .Miscellaneous,
            .OpTypePipeStorage => .TypeDeclaration,
            .OpConstantPipeStorage => .Pipe,
            .OpCreatePipeFromPipeStorage => .Pipe,
            .OpGetKernelLocalSizeForSubgroupCount => .DeviceSideEnqueue,
            .OpGetKernelMaxNumSubgroups => .DeviceSideEnqueue,
            .OpTypeNamedBarrier => .TypeDeclaration,
            .OpNamedBarrierInitialize => .Barrier,
            .OpMemoryNamedBarrier => .Barrier,
            .OpModuleProcessed => .Debug,
            .OpExecutionModeId => .ModeSetting,
            .OpDecorateId => .Annotation,
            .OpGroupNonUniformElect => .NonUniform,
            .OpGroupNonUniformAll => .NonUniform,
            .OpGroupNonUniformAny => .NonUniform,
            .OpGroupNonUniformAllEqual => .NonUniform,
            .OpGroupNonUniformBroadcast => .NonUniform,
            .OpGroupNonUniformBroadcastFirst => .NonUniform,
            .OpGroupNonUniformBallot => .NonUniform,
            .OpGroupNonUniformInverseBallot => .NonUniform,
            .OpGroupNonUniformBallotBitExtract => .NonUniform,
            .OpGroupNonUniformBallotBitCount => .NonUniform,
            .OpGroupNonUniformBallotFindLSB => .NonUniform,
            .OpGroupNonUniformBallotFindMSB => .NonUniform,
            .OpGroupNonUniformShuffle => .NonUniform,
            .OpGroupNonUniformShuffleXor => .NonUniform,
            .OpGroupNonUniformShuffleUp => .NonUniform,
            .OpGroupNonUniformShuffleDown => .NonUniform,
            .OpGroupNonUniformIAdd => .NonUniform,
            .OpGroupNonUniformFAdd => .NonUniform,
            .OpGroupNonUniformIMul => .NonUniform,
            .OpGroupNonUniformFMul => .NonUniform,
            .OpGroupNonUniformSMin => .NonUniform,
            .OpGroupNonUniformUMin => .NonUniform,
            .OpGroupNonUniformFMin => .NonUniform,
            .OpGroupNonUniformSMax => .NonUniform,
            .OpGroupNonUniformUMax => .NonUniform,
            .OpGroupNonUniformFMax => .NonUniform,
            .OpGroupNonUniformBitwiseAnd => .NonUniform,
            .OpGroupNonUniformBitwiseOr => .NonUniform,
            .OpGroupNonUniformBitwiseXor => .NonUniform,
            .OpGroupNonUniformLogicalAnd => .NonUniform,
            .OpGroupNonUniformLogicalOr => .NonUniform,
            .OpGroupNonUniformLogicalXor => .NonUniform,
            .OpGroupNonUniformQuadBroadcast => .NonUniform,
            .OpGroupNonUniformQuadSwap => .NonUniform,
            .OpCopyLogical => .Composite,
            .OpPtrEqual => .Memory,
            .OpPtrNotEqual => .Memory,
            .OpPtrDiff => .Memory,
            .OpTerminateInvocation => .ControlFlow,
            .OpSubgroupBallotKHR => .Group,
            .OpSubgroupFirstInvocationKHR => .Group,
            .OpSubgroupAllKHR => .Group,
            .OpSubgroupAnyKHR => .Group,
            .OpSubgroupAllEqualKHR => .Group,
            .OpSubgroupReadInvocationKHR => .Group,
            .OpTraceRayKHR => .Reserved,
            .OpExecuteCallableKHR => .Reserved,
            .OpConvertUToAccelerationStructureKHR => .Reserved,
            .OpIgnoreIntersectionKHR => .Reserved,
            .OpTerminateRayKHR => .Reserved,
            .OpSDot => .Arithmetic,
            .OpUDot => .Arithmetic,
            .OpSUDot => .Arithmetic,
            .OpSDotAccSat => .Arithmetic,
            .OpUDotAccSat => .Arithmetic,
            .OpSUDotAccSat => .Arithmetic,
            .OpTypeRayQueryKHR => .Reserved,
            .OpRayQueryInitializeKHR => .Reserved,
            .OpRayQueryTerminateKHR => .Reserved,
            .OpRayQueryGenerateIntersectionKHR => .Reserved,
            .OpRayQueryConfirmIntersectionKHR => .Reserved,
            .OpRayQueryProceedKHR => .Reserved,
            .OpRayQueryGetIntersectionTypeKHR => .Reserved,
            .OpGroupIAddNonUniformAMD => .Group,
            .OpGroupFAddNonUniformAMD => .Group,
            .OpGroupFMinNonUniformAMD => .Group,
            .OpGroupUMinNonUniformAMD => .Group,
            .OpGroupSMinNonUniformAMD => .Group,
            .OpGroupFMaxNonUniformAMD => .Group,
            .OpGroupUMaxNonUniformAMD => .Group,
            .OpGroupSMaxNonUniformAMD => .Group,
            .OpFragmentMaskFetchAMD => .Reserved,
            .OpFragmentFetchAMD => .Reserved,
            .OpReadClockKHR => .Reserved,
            .OpImageSampleFootprintNV => .Image,
            .OpGroupNonUniformPartitionNV => .NonUniform,
            .OpWritePackedPrimitiveIndices4x8NV => .Reserved,
            .OpReportIntersectionKHR => .Reserved,
            .OpIgnoreIntersectionNV => .Reserved,
            .OpTerminateRayNV => .Reserved,
            .OpTraceNV => .Reserved,
            .OpTraceMotionNV => .Reserved,
            .OpTraceRayMotionNV => .Reserved,
            .OpTypeAccelerationStructureKHR => .Reserved,
            .OpExecuteCallableNV => .Reserved,
            .OpTypeCooperativeMatrixNV => .Reserved,
            .OpCooperativeMatrixLoadNV => .Reserved,
            .OpCooperativeMatrixStoreNV => .Reserved,
            .OpCooperativeMatrixMulAddNV => .Reserved,
            .OpCooperativeMatrixLengthNV => .Reserved,
            .OpBeginInvocationInterlockEXT => .Reserved,
            .OpEndInvocationInterlockEXT => .Reserved,
            .OpDemoteToHelperInvocation => .ControlFlow,
            .OpIsHelperInvocationEXT => .Reserved,
            .OpConvertUToImageNV => .Reserved,
            .OpConvertUToSamplerNV => .Reserved,
            .OpConvertImageToUNV => .Reserved,
            .OpConvertSamplerToUNV => .Reserved,
            .OpConvertUToSampledImageNV => .Reserved,
            .OpConvertSampledImageToUNV => .Reserved,
            .OpSamplerImageAddressingModeNV => .Reserved,
            .OpSubgroupShuffleINTEL => .Group,
            .OpSubgroupShuffleDownINTEL => .Group,
            .OpSubgroupShuffleUpINTEL => .Group,
            .OpSubgroupShuffleXorINTEL => .Group,
            .OpSubgroupBlockReadINTEL => .Group,
            .OpSubgroupBlockWriteINTEL => .Group,
            .OpSubgroupImageBlockReadINTEL => .Group,
            .OpSubgroupImageBlockWriteINTEL => .Group,
            .OpSubgroupImageMediaBlockReadINTEL => .Group,
            .OpSubgroupImageMediaBlockWriteINTEL => .Group,
            .OpUCountLeadingZerosINTEL => .Reserved,
            .OpUCountTrailingZerosINTEL => .Reserved,
            .OpAbsISubINTEL => .Reserved,
            .OpAbsUSubINTEL => .Reserved,
            .OpIAddSatINTEL => .Reserved,
            .OpUAddSatINTEL => .Reserved,
            .OpIAverageINTEL => .Reserved,
            .OpUAverageINTEL => .Reserved,
            .OpIAverageRoundedINTEL => .Reserved,
            .OpUAverageRoundedINTEL => .Reserved,
            .OpISubSatINTEL => .Reserved,
            .OpUSubSatINTEL => .Reserved,
            .OpIMul32x16INTEL => .Reserved,
            .OpUMul32x16INTEL => .Reserved,
            .OpAtomicFMinEXT => .Atomic,
            .OpAtomicFMaxEXT => .Atomic,
            .OpAssumeTrueKHR => .Miscellaneous,
            .OpExpectKHR => .Miscellaneous,
            .OpDecorateString => .Annotation,
            .OpMemberDecorateString => .Annotation,
            .OpLoopControlINTEL => .Reserved,
            .OpReadPipeBlockingINTEL => .Pipe,
            .OpWritePipeBlockingINTEL => .Pipe,
            .OpFPGARegINTEL => .Reserved,
            .OpRayQueryGetRayTMinKHR => .Reserved,
            .OpRayQueryGetRayFlagsKHR => .Reserved,
            .OpRayQueryGetIntersectionTKHR => .Reserved,
            .OpRayQueryGetIntersectionInstanceCustomIndexKHR => .Reserved,
            .OpRayQueryGetIntersectionInstanceIdKHR => .Reserved,
            .OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR => .Reserved,
            .OpRayQueryGetIntersectionGeometryIndexKHR => .Reserved,
            .OpRayQueryGetIntersectionPrimitiveIndexKHR => .Reserved,
            .OpRayQueryGetIntersectionBarycentricsKHR => .Reserved,
            .OpRayQueryGetIntersectionFrontFaceKHR => .Reserved,
            .OpRayQueryGetIntersectionCandidateAABBOpaqueKHR => .Reserved,
            .OpRayQueryGetIntersectionObjectRayDirectionKHR => .Reserved,
            .OpRayQueryGetIntersectionObjectRayOriginKHR => .Reserved,
            .OpRayQueryGetWorldRayDirectionKHR => .Reserved,
            .OpRayQueryGetWorldRayOriginKHR => .Reserved,
            .OpRayQueryGetIntersectionObjectToWorldKHR => .Reserved,
            .OpRayQueryGetIntersectionWorldToObjectKHR => .Reserved,
            .OpAtomicFAddEXT => .Atomic,
            .OpTypeBufferSurfaceINTEL => .TypeDeclaration,
            .OpTypeStructContinuedINTEL => .TypeDeclaration,
            .OpConstantCompositeContinuedINTEL => .ConstantCreation,
            .OpSpecConstantCompositeContinuedINTEL => .ConstantCreation,
        };
    }
};
pub const ImageOperands = packed struct {
    Bias: bool = false,
    Lod: bool = false,
    Grad: bool = false,
    ConstOffset: bool = false,
    Offset: bool = false,
    ConstOffsets: bool = false,
    Sample: bool = false,
    MinLod: bool = false,
    MakeTexelAvailable: bool = false,
    MakeTexelVisible: bool = false,
    NonPrivateTexel: bool = false,
    VolatileTexel: bool = false,
    SignExtend: bool = false,
    ZeroExtend: bool = false,
    Nontemporal: bool = false,
    _reserved_bit_15: bool = false,
    Offsets: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const MakeTexelAvailableKHR: ImageOperands = .{ .MakeTexelAvailable = true };
    pub const MakeTexelVisibleKHR: ImageOperands = .{ .MakeTexelVisible = true };
    pub const NonPrivateTexelKHR: ImageOperands = .{ .NonPrivateTexel = true };
    pub const VolatileTexelKHR: ImageOperands = .{ .VolatileTexel = true };

    pub const Extended = struct {
        Bias: ?struct { id_ref: IdRef } = null,
        Lod: ?struct { id_ref: IdRef } = null,
        Grad: ?struct { id_ref_0: IdRef, id_ref_1: IdRef } = null,
        ConstOffset: ?struct { id_ref: IdRef } = null,
        Offset: ?struct { id_ref: IdRef } = null,
        ConstOffsets: ?struct { id_ref: IdRef } = null,
        Sample: ?struct { id_ref: IdRef } = null,
        MinLod: ?struct { id_ref: IdRef } = null,
        MakeTexelAvailable: ?struct { id_scope: IdScope } = null,
        MakeTexelVisible: ?struct { id_scope: IdScope } = null,
        NonPrivateTexel: bool = false,
        VolatileTexel: bool = false,
        SignExtend: bool = false,
        ZeroExtend: bool = false,
        Nontemporal: bool = false,
        _reserved_bit_15: bool = false,
        Offsets: ?struct { id_ref: IdRef } = null,
        _reserved_bit_17: bool = false,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const FPFastMathMode = packed struct {
    NotNaN: bool = false,
    NotInf: bool = false,
    NSZ: bool = false,
    AllowRecip: bool = false,
    Fast: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    AllowContractFastINTEL: bool = false,
    AllowReassocINTEL: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const SelectionControl = packed struct {
    Flatten: bool = false,
    DontFlatten: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const LoopControl = packed struct {
    Unroll: bool = false,
    DontUnroll: bool = false,
    DependencyInfinite: bool = false,
    DependencyLength: bool = false,
    MinIterations: bool = false,
    MaxIterations: bool = false,
    IterationMultiple: bool = false,
    PeelCount: bool = false,
    PartialCount: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    InitiationIntervalINTEL: bool = false,
    MaxConcurrencyINTEL: bool = false,
    DependencyArrayINTEL: bool = false,
    PipelineEnableINTEL: bool = false,
    LoopCoalesceINTEL: bool = false,
    MaxInterleavingINTEL: bool = false,
    SpeculatedIterationsINTEL: bool = false,
    NoFusionINTEL: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const Extended = struct {
        Unroll: bool = false,
        DontUnroll: bool = false,
        DependencyInfinite: bool = false,
        DependencyLength: ?struct { literal_integer: LiteralInteger } = null,
        MinIterations: ?struct { literal_integer: LiteralInteger } = null,
        MaxIterations: ?struct { literal_integer: LiteralInteger } = null,
        IterationMultiple: ?struct { literal_integer: LiteralInteger } = null,
        PeelCount: ?struct { literal_integer: LiteralInteger } = null,
        PartialCount: ?struct { literal_integer: LiteralInteger } = null,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        InitiationIntervalINTEL: ?struct { literal_integer: LiteralInteger } = null,
        MaxConcurrencyINTEL: ?struct { literal_integer: LiteralInteger } = null,
        DependencyArrayINTEL: ?struct { literal_integer: LiteralInteger } = null,
        PipelineEnableINTEL: ?struct { literal_integer: LiteralInteger } = null,
        LoopCoalesceINTEL: ?struct { literal_integer: LiteralInteger } = null,
        MaxInterleavingINTEL: ?struct { literal_integer: LiteralInteger } = null,
        SpeculatedIterationsINTEL: ?struct { literal_integer: LiteralInteger } = null,
        NoFusionINTEL: ?struct { literal_integer: LiteralInteger } = null,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const FunctionControl = packed struct {
    Inline: bool = false,
    DontInline: bool = false,
    Pure: bool = false,
    Const: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    OptNoneINTEL: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const MemorySemantics = packed struct {
    _reserved_bit_0: bool = false,
    Acquire: bool = false,
    Release: bool = false,
    AcquireRelease: bool = false,
    SequentiallyConsistent: bool = false,
    _reserved_bit_5: bool = false,
    UniformMemory: bool = false,
    SubgroupMemory: bool = false,
    WorkgroupMemory: bool = false,
    CrossWorkgroupMemory: bool = false,
    AtomicCounterMemory: bool = false,
    ImageMemory: bool = false,
    OutputMemory: bool = false,
    MakeAvailable: bool = false,
    MakeVisible: bool = false,
    Volatile: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const OutputMemoryKHR: MemorySemantics = .{ .OutputMemory = true };
    pub const MakeAvailableKHR: MemorySemantics = .{ .MakeAvailable = true };
    pub const MakeVisibleKHR: MemorySemantics = .{ .MakeVisible = true };
};
pub const MemoryAccess = packed struct {
    Volatile: bool = false,
    Aligned: bool = false,
    Nontemporal: bool = false,
    MakePointerAvailable: bool = false,
    MakePointerVisible: bool = false,
    NonPrivatePointer: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const MakePointerAvailableKHR: MemoryAccess = .{ .MakePointerAvailable = true };
    pub const MakePointerVisibleKHR: MemoryAccess = .{ .MakePointerVisible = true };
    pub const NonPrivatePointerKHR: MemoryAccess = .{ .NonPrivatePointer = true };

    pub const Extended = struct {
        Volatile: bool = false,
        Aligned: ?struct { literal_integer: LiteralInteger } = null,
        Nontemporal: bool = false,
        MakePointerAvailable: ?struct { id_scope: IdScope } = null,
        MakePointerVisible: ?struct { id_scope: IdScope } = null,
        NonPrivatePointer: bool = false,
        _reserved_bit_6: bool = false,
        _reserved_bit_7: bool = false,
        _reserved_bit_8: bool = false,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        _reserved_bit_16: bool = false,
        _reserved_bit_17: bool = false,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const KernelProfilingInfo = packed struct {
    CmdExecTime: bool = false,
    _reserved_bit_1: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const RayFlags = packed struct {
    OpaqueKHR: bool = false,
    NoOpaqueKHR: bool = false,
    TerminateOnFirstHitKHR: bool = false,
    SkipClosestHitShaderKHR: bool = false,
    CullBackFacingTrianglesKHR: bool = false,
    CullFrontFacingTrianglesKHR: bool = false,
    CullOpaqueKHR: bool = false,
    CullNoOpaqueKHR: bool = false,
    SkipTrianglesKHR: bool = false,
    SkipAABBsKHR: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const FragmentShadingRate = packed struct {
    Vertical2Pixels: bool = false,
    Vertical4Pixels: bool = false,
    Horizontal2Pixels: bool = false,
    Horizontal4Pixels: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const SourceLanguage = enum(u32) {
    Unknown = 0,
    ESSL = 1,
    GLSL = 2,
    OpenCL_C = 3,
    OpenCL_CPP = 4,
    HLSL = 5,
    CPP_for_OpenCL = 6,
};
pub const ExecutionModel = enum(u32) {
    Vertex = 0,
    TessellationControl = 1,
    TessellationEvaluation = 2,
    Geometry = 3,
    Fragment = 4,
    GLCompute = 5,
    Kernel = 6,
    TaskNV = 5267,
    MeshNV = 5268,
    RayGenerationKHR = 5313,
    IntersectionKHR = 5314,
    AnyHitKHR = 5315,
    ClosestHitKHR = 5316,
    MissKHR = 5317,
    CallableKHR = 5318,

    pub const RayGenerationNV = ExecutionModel.RayGenerationKHR;
    pub const IntersectionNV = ExecutionModel.IntersectionKHR;
    pub const AnyHitNV = ExecutionModel.AnyHitKHR;
    pub const ClosestHitNV = ExecutionModel.ClosestHitKHR;
    pub const MissNV = ExecutionModel.MissKHR;
    pub const CallableNV = ExecutionModel.CallableKHR;
};
pub const AddressingModel = enum(u32) {
    Logical = 0,
    Physical32 = 1,
    Physical64 = 2,
    PhysicalStorageBuffer64 = 5348,

    pub const PhysicalStorageBuffer64EXT = AddressingModel.PhysicalStorageBuffer64;
};
pub const MemoryModel = enum(u32) {
    Simple = 0,
    GLSL450 = 1,
    OpenCL = 2,
    Vulkan = 3,

    pub const VulkanKHR = MemoryModel.Vulkan;
};
pub const ExecutionMode = enum(u32) {
    Invocations = 0,
    SpacingEqual = 1,
    SpacingFractionalEven = 2,
    SpacingFractionalOdd = 3,
    VertexOrderCw = 4,
    VertexOrderCcw = 5,
    PixelCenterInteger = 6,
    OriginUpperLeft = 7,
    OriginLowerLeft = 8,
    EarlyFragmentTests = 9,
    PointMode = 10,
    Xfb = 11,
    DepthReplacing = 12,
    DepthGreater = 14,
    DepthLess = 15,
    DepthUnchanged = 16,
    LocalSize = 17,
    LocalSizeHint = 18,
    InputPoints = 19,
    InputLines = 20,
    InputLinesAdjacency = 21,
    Triangles = 22,
    InputTrianglesAdjacency = 23,
    Quads = 24,
    Isolines = 25,
    OutputVertices = 26,
    OutputPoints = 27,
    OutputLineStrip = 28,
    OutputTriangleStrip = 29,
    VecTypeHint = 30,
    ContractionOff = 31,
    Initializer = 33,
    Finalizer = 34,
    SubgroupSize = 35,
    SubgroupsPerWorkgroup = 36,
    SubgroupsPerWorkgroupId = 37,
    LocalSizeId = 38,
    LocalSizeHintId = 39,
    SubgroupUniformControlFlowKHR = 4421,
    PostDepthCoverage = 4446,
    DenormPreserve = 4459,
    DenormFlushToZero = 4460,
    SignedZeroInfNanPreserve = 4461,
    RoundingModeRTE = 4462,
    RoundingModeRTZ = 4463,
    StencilRefReplacingEXT = 5027,
    OutputLinesNV = 5269,
    OutputPrimitivesNV = 5270,
    DerivativeGroupQuadsNV = 5289,
    DerivativeGroupLinearNV = 5290,
    OutputTrianglesNV = 5298,
    PixelInterlockOrderedEXT = 5366,
    PixelInterlockUnorderedEXT = 5367,
    SampleInterlockOrderedEXT = 5368,
    SampleInterlockUnorderedEXT = 5369,
    ShadingRateInterlockOrderedEXT = 5370,
    ShadingRateInterlockUnorderedEXT = 5371,
    SharedLocalMemorySizeINTEL = 5618,
    RoundingModeRTPINTEL = 5620,
    RoundingModeRTNINTEL = 5621,
    FloatingPointModeALTINTEL = 5622,
    FloatingPointModeIEEEINTEL = 5623,
    MaxWorkgroupSizeINTEL = 5893,
    MaxWorkDimINTEL = 5894,
    NoGlobalOffsetINTEL = 5895,
    NumSIMDWorkitemsINTEL = 5896,
    SchedulerTargetFmaxMhzINTEL = 5903,

    pub const Extended = union(ExecutionMode) {
        Invocations: struct { literal_integer: LiteralInteger },
        SpacingEqual,
        SpacingFractionalEven,
        SpacingFractionalOdd,
        VertexOrderCw,
        VertexOrderCcw,
        PixelCenterInteger,
        OriginUpperLeft,
        OriginLowerLeft,
        EarlyFragmentTests,
        PointMode,
        Xfb,
        DepthReplacing,
        DepthGreater,
        DepthLess,
        DepthUnchanged,
        LocalSize: struct { x_size: LiteralInteger, y_size: LiteralInteger, z_size: LiteralInteger },
        LocalSizeHint: struct { x_size: LiteralInteger, y_size: LiteralInteger, z_size: LiteralInteger },
        InputPoints,
        InputLines,
        InputLinesAdjacency,
        Triangles,
        InputTrianglesAdjacency,
        Quads,
        Isolines,
        OutputVertices: struct { vertex_count: LiteralInteger },
        OutputPoints,
        OutputLineStrip,
        OutputTriangleStrip,
        VecTypeHint: struct { vector_type: LiteralInteger },
        ContractionOff,
        Initializer,
        Finalizer,
        SubgroupSize: struct { subgroup_size: LiteralInteger },
        SubgroupsPerWorkgroup: struct { subgroups_per_workgroup: LiteralInteger },
        SubgroupsPerWorkgroupId: struct { subgroups_per_workgroup: IdRef },
        LocalSizeId: struct { x_size: IdRef, y_size: IdRef, z_size: IdRef },
        LocalSizeHintId: struct { x_size_hint: IdRef, y_size_hint: IdRef, z_size_hint: IdRef },
        SubgroupUniformControlFlowKHR,
        PostDepthCoverage,
        DenormPreserve: struct { target_width: LiteralInteger },
        DenormFlushToZero: struct { target_width: LiteralInteger },
        SignedZeroInfNanPreserve: struct { target_width: LiteralInteger },
        RoundingModeRTE: struct { target_width: LiteralInteger },
        RoundingModeRTZ: struct { target_width: LiteralInteger },
        StencilRefReplacingEXT,
        OutputLinesNV,
        OutputPrimitivesNV: struct { primitive_count: LiteralInteger },
        DerivativeGroupQuadsNV,
        DerivativeGroupLinearNV,
        OutputTrianglesNV,
        PixelInterlockOrderedEXT,
        PixelInterlockUnorderedEXT,
        SampleInterlockOrderedEXT,
        SampleInterlockUnorderedEXT,
        ShadingRateInterlockOrderedEXT,
        ShadingRateInterlockUnorderedEXT,
        SharedLocalMemorySizeINTEL: struct { size: LiteralInteger },
        RoundingModeRTPINTEL: struct { target_width: LiteralInteger },
        RoundingModeRTNINTEL: struct { target_width: LiteralInteger },
        FloatingPointModeALTINTEL: struct { target_width: LiteralInteger },
        FloatingPointModeIEEEINTEL: struct { target_width: LiteralInteger },
        MaxWorkgroupSizeINTEL: struct { literal_integer_0: LiteralInteger, literal_integer_1: LiteralInteger, literal_integer_2: LiteralInteger },
        MaxWorkDimINTEL: struct { literal_integer: LiteralInteger },
        NoGlobalOffsetINTEL,
        NumSIMDWorkitemsINTEL: struct { literal_integer: LiteralInteger },
        SchedulerTargetFmaxMhzINTEL: struct { literal_integer: LiteralInteger },
    };
};
pub const StorageClass = enum(u32) {
    UniformConstant = 0,
    Input = 1,
    Uniform = 2,
    Output = 3,
    Workgroup = 4,
    CrossWorkgroup = 5,
    Private = 6,
    Function = 7,
    Generic = 8,
    PushConstant = 9,
    AtomicCounter = 10,
    Image = 11,
    StorageBuffer = 12,
    CallableDataKHR = 5328,
    IncomingCallableDataKHR = 5329,
    RayPayloadKHR = 5338,
    HitAttributeKHR = 5339,
    IncomingRayPayloadKHR = 5342,
    ShaderRecordBufferKHR = 5343,
    PhysicalStorageBuffer = 5349,
    CodeSectionINTEL = 5605,
    DeviceOnlyINTEL = 5936,
    HostOnlyINTEL = 5937,

    pub const CallableDataNV = StorageClass.CallableDataKHR;
    pub const IncomingCallableDataNV = StorageClass.IncomingCallableDataKHR;
    pub const RayPayloadNV = StorageClass.RayPayloadKHR;
    pub const HitAttributeNV = StorageClass.HitAttributeKHR;
    pub const IncomingRayPayloadNV = StorageClass.IncomingRayPayloadKHR;
    pub const ShaderRecordBufferNV = StorageClass.ShaderRecordBufferKHR;
    pub const PhysicalStorageBufferEXT = StorageClass.PhysicalStorageBuffer;
};
pub const Dim = enum(u32) {
    @"1D" = 0,
    @"2D" = 1,
    @"3D" = 2,
    Cube = 3,
    Rect = 4,
    Buffer = 5,
    SubpassData = 6,
};
pub const SamplerAddressingMode = enum(u32) {
    None = 0,
    ClampToEdge = 1,
    Clamp = 2,
    Repeat = 3,
    RepeatMirrored = 4,
};
pub const SamplerFilterMode = enum(u32) {
    Nearest = 0,
    Linear = 1,
};
pub const ImageFormat = enum(u32) {
    Unknown = 0,
    Rgba32f = 1,
    Rgba16f = 2,
    R32f = 3,
    Rgba8 = 4,
    Rgba8Snorm = 5,
    Rg32f = 6,
    Rg16f = 7,
    R11fG11fB10f = 8,
    R16f = 9,
    Rgba16 = 10,
    Rgb10A2 = 11,
    Rg16 = 12,
    Rg8 = 13,
    R16 = 14,
    R8 = 15,
    Rgba16Snorm = 16,
    Rg16Snorm = 17,
    Rg8Snorm = 18,
    R16Snorm = 19,
    R8Snorm = 20,
    Rgba32i = 21,
    Rgba16i = 22,
    Rgba8i = 23,
    R32i = 24,
    Rg32i = 25,
    Rg16i = 26,
    Rg8i = 27,
    R16i = 28,
    R8i = 29,
    Rgba32ui = 30,
    Rgba16ui = 31,
    Rgba8ui = 32,
    R32ui = 33,
    Rgb10a2ui = 34,
    Rg32ui = 35,
    Rg16ui = 36,
    Rg8ui = 37,
    R16ui = 38,
    R8ui = 39,
    R64ui = 40,
    R64i = 41,
};
pub const ImageChannelOrder = enum(u32) {
    R = 0,
    A = 1,
    RG = 2,
    RA = 3,
    RGB = 4,
    RGBA = 5,
    BGRA = 6,
    ARGB = 7,
    Intensity = 8,
    Luminance = 9,
    Rx = 10,
    RGx = 11,
    RGBx = 12,
    Depth = 13,
    DepthStencil = 14,
    sRGB = 15,
    sRGBx = 16,
    sRGBA = 17,
    sBGRA = 18,
    ABGR = 19,
};
pub const ImageChannelDataType = enum(u32) {
    SnormInt8 = 0,
    SnormInt16 = 1,
    UnormInt8 = 2,
    UnormInt16 = 3,
    UnormShort565 = 4,
    UnormShort555 = 5,
    UnormInt101010 = 6,
    SignedInt8 = 7,
    SignedInt16 = 8,
    SignedInt32 = 9,
    UnsignedInt8 = 10,
    UnsignedInt16 = 11,
    UnsignedInt32 = 12,
    HalfFloat = 13,
    Float = 14,
    UnormInt24 = 15,
    UnormInt101010_2 = 16,
};
pub const FPRoundingMode = enum(u32) {
    RTE = 0,
    RTZ = 1,
    RTP = 2,
    RTN = 3,
};
pub const FPDenormMode = enum(u32) {
    Preserve = 0,
    FlushToZero = 1,
};
pub const QuantizationModes = enum(u32) {
    TRN = 0,
    TRN_ZERO = 1,
    RND = 2,
    RND_ZERO = 3,
    RND_INF = 4,
    RND_MIN_INF = 5,
    RND_CONV = 6,
    RND_CONV_ODD = 7,
};
pub const FPOperationMode = enum(u32) {
    IEEE = 0,
    ALT = 1,
};
pub const OverflowModes = enum(u32) {
    WRAP = 0,
    SAT = 1,
    SAT_ZERO = 2,
    SAT_SYM = 3,
};
pub const LinkageType = enum(u32) {
    Export = 0,
    Import = 1,
    LinkOnceODR = 2,
};
pub const AccessQualifier = enum(u32) {
    ReadOnly = 0,
    WriteOnly = 1,
    ReadWrite = 2,
};
pub const FunctionParameterAttribute = enum(u32) {
    Zext = 0,
    Sext = 1,
    ByVal = 2,
    Sret = 3,
    NoAlias = 4,
    NoCapture = 5,
    NoWrite = 6,
    NoReadWrite = 7,
};
pub const Decoration = enum(u32) {
    RelaxedPrecision = 0,
    SpecId = 1,
    Block = 2,
    BufferBlock = 3,
    RowMajor = 4,
    ColMajor = 5,
    ArrayStride = 6,
    MatrixStride = 7,
    GLSLShared = 8,
    GLSLPacked = 9,
    CPacked = 10,
    BuiltIn = 11,
    NoPerspective = 13,
    Flat = 14,
    Patch = 15,
    Centroid = 16,
    Sample = 17,
    Invariant = 18,
    Restrict = 19,
    Aliased = 20,
    Volatile = 21,
    Constant = 22,
    Coherent = 23,
    NonWritable = 24,
    NonReadable = 25,
    Uniform = 26,
    UniformId = 27,
    SaturatedConversion = 28,
    Stream = 29,
    Location = 30,
    Component = 31,
    Index = 32,
    Binding = 33,
    DescriptorSet = 34,
    Offset = 35,
    XfbBuffer = 36,
    XfbStride = 37,
    FuncParamAttr = 38,
    FPRoundingMode = 39,
    FPFastMathMode = 40,
    LinkageAttributes = 41,
    NoContraction = 42,
    InputAttachmentIndex = 43,
    Alignment = 44,
    MaxByteOffset = 45,
    AlignmentId = 46,
    MaxByteOffsetId = 47,
    NoSignedWrap = 4469,
    NoUnsignedWrap = 4470,
    ExplicitInterpAMD = 4999,
    OverrideCoverageNV = 5248,
    PassthroughNV = 5250,
    ViewportRelativeNV = 5252,
    SecondaryViewportRelativeNV = 5256,
    PerPrimitiveNV = 5271,
    PerViewNV = 5272,
    PerTaskNV = 5273,
    PerVertexKHR = 5285,
    NonUniform = 5300,
    RestrictPointer = 5355,
    AliasedPointer = 5356,
    BindlessSamplerNV = 5398,
    BindlessImageNV = 5399,
    BoundSamplerNV = 5400,
    BoundImageNV = 5401,
    SIMTCallINTEL = 5599,
    ReferencedIndirectlyINTEL = 5602,
    ClobberINTEL = 5607,
    SideEffectsINTEL = 5608,
    VectorComputeVariableINTEL = 5624,
    FuncParamIOKindINTEL = 5625,
    VectorComputeFunctionINTEL = 5626,
    StackCallINTEL = 5627,
    GlobalVariableOffsetINTEL = 5628,
    CounterBuffer = 5634,
    UserSemantic = 5635,
    UserTypeGOOGLE = 5636,
    FunctionRoundingModeINTEL = 5822,
    FunctionDenormModeINTEL = 5823,
    RegisterINTEL = 5825,
    MemoryINTEL = 5826,
    NumbanksINTEL = 5827,
    BankwidthINTEL = 5828,
    MaxPrivateCopiesINTEL = 5829,
    SinglepumpINTEL = 5830,
    DoublepumpINTEL = 5831,
    MaxReplicatesINTEL = 5832,
    SimpleDualPortINTEL = 5833,
    MergeINTEL = 5834,
    BankBitsINTEL = 5835,
    ForcePow2DepthINTEL = 5836,
    BurstCoalesceINTEL = 5899,
    CacheSizeINTEL = 5900,
    DontStaticallyCoalesceINTEL = 5901,
    PrefetchINTEL = 5902,
    StallEnableINTEL = 5905,
    FuseLoopsInFunctionINTEL = 5907,
    BufferLocationINTEL = 5921,
    IOPipeStorageINTEL = 5944,
    FunctionFloatingPointModeINTEL = 6080,
    SingleElementVectorINTEL = 6085,
    VectorComputeCallableFunctionINTEL = 6087,
    MediaBlockIOINTEL = 6140,

    pub const PerVertexNV = Decoration.PerVertexKHR;
    pub const NonUniformEXT = Decoration.NonUniform;
    pub const RestrictPointerEXT = Decoration.RestrictPointer;
    pub const AliasedPointerEXT = Decoration.AliasedPointer;
    pub const HlslCounterBufferGOOGLE = Decoration.CounterBuffer;
    pub const HlslSemanticGOOGLE = Decoration.UserSemantic;

    pub const Extended = union(Decoration) {
        RelaxedPrecision,
        SpecId: struct { specialization_constant_id: LiteralInteger },
        Block,
        BufferBlock,
        RowMajor,
        ColMajor,
        ArrayStride: struct { array_stride: LiteralInteger },
        MatrixStride: struct { matrix_stride: LiteralInteger },
        GLSLShared,
        GLSLPacked,
        CPacked,
        BuiltIn: struct { built_in: BuiltIn },
        NoPerspective,
        Flat,
        Patch,
        Centroid,
        Sample,
        Invariant,
        Restrict,
        Aliased,
        Volatile,
        Constant,
        Coherent,
        NonWritable,
        NonReadable,
        Uniform,
        UniformId: struct { execution: IdScope },
        SaturatedConversion,
        Stream: struct { stream_number: LiteralInteger },
        Location: struct { location: LiteralInteger },
        Component: struct { component: LiteralInteger },
        Index: struct { index: LiteralInteger },
        Binding: struct { binding_point: LiteralInteger },
        DescriptorSet: struct { descriptor_set: LiteralInteger },
        Offset: struct { byte_offset: LiteralInteger },
        XfbBuffer: struct { xfb_buffer_number: LiteralInteger },
        XfbStride: struct { xfb_stride: LiteralInteger },
        FuncParamAttr: struct { function_parameter_attribute: FunctionParameterAttribute },
        FPRoundingMode: struct { fprounding_mode: FPRoundingMode },
        FPFastMathMode: struct { fpfast_math_mode: FPFastMathMode },
        LinkageAttributes: struct { name: LiteralString, linkage_type: LinkageType },
        NoContraction,
        InputAttachmentIndex: struct { attachment_index: LiteralInteger },
        Alignment: struct { alignment: LiteralInteger },
        MaxByteOffset: struct { max_byte_offset: LiteralInteger },
        AlignmentId: struct { alignment: IdRef },
        MaxByteOffsetId: struct { max_byte_offset: IdRef },
        NoSignedWrap,
        NoUnsignedWrap,
        ExplicitInterpAMD,
        OverrideCoverageNV,
        PassthroughNV,
        ViewportRelativeNV,
        SecondaryViewportRelativeNV: struct { offset: LiteralInteger },
        PerPrimitiveNV,
        PerViewNV,
        PerTaskNV,
        PerVertexKHR,
        NonUniform,
        RestrictPointer,
        AliasedPointer,
        BindlessSamplerNV,
        BindlessImageNV,
        BoundSamplerNV,
        BoundImageNV,
        SIMTCallINTEL: struct { n: LiteralInteger },
        ReferencedIndirectlyINTEL,
        ClobberINTEL: struct { register: LiteralString },
        SideEffectsINTEL,
        VectorComputeVariableINTEL,
        FuncParamIOKindINTEL: struct { kind: LiteralInteger },
        VectorComputeFunctionINTEL,
        StackCallINTEL,
        GlobalVariableOffsetINTEL: struct { offset: LiteralInteger },
        CounterBuffer: struct { counter_buffer: IdRef },
        UserSemantic: struct { semantic: LiteralString },
        UserTypeGOOGLE: struct { user_type: LiteralString },
        FunctionRoundingModeINTEL: struct { target_width: LiteralInteger, fp_rounding_mode: FPRoundingMode },
        FunctionDenormModeINTEL: struct { target_width: LiteralInteger, fp_denorm_mode: FPDenormMode },
        RegisterINTEL,
        MemoryINTEL: struct { memory_type: LiteralString },
        NumbanksINTEL: struct { banks: LiteralInteger },
        BankwidthINTEL: struct { bank_width: LiteralInteger },
        MaxPrivateCopiesINTEL: struct { maximum_copies: LiteralInteger },
        SinglepumpINTEL,
        DoublepumpINTEL,
        MaxReplicatesINTEL: struct { maximum_replicates: LiteralInteger },
        SimpleDualPortINTEL,
        MergeINTEL: struct { merge_key: LiteralString, merge_type: LiteralString },
        BankBitsINTEL: struct { bank_bits: []const LiteralInteger = &.{} },
        ForcePow2DepthINTEL: struct { force_key: LiteralInteger },
        BurstCoalesceINTEL,
        CacheSizeINTEL: struct { cache_size_in_bytes: LiteralInteger },
        DontStaticallyCoalesceINTEL,
        PrefetchINTEL: struct { prefetcher_size_in_bytes: LiteralInteger },
        StallEnableINTEL,
        FuseLoopsInFunctionINTEL,
        BufferLocationINTEL: struct { buffer_location_id: LiteralInteger },
        IOPipeStorageINTEL: struct { io_pipe_id: LiteralInteger },
        FunctionFloatingPointModeINTEL: struct { target_width: LiteralInteger, fp_operation_mode: FPOperationMode },
        SingleElementVectorINTEL,
        VectorComputeCallableFunctionINTEL,
        MediaBlockIOINTEL,
    };
};
pub const BuiltIn = enum(u32) {
    Position = 0,
    PointSize = 1,
    ClipDistance = 3,
    CullDistance = 4,
    VertexId = 5,
    InstanceId = 6,
    PrimitiveId = 7,
    InvocationId = 8,
    Layer = 9,
    ViewportIndex = 10,
    TessLevelOuter = 11,
    TessLevelInner = 12,
    TessCoord = 13,
    PatchVertices = 14,
    FragCoord = 15,
    PointCoord = 16,
    FrontFacing = 17,
    SampleId = 18,
    SamplePosition = 19,
    SampleMask = 20,
    FragDepth = 22,
    HelperInvocation = 23,
    NumWorkgroups = 24,
    WorkgroupSize = 25,
    WorkgroupId = 26,
    LocalInvocationId = 27,
    GlobalInvocationId = 28,
    LocalInvocationIndex = 29,
    WorkDim = 30,
    GlobalSize = 31,
    EnqueuedWorkgroupSize = 32,
    GlobalOffset = 33,
    GlobalLinearId = 34,
    SubgroupSize = 36,
    SubgroupMaxSize = 37,
    NumSubgroups = 38,
    NumEnqueuedSubgroups = 39,
    SubgroupId = 40,
    SubgroupLocalInvocationId = 41,
    VertexIndex = 42,
    InstanceIndex = 43,
    SubgroupEqMask = 4416,
    SubgroupGeMask = 4417,
    SubgroupGtMask = 4418,
    SubgroupLeMask = 4419,
    SubgroupLtMask = 4420,
    BaseVertex = 4424,
    BaseInstance = 4425,
    DrawIndex = 4426,
    PrimitiveShadingRateKHR = 4432,
    DeviceIndex = 4438,
    ViewIndex = 4440,
    ShadingRateKHR = 4444,
    BaryCoordNoPerspAMD = 4992,
    BaryCoordNoPerspCentroidAMD = 4993,
    BaryCoordNoPerspSampleAMD = 4994,
    BaryCoordSmoothAMD = 4995,
    BaryCoordSmoothCentroidAMD = 4996,
    BaryCoordSmoothSampleAMD = 4997,
    BaryCoordPullModelAMD = 4998,
    FragStencilRefEXT = 5014,
    ViewportMaskNV = 5253,
    SecondaryPositionNV = 5257,
    SecondaryViewportMaskNV = 5258,
    PositionPerViewNV = 5261,
    ViewportMaskPerViewNV = 5262,
    FullyCoveredEXT = 5264,
    TaskCountNV = 5274,
    PrimitiveCountNV = 5275,
    PrimitiveIndicesNV = 5276,
    ClipDistancePerViewNV = 5277,
    CullDistancePerViewNV = 5278,
    LayerPerViewNV = 5279,
    MeshViewCountNV = 5280,
    MeshViewIndicesNV = 5281,
    BaryCoordKHR = 5286,
    BaryCoordNoPerspKHR = 5287,
    FragSizeEXT = 5292,
    FragInvocationCountEXT = 5293,
    LaunchIdKHR = 5319,
    LaunchSizeKHR = 5320,
    WorldRayOriginKHR = 5321,
    WorldRayDirectionKHR = 5322,
    ObjectRayOriginKHR = 5323,
    ObjectRayDirectionKHR = 5324,
    RayTminKHR = 5325,
    RayTmaxKHR = 5326,
    InstanceCustomIndexKHR = 5327,
    ObjectToWorldKHR = 5330,
    WorldToObjectKHR = 5331,
    HitTNV = 5332,
    HitKindKHR = 5333,
    CurrentRayTimeNV = 5334,
    IncomingRayFlagsKHR = 5351,
    RayGeometryIndexKHR = 5352,
    WarpsPerSMNV = 5374,
    SMCountNV = 5375,
    WarpIDNV = 5376,
    SMIDNV = 5377,

    pub const SubgroupEqMaskKHR = BuiltIn.SubgroupEqMask;
    pub const SubgroupGeMaskKHR = BuiltIn.SubgroupGeMask;
    pub const SubgroupGtMaskKHR = BuiltIn.SubgroupGtMask;
    pub const SubgroupLeMaskKHR = BuiltIn.SubgroupLeMask;
    pub const SubgroupLtMaskKHR = BuiltIn.SubgroupLtMask;
    pub const BaryCoordNV = BuiltIn.BaryCoordKHR;
    pub const BaryCoordNoPerspNV = BuiltIn.BaryCoordNoPerspKHR;
    pub const FragmentSizeNV = BuiltIn.FragSizeEXT;
    pub const InvocationsPerPixelNV = BuiltIn.FragInvocationCountEXT;
    pub const LaunchIdNV = BuiltIn.LaunchIdKHR;
    pub const LaunchSizeNV = BuiltIn.LaunchSizeKHR;
    pub const WorldRayOriginNV = BuiltIn.WorldRayOriginKHR;
    pub const WorldRayDirectionNV = BuiltIn.WorldRayDirectionKHR;
    pub const ObjectRayOriginNV = BuiltIn.ObjectRayOriginKHR;
    pub const ObjectRayDirectionNV = BuiltIn.ObjectRayDirectionKHR;
    pub const RayTminNV = BuiltIn.RayTminKHR;
    pub const RayTmaxNV = BuiltIn.RayTmaxKHR;
    pub const InstanceCustomIndexNV = BuiltIn.InstanceCustomIndexKHR;
    pub const ObjectToWorldNV = BuiltIn.ObjectToWorldKHR;
    pub const WorldToObjectNV = BuiltIn.WorldToObjectKHR;
    pub const HitKindNV = BuiltIn.HitKindKHR;
    pub const IncomingRayFlagsNV = BuiltIn.IncomingRayFlagsKHR;
};
pub const Scope = enum(u32) {
    CrossDevice = 0,
    Device = 1,
    Workgroup = 2,
    Subgroup = 3,
    Invocation = 4,
    QueueFamily = 5,
    ShaderCallKHR = 6,

    pub const QueueFamilyKHR = Scope.QueueFamily;
};
pub const GroupOperation = enum(u32) {
    Reduce = 0,
    InclusiveScan = 1,
    ExclusiveScan = 2,
    ClusteredReduce = 3,
    PartitionedReduceNV = 6,
    PartitionedInclusiveScanNV = 7,
    PartitionedExclusiveScanNV = 8,
};
pub const KernelEnqueueFlags = enum(u32) {
    NoWait = 0,
    WaitKernel = 1,
    WaitWorkGroup = 2,
};
pub const Capability = enum(u32) {
    Matrix = 0,
    Shader = 1,
    Geometry = 2,
    Tessellation = 3,
    Addresses = 4,
    Linkage = 5,
    Kernel = 6,
    Vector16 = 7,
    Float16Buffer = 8,
    Float16 = 9,
    Float64 = 10,
    Int64 = 11,
    Int64Atomics = 12,
    ImageBasic = 13,
    ImageReadWrite = 14,
    ImageMipmap = 15,
    Pipes = 17,
    Groups = 18,
    DeviceEnqueue = 19,
    LiteralSampler = 20,
    AtomicStorage = 21,
    Int16 = 22,
    TessellationPointSize = 23,
    GeometryPointSize = 24,
    ImageGatherExtended = 25,
    StorageImageMultisample = 27,
    UniformBufferArrayDynamicIndexing = 28,
    SampledImageArrayDynamicIndexing = 29,
    StorageBufferArrayDynamicIndexing = 30,
    StorageImageArrayDynamicIndexing = 31,
    ClipDistance = 32,
    CullDistance = 33,
    ImageCubeArray = 34,
    SampleRateShading = 35,
    ImageRect = 36,
    SampledRect = 37,
    GenericPointer = 38,
    Int8 = 39,
    InputAttachment = 40,
    SparseResidency = 41,
    MinLod = 42,
    Sampled1D = 43,
    Image1D = 44,
    SampledCubeArray = 45,
    SampledBuffer = 46,
    ImageBuffer = 47,
    ImageMSArray = 48,
    StorageImageExtendedFormats = 49,
    ImageQuery = 50,
    DerivativeControl = 51,
    InterpolationFunction = 52,
    TransformFeedback = 53,
    GeometryStreams = 54,
    StorageImageReadWithoutFormat = 55,
    StorageImageWriteWithoutFormat = 56,
    MultiViewport = 57,
    SubgroupDispatch = 58,
    NamedBarrier = 59,
    PipeStorage = 60,
    GroupNonUniform = 61,
    GroupNonUniformVote = 62,
    GroupNonUniformArithmetic = 63,
    GroupNonUniformBallot = 64,
    GroupNonUniformShuffle = 65,
    GroupNonUniformShuffleRelative = 66,
    GroupNonUniformClustered = 67,
    GroupNonUniformQuad = 68,
    ShaderLayer = 69,
    ShaderViewportIndex = 70,
    UniformDecoration = 71,
    FragmentShadingRateKHR = 4422,
    SubgroupBallotKHR = 4423,
    DrawParameters = 4427,
    WorkgroupMemoryExplicitLayoutKHR = 4428,
    WorkgroupMemoryExplicitLayout8BitAccessKHR = 4429,
    WorkgroupMemoryExplicitLayout16BitAccessKHR = 4430,
    SubgroupVoteKHR = 4431,
    StorageBuffer16BitAccess = 4433,
    UniformAndStorageBuffer16BitAccess = 4434,
    StoragePushConstant16 = 4435,
    StorageInputOutput16 = 4436,
    DeviceGroup = 4437,
    MultiView = 4439,
    VariablePointersStorageBuffer = 4441,
    VariablePointers = 4442,
    AtomicStorageOps = 4445,
    SampleMaskPostDepthCoverage = 4447,
    StorageBuffer8BitAccess = 4448,
    UniformAndStorageBuffer8BitAccess = 4449,
    StoragePushConstant8 = 4450,
    DenormPreserve = 4464,
    DenormFlushToZero = 4465,
    SignedZeroInfNanPreserve = 4466,
    RoundingModeRTE = 4467,
    RoundingModeRTZ = 4468,
    RayQueryProvisionalKHR = 4471,
    RayQueryKHR = 4472,
    RayTraversalPrimitiveCullingKHR = 4478,
    RayTracingKHR = 4479,
    Float16ImageAMD = 5008,
    ImageGatherBiasLodAMD = 5009,
    FragmentMaskAMD = 5010,
    StencilExportEXT = 5013,
    ImageReadWriteLodAMD = 5015,
    Int64ImageEXT = 5016,
    ShaderClockKHR = 5055,
    SampleMaskOverrideCoverageNV = 5249,
    GeometryShaderPassthroughNV = 5251,
    ShaderViewportIndexLayerEXT = 5254,
    ShaderViewportMaskNV = 5255,
    ShaderStereoViewNV = 5259,
    PerViewAttributesNV = 5260,
    FragmentFullyCoveredEXT = 5265,
    MeshShadingNV = 5266,
    ImageFootprintNV = 5282,
    FragmentBarycentricKHR = 5284,
    ComputeDerivativeGroupQuadsNV = 5288,
    FragmentDensityEXT = 5291,
    GroupNonUniformPartitionedNV = 5297,
    ShaderNonUniform = 5301,
    RuntimeDescriptorArray = 5302,
    InputAttachmentArrayDynamicIndexing = 5303,
    UniformTexelBufferArrayDynamicIndexing = 5304,
    StorageTexelBufferArrayDynamicIndexing = 5305,
    UniformBufferArrayNonUniformIndexing = 5306,
    SampledImageArrayNonUniformIndexing = 5307,
    StorageBufferArrayNonUniformIndexing = 5308,
    StorageImageArrayNonUniformIndexing = 5309,
    InputAttachmentArrayNonUniformIndexing = 5310,
    UniformTexelBufferArrayNonUniformIndexing = 5311,
    StorageTexelBufferArrayNonUniformIndexing = 5312,
    RayTracingNV = 5340,
    RayTracingMotionBlurNV = 5341,
    VulkanMemoryModel = 5345,
    VulkanMemoryModelDeviceScope = 5346,
    PhysicalStorageBufferAddresses = 5347,
    ComputeDerivativeGroupLinearNV = 5350,
    RayTracingProvisionalKHR = 5353,
    CooperativeMatrixNV = 5357,
    FragmentShaderSampleInterlockEXT = 5363,
    FragmentShaderShadingRateInterlockEXT = 5372,
    ShaderSMBuiltinsNV = 5373,
    FragmentShaderPixelInterlockEXT = 5378,
    DemoteToHelperInvocation = 5379,
    BindlessTextureNV = 5390,
    SubgroupShuffleINTEL = 5568,
    SubgroupBufferBlockIOINTEL = 5569,
    SubgroupImageBlockIOINTEL = 5570,
    SubgroupImageMediaBlockIOINTEL = 5579,
    RoundToInfinityINTEL = 5582,
    FloatingPointModeINTEL = 5583,
    IntegerFunctions2INTEL = 5584,
    FunctionPointersINTEL = 5603,
    IndirectReferencesINTEL = 5604,
    AsmINTEL = 5606,
    AtomicFloat32MinMaxEXT = 5612,
    AtomicFloat64MinMaxEXT = 5613,
    AtomicFloat16MinMaxEXT = 5616,
    VectorComputeINTEL = 5617,
    VectorAnyINTEL = 5619,
    ExpectAssumeKHR = 5629,
    SubgroupAvcMotionEstimationINTEL = 5696,
    SubgroupAvcMotionEstimationIntraINTEL = 5697,
    SubgroupAvcMotionEstimationChromaINTEL = 5698,
    VariableLengthArrayINTEL = 5817,
    FunctionFloatControlINTEL = 5821,
    FPGAMemoryAttributesINTEL = 5824,
    FPFastMathModeINTEL = 5837,
    ArbitraryPrecisionIntegersINTEL = 5844,
    ArbitraryPrecisionFloatingPointINTEL = 5845,
    UnstructuredLoopControlsINTEL = 5886,
    FPGALoopControlsINTEL = 5888,
    KernelAttributesINTEL = 5892,
    FPGAKernelAttributesINTEL = 5897,
    FPGAMemoryAccessesINTEL = 5898,
    FPGAClusterAttributesINTEL = 5904,
    LoopFuseINTEL = 5906,
    FPGABufferLocationINTEL = 5920,
    ArbitraryPrecisionFixedPointINTEL = 5922,
    USMStorageClassesINTEL = 5935,
    IOPipesINTEL = 5943,
    BlockingPipesINTEL = 5945,
    FPGARegINTEL = 5948,
    DotProductInputAll = 6016,
    DotProductInput4x8Bit = 6017,
    DotProductInput4x8BitPacked = 6018,
    DotProduct = 6019,
    BitInstructions = 6025,
    AtomicFloat32AddEXT = 6033,
    AtomicFloat64AddEXT = 6034,
    LongConstantCompositeINTEL = 6089,
    OptNoneINTEL = 6094,
    AtomicFloat16AddEXT = 6095,
    DebugInfoModuleINTEL = 6114,

    pub const StorageUniformBufferBlock16 = Capability.StorageBuffer16BitAccess;
    pub const StorageUniform16 = Capability.UniformAndStorageBuffer16BitAccess;
    pub const ShaderViewportIndexLayerNV = Capability.ShaderViewportIndexLayerEXT;
    pub const FragmentBarycentricNV = Capability.FragmentBarycentricKHR;
    pub const ShadingRateNV = Capability.FragmentDensityEXT;
    pub const ShaderNonUniformEXT = Capability.ShaderNonUniform;
    pub const RuntimeDescriptorArrayEXT = Capability.RuntimeDescriptorArray;
    pub const InputAttachmentArrayDynamicIndexingEXT = Capability.InputAttachmentArrayDynamicIndexing;
    pub const UniformTexelBufferArrayDynamicIndexingEXT = Capability.UniformTexelBufferArrayDynamicIndexing;
    pub const StorageTexelBufferArrayDynamicIndexingEXT = Capability.StorageTexelBufferArrayDynamicIndexing;
    pub const UniformBufferArrayNonUniformIndexingEXT = Capability.UniformBufferArrayNonUniformIndexing;
    pub const SampledImageArrayNonUniformIndexingEXT = Capability.SampledImageArrayNonUniformIndexing;
    pub const StorageBufferArrayNonUniformIndexingEXT = Capability.StorageBufferArrayNonUniformIndexing;
    pub const StorageImageArrayNonUniformIndexingEXT = Capability.StorageImageArrayNonUniformIndexing;
    pub const InputAttachmentArrayNonUniformIndexingEXT = Capability.InputAttachmentArrayNonUniformIndexing;
    pub const UniformTexelBufferArrayNonUniformIndexingEXT = Capability.UniformTexelBufferArrayNonUniformIndexing;
    pub const StorageTexelBufferArrayNonUniformIndexingEXT = Capability.StorageTexelBufferArrayNonUniformIndexing;
    pub const VulkanMemoryModelKHR = Capability.VulkanMemoryModel;
    pub const VulkanMemoryModelDeviceScopeKHR = Capability.VulkanMemoryModelDeviceScope;
    pub const PhysicalStorageBufferAddressesEXT = Capability.PhysicalStorageBufferAddresses;
    pub const DemoteToHelperInvocationEXT = Capability.DemoteToHelperInvocation;
    pub const DotProductInputAllKHR = Capability.DotProductInputAll;
    pub const DotProductInput4x8BitKHR = Capability.DotProductInput4x8Bit;
    pub const DotProductInput4x8BitPackedKHR = Capability.DotProductInput4x8BitPacked;
    pub const DotProductKHR = Capability.DotProduct;
};
pub const RayQueryIntersection = enum(u32) {
    RayQueryCandidateIntersectionKHR = 0,
    RayQueryCommittedIntersectionKHR = 1,
};
pub const RayQueryCommittedIntersectionType = enum(u32) {
    RayQueryCommittedIntersectionNoneKHR = 0,
    RayQueryCommittedIntersectionTriangleKHR = 1,
    RayQueryCommittedIntersectionGeneratedKHR = 2,
};
pub const RayQueryCandidateIntersectionType = enum(u32) {
    RayQueryCandidateIntersectionTriangleKHR = 0,
    RayQueryCandidateIntersectionAABBKHR = 1,
};
pub const PackedVectorFormat = enum(u32) {
    PackedVectorFormat4x8Bit = 0,

    pub const PackedVectorFormat4x8BitKHR = PackedVectorFormat.PackedVectorFormat4x8Bit;
};
