const cmp = @import("cmp.zig");
const testing = @import("std").testing;

fn test__ucmpti2(a: u128, b: u128, expected: i32) !void {
    var result = cmp.__ucmpti2(a, b);
    try testing.expectEqual(expected, result);
}

test "ucmpti2" {
    // minInt == 0
    // maxInt == 340282366920938463463374607431768211455
    // minInt/2 == 0
    // maxInt/2 == 170141183460469231731687303715884105727
    // 1. equality minInt, minInt+1, maxInt/2, maxInt-1, maxInt
    try test__ucmpti2(0, 0, 1);
    try test__ucmpti2(1, 1, 1);
    try test__ucmpti2(170141183460469231731687303715884105727, 170141183460469231731687303715884105727, 1);
    try test__ucmpti2(340282366920938463463374607431768211454, 340282366920938463463374607431768211454, 1);
    try test__ucmpti2(340282366920938463463374607431768211455, 340282366920938463463374607431768211455, 1);
    // 2. cmp minInt,   {minInt + 1, maxInt/2, maxInt-1, maxInt}
    try test__ucmpti2(0, 1, 0);
    try test__ucmpti2(0, 170141183460469231731687303715884105727, 0);
    try test__ucmpti2(0, 340282366920938463463374607431768211454, 0);
    try test__ucmpti2(0, 340282366920938463463374607431768211455, 0);
    // 3. cmp minInt+1, {minInt, maxInt/2, maxInt-1, maxInt}
    try test__ucmpti2(1, 0, 2);
    try test__ucmpti2(1, 170141183460469231731687303715884105727, 0);
    try test__ucmpti2(1, 340282366920938463463374607431768211454, 0);
    try test__ucmpti2(1, 340282366920938463463374607431768211455, 0);
    // 4. cmp minInt/2, {}
    // 5. cmp -1,       {}
    // 6. cmp 0,        {}
    // 7. cmp 1,        {}
    // 8. cmp maxInt/2, {}
    try test__ucmpti2(170141183460469231731687303715884105727, 0, 2);
    try test__ucmpti2(170141183460469231731687303715884105727, 1, 2);
    try test__ucmpti2(170141183460469231731687303715884105727, 340282366920938463463374607431768211454, 0);
    try test__ucmpti2(170141183460469231731687303715884105727, 340282366920938463463374607431768211455, 0);
    // 9. cmp maxInt-1, {minInt, minInt + 1,  maxInt/2, maxInt}
    try test__ucmpti2(340282366920938463463374607431768211454, 0, 2);
    try test__ucmpti2(340282366920938463463374607431768211454, 1, 2);
    try test__ucmpti2(340282366920938463463374607431768211454, 170141183460469231731687303715884105727, 2);
    try test__ucmpti2(340282366920938463463374607431768211454, 340282366920938463463374607431768211455, 0);
    // 10.cmp maxInt,   {minInt, minInt + 1, minInt/2, -2,-1,0,1,2, maxInt/2, maxInt-1,       }
    try test__ucmpti2(340282366920938463463374607431768211455, 0, 2);
    try test__ucmpti2(340282366920938463463374607431768211455, 1, 2);
    try test__ucmpti2(340282366920938463463374607431768211455, 170141183460469231731687303715884105727, 2);
    try test__ucmpti2(340282366920938463463374607431768211455, 340282366920938463463374607431768211454, 2);
}
