const COMMON_DATA = require('../../source/common/data.json')

module.exports = {
  'config': {
    // Root directories
    'openPaths': [], // Array to include all opened root paths
    'openFiles': [], // Array to include all currently opened files
    'lastFile': null, // Save last opened file hash here
    'lastDir': null, // Save last opened dir hash here
    'dialogPaths': {
      'askFileDialog': '',
      'askDirDialog': '',
      'askLangFileDialog': ''
    },
    'window': {
      'x': 0,
      'y': 0,
      'width': 1920,
      'height': 1080,
      'max': true
    },
    // Visible attachment filetypes
    'attachmentExtensions': COMMON_DATA.attachmentExtensions,
    // UI related options
    'darkTheme': false, // TODO DEPRECATED to be renamed to darkMode
    'alwaysReloadFiles': false, // Should Zettlr automatically load remote changes?
    'autoDarkMode': 'off', // Possible values: 'off', 'system', 'schedule', 'auto'
    'autoDarkModeStart': '22:00', // Switch into dark mode at this time
    'autoDarkModeEnd': '06:00', // Switch to light mode at this time
    'fileMeta': true,
    'fileMetaTime': 'modtime', // The time to be displayed in file meta
    'hideDirs': true, // Should the app hide directories during global search?
    'sorting': 'natural', // Can be natural or based on ASCII values
    'sortingTime': 'modtime', // can be modtime or creationtime
    'muteLines': true, // Should the editor mute lines in distraction free mode?
    'sidebarMode': 'thin', // thin = Preview or directories visible --- expanded = both visible --- combined = tree view displays also files
    'enableRMarkdown': false, // Whether or not RMarkdown files should be recognised
    'newFileNamePattern': '%id.md',
    'newFileDontPrompt': false, // If true immediately creates files
    // Export options
    'pandoc': 'pandoc',
    'xelatex': 'xelatex',
    // The pandoc command to be run on export
    'pandocCommand': 'pandoc "$infile$" -f markdown $outflag$ $tpl$ $toc$ $tocdepth$ $citeproc$ $standalone$ --pdf-engine=xelatex --mathjax -o "$outfile$"',
    'export': {
      'dir': 'temp', // Can either be "temp" or "cwd" (current working directory)
      'stripIDs': false, // Strip ZKN IDs such as @ID:<id>
      'stripTags': false, // Strip tags a.k.a. #tag
      'stripLinks': 'full', // Strip internal links: "full" - remove completely, "unlink" - only remove brackets, "no" - don't alter
      'cslLibrary': '', // Path to a CSL JSON library file
      'cslStyle': '' // Path to a CSL Style file
    },
    // PDF options (for all documents; projects will copy this object over)
    'pdf': {
      'author': 'Generated by Zettlr', // Default user name
      'keywords': '', // PDF keywords
      'papertype': 'a4paper', // Paper to use, e.g. A4 or Letter
      'pagenumbering': 'gobble', // By default omit page numbers
      'tmargin': 3, // Margins to paper (top, right, bottom, left)
      'rmargin': 3,
      'bmargin': 3,
      'lmargin': 3,
      'margin_unit': 'cm',
      'lineheight': '1.5', // Default: 150% line height
      'mainfont': 'Times New Roman', // Main font
      'sansfont': 'Arial', // Sans font, used, e.g. for headings
      'fontsize': 12, // Will be translated to pt
      'textpl': '' // Can be used to store a custom TeX template
    },
    // Zettelkasten stuff (IDs, as well as link matchers)
    'zkn': {
      'idRE': '(\\d{14})',
      'idGen': '%Y%M%D%h%m%s',
      'linkStart': '[[',
      'linkEnd': ']]',
      'linkWithFilename': 'always' // can be always|never|withID
    },
    // Editor related stuff
    'editor': {
      'autoCloseBrackets': true,
      'defaultSaveImagePath': '',
      'homeEndBehaviour': true, // If checked (true), CodeMirror goes to start/end of a paragraph, not a line.
      'enableTableHelper': true, // Enable the table helper plugin
      'indentUnit': 4, // The number of spaces to be added
      'countChars': false, // Set to true to enable counting characters instead of words
      'boldFormatting': '**', // Can be ** or __
      'italicFormatting': '_', // Can be * or _
      'readabilityAlgorithm': 'dale-chall', // The algorithm to use with readability mode.
      'autoCorrect': {
        'active': true, // AutoCorrect is on by default
        'style': 'LibreOffice', // Default to LibreOffice style
        'quotes': false,
        'replacements': [
          // Arrows
          { key: '-->', val: '→' },
          { key: '–>', val: '→' }, // For Word mode arrows
          { key: '<--', val: '←' },
          { key: '<->', val: '↔' },
          { key: '<-->', val: '↔' },
          { key: '==>', val: '⇒' },
          { key: '<==', val: '⇐' },
          { key: '<=>', val: '⇔' },
          { key: '<==>', val: '⇔' },
          // Mathematical symbols
          { key: '!=', val: '≠' },
          { key: '<>', val: '≠' },
          { key: '+-', val: '±' },
          { key: ':times:', val: '×' },
          { key: ':division:', val: '÷' },
          { key: '<=', val: '≤' },
          { key: '>=', val: '≥' },
          { key: '1/2', val: '½' },
          { key: '1/3', val: '⅓' },
          { key: '1/4', val: '¼' },
          { key: '1/8', val: '⅛' },
          { key: '2/3', val: '⅔' },
          { key: '3/4', val: '¾' },
          { key: '3/8', val: '⅜' },
          { key: '5/8', val: '⅝' },
          { key: '7/8', val: '⅞' },
          // Units
          { key: 'mm2', val: 'mm²' },
          { key: 'cm2', val: 'cm²' },
          { key: 'm2', val: 'm²' },
          { key: 'km2', val: 'km²' },
          { key: 'mm3', val: 'mm³' },
          { key: 'cm3', val: 'cm³' },
          { key: 'ccm', val: 'cm³' },
          { key: 'm3', val: 'm³' },
          { key: 'km3', val: 'km³' },
          { key: ':sup2:', val: '²' },
          { key: ':sup3:', val: '³' },
          { key: ':deg:', val: '°' },
          // Currencies
          { key: ':eur:', val: '€' },
          { key: ':gbp:', val: '£' },
          { key: ':yen:', val: '¥' },
          { key: ':cent:', val: '¢' },
          { key: ':inr:', val: '₹' },
          // Special symbols
          { key: '(c)', val: '©' },
          { key: '(tm)', val: '™' },
          { key: '(r)', val: '®' },
          // Interpunctation
          { key: '...', val: '…' },
          { key: '--', val: '–' },
          { key: '---', val: '—' }
        ]
      } // END autoCorrect options
    },
    'display': {
      'theme': 'berlin', // The theme used by the app, can be berlin, frankfurt, bielefeld, karl-marx-stadt
      'imageWidth': 100, // Maximum preview image width
      'imageHeight': 50, // Maximum preview image height
      'renderCitations': true,
      'renderIframes': true,
      'renderImages': true,
      'renderLinks': true,
      'renderMath': true,
      'renderTasks': true,
      'renderHTags': false
    },
    // Language
    'selectedDicts': [ ], // By default no spell checking is active to speed up first start.
    'appLang': 'en-US',
    'debug': false,
    'checkForBeta': false, // Should the user be notified of beta releases?
    'uuid': null // The app's unique anonymous identifier
  },
  'project': {
    // General values that not only pertain to the PDF generation
    'title': 'Untitled', // Default project title is the directory's name
    'format': 'pdf', // Can be PDF, HTML, DOCX, and ODT.
    'cslStyle': '', // A path to an optional CSL style file.
    'pdf': {
      'author': 'Generated by Zettlr',
      // PDF keywords are seldomly used
      'keywords': '',
      // papertype is a value that XeLaTeX expects
      'papertype': 'a4paper',
      // pagenumbering must also be a value that XeLaTeX accepts
      'pagenumbering': 'arabic',
      // All four paper margins
      'tmargin': 3,
      'rmargin': 3,
      'bmargin': 3,
      'lmargin': 3,
      'margin_unit': 'cm',
      'lineheight': '1.2', // TODO: Why is this a string?
      'mainfont': 'Times New Roman',
      'sansfont': 'Arial',
      'fontsize': 12,
      'toc': true, // Default: generate table of contents
      'tocDepth': 2, // Default: Include headings 1+2 in TOCs
      'titlepage': true, // Generate a title page by default
      'textpl': '' // Can be used to store a custom TeX template
    }
  },
  'directory': {
    'sorting': 'name-up',
    'project': null // Default: no project
  },
  'sortings': [
    'name-up',
    'name-down',
    'time-up',
    'time-down'
  ]
}
