vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO martinmoene/ring-span-lite
    REF v0.6.0
    SHA512 1C3C9560BC1F8CBDF9CDFD5593233020D8403CE707D8B129FED82080CB806E82E83CBB839BEA64D53B022A58400F817A54FFB30099A0D7D7B300E8D0103F483B
)

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        -DRING_SPAN_LITE_OPT_BUILD_TESTS=OFF
        -DRING_SPAN_LITE_OPT_BUILD_EXAMPLES=OFF
)

vcpkg_cmake_install()

vcpkg_cmake_config_fixup(
    CONFIG_PATH "lib/cmake/${PORT}"
)

file(REMOVE_RECURSE
    "${CURRENT_PACKAGES_DIR}/debug"
    "${CURRENT_PACKAGES_DIR}/lib"
)

file(INSTALL
    "${SOURCE_PATH}/LICENSE.txt" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}" RENAME copyright
)
