vcpkg_check_linkage(ONLY_STATIC_LIBRARY)

vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO itay-grudev/SingleApplication
    REF "v${VERSION}"
    SHA512 9a63dcbfd4c80626093b23df0ee97d704b494d928b76b81e0373a0a847e73a0c4fd6557e338221c473412394c4ab3456d90e1e5c7894112b08ce7f11c9e66e58
    HEAD_REF master
)

set(QAPPLICATION_CLASS QGuiApplication)
vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        -DQT_DEFAULT_MAJOR_VERSION=6
        -DQAPPLICATION_CLASS=${QAPPLICATION_CLASS}
)

vcpkg_cmake_build(TARGET SingleApplication)

if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "release")
  file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/${VCPKG_TARGET_STATIC_LIBRARY_PREFIX}SingleApplication${VCPKG_TARGET_STATIC_LIBRARY_SUFFIX}" DESTINATION "${CURRENT_PACKAGES_DIR}/lib")
endif()
if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "debug")
  file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/${VCPKG_TARGET_STATIC_LIBRARY_PREFIX}SingleApplication${VCPKG_TARGET_STATIC_LIBRARY_SUFFIX}" DESTINATION "${CURRENT_PACKAGES_DIR}/debug/lib")
endif()
file(INSTALL "${SOURCE_PATH}/singleapplication.h" DESTINATION "${CURRENT_PACKAGES_DIR}/include")

configure_file("${CMAKE_CURRENT_LIST_DIR}/Config.cmake.in" "${CURRENT_PACKAGES_DIR}/share/${PORT}/${PORT}-config.cmake" @ONLY)

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE")