/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.delete;

import javax.ws.rs.client.ResponseProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.glossary.delete.GlossaryDeleteOptions;
import org.zanata.rest.client.GlossaryClient;
import org.zanata.rest.client.RestClientFactory;

public class GlossaryDeleteCommand
extends ConfigurableCommand<GlossaryDeleteOptions> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryDeleteCommand.class);
    private final GlossaryClient client = this.getClientFactory().getGlossaryClient();

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts) {
        this(opts, OptionsUtil.createClientFactory(opts));
    }

    @Override
    public void run() throws Exception {
        String qualifiedName;
        log.info("Server: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUrl());
        log.info("Username: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUsername());
        if (!StringUtils.isEmpty((CharSequence)((GlossaryDeleteOptions)this.getOpts()).getId())) {
            log.info("Entry id to delete: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getId());
        }
        if (StringUtils.isNotBlank((CharSequence)((GlossaryDeleteOptions)this.getOpts()).getProject())) {
            log.info("Project: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getProject());
        }
        log.info("Delete entire glossary?: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getAllGlossary());
        if (!((GlossaryDeleteOptions)this.getOpts()).getAllGlossary() && StringUtils.isBlank((CharSequence)((GlossaryDeleteOptions)this.getOpts()).getId())) {
            throw new RuntimeException("Option '--id' is required.");
        }
        String project = ((GlossaryDeleteOptions)this.getOpts()).getProject();
        try {
            qualifiedName = StringUtils.isBlank((CharSequence)project) ? this.client.getGlobalQualifiedName() : this.client.getProjectQualifiedName(project);
        }
        catch (ResponseProcessingException rpe) {
            if (rpe.getResponse().getStatus() == 404) {
                log.error("Project {} not found", (Object)project);
                return;
            }
            throw rpe;
        }
        if (((GlossaryDeleteOptions)this.getOpts()).getAllGlossary()) {
            if (((GlossaryDeleteOptions)this.getOpts()).isInteractiveMode()) {
                ConsoleInteractorImpl console = new ConsoleInteractorImpl((BasicOptions)this.getOpts());
                console.printf(ConsoleInteractor.DisplayMode.Question, "\nAre you sure (y/n)? ", new Object[0]);
                console.expectYes();
            }
            Integer deletedCount = this.client.deleteAll(qualifiedName);
            log.info("Deleted glossary entries: {}", (Object)deletedCount);
        } else {
            try {
                this.client.delete(((GlossaryDeleteOptions)this.getOpts()).getId(), qualifiedName);
            }
            catch (ResponseProcessingException rpe) {
                if (rpe.getResponse().getStatus() == 404) {
                    log.error("Glossary entry {} not found", (Object)((GlossaryDeleteOptions)this.getOpts()).getId());
                }
                throw rpe;
            }
        }
    }
}

