/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import org.zanata.adapter.properties.PropWriter;
import org.zanata.client.commands.pull.AbstractPullStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.dto.LocaleMappedTranslatedDoc;
import org.zanata.common.LocaleId;
import org.zanata.common.dto.TranslatedDoc;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;

public class PropertiesStrategy
extends AbstractPullStrategy {
    StringSet extensions = new StringSet("comment");

    protected PropertiesStrategy(PullOptions opts) {
        super(opts);
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return false;
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        PropWriter.writeSource((Resource)doc, (File)this.getOpts().getSrcDir(), (PropWriter.CHARSET)PropWriter.CHARSET.Latin1);
    }

    @Override
    public FileDetails writeTransFile(String docName, LocaleMappedTranslatedDoc doc) throws IOException {
        boolean createSkeletons = this.getOpts().getCreateSkeletons();
        File transFileToWrite = this.getTransFileToWrite(docName, doc.getLocale());
        LocaleId locale = new LocaleId(doc.getLocale().getLocale());
        TranslatedDoc transDoc = createSkeletons ? new TranslatedDoc(doc.getSource(), doc.getTranslation(), locale) : new TranslatedDoc(null, doc.getTranslation(), locale);
        PropWriter.writeTranslationsFile((TranslatedDoc)transDoc, (File)transFileToWrite, (PropWriter.CHARSET)PropWriter.CHARSET.Latin1, (boolean)createSkeletons, (boolean)this.getOpts().getApprovedOnly());
        return null;
    }
}

