/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.commons.io.FilenameUtils;

public class DocNameWithExt {
    private final String fullName;
    private final String extension;

    DocNameWithExt(String fullName) {
        this.fullName = fullName;
        this.extension = FilenameUtils.getExtension((String)fullName).toLowerCase();
    }

    public static DocNameWithExt from(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)extension) ? 1 : 0) != 0, (Object)"expected a full filename (with extension)");
        return new DocNameWithExt(filename);
    }

    public static DocNameWithExt from(String docNameWithoutExt, String extension) {
        return new DocNameWithExt(docNameWithoutExt + "." + extension);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getExtension() {
        return this.extension;
    }
}

