/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.properties;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.fedorahosted.openprops.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.common.dto.TranslatedDoc;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.PathUtil;

public class PropWriter {
    private static final Logger log = LoggerFactory.getLogger(PropWriter.class);

    public static void writeSource(Resource doc, File baseDir, CHARSET charset) throws IOException {
        File baseFile = new File(baseDir, doc.getName() + ".properties");
        PathUtil.makeDirs((File)baseFile.getParentFile());
        log.debug("Creating base file {}", (Object)baseFile);
        Properties props = new Properties();
        for (TextFlow textFlow : doc.getTextFlows()) {
            List contents = textFlow.getContents();
            if (contents.size() != 1) {
                throw new RuntimeException("file format does not support plural forms: resId=" + textFlow.getId());
            }
            props.setProperty(textFlow.getId(), (String)textFlow.getContents().get(0));
            SimpleComment simpleComment = (SimpleComment)textFlow.getExtensions(true).findByType(SimpleComment.class);
            if (simpleComment == null || simpleComment.getValue() == null) continue;
            props.setComment(textFlow.getId(), simpleComment.getValue());
        }
        PropWriter.storeProps(props, baseFile, charset);
    }

    public static void writeTranslationsFile(TranslatedDoc translatedDoc, File propertiesFile, CHARSET charset, boolean createSkeletons, boolean approvedOnly) throws IOException {
        Properties targetProp = new Properties();
        Resource srcDoc = translatedDoc.getSource();
        TranslationsResource doc = translatedDoc.getTranslation();
        if (srcDoc == null) {
            for (TextFlowTarget target : doc.getTextFlowTargets()) {
                PropWriter.textFlowTargetToProperty(target.getResId(), target, targetProp, createSkeletons, approvedOnly);
            }
        } else {
            HashMap<String, TextFlowTarget> targets = new HashMap<String, TextFlowTarget>();
            if (doc != null) {
                for (TextFlowTarget target : doc.getTextFlowTargets()) {
                    targets.put(target.getResId(), target);
                }
            }
            for (TextFlow textFlow : srcDoc.getTextFlows()) {
                TextFlowTarget target = (TextFlowTarget)targets.get(textFlow.getId());
                PropWriter.textFlowTargetToProperty(textFlow.getId(), target, targetProp, createSkeletons, approvedOnly);
            }
        }
        PropWriter.storeProps(targetProp, propertiesFile, charset);
    }

    @VisibleForTesting
    static void writeTranslations(TranslatedDoc translatedDoc, File baseDir, String bundleName, String locale, CHARSET charset, boolean createSkeletons, boolean approvedOnly) throws IOException {
        File langFile = new File(baseDir, bundleName + "_" + locale + ".properties");
        PathUtil.makeDirs((File)langFile.getParentFile());
        log.debug("Creating target file {}", (Object)langFile);
        PropWriter.writeTranslationsFile(translatedDoc, langFile, charset, createSkeletons, approvedOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProps(Properties props, File file, CHARSET charset) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            if (charset.alias.equals(StandardCharsets.UTF_8)) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8.displayName());
                props.store((Writer)writer, null);
            } else {
                props.store((OutputStream)out, null);
            }
        }
    }

    private static boolean hasATranslation(@Nullable TextFlowTarget target) {
        return target != null && !target.getContents().isEmpty();
    }

    private static boolean usable(@Nullable TextFlowTarget target, boolean approvedOnly) {
        return PropWriter.hasATranslation(target) && (target.getState().isApproved() || !approvedOnly && target.getState().isTranslated());
    }

    private static void textFlowTargetToProperty(String resId, TextFlowTarget target, Properties targetProp, boolean createSkeletons, boolean approvedOnly) {
        if (!PropWriter.usable(target, approvedOnly)) {
            if (createSkeletons) {
                targetProp.setProperty(resId, "");
            }
            return;
        }
        List contents = target.getContents();
        if (contents.size() != 1) {
            throw new RuntimeException("file format does not support plural forms: resId=" + resId);
        }
        targetProp.setProperty(target.getResId(), (String)contents.get(0));
        SimpleComment simpleComment = (SimpleComment)target.getExtensions(true).findByType(SimpleComment.class);
        if (simpleComment != null && simpleComment.getValue() != null) {
            targetProp.setComment(target.getResId(), simpleComment.getValue());
        }
    }

    public static enum CHARSET {
        UTF8(StandardCharsets.UTF_8),
        Latin1(StandardCharsets.ISO_8859_1);

        private final Charset alias;

        private CHARSET(Charset alias) {
            this.alias = alias;
        }

        public Charset getAlias() {
            return this.alias;
        }
    }
}

