/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.init.InitOptions;

class ProjectConfigHandler {
    private final ConsoleInteractor consoleInteractor;
    private final InitOptions opts;
    private File backup;

    ProjectConfigHandler(ConsoleInteractor consoleInteractor, InitOptions opts) {
        this.consoleInteractor = consoleInteractor;
        this.opts = opts;
    }

    @VisibleForTesting
    protected void handleExistingProjectConfig() throws IOException {
        File projectConfig = this.getOpts().getProjectConfig();
        if (projectConfig.exists()) {
            this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get("project.config.exists"), new Object[0]).printf(ConsoleInteractor.DisplayMode.Question, Messages.get("continue.yes.no"), new Object[0]);
            this.consoleInteractor.expectYes();
            String suffix = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss").format(new Date());
            this.backup = new File(projectConfig.getParent(), "zanata.xml." + suffix);
            FileUtils.moveFile((File)projectConfig, (File)this.backup);
            this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages.get("backup.old.project.config"), this.backup);
            this.clearValuesSetByConfigurableMojo();
        }
    }

    private void clearValuesSetByConfigurableMojo() {
        this.opts.setProj(null);
        this.opts.setProjectVersion(null);
        this.opts.setProjectType(null);
        this.opts.setProjectConfig(null);
        this.opts.setSrcDir(null);
        this.opts.setTransDir(null);
        this.opts.setIncludes(null);
        this.opts.setExcludes(null);
    }

    public InitOptions getOpts() {
        return this.opts;
    }

    public boolean hasOldConfig() {
        return this.backup != null;
    }

    public File getBackup() {
        return this.backup;
    }
}

