/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.rest.RestUtil;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;

public class SourceDocResourceClient {
    private final RestClientFactory factory;
    private final String project;
    private final String projectVersion;
    private final URI baseUri;

    SourceDocResourceClient(RestClientFactory factory, String project, String projectVersion) {
        this.factory = factory;
        this.project = project;
        this.projectVersion = projectVersion;
        this.baseUri = factory.getBaseUri();
    }

    public List<ResourceMeta> getResourceMeta(Set<String> extensions) {
        Client client = this.factory.getClient();
        WebTarget webResource = this.getBaseServiceResource(client).path("r");
        if (extensions != null) {
            webResource.queryParam("ext", extensions.toArray());
        }
        return (List)webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<List<ResourceMeta>>(){});
    }

    private WebTarget getBaseServiceResource(Client client) {
        return client.target(this.baseUri).path("projects").path("p").path(this.project).path("iterations").path("i").path(this.projectVersion);
    }

    public Resource getResource(String docId, Set<String> extensions) {
        Client client = this.factory.getClient();
        WebTarget webResource = this.getBaseServiceResource(client).path("resource").queryParam("docId", new Object[]{docId}).queryParam("ext", extensions.toArray());
        try {
            return (Resource)webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(Resource.class);
        }
        catch (ResponseProcessingException e) {
            if (RestUtil.isNotFound((Response)e.getResponse())) {
                String idNoSlash = RestUtil.convertToDocumentURIId((String)docId);
                webResource = this.getBaseServiceResource(client).path("r").path(idNoSlash).queryParam("ext", extensions.toArray());
                return (Resource)webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(Resource.class);
            }
            throw e;
        }
    }

    public String putResource(String docId, Resource resource, Set<String> extensions, boolean copyTrans) {
        Client client = this.factory.getClient();
        WebTarget webResource = this.getBaseServiceResource(client).path("resource").queryParam("docId", new Object[]{docId}).queryParam("ext", extensions.toArray()).queryParam("copyTrans", new Object[]{String.valueOf(copyTrans)});
        try {
            Response response = webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.entity((Object)resource, (MediaType)MediaType.APPLICATION_XML_TYPE));
            response.bufferEntity();
            return (String)response.readEntity(String.class);
        }
        catch (ResponseProcessingException e) {
            if (RestUtil.isNotFound((Response)e.getResponse())) {
                String idNoSlash = RestUtil.convertToDocumentURIId((String)docId);
                webResource = this.getBaseServiceResource(client).path("r").path(idNoSlash).queryParam("ext", extensions.toArray()).queryParam("copyTrans", new Object[]{String.valueOf(copyTrans)});
                Response response = webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.entity((Object)resource, (MediaType)MediaType.APPLICATION_XML_TYPE));
                response.bufferEntity();
                return (String)response.readEntity(String.class);
            }
            throw e;
        }
    }

    public String deleteResource(String docId) {
        Client client = this.factory.getClient();
        WebTarget webResource = this.getBaseServiceResource(client);
        try {
            return (String)webResource.path("resource").queryParam("docId", new Object[]{docId}).request().delete(String.class);
        }
        catch (ResponseProcessingException e) {
            if (RestUtil.isNotFound((Response)e.getResponse())) {
                String idNoSlash = RestUtil.convertToDocumentURIId((String)docId);
                return (String)webResource.path("r").path(idNoSlash).request().delete(String.class);
            }
            throw e;
        }
    }
}

