/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidContentTypeFilter
implements ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(InvalidContentTypeFilter.class);
    private static final String ERROR_MSG = "Received invalid content type from the server. Most likely you're hitting an error page or being redirected. Please check the server URL is correct (in zanata.ini and in zanata.xml) and make sure you use the correct address.";
    private static final Pattern VALID_TYPES_REGEX = Pattern.compile("application/.*");

    @VisibleForTesting
    protected static boolean isContentTypeCompatible(MediaType responseContentType) {
        if (responseContentType == null || responseContentType.isWildcardType() || responseContentType.isWildcardSubtype()) {
            return true;
        }
        if (MediaType.TEXT_PLAIN_TYPE.isCompatible(responseContentType)) {
            return true;
        }
        Matcher matcher = VALID_TYPES_REGEX.matcher(responseContentType.toString());
        return matcher.matches();
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"})
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL) && !InvalidContentTypeFilter.isContentTypeCompatible(responseContext.getMediaType())) {
            log.error(ERROR_MSG);
            String snippet = String.format("Wrong content type received: [%s]", responseContext.getMediaType());
            log.error(snippet);
            throw new IllegalStateException(snippet);
        }
    }
}

