/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.zanata.client.HelpOptions;
import org.zanata.client.SubCommandHandler2;
import org.zanata.client.commands.AppAbortException;
import org.zanata.client.commands.AppAbortStrategy;
import org.zanata.client.commands.ArgsUtil;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.BasicOptionsImpl;
import org.zanata.client.commands.ListRemoteOptionsImpl;
import org.zanata.client.commands.PutProjectOptionsImpl;
import org.zanata.client.commands.PutUserOptionsImpl;
import org.zanata.client.commands.PutVersionOptionsImpl;
import org.zanata.client.commands.SystemExitStrategy;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.glossary.delete.GlossaryDeleteOptionsImpl;
import org.zanata.client.commands.glossary.pull.GlossaryPullOptionsImpl;
import org.zanata.client.commands.glossary.push.GlossaryPushOptionsImpl;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.commands.stats.GetStatisticsOptionsImpl;
import org.zanata.util.VersionUtility;

public class ZanataClient
extends BasicOptionsImpl {
    public static final String COMMAND_NAME = System.getProperty("app.name", "zanata-cli");
    public static final String COMMAND_DESCRIPTION = "Zanata Java command-line client";
    private boolean version;
    private final CmdLineParser parser = new CmdLineParser((Object)this);
    private final AppAbortStrategy abortStrategy;
    private final PrintWriter out;
    private final PrintWriter err;
    @Argument(handler=SubCommandHandler2.class, metaVar="<command>")
    @SubCommands(value={@SubCommand(name="help", impl=HelpOptions.class), @SubCommand(name="init", impl=InitOptionsImpl.class), @SubCommand(name="list-remote", impl=ListRemoteOptionsImpl.class), @SubCommand(name="pull", impl=PullOptionsImpl.class), @SubCommand(name="push", impl=PushOptionsImpl.class), @SubCommand(name="put-project", impl=PutProjectOptionsImpl.class), @SubCommand(name="put-user", impl=PutUserOptionsImpl.class), @SubCommand(name="put-version", impl=PutVersionOptionsImpl.class), @SubCommand(name="stats", impl=GetStatisticsOptionsImpl.class), @SubCommand(name="glossary-delete", impl=GlossaryDeleteOptionsImpl.class), @SubCommand(name="glossary-push", impl=GlossaryPushOptionsImpl.class), @SubCommand(name="glossary-pull", impl=GlossaryPullOptionsImpl.class)})
    private Object command;
    private static final String COMMAND_FIELD = "command";
    public static final ImmutableMap<String, Class<BasicOptions>> OPTIONS;

    public static void main(String[] args) {
        ZanataClient tool = new ZanataClient();
        tool.processArgs(args);
    }

    public ZanataCommand initCommand() {
        return null;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    ZanataClient() {
        this((AppAbortStrategy)new SystemExitStrategy(), new PrintWriter(System.out), new PrintWriter(System.err));
    }

    @Deprecated
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public ZanataClient(AppAbortStrategy strategy, PrintStream out, PrintStream err) {
        this(strategy, new PrintWriter(new OutputStreamWriter(out)), new PrintWriter(new OutputStreamWriter(err)));
    }

    public ZanataClient(AppAbortStrategy strategy, Writer out, Writer err) {
        this(strategy, new PrintWriter(out), new PrintWriter(err));
    }

    public ZanataClient(AppAbortStrategy strategy, PrintWriter out, PrintWriter err) {
        this.abortStrategy = strategy;
        this.out = out;
        this.err = err;
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processArgs(String ... args) {
        block18: {
            try {
                if (args.length == 2 && OPTIONS.containsKey((Object)args[0]) && (args[1].equals("--help") || args[1].equals("-h"))) {
                    String cmdName = args[0];
                    BasicOptions opts = (BasicOptions)((Class)OPTIONS.get((Object)cmdName)).newInstance();
                    new ArgsUtil(this.abortStrategy, opts).printHelp(this.out, this.getCommandName());
                    return;
                }
                this.parser.parseArgument(args);
                if (this.version) {
                    this.out.println(this.getCommandName());
                    VersionUtility.printVersions(ZanataClient.class, (PrintWriter)this.out);
                    break block18;
                }
                if (this.getHelp() || this.command == null) {
                    this.printHelp(this.out);
                    break block18;
                }
                if (this.command instanceof HelpOptions) {
                    HelpOptions helpCmd = (HelpOptions)this.command;
                    if (helpCmd.getCommand() == null) {
                        this.printHelp(this.out);
                    } else if (!OPTIONS.containsKey((Object)helpCmd.getCommand())) {
                        this.out.println("Error: Unknown command '" + helpCmd.getCommand() + "'");
                        this.printHelp(this.out);
                    } else {
                        String cmdName = helpCmd.getCommand();
                        BasicOptions opts = (BasicOptions)((Class)OPTIONS.get((Object)cmdName)).newInstance();
                        new ArgsUtil(this.abortStrategy, opts).printHelp(this.out, this.getCommandName());
                    }
                    break block18;
                }
                if (this.command instanceof BasicOptions) {
                    BasicOptions opts = (BasicOptions)this.command;
                    this.copyGlobalOptionsTo(opts);
                    new ArgsUtil(this.abortStrategy, opts).runCommand();
                    break block18;
                }
                throw new RuntimeException("unexpected command type");
            }
            catch (CmdLineException e) {
                String msg = e.getMessage();
                this.err.println(msg);
                this.printHelp(this.err);
                this.abortStrategy.abort(msg);
            }
            catch (AppAbortException e) {
                throw e;
            }
            catch (Exception e) {
                ArgsUtil.handleException((Exception)e, (boolean)this.getErrors(), (AppAbortStrategy)this.abortStrategy);
            }
            finally {
                this.out.flush();
                this.err.flush();
            }
        }
    }

    private void copyGlobalOptionsTo(BasicOptions options) {
        options.setDebug(this.getDebug());
        options.setErrors(this.getErrors());
        options.setHelp(this.getHelp());
        options.setInteractiveMode(this.isInteractiveMode());
        options.setQuiet(this.getQuiet());
    }

    private void printHelp(PrintWriter out) {
        out.print("Usage: " + this.getCommandName());
        this.parser.printSingleLineUsage((Writer)out, null);
        out.println();
        out.println();
        out.println(this.getCommandDescription());
        out.println();
        this.parser.printUsage((Writer)out, null);
        out.println();
        out.println("Type '" + this.getCommandName() + " help <command>' for help on a specific command.");
        out.println();
        out.println("Available commands:");
        for (String cmd : OPTIONS.keySet()) {
            out.println("  " + cmd);
        }
    }

    @Option(name="--version", aliases={"-v"}, usage="Output version information and exit")
    public void setVersion(boolean version) {
        this.version = version;
    }

    static {
        try {
            ImmutableMap.Builder m = ImmutableMap.builder();
            Field cmdField = ZanataClient.class.getDeclaredField(COMMAND_FIELD);
            SubCommands subCommands = cmdField.getAnnotation(SubCommands.class);
            for (SubCommand sub : subCommands.value()) {
                if (!BasicOptions.class.isAssignableFrom(sub.impl())) continue;
                Class clazz = sub.impl();
                m.put((Object)sub.name(), (Object)clazz);
            }
            OPTIONS = m.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

