START TRANSACTION;
INSERT INTO `users` (`userid`,`alias`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`lang`,`refresh`,`type`,`theme`,`rows_per_page`) values ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','en_GB','30s','3','default','50');
INSERT INTO `users` (`userid`,`alias`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`lang`,`refresh`,`type`,`theme`,`rows_per_page`) values ('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','en_GB','30s','1','default','50');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('1','Templates','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('2','Linux servers','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('4','Zabbix servers','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('5','Discovered hosts','1','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('6','Virtual machines','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('7','Hypervisors','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('8','Templates/Modules','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('9','Templates/Network devices','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('10','Templates/Operating systems','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('11','Templates/Server hardware','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('12','Templates/Applications','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('13','Templates/Databases','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('14','Templates/Virtualization','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('15','Templates/Telephony','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('16','Templates/SAN','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('17','Templates/Power','0','0');
INSERT INTO `drules` (`druleid`,`proxy_hostid`,`name`,`iprange`,`delay`,`status`) values ('2',NULL,'Local network','192.168.0.1-254','1h','1');
INSERT INTO `dchecks` (`dcheckid`,`druleid`,`type`,`key_`,`snmp_community`,`ports`,`snmpv3_securityname`,`snmpv3_securitylevel`,`snmpv3_authpassphrase`,`snmpv3_privpassphrase`,`uniq`,`snmpv3_authprotocol`,`snmpv3_privprotocol`,`snmpv3_contextname`,`host_source`,`name_source`) values ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','0','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('3','2','SMS','','','','','/dev/ttyS0','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('5','4','Mattermost','','','','','','','','0','25','0','0','0','0','','1','1','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SEND_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(mattermost_url, team_name, postid) {\r\n    return \'{0}/{1}/pl/{2}\'.format(\r\n        mattermost_url.replace(/\\/+$/, \'\'),\r\n        team_name,\r\n        postid\r\n    );\r\n}\r\n\r\nfunction getChannel(send_to) {\r\n    switch (true) {\r\n        case /.+\\/#.+/.test(send_to):\r\n            return getChannelByName(send_to);\r\n\r\n        case /@.+/.test(send_to):\r\n            return getDirectChannel(send_to);\r\n\r\n        default:\r\n            return getChannelByID(send_to);\r\n    }\r\n}\r\n\r\nfunction getChannelByName(send_to) {\r\n    var team_chan = send_to\r\n        .trim()\r\n        .split(\'/#\');\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getDirectChannel(send_to) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var teamUser = send_to\r\n            .trim()\r\n            .split(\'/@\'),\r\n        bot = getBotUser(),\r\n        user = getUserByName(teamUser[1]);\r\n\r\n    var resp = JSON.parse(req.Post(\r\n        Mattermost.direct_channel,\r\n        JSON.stringify([bot.id, user.id])\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 201) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    resp.team_name = teamUser[0];\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getChannelByID(channelID) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.get_channel.format(channelID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getBotUser() {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.bot_user,\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getUserByName(userName) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.user_byname.format(userName),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getTeamByID(teamID) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.get_team.format(teamID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction getTagValue(event_tags, key) {\r\n    var pattern = new RegExp(\'(\' + key + \':.+)\');\r\n    var tagValue = event_tags\r\n        .split(\',\')\r\n        .filter(function (v) {\r\n            return v.match(pattern);\r\n        })\r\n        .map(function (v) {\r\n            return v.split(\':\')[1];\r\n        })[0]\r\n        || 0;\r\n\r\n    return tagValue;\r\n}\r\n\r\nfunction handlerAlarm(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(\r\n            Mattermost.post_message,\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_post_id = resp.id;\r\n        result.tags.__mattermost_channel_id = channel.id;\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.root_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        if (params.event_source === \'0\') {}\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(\r\n            Mattermost.post_message, JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.channel_id = getTagValue(params.event_tags, \'mattermost_channel_id\');\r\n        fields.id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var post_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        resp = JSON.parse(req.Put(\r\n            Mattermost.chat_update.format(post_id),\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.Status() != 200) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort\r\n) {\r\n    var message = {\r\n        fallbac: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        footer: problem_url,\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_ip),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    \r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort && params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: \'`{0}`\'.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, \'\') || \'None\'),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.send_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_ip !== \'string\' || params.host_ip.trim() === \'\') {\r\n        throw \'Field "host_ip" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.mattermost_url !== \'string\' || params.mattermost_url.trim() === \'\') {\r\n        throw \'Field "mattermost_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.mattermost_url)) {\r\n        throw \'Field "mattermost_url" must contain a schema\';\r\n    }\r\n\r\n    if ([\'alarm\', \'event\'].indexOf(params.send_mode) === -1) {\r\n        throw \'Incorrect "send_mode" parameter given: \' + params.send_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (typeof params.send_to !== \'string\' || params.send_to.trim() === \'\') {\r\n        throw \'Field "send_to" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new CurlHttpRequest(),\r\n        fields = {},\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.AddHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.AddHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    params.mattermost_url = params.mattermost_url.replace(/\\/+$/, \'\');\r\n    params.zabbix_url = params.zabbix_url.replace(/\\/+$/, \'\');\r\n\r\n    var APIEndpoint = params.mattermost_url + \'/api/v4/\';\r\n\r\n    var Mattermost = {\r\n        post_message: APIEndpoint + \'posts\',\r\n        get_channel: APIEndpoint + \'channels/{0}\',\r\n        get_team: APIEndpoint + \'teams/{0}\',\r\n        chat_update: APIEndpoint + \'posts/{0}\',\r\n        direct_channel: APIEndpoint + \'channels/direct\',\r\n        channel_byname: APIEndpoint + \'teams/name/{0}/channels/name/{1}\',\r\n        user_byname: APIEndpoint + \'users/username/{0}\',\r\n        bot_user: APIEndpoint + \'users/me\'\r\n\r\n    };\r\n\r\n    params.send_mode = params.send_mode.toLowerCase();\r\n    params.send_mode = params.send_mode in SEND_MODE_HANDLERS\r\n        ? params.send_mode\r\n        : \'alarm\';\r\n\r\n    SEND_MODE_HANDLERS[params.send_mode](req, params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ Mattermost Webhook ] Mattermost notification failed: \' + error);\r\n    throw \'Mattermost notification failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('6','4','Opsgenie','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n        Media.params.web += Media.params.web.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n                && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag === \'string\') {\r\n                        label = (tag.tag + (typeof tag.value !== \'undefined\'\r\n                                && tag.value !== \'\' ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        Media.labels.push(label);\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse "event_tags_json" param\');\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data, allow_404) {\r\n        if (typeof(allow_404) === \'undefined\') {\r\n            allow_404 = false;\r\n        }\r\n\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: \' + Media.params.token);\r\n        request.SetProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if ((request.Status() < 200 || request.Status() >= 300)\r\n                && (!allow_404 || request.Status() !== 404)) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getAlertId: function (requestId) {\r\n        do {\r\n            resp = Media.request(\'get\', \'requests/\' + requestId, undefined, true);\r\n        }\r\n        while (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\'\r\n                || resp.response.data.success === false);\r\n\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\') {\r\n            throw \'Cannot get \' + Media.name + \' issue ID. Check debug log for more information.\';\r\n        }\r\n\r\n        return resp;\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        responders = [],\r\n        tags = [],\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'opsgenie_api\',\r\n            \'opsgenie_web\',\r\n            \'opsgenie_token\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'opsgenie_\')) {\r\n                media[key.substring(9)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'Opsgenie\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'GenieKey \' + Media.params.token;\r\n    Media.setProxy(params.HTTPProxy);\r\n    Media.setTags(params.event_tags_json); // Set Media.labels\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        fields.message = params.alert_subject;\r\n        fields.alias = params.event_id;\r\n        fields.description = params.alert_message;\r\n        fields.priority = priority;\r\n        fields.source = \'Zabbix\';\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.details = {\r\n                \'Zabbix server\': params.zbxurl,\r\n                Problem: params.zbxurl + \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id\r\n            };\r\n        }\r\n        else {\r\n            fields.details = {\'Zabbix server\': params.zbxurl};\r\n        }\r\n\r\n        if (typeof params.opsgenie_teams === \'string\') {\r\n            responders = params.opsgenie_teams.split(\',\');\r\n            fields.responders = responders.map(function(team) {\r\n                return {type: \'team\', name: team.trim()};\r\n            });\r\n        }\r\n\r\n        fields.tags = Media.labels;\r\n        if (typeof params.opsgenie_tags === \'string\') {\r\n            tags = params.opsgenie_tags.split(\',\');\r\n            tags.forEach(function(item) {\r\n                fields.tags.push(item.trim());\r\n            });\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;\r\n                result.tags.__zbx_ops_issuelink = Media.params.web + \'alert/detail/\' + resp.response.data.alertId;\r\n            }\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        fields.user = (params.event_value != 0) ? params.zbxuser : \'\';\r\n        fields.note = params.alert_message;\r\n\r\n        resp = Media.request(\'post\', params.event_id + \'/notes?identifierType=alias\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/5.0/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd dedicated user with media type "Opsgenie".\r\nChange the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),\r\nopsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('7','4','PagerDuty','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','try {\r\n\r\n    var params = JSON.parse(value),\r\n        req = new CurlHttpRequest(),\r\n        fields = {},\r\n        resp = \'\';\r\n\r\n    // Correspondence between the PagerDuty and Zabbix severity level\r\n    var severityMapping = [\r\n        \'info\',    // Not classified\r\n        \'info\',    // Information\r\n        \'warning\', // Warning\r\n        \'warning\', // Average\r\n        \'error\',   // High\r\n        \'critical\' // Disaster\r\n    ];\r\n\r\n    if (!severityMapping[params.severity]) {\r\n        params.severity = \'0\';\r\n    }\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (isNaN(parseInt(params.eventid)) || params.eventid < 1) {\r\n        throw \'incorrect value for variable "eventid". The value must be a positive number.\';\r\n    }\r\n    if (params.eventname.length < 1) {\r\n        throw \'incorrect value for variable "eventname". The value must be a non-empty string.\';\r\n    }\r\n    if (isNaN(parseInt(params.severity)) || (params.severity < 0 && params.severity > 5)) {\r\n        throw \'incorrect value for variable "severity". The value must be a number 0..5.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.eventvalue !== \'0\' && params.eventvalue !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "eventvalue" parameter given: "\' + params.eventvalue + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        if (params.hostname.length < 1) {\r\n            throw \'incorrect value for variable "hostname". The value must be a non-empty string.\';\r\n        }\r\n        if (isNaN(parseInt(params.triggerid)) || params.triggerid < 1) {\r\n            throw \'incorrect value for variable "triggerid". The value must be a positive number.\';\r\n        }\r\n        if (params.eventack != \'Yes\' && params.eventack != \'No\') {\r\n            throw \'incorrect value for variable "eventack". The value must be Yes or No.\';\r\n        }\r\n        if (isNaN(parseInt(params.eventupdate)) || (params.eventupdate < 0 || params.eventupdate > 1)) {\r\n            throw \'incorrect value for variable "eventupdate". The value must be 0 or 1.\';\r\n        }\r\n    }\r\n\r\n\r\n\r\n    req.AddHeader(\'Content-Type: application/json\');\r\n\r\n    fields.routing_key = params.token;\r\n    fields.dedup_key = params.eventid;\r\n\r\n    if (((params.eventvalue == 1) && (params.eventupdate == 0)) || params.event_source !== \'0\') {\r\n        fields.event_action = \'trigger\';\r\n        fields.payload = {\r\n            summary: params.eventname,\r\n            source: (params.event_source === \'1\') ? \'Discovery\' : params.hostname + \' : \' + params.hostip,\r\n            severity: severityMapping[params.severity],\r\n        };\r\n        \r\n        if (params.event_source === \'0\') {\r\n            fields.payload.custom_details = {\r\n                \'Event date\': params.eventdate,\r\n                \'Event time\': params.eventtime,\r\n                \'Trigger description\': params.triggerdesc,\r\n                \'Trigger opdata\': params.triggeropdata,\r\n                \'Event tags\': params.eventtags,\r\n                \'Event host\': params.hostname,\r\n                \'Event host ip\': params.hostip\r\n            };\r\n            fields.links = [{\r\n                href: params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid,\r\n                text: \'Event link\'\r\n            }];\r\n        }\r\n        else {\r\n            fields.payload.custom_details = {\r\n                \'Alert message\': params.alert_message\r\n            };\r\n        }\r\n\r\n        fields.client = \'Zabbix\';\r\n        fields.client_url = params.url;\r\n    }\r\n    else if ((params.eventvalue == 1) && (params.eventupdate == 1) && (params.eventack == \'Yes\'))\r\n        fields.event_action = \'acknowledge\';\r\n    else if (params.eventvalue == 0)\r\n        fields.event_action = \'resolve\';\r\n    else\r\n        throw \'incorrect values. Update message without ack will not be sent.\';\r\n\r\n    Zabbix.Log(4, \'[PagerDuty Webhook] Sending request:\' + JSON.stringify(fields));\r\n    resp = req.Post(\'https://events.pagerduty.com/v2/enqueue\',\r\n        JSON.stringify(fields)\r\n    );\r\n    Zabbix.Log(4, \'[PagerDuty Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. PagerDuty returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.Status() != 202) {\r\n        if (typeof resp === \'object\' && typeof resp.errors === \'object\' && typeof resp.errors[0] === \'string\') {\r\n            throw resp.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error.\';\r\n        }\r\n    }\r\n\r\n    if (resp.status != \'success\') {\r\n        throw \'Unknown error.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[PagerDuty Webhook] Notification failed : \' + error);\r\n    throw \'PagerDuty notification failed : \' + error;\r\n}','30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/5.0/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "PagerDuty" and place the integration key in the "token" parameter to integrate into the service.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('8','4','Pushover','','','','','','','','0','25','0','0','0','0','','0','3','10s','1','try {\r\n    var params = JSON.parse(value),\r\n        request = new CurlHttpRequest(),\r\n        data,\r\n        response,\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    if (isNaN(priority) || priority < -2 || priority > 2) {\r\n        throw \'"priority" should be -2..2\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && isNaN(params.triggerid)) {\r\n        throw \'field "triggerid" is not a number\';\r\n    }\r\n\r\n    if (isNaN(params.eventid)) {\r\n        throw \'field "eventid" is not a number\';\r\n    }\r\n\r\n    if (typeof params.message !== \'string\' || params.message.trim() === \'\') {\r\n        throw \'field "message" cannot be empty\';\r\n    }\r\n\r\n    data = {\r\n        token: params.token,\r\n        user: params.user,\r\n        title: params.title,\r\n        message: params.message,\r\n        url: (params.event_source === \'0\') \r\n            ? params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid\r\n            : params.url,\r\n        url_title: params.url_title,\r\n        priority: priority\r\n    };\r\n\r\n    if (priority == 2) {\r\n        if (isNaN(params.retry) || params.retry < 30) {\r\n            throw \'field "retry" should be a number with value of at least 30 if "priority" is set to 2\';\r\n        }\r\n\r\n        if (isNaN(params.expire) || params.expire > 10800) {\r\n            throw \'field "expire" should be a number with value of at most 10800 if "priority" is set to 2\';\r\n        }\r\n\r\n        data.retry = params.retry;\r\n        data.expire = params.expire;\r\n    }\r\n\r\n    data = JSON.stringify(data);\r\n    Zabbix.Log(4, \'[ Pushover Webhook ] Sending request: \' + params.endpoint + \'\\n\' + data);\r\n\r\n    request.AddHeader(\'Content-Type: application/json\');\r\n    response = request.Post(params.endpoint, data);\r\n\r\n    Zabbix.Log(4, \'[ Pushover Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n    if (response !== null) {\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ Pushover Webhook ] Failed to parse response received from Pushover\');\r\n            response = null;\r\n        }\r\n    }\r\n\r\n    if (request.Status() != 200 || response === null || typeof response !== \'object\' || response.status !== 1) {\r\n        if (response !== null && typeof response === \'object\' && typeof response.errors === \'object\'\r\n                && typeof response.errors[0] === \'string\') {\r\n            throw response.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ Pushover Webhook ] Pushover notification failed: \' + error);\r\n    throw \'Pushover notification failed: \' + error;\r\n}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover\r\n\r\nSet token parameter with to your Pushover application key.\r\nWhen assigning Pushover media to the Zabbix user - add user key into send to field.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('9','4','Slack','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SLACK_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(channelId, messageTimestamp) {\r\n    var req = new CurlHttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.AddHeader(\'Content-Type: application/x-www-form-urlencoded; charset=utf-8\');\r\n    req.AddHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    var query = \'{0}?channel={1}&message_ts={2}\'.format(\r\n            Slack.getPermalink,\r\n            encodeURIComponent(channelId),\r\n            encodeURIComponent(messageTimestamp)),\r\n        resp = JSON.parse(req.Get(query));\r\n\r\n    if (req.Status() != 200 || !resp.ok || resp.ok === \'false\') {\r\n        throw \'message was created, but getting message link was failed with reason "\' + resp.error + \'"\';\r\n    }\r\n\r\n    return resp.permalink;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction handlerAlarm(params) {\r\n    var fields = {\r\n        channel: params.channel,\r\n        as_user: params.slack_as_user,\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n        result.tags.__message_ts = resp.ts;\r\n        result.tags.__channel_id = resp.channel;\r\n        result.tags.__channel_name = params.channel;\r\n        result.tags.__message_link = getPermalink(resp.channel, resp.ts);\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.thread_ts = params.message_ts;\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n        if (req.Status() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.channel = params.channel_id;\r\n        fields.text = \'\';\r\n        fields.ts = params.message_ts;\r\n        fields.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.chatUpdate, JSON.stringify(fields)));\r\n        if (req.Status() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(params) {\r\n    var fields = {\r\n        channel: params.channel,\r\n        as_user: params.slack_as_user\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n        result.tags.__channel_name = params.channel;\r\n        result.tags.__message_link = getPermalink(resp.channel, resp.ts);\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort,\r\n    messageText\r\n) {\r\n    var message = {\r\n        fallback: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        pretext: messageText || \'\',\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_conn),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort  && params.event_source === \'0\') {\r\n        message[\'actions\'] = [\r\n            {\r\n                type: \'button\',\r\n                text: \'Open in Zabbix\',\r\n                url: problem_url\r\n            }\r\n        ];\r\n\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: params.event_tags.replace(/__.+?:(.+?,|.+)/g, \'\') || \'None\',\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.channel !== \'string\' || params.channel.trim() === \'\') {\r\n        throw \'Field "channel" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.slack_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if (!~[0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity))) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_conn !== \'string\' || params.host_conn.trim() === \'\') {\r\n        throw \'Field "host_conn" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (!~[\'true\', \'false\'].indexOf(params.slack_as_user.toLowerCase())) {\r\n        throw \'Incorrect "slack_as_user" parameter given: \' + params.slack_as_user + \'\\nMust be "true" or "false".\';\r\n    }\r\n\r\n    if (!~[\'alarm\', \'event\'].indexOf(params.slack_mode)) {\r\n        throw \'Incorrect "slack_mode" parameter given: \' + params.slack_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new CurlHttpRequest(),\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.AddHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.AddHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    var slack_endpoint = \'https://slack.com/api/\';\r\n\r\n    var Slack = {\r\n        postMessage: slack_endpoint + \'chat.postMessage\',\r\n        getPermalink: slack_endpoint + \'chat.getPermalink\',\r\n        chatUpdate: slack_endpoint + \'chat.update\'\r\n    };\r\n\r\n    params.slack_mode = params.slack_mode.toLowerCase();\r\n    params.slack_mode = params.slack_mode in SLACK_MODE_HANDLERS\r\n        ? params.slack_mode\r\n        : \'alarm\';\r\n\r\n    SLACK_MODE_HANDLERS[params.slack_mode](params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ Slack Webhook ] Slack notification failed : \' + error);\r\n    throw \'Slack notification failed : \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__message_link}','Open in Slack: {EVENT.TAGS.__channel_name}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('10','4','Discord','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', // Not classified.\r\n    \'#7499FF\', // Information.\r\n    \'#FFC859\', // Warning.\r\n    \'#FFA059\', // Average.\r\n    \'#E97659\', // High.\r\n    \'#E45959\', // Disaster.\r\n    \'#009900\'  // Resolved.\r\n];\r\n\r\nfunction stringTruncate(str, len) {\r\n    return str.length > len ? str.substring(0, len - 3) + \'...\' : str;\r\n}\r\n\r\ntry {\r\n    Zabbix.Log(4, \'[ Discord Webhook ] Executed with params: \' + value);\r\n\r\n    var params = JSON.parse(value);\r\n\r\n    if (!params.discord_endpoint) {\r\n        throw \'Cannot get discord_endpoint\';\r\n    }\r\n    else {\r\n        params.discord_endpoint = params.discord_endpoint.replace(\'/api/\', \'/api/v7/\') + \'?wait=True\';\r\n    }\r\n\r\n    params.zabbix_url = (params.zabbix_url.endsWith(\'/\'))\r\n        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Set params to true for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: "\' + params.event_value + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: "\' + params.event_update_status + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value == 0) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (!SEVERITY_COLORS[params.event_nseverity]) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    var color = parseInt(SEVERITY_COLORS[params.event_nseverity].replace(\'#\', \'\'), 16),\r\n        fields = [],\r\n        body = {\r\n            embeds: [\r\n                {\r\n                    color: color || 0,\r\n                    url: (params.event_source === \'0\')\r\n                        ? params.zabbix_url + \'/tr_events.php?triggerid=\' + params.trigger_id +\r\n                            \'&eventid=\' + params.event_id\r\n                        : params.zabbix_url\r\n                }\r\n            ]\r\n        };\r\n\r\n    // Default message from {ALERT.MESSAGE}.\r\n    if (params.use_default_message.toLowerCase() == \'true\') {\r\n        body.embeds[0].title = stringTruncate(params.alert_subject, 256);\r\n        body.embeds[0].description = stringTruncate(params.alert_message, 2048);\r\n    }\r\n    else {\r\n        fields.push(\r\n            {\r\n                name: \'Host\',\r\n                value: params.host_name + \' [\' + params.host_ip + \']\'\r\n            }\r\n        );\r\n\r\n        // Resolved message.\r\n        if (params.event_value == 0 && params.event_update_status == 0) {\r\n            body.embeds[0].title = stringTruncate(\'OK: \' + params.event_name, 256);\r\n            fields.push(\r\n                {\r\n                    name: \'Recovery time\',\r\n                    value: params.event_recovery_time + \' \' + params.event_recovery_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        // Problem message.\r\n        else if (params.event_value == 1 && params.event_update_status == 0) {\r\n            body.embeds[0].title = stringTruncate(\'PROBLEM: \' + params.event_name, 256);\r\n            fields.push(\r\n                {\r\n                    name: \'Event time\',\r\n                    value: params.event_time + \' \' + params.event_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        // Update message.\r\n        else if (params.event_update_status == 1) {\r\n            body.embeds[0].title = stringTruncate(\'UPDATE: \' + params.event_name, 256);\r\n            body.embeds[0].description = params.event_update_user + \' \' + params.event_update_action + \'.\';\r\n\r\n            if (params.event_update_message) {\r\n                body.embeds[0].description += \' Comment:\\n>>> \' + params.event_update_message;\r\n            }\r\n\r\n            body.embeds[0].description = stringTruncate(body.embeds[0].description, 2048);\r\n\r\n            fields.push(\r\n                {\r\n                    name: \'Event update time\',\r\n                    value: params.event_update_time + \' \' + params.event_update_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        fields.push(\r\n            {\r\n                name: \'Severity\',\r\n                value: params.event_severity,\r\n                inline: \'True\'\r\n            }\r\n        );\r\n\r\n        if (params.event_opdata) {\r\n            fields.push(\r\n                {\r\n                    name: \'Operational data\',\r\n                    value: stringTruncate(params.event_opdata, 1024),\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        if (params.event_value == 1 && params.event_update_status == 0 && params.trigger_description) {\r\n            fields.push(\r\n                {\r\n                    name: \'Trigger description\',\r\n                    value: stringTruncate(params.trigger_description, 1024)\r\n                }\r\n            );\r\n        }\r\n\r\n        body.embeds[0].footer = {\r\n            text: \'Event ID: \' + params.event_id\r\n        };\r\n\r\n        if (params.event_tags) {\r\n            body.embeds[0].footer.text += \'\\nEvent tags: \' + params.event_tags;\r\n        }\r\n        body.embeds[0].footer.text = stringTruncate(body.embeds[0].footer.text, 2048);\r\n    }\r\n\r\n    if (fields.length > 0) {\r\n        body.embeds[0].fields = fields;\r\n    }\r\n\r\n    var req = new CurlHttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.AddHeader(\'Content-Type: application/json\');\r\n\r\n    var resp = req.Post(params.discord_endpoint, JSON.stringify(body)),\r\n        data = JSON.parse(resp);\r\n\r\n    Zabbix.Log(4, \'[ Discord Webhook ] JSON: \' + JSON.stringify(body));\r\n    Zabbix.Log(4, \'[ Discord Webhook ] Response: \' + resp);\r\n\r\n    if (data.id) {\r\n        return resp;\r\n    }\r\n    else {\r\n        var message = ((typeof data.message === \'string\') ? data.message : \'Unknown error\');\r\n\r\n        Zabbix.Log(3, \'[ Discord Webhook ] FAILED with response: \' + resp);\r\n        throw message + \'. For more details check zabbix server log.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Discord Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('11','4','SIGNL4','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','// SIGNL4 Webhook\r\ntry {\r\n    var response,\r\n        payload,\r\n        params = JSON.parse(value),\r\n        endpoint = \'https://connect.signl4.com/webhook/\',\r\n        request = new CurlHttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (typeof params.teamsecret === \'string\' && params.teamsecret.trim() !== \'\') {\r\n        endpoint += params.teamsecret;\r\n        delete params.teamsecret;\r\n    }\r\n    else {\r\n        throw \'The team secret of your SIGNL4 team cannot be empty.\';\r\n    }\r\n\r\n    if (typeof params.Severity === \'string\' && params.Severity === \'{EVENT.SEVERITY}\') {\r\n        params.Severity = \'Not classified\';\r\n    }\r\n\r\nif (typeof params.User === \'string\' && params.User === \'{USER.FULLNAME}\') {\r\n        params.User = \'\';\r\n    }\r\n\r\nif (typeof params.Event_Update_Action === \'string\' && params.Event_Update_Action === \'{EVENT.UPDATE.ACTION}\') {\r\n        params.Event_Update_Action = \'\';\r\n    }\r\n\r\n// Assemble X-S4-ExternalID for two-way integration\r\n// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"\r\nparams[\'X-S4-ExternalID\'] = \'ZabbixEventID: \' + params.Event_ID;\r\nif (typeof params.Zabbix_URL === \'string\' && params.Zabbix_URL.indexOf(\'http\') == 0) {\r\n// Make sure the URL ends with \'/\'\r\nif (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != \'/\') {\r\nparams.Zabbix_URL = params.Zabbix_URL + \'/\';\r\n}\r\n\r\nparams[\'X-S4-ExternalID\'] = params[\'X-S4-ExternalID\'] + \' ZabbixURL: \' +  params.Zabbix_URL;\r\n\r\n// Add Link parameter\r\nparams[\'Link\'] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;\r\n}\r\n\r\n// Check if this is a new problem or a recovery\r\nif (params.Trigger_Status == \'OK\') {\r\nparams[\'X-S4-Status\'] = \'resolved\';\r\n}\r\nelse {\r\nparams[\'X-S4-Status\'] = \'new\';\r\n}\r\n\r\n    payload = JSON.stringify(params);\r\n    Zabbix.Log(4, \'[ SIGNL4 Webhook ] Sending request: \' + payload);\r\n\r\n    request.AddHeader(\'Content-Type: application/json\');\r\n    response = request.Post(endpoint, \'payload=\' + payload);\r\n\r\n    Zabbix.Log(4, \'[ SIGNL4 Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response\r\n    );\r\n\r\n    if (request.Status() !== 201) {\r\n        throw \'Request failed with status code \' + request.Status() +\r\n                \'. Check debug log for more information.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ SIGNL4 Webhook ] ERROR: \' + error);\r\n\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.\r\n\r\nGet the app at https://www.signl4.com.\r\n\r\nFind out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/\r\n');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('12','4','Jira','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/api/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\'\r\n                        && !tag.tag.startsWith(\'__zbx\')) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 256) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    escapeMarkup: function (str) {\r\n        var length = str.length,\r\n            result = \'\',\r\n            markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n        for (var i = 0; i < length; i++) {\r\n            var char = str[i];\r\n\r\n            result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n        }\r\n\r\n        return result;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Jira.getSchema(),\r\n                path = [\'projects\', 0, \'issuetypes\', 0, \'fields\'],\r\n                field;\r\n\r\n            while ((field = path.shift()) !== undefined) {\r\n                schema = schema[field];\r\n                if (typeof schema === \'undefined\') {\r\n                    schema = null;\r\n                    break;\r\n                }\r\n            }\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        if (typeof schema[field] === \'object\' && typeof schema[field].schema === \'object\') {\r\n                            switch (schema[field].schema.type) {\r\n                                case \'number\':\r\n                                    data.fields[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    break;\r\n\r\n                                case \'option\':\r\n                                    data.fields[field] = {value: fields[field]};\r\n                                    break;\r\n\r\n                                case \'array\':\r\n                                    if (schema[field].schema.items === \'option\') {\r\n                                        data.fields[field] = [{value: fields[field]}];\r\n                                    }\r\n                                    else {\r\n                                        data.fields[field] = [fields[field]];\r\n                                    }\r\n                                    break;\r\n\r\n                                default:\r\n                                    data.fields[field] = fields[field];\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'project_key\', \'issue_type\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.SetProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'issue/createmeta?expand=projects.issuetypes.fields&projectKeys=\' +\r\n            encodeURIComponent(Jira.params.project_key) + \'&issuetypeNames=\' +\r\n            encodeURIComponent(Jira.params.issue_type));\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(summary, description, fields) {\r\n        var data = {\r\n            fields: {\r\n                project: {\r\n                    key: Jira.params.project_key\r\n                },\r\n                issuetype: {\r\n                    name: Jira.params.issue_type\r\n                },\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.fields.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'issue\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.key === \'undefined\') {\r\n            throw \'Cannot create Jira issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.key;\r\n    },\r\n\r\n    updateIssue: function(summary, fields, update) {\r\n        var data = {fields: {}};\r\n\r\n        if (summary) {\r\n            data.fields.summary = summary;\r\n        }\r\n\r\n        Jira.request(\'put\', \'issue/\' + encodeURIComponent(Jira.params.issue_key), Jira.addCustomFields(data, fields));\r\n        Jira.commentIssue(update);\r\n    },\r\n\r\n    commentIssue: function(update) {\r\n        var data = {};\r\n\r\n        if (typeof update === \'string\') {\r\n            data.body = update;\r\n            Jira.request(\'post\', \'issue/\' + encodeURIComponent(Jira.params.issue_key) + \'/comment\', data);\r\n        }\r\n        else if (update.status === \'1\') {\r\n            data.body = update.user + \' \' + update.action + \'.\';\r\n\r\n            if (update.message) {\r\n                data.body += \'\\nMessage: {quote}\' + Jira.escapeMarkup(update.message) + \'{quote}\';\r\n            }\r\n\r\n            Jira.request(\'post\', \'issue/\' + encodeURIComponent(Jira.params.issue_key) + \'/comment\', data);\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'summary\', \'event_recovery_value\', \'event_source\', \'event_value\'];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createIssue(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\' && !jira.issue_key.startsWith(jira.project_key)) {\r\n        var key = Jira.createIssue(params.alert_subject,\r\n            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);\r\n\r\n\r\n        result.tags.__zbx_jira_issuekey = key;\r\n        result.tags.__zbx_jira_issuelink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (!jira.issue_key.startsWith(jira.project_key)) {\r\n            throw \'Incorrect Issue key given: \' + jira.issue_key;\r\n        }\r\n        Jira.updateIssue(params.alert_subject, fields,\r\n            ((params.event_value === \'0\' && !Object.keys(fields).length)\r\n                ? params.alert_message : update));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Jira Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('13','4','Jira with CustomFields','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/api/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' ) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 256) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    escapeMarkup: function (str) {\r\n        var length = str.length,\r\n            result = \'\',\r\n            markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n        for (var i = 0; i < length; i++) {\r\n            var char = str[i];\r\n\r\n            result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n        }\r\n\r\n        return result;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Jira.getSchema(),\r\n                path = [\'projects\', 0, \'issuetypes\', 0, \'fields\'],\r\n                field;\r\n\r\n            while ((field = path.shift()) !== undefined) {\r\n                schema = schema[field];\r\n                if (typeof schema === \'undefined\') {\r\n                    schema = null;\r\n                    break;\r\n                }\r\n            }\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        data.fields[field] = fields[field];\r\n\r\n                        if (typeof schema[field] === \'object\' && typeof schema[field].schema === \'object\'\r\n                            && (schema[field].schema.type === \'number\' || schema[field].schema.type === \'datetime\')) {\r\n                            switch (schema[field].schema.type) {\r\n                                case \'number\':\r\n                                    data.fields[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    else {\r\n                                        delete data.fields[field];\r\n                                    }\r\n                                    break;\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'project_key\', \'issue_type\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.SetProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'issue/createmeta?expand=projects.issuetypes.fields&projectKeys=\' +\r\n                Jira.params.project_key + \'&issuetypeNames=\' + Jira.params.issue_type);\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(summary, description, fields) {\r\n        var data = {\r\n            fields: {\r\n                project: {\r\n                    key: Jira.params.project_key\r\n                },\r\n                issuetype: {\r\n                    name: Jira.params.issue_type\r\n                },\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.fields.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'issue\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.key === \'undefined\') {\r\n            throw \'Cannot create Jira issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.key;\r\n    },\r\n\r\n    updateIssue: function(summary, fields, update) {\r\n        var data = {fields: {}};\r\n\r\n        if (summary) {\r\n            data.fields.summary = summary;\r\n        }\r\n\r\n        Jira.request(\'put\', \'issue/\' + Jira.params.issue_key, Jira.addCustomFields(data, fields));\r\n        Jira.commentIssue(update);\r\n    },\r\n\r\n    commentIssue: function(update) {\r\n        var data = {};\r\n\r\n        if (typeof update === \'string\') {\r\n            data.body = update;\r\n            Jira.request(\'post\', \'issue/\' + Jira.params.issue_key + \'/comment\', data);\r\n        }\r\n        else if (update.status === \'1\') {\r\n            data.body = update.user + \' \' + update.action + \'.\';\r\n\r\n            if (update.message) {\r\n                data.body += \'\\nMessage: {quote}\' + Jira.escapeMarkup(update.message) + \'{quote}\';\r\n            }\r\n\r\n            Jira.request(\'post\', \'issue/\' + Jira.params.issue_key + \'/comment\', data);\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'summary\', \'event_recovery_value\', \'event_source\', \'event_value\'];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createIssue(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\' && !jira.issue_key.startsWith(jira.project_key)) {\r\n        var key = Jira.createIssue(params.alert_subject,\r\n            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);\r\n\r\n\r\n        result.tags.__zbx_jira_issuekey = key;\r\n        result.tags.__zbx_jira_issuelink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (!jira.issue_key.startsWith(jira.project_key)) {\r\n            throw \'Incorrect Issue key given: \' + jira.issue_key;\r\n        }\r\n        Jira.updateIssue(params.alert_subject, fields,\r\n            ((params.event_value === \'0\' && !Object.keys(fields).length)\r\n                ? params.alert_message : update));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Jira Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('14','4','MS Teams','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', // Not classified.\r\n    \'#7499FF\', // Information.\r\n    \'#FFC859\', // Warning.\r\n    \'#FFA059\', // Average.\r\n    \'#E97659\', // High.\r\n    \'#E45959\', // Disaster.\r\n    \'#009900\', // Resolved.\r\n    \'#000000\'  // Default.\r\n];\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    if (typeof params.teams_endpoint !== \'string\' || params.teams_endpoint.trim() === \'\') {\r\n        throw \'Cannot get teams_endpoint\';\r\n    }\r\n    else if (!params.teams_endpoint.startsWith(\'http\')) {\r\n        throw \'Invalid MS Teams webhook URL: \' + params.teams_endpoint;\r\n    }\r\n\r\n    params.zabbix_url = (params.zabbix_url.endsWith(\'/\'))\r\n        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Set "use_default_message" to true for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: "\' + params.event_value + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: "\' + params.event_update_status + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value == 0) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (!SEVERITY_COLORS[params.event_nseverity]) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    var request = new CurlHttpRequest(),\r\n        facts = [],\r\n        body = {\r\n            themeColor: SEVERITY_COLORS[params.event_nseverity].replace(\'#\', \'\'),\r\n            summary: \'Zabbix\',\r\n            sections: [\r\n                {\r\n                    markdown: \'false\',\r\n                    activityTitle: params.alert_subject,\r\n                    activitySubtitle: \'On \' + params.host_name + \' [\' + params.host_ip + \']\',\r\n                    text: (params.use_default_message.toLowerCase() == \'true\')\r\n                        ? params.alert_message\r\n                        : params.trigger_description\r\n                }\r\n            ],\r\n            potentialAction: [\r\n                {\r\n                    \'@type\': \'OpenUri\',\r\n                    name: (params.event_source === \'0\')\r\n                        ? \'Event Info\'\r\n                        : \'Zabbix Home\',\r\n                    targets: [\r\n                        {\r\n                            os: \'default\',\r\n                            uri: (params.event_source === \'0\')\r\n                                ? params.zabbix_url + \'/tr_events.php?triggerid=\' +\r\n                                    params.trigger_id + \'&eventid=\' + params.event_id\r\n                                : params.zabbix_url\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        };\r\n\r\n    if (params.use_default_message.toLowerCase() !== \'true\') {\r\n        // Problem message.\r\n        if (params.event_value === \'1\' && params.event_update_status === \'0\') {\r\n            facts.push({\r\n                name: \'Event time\',\r\n                value: params.event_time + \' \' + params.event_date\r\n            });\r\n        }\r\n        // Update message.\r\n        else if (params.event_update_status === \'1\') {\r\n            body.sections[0].text = params.event_update_user + \' \' + params.event_update_action + \'.\';\r\n\r\n            if (params.event_update_message) {\r\n                body.sections[0].text += \'<br>Message:<br>\' + params.event_update_message;\r\n            }\r\n\r\n            facts.push({\r\n                name: \'Event update time\',\r\n                value: params.event_update_time + \' \' + params.event_update_date\r\n            });\r\n        }\r\n        // Resolved message.\r\n        else {\r\n            facts.push({\r\n                name: \'Recovery time\',\r\n                value: params.event_recovery_time + \' \' + params.event_recovery_date\r\n            });\r\n        }\r\n\r\n        if (params.event_severity && params.event_severity !== \'{EVENT.SEVERITY}\') {\r\n            facts.push({\r\n                name: \'Severity\',\r\n                value: params.event_severity\r\n            });\r\n        }\r\n\r\n\r\n        if (params.event_opdata && params.event_opdata !== \'{EVENT.OPDATA}\') {\r\n            facts.push({\r\n                name: \'Operational data\',\r\n                value: params.event_opdata\r\n            });\r\n        }\r\n\r\n        if (params.event_tags && params.event_tags !== \'{EVENT.TAGS}\') {\r\n            facts.push({\r\n                name: \'Event tags\',\r\n                value: params.event_tags\r\n            });\r\n        }\r\n\r\n        Object.keys(params)\r\n            .forEach(function (key) {\r\n                if (key.startsWith(\'fact_\') && params[key] !== \'\') {\r\n                    facts.push({\r\n                        name: key.substring(5),\r\n                        value: params[key]\r\n                    });\r\n                }\r\n                else if (key.startsWith(\'openUri_\') && params[key] !== \'\' && !params[key].startsWith(\'{\')) {\r\n                    body.potentialAction.push({\r\n                        \'@type\': \'OpenUri\',\r\n                        name: key.substring(8),\r\n                        targets: [\r\n                            {\r\n                                os: \'default\',\r\n                                uri: params[key]\r\n                            }\r\n                        ]\r\n                    });\r\n                }\r\n            });\r\n        body.sections[0].facts = facts;\r\n    }\r\n\r\n    body.sections[0].text = body.sections[0].text.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n\r\n    request.AddHeader(\'Content-Type: application/json\');\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy !== \'\') {\r\n        request.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    Zabbix.Log(4, \'[ MS Teams Webhook ] JSON: \' + JSON.stringify(body));\r\n\r\n    var response = request.Post(params.teams_endpoint, JSON.stringify(body));\r\n\r\n    Zabbix.Log(4, \'[ MS Teams Webhook ] Response: \' + response);\r\n\r\n    if (response === \'1\') {\r\n        return \'OK\';\r\n    }\r\n    else {\r\n        Zabbix.Log(4, \'[ MS Teams Webhook ] FAILED with response: \' + response);\r\n        throw response;\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ MS Teams Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('15','4','Redmine','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Redmine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Redmine.params = params;\r\n        if (typeof Redmine.params.url === \'string\') {\r\n            if (!Redmine.params.url.endsWith(\'/\')) {\r\n                Redmine.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Redmine.getSchema();\r\n\r\n            if (schema) {\r\n                data.issue.custom_fields = [];\r\n\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (var idx in schema.custom_fields) {\r\n                            if (schema.custom_fields[idx].id != field) {\r\n                                continue;\r\n                            }\r\n\r\n                            var field_value;\r\n\r\n                            switch (schema.custom_fields[idx].field_format) {\r\n                                case \'string\':\r\n                                    field_value = fields[field];\r\n                                    break;\r\n\r\n                                case \'int\':\r\n                                    field_value = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'float\':\r\n                                    field_value = parseFloat(fields[field]);\r\n                                    break;\r\n\r\n                                case \'date\':\r\n                                    if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n                                        field_value = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    break;\r\n                            }\r\n\r\n                            if (field_value !== undefined) {\r\n                                data.issue.custom_fields.push({id: field, value: field_value});\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Redmine Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_key\'].forEach(function (field) {\r\n            if (typeof Redmine.params !== \'object\' || typeof Redmine.params[field] === \'undefined\'\r\n                || Redmine.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Redmine.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        if (typeof Redmine.HTTPProxy === \'string\' && Redmine.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(Redmine.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'X-Redmine-API-Key: \' + Redmine.params.access_key);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Redmine Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Redmine Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Redmine Webhook ] Failed to parse response received from Redmine\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getProjectID: function(name) {\r\n        var result = Redmine.request(\'get\', \'projects.json\'),\r\n            project_id;\r\n\r\n        if (result.response) {\r\n            var projects = result.response.projects || [];\r\n\r\n            for (var i in projects) {\r\n                if (projects[i].name === name) {\r\n                    project_id = projects[i].id;\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            Zabbix.Log(4, \'[ Redmine Webhook ] Failed to retrieve project data.\');\r\n        }\r\n\r\n        if (typeof project_id === \'undefined\') {\r\n            throw \'Cannot find project with name: \' + name;\r\n        }\r\n\r\n        return project_id;\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Redmine.request(\'get\', \'custom_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(subject, description, priority, fields) {\r\n        var project_id = /^\\d+$/.test(Redmine.params.project)\r\n                ? Redmine.params.project\r\n                : Redmine.getProjectID(Redmine.params.project),\r\n            data = {\r\n                issue: {\r\n                    project_id: project_id,\r\n                    tracker_id: Redmine.params.tracker_id,\r\n                    subject: subject,\r\n                    description: description\r\n                }\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.issue.priority_id = priority;\r\n        }\r\n\r\n        result = Redmine.request(\'post\', \'issues.json\', Redmine.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.issue.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Redmine issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issue.id;\r\n    },\r\n\r\n    updateIssue: function(note, fields) {\r\n        var data = {\r\n            issue: {\r\n                notes: note || \'\'\r\n            }\r\n        };\r\n\r\n        Redmine.request(\'put\', \'issues/\' + Redmine.params.issue_key + \'.json\', Redmine.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_redmine = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'tracker_id\', \'project\',\r\n            \'event_source\', \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'redmine_\')) {\r\n                params_redmine[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                params_fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {\r\n        throw \'Incorrect "redmine_issue_key" parameter given: \' + params.redmine_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Redmine.setParams(params_redmine);\r\n    Redmine.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Redmine.createIssue(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var issue_id = Redmine.createIssue(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_redmine_issue_id = issue_id;\r\n        result.tags.__zbx_redmine_issuelink = params.redmine_url +\r\n            (params.redmine_url.endsWith(\'/\') ? \'\' : \'/\') + \'issues/\' + issue_id;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        Redmine.updateIssue(params.alert_subject + \'\\n\' + params.alert_message, params_fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Redmine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('16','4','Telegram','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Telegram = {\r\n    token: null,\r\n    to: null,\r\n    message: null,\r\n    proxy: null,\r\n    parse_mode: null,\r\n\r\n    sendMessage: function() {\r\n        var params = {\r\n            chat_id: Telegram.to,\r\n            text: Telegram.message,\r\n            disable_web_page_preview: true,\r\n            disable_notification: false\r\n        },\r\n        data,\r\n        response,\r\n        request = new CurlHttpRequest(),\r\n        url = \'https://api.telegram.org/bot\' + Telegram.token + \'/sendMessage\';\r\n\r\n        if (Telegram.parse_mode !== null) {\r\n            params[\'parse_mode\'] = Telegram.parse_mode;\r\n        }\r\n\r\n        if (Telegram.proxy) {\r\n            request.SetProxy(Telegram.proxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        data = JSON.stringify(params);\r\n\r\n        // Remove replace() function if you want to see the exposed token in the log file.\r\n        Zabbix.Log(4, \'[Telegram Webhook] URL: \' + url.replace(Telegram.token, \'<TOKEN>\'));\r\n        Zabbix.Log(4, \'[Telegram Webhook] params: \' + data);\r\n        response = request.Post(url, data);\r\n        Zabbix.Log(4, \'[Telegram Webhook] HTTP code: \' + request.Status());\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            response = null;\r\n        }\r\n\r\n        if (request.Status() !== 200 || typeof response.ok !== \'boolean\' || response.ok !== true) {\r\n            if (typeof response.description === \'string\') {\r\n                throw response.description;\r\n            }\r\n            else {\r\n                throw \'Unknown error. Check debug log for more information.\'\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    if (typeof params.Token === \'undefined\') {\r\n        throw \'Incorrect value is given for parameter "Token": parameter is missing\';\r\n    }\r\n\r\n    Telegram.token = params.Token;\r\n\r\n    if (params.HTTPProxy) {\r\n        Telegram.proxy = params.HTTPProxy;\r\n    } \r\n\r\n    if ([\'Markdown\', \'HTML\', \'MarkdownV2\'].indexOf(params.ParseMode) !== -1) {\r\n        Telegram.parse_mode = params.ParseMode;\r\n    }\r\n\r\n    Telegram.to = params.To;\r\n    Telegram.message = params.Subject + \'\\n\' + params.Message;\r\n    Telegram.sendMessage();\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[Telegram Webhook] notification failed: \' + error);\r\n    throw \'Sending failed: \' + error + \'.\';\r\n}','10s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram\r\n\r\n1. Register bot: send "/newbot" to @BotFather and follow instructions\r\n2. Copy and paste the obtained token into the "Token" field above\r\n3. If you want to send personal notifications, you need to get chat id of the user you want to send messages to:\r\n    3.1. Send "/getid" to "@myidbot" in Telegram messenger\r\n    3.2. Copy returned chat id and save it in the "Telegram Webhook" media for the user\r\n    3.3. Ask the user to send "/start" to your bot (Telegram bot won\'t send anything to the user without it)\r\n4. If you want to send group notifications, you need to get group id of the group you want to send messages to:\r\n    4.1. Add "@myidbot" to your group\r\n    4.2. Send "/getgroupid@myidbot" in your group\r\n    4.3. Copy returned group id save it in the "Telegram Webhook" media for the user you created for  group notifications\r\n    4.4. Send "/start@your_bot_name_here" in your group (Telegram bot won\'t send anything to the group without it)');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('17','4','Zendesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Zendesk = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zendesk.params = params;\r\n        if (typeof Zendesk.params.url === \'string\') {\r\n            if (!Zendesk.params.url.endsWith(\'/\')) {\r\n                Zendesk.params.url += \'/\';\r\n            }\r\n            Zendesk.params.url += \'api/v2/\';\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Zendesk.getSchema(),\r\n                arr = [],\r\n                i,\r\n                n;\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {\r\n                            if (schema.ticket_fields[i].id == field\r\n                                && [\'text\', \'integer\', \'date\'].indexOf(schema.ticket_fields[i].type) !== -1){\r\n\r\n                                switch (schema.ticket_fields[i].type) {\r\n                                    case \'integer\':\r\n                                        fields[field] = parseInt(fields[field]);\r\n                                        break;\r\n                                    case \'date\':\r\n                                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/) !== null) {\r\n                                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                        }\r\n                                        else {\r\n                                            fields[field] = \'\';\r\n                                        }\r\n                                        break;\r\n                                }\r\n\r\n                                arr.push({id: field, value: fields[field]});\r\n                                break;\r\n                            }\r\n                        }\r\n                    });\r\n\r\n                if (arr.length) {\r\n                    data.ticket[\'custom_fields\'] = arr;\r\n                }\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[Zendesk Webhook] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'token\', \'type\'].forEach(function (field) {\r\n            if (typeof Zendesk.params !== \'object\' || typeof Zendesk.params[field] === \'undefined\') {\r\n                throw \'Required Zendesk param is not set: \' + field + \'\\n\' + Zendesk.params[field];\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zendesk.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        if (typeof Zendesk.HTTPProxy === \'string\' && Zendesk.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(Zendesk.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Zendesk.params.token));\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[Zendesk Webhook] Sending request: \' + url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[Zendesk Webhook] Received response with status code \' + request.Status() + \'. \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[Zendesk Webhook] Failed to parse response received from Zendesk.\');\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response.description !== \'undefined\'\r\n                && Object.keys(response.description).length > 0) {\r\n                message += \': \' + JSON.stringify(response.description);\r\n            }\r\n            else {\r\n                message += \'. \' + response;\r\n            }\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Zendesk.request(\'get\', \'ticket_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(data, fields) {\r\n        var result = Zendesk.request(\'post\', \'tickets.json\', Zendesk.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.ticket.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zendesk issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.ticket.id;\r\n    },\r\n\r\n    updateIssue: function(data, fields) {\r\n        Zendesk.request(\'put\', \'tickets/\' + Zendesk.params.issue_key + \'.json\', Zendesk.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        zendesk = {},\r\n        update = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zendesk_\')) {\r\n                zendesk[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter \' + key + \' cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    // Possible values: question, incident, problems, task\r\n    if ([\'question\', \'incident\', \'problem\', \'task\'].indexOf(params.zendesk_type) === -1) {\r\n        throw \'Incorrect "zendesk_type" parameter given: \' + params.zendesk_type +\r\n            \'\\nMust be one of question, incident, problem, task.\';\r\n    }\r\n\r\n    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    // Zendesk_issue_key must be a positive integer if an update action is being performed.\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n        || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {\r\n        throw \'Incorrect "zendesk_issue_key" parameter given: \' + params.zendesk_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name] || severities[7].name;\r\n\r\n    Zendesk.setParams(zendesk);\r\n    Zendesk.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n\r\n        Zendesk.createIssue(data, fields);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                        params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\' + params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n        var key = Zendesk.createIssue(data, fields);\r\n\r\n        result.tags.__zbx_zdk_issuekey = key;\r\n        result.tags.__zbx_zdk_issuelink = params.zendesk_url +\r\n            (params.zendesk_url.endsWith(\'/\') ? \'\' : \'/\') + \'agent/tickets/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        data = {\r\n            ticket: {\r\n                type: Zendesk.params.type,\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                }\r\n            }\r\n        };\r\n\r\n        Zendesk.updateIssue(data, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[Zendesk Webhook] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('18','4','ServiceNow','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var ServiceNow = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        ServiceNow.params = params;\r\n        if (typeof ServiceNow.params.url === \'string\') {\r\n            if (!ServiceNow.params.url.endsWith(\'/\')) {\r\n                ServiceNow.params.url += \'/\';\r\n            }\r\n\r\n            ServiceNow.params.url += \'api/now/table/incident\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        ServiceNow.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    data[field] = (fields[field].match(/^\\d{4}\\.\\d{2}\\.\\d{2}$/) !== null)\r\n                        ? fields[field].replace(/\\./g, \'-\')\r\n                        : fields[field];\r\n                });\r\n        }\r\n    },\r\n\r\n    request: function (method, data) {\r\n        [\'url\', \'user\', \'password\'].forEach(function (field) {\r\n            if (typeof ServiceNow.params !== \'object\' || typeof ServiceNow.params[field] === \'undefined\'\r\n                || ServiceNow.params[field] === \'\' ) {\r\n                throw \'Required ServiceNow param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = ServiceNow.params.url,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(ServiceNow.params.user + \':\' + ServiceNow.params.password));\r\n\r\n        if (typeof ServiceNow.HTTPProxy !== \'undefined\' && ServiceNow.HTTPProxy !== \'\') {\r\n            request.SetProxy(ServiceNow.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ ServiceNow Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ ServiceNow Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ ServiceNow Webhook ] Failed to parse response received from ServiceNow\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.error.message !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error.message);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.result !== \'object\' || typeof response.result.sys_id === \'undefined\') {\r\n            throw \'Cannot create ServiceNow incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        servicenow = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\', \'event_nseverity\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        method = \'post\',\r\n        process_tags = true;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'servicenow_\')) {\r\n                servicenow[key.substring(11)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'u_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    data.short_description = params.alert_subject;\r\n    data.description = params.alert_message;\r\n    data.comments = params.alert_message;\r\n\r\n    if (typeof params[\'urgency_for_\' + severities[params.event_nseverity].name] !== \'undefined\') {\r\n        data.urgency = params[\'urgency_for_\' + severities[params.event_nseverity].name];\r\n    }\r\n\r\n    ServiceNow.setParams(servicenow);\r\n    ServiceNow.setProxy(params.HTTPProxy);\r\n    ServiceNow.setFields(data, fields);\r\n\r\n    if (params.event_source === \'0\' && (params.event_value === \'0\' || params.event_update_status === \'1\')) {\r\n        process_tags = false;\r\n        method = \'put\';\r\n        delete data.description;\r\n        delete data.urgency;\r\n        ServiceNow.params.url += \'/\' + params.servicenow_sys_id;\r\n    }\r\n\r\n    var response = ServiceNow.request(method, data);\r\n\r\n    if (process_tags) {\r\n        result.tags.__zbx_servicenow_sys_id = response.sys_id;\r\n        result.tags.__zbx_servicenow_link = params.servicenow_url +\r\n            (params.servicenow_url.endsWith(\'/\') ? \'\' : \'/\') + \'incident.do?sys_id=\' + response.sys_id;\r\n        result.tags.__zbx_servicenow_number = response.number;\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ ServiceNow Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('19','4','Zammad','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Zammad = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zammad.params = params;\r\n        if (typeof Zammad.params.url === \'string\') {\r\n            if (!Zammad.params.url.endsWith(\'/\')) {\r\n                Zammad.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_token\'].forEach(function (field) {\r\n            if (typeof Zammad.params !== \'object\' || typeof Zammad.params[field] === \'undefined\'\r\n                || Zammad.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zammad.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        if (typeof Zammad.HTTPProxy === \'string\' && Zammad.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(Zammad.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Token token=\' + Zammad.params.access_token);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Zammad Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Zammad Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Zammad Webhook ] Failed to parse response received from Zammad\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    setTicketTags: function(tags, ticket_id) {\r\n        try {\r\n            var tags_json = JSON.parse(tags),\r\n                result;\r\n\r\n            for (var i in tags_json) {\r\n                result = Zammad.request(\'get\',\r\n                    \'/api/v1/tags/add?object=Ticket&o_id=\' + ticket_id +\r\n                    \'&item=\' + tags_json[i].tag);\r\n\r\n                if (typeof result.response !== \'object\'\r\n                    || result.status != 200) {\r\n                    Zabbix.Log(4, \'[ Zammad Webhook ] Cannot add ticket tag:\' + tags_json[i].tag);\r\n                }\r\n            }\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ Zammad Webhook ] Failed to add ticket tags:\' + error);\r\n        }\r\n\r\n        return;\r\n    },\r\n\r\n    createTicket: function(subject, message, priority) {\r\n        var data = {\r\n                title: subject,\r\n                group: \'Users\',\r\n                article: {\r\n                    subject: subject,\r\n                    body: message,\r\n                    type: \'note\',\r\n                    internal: false\r\n                },\r\n                customer: Zammad.params.customer\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.priority_id = priority;\r\n        }\r\n\r\n        result = Zammad.request(\'post\', \'api/v1/tickets\', data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zammad ticket. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(subject, message) {\r\n        var data = {\r\n            ticket_id: Zammad.params.ticket_id,\r\n            subject: subject,\r\n            body: message || \'\',\r\n            type: \'note\',\r\n            internal: false\r\n        };\r\n\r\n        result = Zammad.request(\'post\', \'api/v1/ticket_articles\', data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot update Zammad ticket. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_zammad = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'customer\',\r\n            \'event_source\', \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zammad_\')) {\r\n                params_zammad[key.substring(7)] = params[key].trim();\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zammad_ticket_id)) || parseInt(params.zammad_ticket_id) < 1 )) {\r\n        throw \'Incorrect "zammad_ticket_id" parameter given: \' + params.zammad_ticket_id +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Zammad.setParams(params_zammad);\r\n    Zammad.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create ticket for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Zammad.createTicket(params.alert_subject, params.alert_message, priority, params.event_tags);\r\n    }\r\n    // Create ticket for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var ticket_id = Zammad.createTicket(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority);\r\n\r\n        result.tags.__zbx_zammad_ticket_id = ticket_id;\r\n        result.tags.__zbx_zammad_ticketlink = params.zammad_url +\r\n            (params.zammad_url.endsWith(\'/\') ? \'\' : \'/\') + \'#ticket/zoom/\' + ticket_id;\r\n\r\n        if (Zammad.params.enable_tags.toLowerCase() === \'true\') {\r\n            Zammad.setTicketTags(params.event_tags, ticket_id);\r\n        }\r\n    }\r\n    // Update created ticket for trigger-based event.\r\n    else {\r\n        Zammad.updateTicket(params.alert_subject, params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Zammad Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('20','4','Jira ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n    schema: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/servicedeskapi/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (!Jira.schema) {\r\n            Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Cannot add labels because failed to retrieve field schema.\');\r\n\r\n            return;\r\n        }\r\n\r\n        var block = Jira.schema.requestTypeFields.filter(function(object) {\r\n            return object.fieldId == \'labels\';\r\n        });\r\n\r\n        if (block[0] && typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' ) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 255) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (Jira.schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        data.requestFieldValues[field] = fields[field];\r\n\r\n                        var block = Jira.schema.requestTypeFields.filter(function(object) {\r\n                            return object.fieldId == field;\r\n                        });\r\n\r\n                        if (typeof block[0] === \'object\' && typeof block[0].jiraSchema === \'object\'\r\n                            && (block[0].jiraSchema.type === \'number\' || block[0].jiraSchema.type === \'datetime\')) {\r\n                            switch (block[0].jiraSchema.type) {\r\n                                case \'number\':\r\n                                    data.requestFieldValues[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.requestFieldValues[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    else {\r\n                                        delete data.requestFieldValues[field];\r\n                                    }\r\n                                    break;\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Cannot add custom fields\' +\r\n                    \'because failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'servicedesk_id\', \'request_type_id\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n        request.AddHeader(\'X-ExperimentalApi: opt-in\');\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.SetProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessage !== \'undefined\'\r\n                && Object.keys(response.errorMessage).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessage);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'servicedesk/\' + Jira.params.servicedesk_id + \'/requesttype/\' +\r\n            Jira.params.request_type_id + \'/field\');\r\n\r\n        if (typeof Jira.schema !== \'object\' && typeof Jira.schema.requestTypeFields !== \'object\') {\r\n            Jira.schema = null;\r\n        }\r\n        else {\r\n            Jira.schema = result.response;\r\n        }\r\n    },\r\n\r\n    createRequest: function(summary, description, fields) {\r\n        var data = {\r\n            serviceDeskId: Jira.params.servicedesk_id,\r\n            requestTypeId: Jira.params.request_type_id,\r\n            requestFieldValues: {\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.requestFieldValues.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'request\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.issueKey === \'undefined\') {\r\n            throw \'Cannot create Jira request. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issueKey;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        comment = {public: true},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.getSchema();\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create request for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createRequest(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create request for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n        && jira.request_key === \'{EVENT.TAGS.__zbx_jira_requestkey}\') {\r\n        var key = Jira.createRequest(params.alert_subject, params.alert_message, fields);\r\n\r\n        result.tags.__zbx_jira_requestkey = key;\r\n        result.tags.__zbx_jira_requestlink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Comment created request for trigger-based event.\r\n    else {\r\n        if (jira.request_key === \'{EVENT.TAGS.__zbx_jira_requestkey}\' || jira.request_key.trim() === \'\') {\r\n            throw \'Incorrect Request key given: \' + jira.request_key;\r\n        }\r\n        comment.body = params.alert_message;\r\n        Jira.request(\'post\', \'request/\' + Jira.params.request_key + \'/comment\', comment);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Jira Service Desk Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira ServiceDesk: {EVENT.TAGS.__zbx_jira_requestkey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('21','4','OTRS','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var OTRS = {\r\n    params: {},\r\n    entrypoint: \'nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        OTRS.params = params;\r\n        if (typeof OTRS.params.url === \'string\') {\r\n            if (!OTRS.params.url.endsWith(\'/\')) {\r\n                OTRS.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addDynamicFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            data.DynamicField = [];\r\n\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (field !== undefined) {\r\n                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                        }\r\n\r\n                        data.DynamicField.push({Name: field, Value: fields[field]});\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'auth_user\', \'auth_password\', \'queue\',\r\n            \'customer\', \'ticket_state\', \'default_priority_id\', \'time_unit\'].forEach(function (field) {\r\n            if (typeof OTRS.params !== \'object\' || typeof OTRS.params[field] === \'undefined\'\r\n                || OTRS.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new CurlHttpRequest(),\r\n            url = OTRS.params.url + query +\r\n                \'?UserLogin=\' + encodeURIComponent(OTRS.params.auth_user) +\r\n                \'&Password=\' + encodeURIComponent(OTRS.params.auth_password);\r\n\r\n        if (typeof OTRS.HTTPProxy !== \'undefined\' && OTRS.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(OTRS.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ OTRS Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ OTRS Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ OTRS Webhook ] Failed to parse response received from OTRS\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (typeof response.Error !== \'undefined\'\r\n            && Object.keys(response.Error).length > 0) {\r\n            message = \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createTicket: function(subject, message, priority, fields) {\r\n        var result,\r\n            data = {\r\n                Ticket: {\r\n                    Title: subject,\r\n                    Queue: OTRS.params.queue,\r\n                    State: OTRS.params.ticket_state,\r\n                    PriorityID: priority || OTRS.params.default_priority_id,\r\n                    CustomerUser: OTRS.params.customer\r\n                },\r\n                Article: {\r\n                    Subject: subject,\r\n                    Body: message,\r\n                    TimeUnit: OTRS.params.time_unit,\r\n                    ContentType: \'text/plain; charset=utf8\'\r\n                }\r\n            };\r\n\r\n        result = OTRS.request(\'post\', OTRS.entrypoint, OTRS.addDynamicFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.TicketID === \'undefined\'\r\n            || result.status != 200) {\r\n            throw \'Cannot create OTRS ticket. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.TicketID;\r\n    },\r\n\r\n    updateTicket: function(subject, message) {\r\n        var result,\r\n            data = {\r\n                Article: {\r\n                    Subject: subject,\r\n                    Body: message || \'\',\r\n                    TimeUnit: OTRS.params.time_unit,\r\n                    ContentType: \'text/plain; charset=utf8\'\r\n                }\r\n            };\r\n\r\n        result = OTRS.request(\'put\', OTRS.entrypoint + \'/\' + encodeURIComponent(OTRS.params.ticket_id), data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.TicketID === \'undefined\'\r\n            || result.status != 200) {\r\n            throw \'Cannot update OTRS ticket. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_otrs = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'event_source\',\r\n            \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'otrs_\')) {\r\n                params_otrs[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'dynamicfield_\')) {\r\n                params_fields[key.substring(13)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.otrs_ticket_id)) || parseInt(params.otrs_ticket_id) < 1 )) {\r\n        throw \'Incorrect "otrs_ticket_id" parameter given: \' + params.otrs_ticket_id +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    OTRS.setParams(params_otrs);\r\n    OTRS.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create ticket for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        OTRS.createTicket(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create ticket for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var ticket_id = OTRS.createTicket(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_otrs_ticket_id = ticket_id;\r\n        result.tags.__zbx_otrs_ticketlink = params.otrs_url +\r\n            (params.otrs_url.endsWith(\'/\') ? \'\' : \'/\') + \'index.pl?Action=AgentTicketZoom;TicketID=\' + ticket_id;\r\n    }\r\n    // Update created ticket for trigger-based event.\r\n    else {\r\n        OTRS.updateTicket(params.alert_subject, params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ OTRS Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','OTRS: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('22','4','iLert','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','try {\r\n    var result = { tags: {} },\r\n        params = JSON.parse(value),\r\n        req = new CurlHttpRequest(),\r\n        resp = \'\';\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n    var alertSourceKey = params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    if (!alertSourceKey || (typeof alertSourceKey === \'string\' && alertSourceKey.trim() === \'\')) {\r\n        throw \'incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.\';\r\n    }\r\n    delete params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    \r\n    var ilertApiBaseURL = "https://api.ilert.com";\r\n    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)\r\n\r\n    var incidentKey = "zabbix-" + params[\'EVENT.ID\'];\r\n    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;\r\n\r\n    req.AddHeader(\'Accept: application/json\');\r\n    req.AddHeader(\'Content-Type: application/json\');\r\n\r\n    Zabbix.Log(4, \'[iLert Webhook] Sending request:\' + JSON.stringify(params));\r\n    resp = req.Post(reqURL, JSON.stringify(params));\r\n    Zabbix.Log(4, \'[iLert Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. iLert returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.Status() == 200) {\r\n        result.tags.__ilert_incident_url = incidentViewURL;\r\n        return JSON.stringify(result);\r\n    }\r\n\r\n    if (req.Status() == 400 && typeof resp === \'object\' && typeof resp.code === \'string\') {\r\n        if (resp.code === \'NO_OPEN_INCIDENT_WITH_KEY\') {\r\n          return JSON.stringify(result);\r\n        }\r\n        if (resp.code === \'INCIDENT_ALREADY_ACCEPTED\') {\r\n          result.tags.__ilert_incident_url = incidentViewURL;\r\n          return JSON.stringify(result);\r\n        }\r\n    }\r\n\r\n    if (typeof resp === \'object\' && typeof resp.message === \'string\') {\r\n        throw resp.message;\r\n    }\r\n    else {\r\n        throw \'Unknown error.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[iLert Webhook] Notification failed : \' + error);\r\n    throw \'iLert notification failed : \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native \r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('23','4','SolarWinds Service Desk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SolarWinds = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        SolarWinds.params = params;\r\n        SolarWinds.params.endpoint = \'https://api.samanage.com/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        SolarWinds.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof data.incident === \'object\' && typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (typeof fields.sw_fields === \'object\' && Object.keys(fields.sw_fields).length) {\r\n                Object.keys(fields.sw_fields)\r\n                    .forEach(function(field) {\r\n                        try {\r\n                            data.incident[field] = JSON.parse(fields.sw_fields[field]);\r\n                        }\r\n                        catch (error) {\r\n                            data.incident[field] = fields.sw_fields[field];\r\n                        }\r\n                    });\r\n            }\r\n\r\n            if (typeof fields.sw_customfields === \'object\' && Object.keys(fields.sw_customfields).length) {\r\n                data.incident.custom_fields_values = {custom_fields_value: []};\r\n                Object.keys(fields.sw_customfields)\r\n                    .forEach(function(field) {\r\n                        data.incident.custom_fields_values.custom_fields_value.push({\r\n                            name: field,\r\n                            value: fields.sw_customfields[field]\r\n                        });\r\n                    });\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'token\'].forEach(function (field) {\r\n            if (typeof SolarWinds.params !== \'object\' || typeof SolarWinds.params[field] === \'undefined\'\r\n                || SolarWinds.params[field] === \'\' ) {\r\n                throw \'Required SolarWinds param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = SolarWinds.params.endpoint + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'X-Samanage-Authorization: Bearer \' + SolarWinds.params.token);\r\n        request.AddHeader(\'Accept: application/vnd.samanage.v2.1+json\');\r\n\r\n        if (typeof SolarWinds.HTTPProxy !== \'undefined\' && SolarWinds.HTTPProxy !== \'\') {\r\n            request.SetProxy(SolarWinds.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SolarWinds SD Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SolarWinds SD Webhook ] Received response with status code \' + request.Status() +\r\n            \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response === \'object\'\r\n                && Object.keys(response).length > 0) {\r\n                Object.keys(response)\r\n                    .forEach(function(field) {\r\n                        message += \'\\n\' + field + \': \' + response[field][0];\r\n                    });\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(name, description, fields) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                description: description,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        var result = SolarWinds.request(\'post\', \'incidents.json\', SolarWinds.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.id === \'undefined\') {\r\n            throw \'Cannot create SolarWinds incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateIncident: function(name, fields, message) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\r\n            \'put\',\r\n            \'incidents/\' + SolarWinds.params.incident_id + \'.json\',\r\n            SolarWinds.addCustomFields(data, fields));\r\n\r\n        SolarWinds.commenIncident(message);\r\n    },\r\n\r\n    commenIncident: function(message) {\r\n        var data = {\r\n            comment: {\r\n                body: message\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\'post\', \'incidents/\' + SolarWinds.params.incident_id + \'/comments.json\', data);\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        samanage = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_recovery_value\', \'event_source\', \'event_value\', \'priority_default\'],\r\n        severities = [\r\n            {name: \'not_classified\'},\r\n            {name: \'information\'},\r\n            {name: \'warning\'},\r\n            {name: \'average\'},\r\n            {name: \'high\'},\r\n            {name: \'disaster\'},\r\n            {name: \'resolved\'},\r\n            {name: \'default\'}\r\n        ];\r\n\r\n    fields.sw_fields = {};\r\n    fields.sw_customfields = {};\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'samanage_\')) {\r\n                samanage[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_field_\')) {\r\n                fields.sw_fields[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_customfield_\')) {\r\n                fields.sw_customfields[key.substring(15)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    samanage.priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    SolarWinds.setParams(samanage);\r\n    SolarWinds.setProxy(params.HTTPProxy);\r\n\r\n    // Create incident for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        SolarWinds.createIncident(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create incident for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\') {\r\n        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);\r\n\r\n\r\n        result.tags.__zbx_solarwinds_inc_id = key;\r\n        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +\r\n            (params.samanage_url.endsWith(\'/\') ? \'\' : \'/\') + \'incidents/\' + key;\r\n    }\r\n    // Update created incident for trigger-based event.\r\n    else {\r\n        if (samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\' || samanage.incident_id === \'\') {\r\n            throw \'Incorrect incident key given: \' + samanage.incident_id;\r\n        }\r\n        if (!params.alert_message) {\r\n            throw \'Parameter "alert_message" can\\\'t be empty.\';\r\n        }\r\n        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ SolarWinds SD Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('24','4','SysAid','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SysAid = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        var required = [\'url\', \'auth_user\', \'auth_password\', \'category_level_1\', \'category_level_2\',\r\n            \'category_level_3\', \'incident_id\', \'template_id\', \'urgency_id\', \'incident_state\',\r\n            \'default_priority_id\'\r\n        ];\r\n\r\n        required.forEach(function (field) {\r\n            if (typeof params !== \'object\' || typeof params[field] === \'undefined\' || params[field] === \'\') {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        SysAid.params = params;\r\n        if (typeof SysAid.params.url === \'string\' && !SysAid.params.url.endsWith(\'/\')) {\r\n            SysAid.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    login: function () {\r\n        var result = SysAid.request(\'post\', \'api/v1/login\', {\r\n            user_name: SysAid.params.auth_user,\r\n            password: SysAid.params.auth_password\r\n        });\r\n\r\n        return result.response.user.id;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            request = SysAid.req || (SysAid.req = new CurlHttpRequest()),\r\n            url = SysAid.params.url + query;\r\n\r\n        if (typeof SysAid.HTTPProxy !== \'undefined\' && SysAid.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(SysAid.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SysAid Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SysAid Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (request.Status() !== 200) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ SysAid Webhook ] Failed to parse response received from SysAid\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (response === null || (typeof response.Error !== \'undefined\' && Object.keys(response.Error).length > 0)) {\r\n            throw \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(subject, message, priority) {\r\n        var result = SysAid.request(\'post\', \'api/v1/sr/?template=\' + encodeURIComponent(SysAid.params.template_id), {\r\n            info: [\r\n                {\r\n                    key: \'problem_type\',\r\n                    value: [\r\n                        SysAid.params.category_level_1,\r\n                        SysAid.params.category_level_2,\r\n                        SysAid.params.category_level_3\r\n                    ].join(\'_\')\r\n                },\r\n                {\r\n                    key: \'title\',\r\n                    value: subject\r\n                },\r\n                {\r\n                    key: \'description\',\r\n                    value: message\r\n                },\r\n                {\r\n                    key: \'status\',\r\n                    value: \'1\'\r\n                },\r\n                {\r\n                    key: \'urgency\',\r\n                    value: SysAid.params.urgency_id\r\n                },\r\n                {\r\n                    key: \'priority\',\r\n                    value: priority || SysAid.params.default_priority_id,\r\n                }\r\n            ]\r\n        });\r\n\r\n        if (result.response.id === \'undefined\') {\r\n            throw \'Cannot create SysAid incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(note) {\r\n        var date = new Date().getTime();\r\n\r\n        SysAid.request(\'put\', \'api/v1/sr/\' + encodeURIComponent(SysAid.params.incident_id), {\r\n            id: SysAid.params.incident_id,\r\n            info: [\r\n                {\r\n                    key: \'update_time\',\r\n                    value: date\r\n                },\r\n                {\r\n                    key: \'notes\',\r\n                    value: [\r\n                        {\r\n                            userName: \'Zabbix\',\r\n                            createDate: date,\r\n                            text: note\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        });\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_sysaid = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_source\', \'event_value\',  \'event_update_status\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sysaid_\')) {\r\n                params_sysaid[key.substring(7)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {\r\n        throw \'Incorrect "sysaid_incident_id" parameter given: \' + params.sysaid_incident_id + \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    SysAid.setParams(params_sysaid);\r\n    SysAid.HTTPProxy = params.HTTPProxy;\r\n    SysAid.login();\r\n\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        // Create ticket for non trigger-based events.\r\n        SysAid.createIncident(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        // Create ticket for trigger-based events.\r\n        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + \'\\n\' + params.alert_message +\r\n                \'\\n\' + params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\', priority\r\n        );\r\n\r\n        result.tags.__zbx_sysaid_incident_id = incident_id;\r\n        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +\r\n            (params.sysaid_url.endsWith(\'/\') ? \'\' : \'/\') + \'SREdit.jsp?id=\' + incident_id + \'&fromId=IncidentsList\';\r\n    }\r\n    else {\r\n        // Update created ticket for trigger-based event.\r\n        SysAid.updateTicket(params.alert_subject + \'\\n\' + params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ SysAid Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('25','4','TOPdesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Accept: application/json\');\r\n        request.AddHeader(\'Authorization: \' + Media.params.token);\r\n        request.SetProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'topdesk_api\',\r\n            \'topdesk_user\',\r\n            \'topdesk_password\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'topdesk_\')) {\r\n                media[key.substring(8)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'TOPdesk\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'Basic \' + btoa(Media.params.user + \':\' + Media.params.password);\r\n    Media.setProxy(params.HTTPProxy);\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket creating.\');\r\n        fields.caller = {dynamicName: \'Zabbix\'};\r\n        fields.briefDescription = params.alert_subject;\r\n        fields.request = params.alert_message.replace(/\\n/g, \'<br>\');\r\n        fields.priority = {name: priority};\r\n        fields.processingStatus = {name: Media.params.status};\r\n        fields.externalNumber = params.event_id;\r\n        fields.request += \'<br>\' + params.zbxurl;\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.request += \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id;\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'tas/api/incidents\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n            result.tags.__zbx_tpd_issuekey = resp.response.number;\r\n            result.tags.__zbx_tpd_issuelink = Media.params.api +\r\n                \'tas/secure/incident?action=show&unid=\' + resp.response.id;\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        if (params.event_source == 3 && params.event_value == 0) {\r\n            throw \'Internal event recovery actions are not supported.\';\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket updating.\');\r\n        fields.action = params.alert_message.replace(/\\n/g, \'<br>\');\r\n\r\n        resp = Media.request(\'put\', \'tas/api/incidents/number/\' + Media.params.issue_key, fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\'\r\n                || resp.response.number !== Media.params.issue_key) {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/5.0/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "TOPdesk".\r\nChange the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('26','4','iTop','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Itop = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        if (params.log !== \'private_log\' && params.log !== \'public_log\') {\r\n            throw \'Incorrect "itop_log" parameter given: \' + params.log + \'\\nMust be "private_log" or "public_log".\';\r\n        }\r\n\r\n        Itop.params = params;\r\n        if (typeof Itop.params.url === \'string\') {\r\n            if (!Itop.params.url.endsWith(\'/\')) {\r\n                Itop.params.url += \'/\';\r\n            }\r\n\r\n            Itop.params.url += \'webservices/rest.php?version=\' + encodeURIComponent(Itop.params.api_version);\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Itop.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setCreatePayload: function () {\r\n        json_data.operation = \'core/create\';\r\n        json_data.fields.org_id = Itop.params.organization_id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields.description = params.alert_message.replace(\'<\', \'&lt;\')\r\n            .replace(\'>\', \'&gt;\')\r\n            .replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n    },\r\n\r\n    setUpdatePayload: function () {\r\n        json_data.operation = \'core/update\';\r\n        json_data.key = Itop.params.id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields[Itop.params.log] = {\r\n            add_item: {\r\n                message: params.alert_subject + \'\\n\' + params.alert_message,\r\n                format: \'text\'\r\n            }\r\n        };\r\n    },\r\n\r\n    request: function (data) {\r\n        [\'url\', \'user\', \'password\', \'organization_id\', \'class\', \'api_version\', \'id\'].forEach(function (field) {\r\n            if (typeof Itop.params !== \'object\' || typeof Itop.params[field] === \'undefined\'\r\n                    || Itop.params[field] === \'\' ) {\r\n                throw \'Required Itop param is not set: "itop_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Itop.params.url,\r\n            request = new CurlHttpRequest(),\r\n            object;\r\n\r\n        request.AddHeader(\'Content-Type: multipart/form-data\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Itop.params.user + \':\' + Itop.params.password));\r\n\r\n        if (Itop.HTTPProxy) {\r\n            request.SetProxy(Itop.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ iTop Webhook ] Sending request: \' + url + \'&json_data=\' + data);\r\n\r\n        response = request.Post(url + \'&json_data=\' + encodeURIComponent(data));\r\n\r\n        Zabbix.Log(4, \'[ iTop Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ iTop Webhook ] Failed to parse response received from iTop\');\r\n            throw \'Failed to parse response received from iTop.\\nRequest status code \' +\r\n                    request.Status() + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            throw \'Request failed with status code \' + request.Status() + \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.code !== \'undefined\' && response.code !== 0) {\r\n            throw \'Request failed with iTop code \' + response.code + \': \' +\r\n                    JSON.stringify(response.message) + \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            Object.keys(response.objects)\r\n                .forEach(function (key) {\r\n                    object = response.objects[key];\r\n                });\r\n\r\n            return {\r\n                status: request.Status(),\r\n                response: object.fields\r\n            };\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        json_data = {},\r\n        itop_params = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'summary\', \'event_recovery_value\',\r\n            \'event_source\', \'event_value\', \'action_name\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'itop_\')) {\r\n                itop_params[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Itop.setParams(itop_params);\r\n    Itop.setProxy(params.HTTPProxy);\r\n\r\n    json_data.operation = \'\';\r\n    json_data.class = Itop.params.class;\r\n    json_data.comment = Itop.params.comment;\r\n    json_data.output_fields = \'id, friendlyname\';\r\n    json_data.fields = {};\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Itop.setCreatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\') {\r\n        Itop.setCreatePayload();\r\n\r\n        var response = Itop.request(json_data);\r\n\r\n        result.tags.__zbx_itop_id = response.response.id;\r\n        result.tags.__zbx_itop_key = response.response.friendlyname;\r\n        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n                \'pages/UI.php?operation=details&class=\' + encodeURIComponent(Itop.params.class) + \'&id=\' +\r\n                encodeURIComponent(response.response.id);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\') {\r\n            throw \'Incorrect iTop ticket ID given: \' + Itop.params.id;\r\n        }\r\n        Itop.setUpdatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ iTop Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('27','4','Rocket.Chat','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var RocketChat = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        RocketChat.params = params;\r\n        if (RocketChat.params.url && RocketChat.params.api_url) {\r\n            if (!RocketChat.params.url.endsWith(\'/\')) {\r\n                RocketChat.params.url += \'/\';\r\n            }\r\n            if (!RocketChat.params.api_url.endsWith(\'/\')) {\r\n                RocketChat.params.api_url += \'/\';\r\n            }\r\n            if (RocketChat.params.api_url.startsWith(\'/\')) {\r\n                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);\r\n            }\r\n\r\n            RocketChat.params.url += RocketChat.params.api_url;\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        RocketChat.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = [];\r\n\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.Log(4, \'[ RocketChat Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[2] === \'undefined\'\r\n                                    || (prefix[2] === \'p\' && params.event_value === \'1\')\r\n                                    || (prefix[2] === \'r\' && params.event_value === \'0\')) {\r\n                                data.push({\r\n                                    title: field.substring(field.indexOf(\':\') + 1),\r\n                                    value: fields[field],\r\n                                    short: prefix[1] === \'short\'\r\n                                });\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.Log(4, \'[ RocketChat Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'api_url\', \'user_id\', \'user_token\', \'send_to\'].forEach(function (field) {\r\n            if (typeof RocketChat.params !== \'object\' || typeof RocketChat.params[field] === \'undefined\'\r\n                    || RocketChat.params[field] === \'\' ) {\r\n                throw \'Required parameter is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = RocketChat.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'X-Auth-Token:\' + RocketChat.params.user_token);\r\n        request.AddHeader(\'X-User-Id:\' + RocketChat.params.user_id);\r\n\r\n        if (typeof RocketChat.HTTPProxy !== \'undefined\' && RocketChat.HTTPProxy !== \'\') {\r\n            request.SetProxy(RocketChat.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ RocketChat Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ RocketChat Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ RocketChat Webhook ] Failed to parse response received from RocketChat\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.message !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.message);\r\n            }\r\n            else if (response !== null && typeof response.error !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    postMessage: function(use_default_message, message, fields) {\r\n        var data = {\r\n            channel: RocketChat.params.send_to,\r\n            attachments: [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject\r\n            }]\r\n        };\r\n\r\n        if (RocketChat.params.title_link) {\r\n            data.attachments[0].title_link = RocketChat.params.title_link;\r\n        }\r\n\r\n        if (use_default_message) {\r\n            data.attachments[0].text = message;\r\n        }\r\n        else {\r\n            data.attachments[0].fields = RocketChat.addFields(fields);\r\n        }\r\n\r\n        var result = RocketChat.request(\'post\', \'chat.postMessage\', data);\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.message._id === \'undefined\') {\r\n            throw \'Cannot send RocketChat message. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            id: result.response.message._id,\r\n            rid: result.response.message.rid,\r\n            channel: result.response.channel\r\n        };\r\n    },\r\n\r\n    sendMessage: function(update, fields) {\r\n\r\n        var data = {\r\n            message: {\r\n                rid: RocketChat.params.room_id,\r\n                tmid: RocketChat.params.msg_id,\r\n                tshow: true\r\n            }\r\n        };\r\n\r\n        if (update.status === \'0\') {\r\n            data.message.attachments = [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject,\r\n                title_link: RocketChat.params.title_link,\r\n                fields: RocketChat.addFields(fields)\r\n            }];\r\n        }\r\n        else {\r\n            data.message.alias = update.user;\r\n            data.message.msg = update.action;\r\n            if (update.message) {\r\n                data.message.attachments = [{\r\n                    color: RocketChat.params.color,\r\n                    text: update.message\r\n                }];\r\n            }\r\n        }\r\n\r\n        RocketChat.request(\'post\', \'chat.sendMessage\', data);\r\n    },\r\n\r\n    getMessageLink: function(rid, id) {\r\n        var room = RocketChat.request(\'get\', \'rooms.info?roomId=\' + encodeURIComponent(rid)),\r\n            link = params.rc_url +\r\n                (params.rc_url.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n        switch (room.response.room.t) {\r\n            case \'c\':\r\n                link += \'channel/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'p\':\r\n                link += \'group/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'d\':\r\n                link += \'direct/\' + rid + \'?msg=\' + id;\r\n                break;\r\n\r\n            default:\r\n                Zabbix.Log(4, \'[ RocketChat Webhook ] Can\\\'t get room type. Link to message will not be added.\');\r\n        }\r\n\r\n        return link;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        response,\r\n        fields = {},\r\n        rc = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'alert_message\', \'event_source\', \'event_value\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'rc_\')) {\r\n                rc[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\')) {\r\n                fields[key.substring(6)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing parameters for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n        params.rc_title_link = false;\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    RocketChat.setParams(rc);\r\n    RocketChat.setProxy(params.HTTPProxy);\r\n    RocketChat.params.color = severities[params.event_nseverity].color;\r\n\r\n    // Send default message if use_default_message === true.\r\n    if (params.use_default_message.toLowerCase() === \'true\') {\r\n        response = RocketChat.postMessage(true, params.alert_message);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send message for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        response = RocketChat.postMessage(false, params.alert_message, fields);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send thread message for trigger-based event.\r\n    else {\r\n        RocketChat.sendMessage(update, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ RocketChat Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('28','4','VictorOps','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var VictorOps = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        VictorOps.params = params;\r\n        if (VictorOps.params.endpoint) {\r\n            if (!VictorOps.params.endpoint.endsWith(\'/\')) {\r\n                VictorOps.params.endpoint += \'/\';\r\n            }\r\n\r\n            if (typeof VictorOps.params.routing_key !== \'undefined\'\r\n                    && VictorOps.params.routing_key !== \'{ALERT.SENDTO}\'\r\n                    && VictorOps.params.routing_key !== \'Default\') {\r\n                VictorOps.params.endpoint += VictorOps.params.routing_key;\r\n            }\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        VictorOps.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = {};\r\n\r\n        if (typeof fields === \'object\') {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.Log(4, \'[ VictorOps Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[1] === \'undefined\'\r\n                                    || (prefix[1] === \'p\' && params.event_value === \'1\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'r\' && params.event_value === \'0\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'u\' && params.event_update_status === \'1\')) {\r\n                                data[field.substring(field.indexOf(\':\') + 1)] = fields[field];\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.Log(4, \'[ VictorOps Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (data) {\r\n        if (typeof VictorOps.params !== \'object\' || typeof VictorOps.params.endpoint === \'undefined\'\r\n                || VictorOps.params.endpoint === \'\' ) {\r\n            throw \'Required parameter is not set: "vops_endpoint".\';\r\n        }\r\n\r\n        var response,\r\n            url = VictorOps.params.endpoint,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n\r\n        if (typeof VictorOps.HTTPProxy !== \'undefined\' && VictorOps.HTTPProxy !== \'\') {\r\n            request.SetProxy(VictorOps.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ VictorOps Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.Post(url, data);\r\n\r\n        Zabbix.Log(4, \'[ VictorOps Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ VictorOps Webhook ] Failed to parse response received from VictorOps\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.messages !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.messages);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        vops = {},\r\n        required_params = [\'event_source\', \'event_value\', \'priority_update\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'vops_\')) {\r\n                vops[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field\')) {\r\n                fields[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\') {\r\n        fields[\':message_type\'] = params.priority_update;\r\n    }\r\n    else {\r\n        fields[\':message_type\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n            || \'INFO\';\r\n    }\r\n\r\n    if (params.event_info && params.event_source === \'0\') {\r\n        fields[\':event_info\'] = params.event_info;\r\n    }\r\n\r\n    VictorOps.setParams(vops);\r\n    VictorOps.setProxy(params.HTTPProxy);\r\n    VictorOps.request(VictorOps.addFields(fields));\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ VictorOps Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('29','4','Brevis.one','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var BrevisOne = {\r\n    params: [],\r\n\r\n    addParam: function (name, value) {\r\n        BrevisOne.params.push(name + \'=\' + encodeURIComponent(value));\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        BrevisOne.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setPayload: function (params) {\r\n        var parts = params.send_to.split(\':\'),\r\n            defaultValues = {\r\n                ring: \'true\',\r\n                flash: \'true\',\r\n                telauto: \'false\'\r\n            };\r\n\r\n        BrevisOne.addParam(\'username\', params.username);\r\n        BrevisOne.addParam(\'password\', params.password);\r\n        BrevisOne.addParam(\'text\', params.text);\r\n\r\n        if (parts.length > 1) {\r\n            BrevisOne.addParam(\'mode\', parts[0]);\r\n            BrevisOne.addParam(\'to\', parts[1]);\r\n        }\r\n        else {\r\n            BrevisOne.addParam(\'to\', parts[0]);\r\n        }\r\n\r\n        Object.keys(defaultValues)\r\n            .forEach(function (key) {\r\n                if (params[key] && params[key].trim() && params[key].toLowerCase() === defaultValues[key]) {\r\n                    BrevisOne.addParam(key, defaultValues[key]);\r\n                }\r\n            });\r\n    },\r\n\r\n    request: function () {\r\n        var response,\r\n            request = new CurlHttpRequest(),\r\n            data = \'?\' + BrevisOne.params.join(\'&\');\r\n\r\n        request.AddHeader(\'Content-Type: multipart/form-data\');\r\n\r\n        if (typeof BrevisOne.HTTPProxy !== \'undefined\' && BrevisOne.HTTPProxy !== \'\') {\r\n            request.SetProxy(BrevisOne.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ BrevisOne Webhook ] Sending request.\');\r\n\r\n        response = request.Post(params.endpoint + data);\r\n\r\n        Zabbix.Log(4, \'[ BrevisOne Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response) {\r\n                message += \': \' + response;\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    [\'endpoint\', \'password\', \'username\', \'text\', \'send_to\'].forEach(function (field) {\r\n        if (typeof params !== \'object\' || typeof params[field] === \'undefined\'\r\n                || !params[field].trim()) {\r\n            throw \'Required parameter is not set: "\' + field + \'".\';\r\n        }\r\n    });\r\n\r\n    if (params.send_to === \'{ALERT.SENDTO}\') {\r\n        throw \'Required parameter is not set: "send_to".\';\r\n    }\r\n\r\n    BrevisOne.setProxy(params.HTTPProxy);\r\n    BrevisOne.setPayload(params);\r\n    BrevisOne.request();\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ BrevisOne Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('30','4','Express.ms','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Express = {\r\n    params: [],\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Express.params = params;\r\n\r\n        if (typeof Express.params.url === \'string\' && !Express.params.url.endsWith(\'/\')) {\r\n            Express.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Express.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    request: function (query, data) {\r\n        var response,\r\n            url = Express.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Bearer \' + Express.params.token);\r\n\r\n        if (typeof Express.HTTPProxy !== \'undefined\' && Express.HTTPProxy !== \'\') {\r\n            request.SetProxy(Express.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Express Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.Post(url, data);\r\n\r\n        Zabbix.Log(4, \'[ Express Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Express Webhook ] Failed to parse response received from Express\');\r\n                response = {};\r\n            }\r\n        }\r\n\r\n        if (response.status !== \'ok\') {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (typeof response.reason !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.reason);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    },\r\n\r\n    postMessage: function (is_problem) {\r\n        var data,\r\n            url,\r\n            result = {tags: {}},\r\n            response;\r\n\r\n        if (is_problem) {\r\n            data = {\r\n                group_chat_id: Express.params.send_to,\r\n                notification: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v3/botx/notification/callback/direct\';\r\n        }\r\n        else {\r\n            data = {\r\n                reply: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v3/botx/events/reply_event\';\r\n\r\n            try {\r\n                var tags = JSON.parse(Express.params.tags);\r\n            }\r\n            catch (error) {\r\n                throw \'Value of "express_tags" is not JSON. Value: \' + Express.params.tags + \'.\';\r\n            }\r\n\r\n            tags.forEach(function(tag) {\r\n                if (tag.tag === \'__zbx_ex_sync_id_\' + Express.params.send_to) {\r\n                    data.source_sync_id = tag.value;\r\n                }\r\n            });\r\n\r\n            if (!data.source_sync_id) {\r\n                throw \'Cannot update data. sync_id for the provided sender is unknown.\';\r\n            }\r\n        }\r\n\r\n        response = Express.request(url, data);\r\n\r\n        if (is_problem && response.sync_id) {\r\n            result.tags[\'__zbx_ex_sync_id_\' + Express.params.send_to] = response.sync_id;\r\n\r\n            return JSON.stringify(result);\r\n        }\r\n        else {\r\n            return \'OK\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        express = {},\r\n        required_params = [\r\n            \'express_url\', \'express_send_to\', \'express_message\', \'express_tags\', \'express_token\',\r\n            \'event_source\', \'event_value\', \'event_update_status\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'express_\')) {\r\n                express[key.substring(8)] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1\r\n                    && (params[key].trim() === \'\' || params[key] === \'{ALERT.SENDTO}\')) {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing event_value and event_update_status for non trigger-based events.\r\n    if (params.event_source !== \'0\' ) {\r\n        params.event_value = \'1\';\r\n        params.event_update_status = \'0\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    Express.setParams(express);\r\n    Express.setProxy(params.HTTPProxy);\r\n\r\n    return Express.postMessage(params.event_value === \'1\' && params.event_update_status === \'0\');\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Express Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('31','4','ManageEngine ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var MEngine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        MEngine.params = params;\r\n        if (typeof MEngine.params.url === \'string\') {\r\n            if (!MEngine.params.url.endsWith(\'/\')) {\r\n                MEngine.params.url += \'/\';\r\n            }\r\n\r\n            MEngine.params.url += \'api/v3/\';\r\n        }\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() !== \'true\'\r\n                && typeof MEngine.params.on_demand_url_auth === \'string\') {\r\n            if (!MEngine.params.on_demand_url_auth.endsWith(\'/\')) {\r\n                MEngine.params.on_demand_url_auth += \'/\';\r\n            }\r\n\r\n            MEngine.params.on_demand_url_auth += \'oauth/v2/token?\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        MEngine.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    createLink: function (id, url) {\r\n        return url + (url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            ((MEngine.params.on_premise.toLowerCase() === \'true\')\r\n                ? (\'WorkOrder.do?woMode=viewWO&woID=\' + id)\r\n                : (\'app/itdesk/ui/requests/\' + id + \'/details\')\r\n            );\r\n    },\r\n\r\n    refreshAccessToken: function () {\r\n        [\r\n            \'on_demand_url_auth\',\r\n            \'on_demand_refresh_token\',\r\n            \'on_demand_client_id\',\r\n            \'on_demand_client_secret\'\r\n        ].forEach(function (field) {\r\n            if (typeof MEngine.params !== \'object\' || typeof MEngine.params[field] === \'undefined\'\r\n                    || MEngine.params[field].trim() === \'\' ) {\r\n                throw \'Required MEngine param is not set: "sd_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new CurlHttpRequest(),\r\n            url = MEngine.params.on_demand_url_auth +\r\n                \'refresh_token=\' + encodeURIComponent(MEngine.params.on_demand_refresh_token) +\r\n                \'&grant_type=refresh_token&client_id=\' + encodeURIComponent(MEngine.params.on_demand_client_id) +\r\n                \'&client_secret=\' + encodeURIComponent(MEngine.params.on_demand_client_secret) +\r\n                \'&redirect_uri=https://www.zoho.com&scope=SDPOnDemand.requests.ALL\';\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.SetProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ ManageEngine Webhook ] Refreshing access token. Request: \' + url);\r\n\r\n        response = request.Post(url);\r\n\r\n        Zabbix.Log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n        request.Status() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ ManageEngine Webhook ] Failed to parse response received from Zoho Accounts\');\r\n        }\r\n\r\n        if ((request.Status() < 200 || request.Status() >= 300) && !response.access_token) {\r\n            throw \'Access token refresh failed with HTTP status code \' + request.Status() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            MEngine.params.on_demand_auth_token = response.access_token;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            url = MEngine.params.url + query,\r\n            input,\r\n            request = new CurlHttpRequest(),\r\n            message;\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() === \'true\') {\r\n            request.AddHeader(\'TECHNICIAN_KEY: \' + MEngine.params.on_premise_auth_token);\r\n        }\r\n        else {\r\n            request.AddHeader(\'Authorization: Zoho-oauthtoken \' + MEngine.params.on_demand_auth_token);\r\n            request.AddHeader(\'Accept: application/v3+json\');\r\n        }\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.SetProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        input = \'input_data=\' + encodeURIComponent(data);\r\n        Zabbix.Log(4, \'[ ManageEngine Webhook ] Sending request: \' + url + \'?\' + input);\r\n\r\n        switch (method) {\r\n            case \'post\':\r\n                response = request.Post(url, input);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, input);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ ManageEngine Webhook ] Failed to parse response received from ManageEngine\');\r\n        }\r\n\r\n        if ((request.Status() < 200 || request.Status() >= 300)\r\n                && typeof response.response_status !== \'object\') {\r\n            throw \'Request failed with HTTP status code \' + request.Status() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.response_status === \'object\' && response.response_status.status === \'failed\') {\r\n            message = \'Request failed with status_code \';\r\n\r\n            if (typeof response.response_status.messages === \'object\'\r\n                    && response.response_status.messages[0]\r\n                    && response.response_status.messages[0].message) {\r\n                message += response.response_status.messages[0].status_code +\r\n                    \'. Message: \' + response.response_status.messages[0].message;\r\n            }\r\n            else {\r\n                message += response.response_status.status_code;\r\n            }\r\n\r\n            message += \'. Check debug log for more information.\';\r\n            throw message;\r\n        }\r\n        else if (response.request) {\r\n            return response.request.id;\r\n        }\r\n    },\r\n\r\n    createPaylaod: function (fields, isNote) {\r\n        var data = {},\r\n            result;\r\n\r\n        if (isNote) {\r\n            data.description = fields[\'field_string:description\'].replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            result = {request_note: data};\r\n        }\r\n        else {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field].trim() === \'\') {\r\n                        Zabbix.Log(4, \'[ ManageEngine Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var prefix = field.split(\':\')[0],\r\n                                root;\r\n\r\n                            if  (prefix.startsWith(\'udf_\') && !data.udf_fields) {\r\n                                data.udf_fields = {};\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else if (prefix.startsWith(\'udf_\')) {\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else {\r\n                                root = data;\r\n                            }\r\n\r\n                            if (prefix.endsWith(\'string\')) {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = fields[field];\r\n                            }\r\n                            else {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = {\r\n                                    name: fields[field]\r\n                                };\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.Log(4, \'[ ManageEngine Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n            if (data.description) {\r\n                data.description = data.description.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            }\r\n\r\n            result = {request: data};\r\n        }\r\n\r\n        return result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        sd = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'sd_on_premise\', \'field_string:subject\', \'field_string:description\',\r\n            \'event_recovery_value\', \'event_source\', \'event_value\', \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sd_\')) {\r\n                sd[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\') || key.startsWith(\'udf_field_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\' && (typeof params.sd_request_id === \'undefined\'\r\n            || params.sd_request_id.trim() === \'\'\r\n            || params.sd_request_id === \'{EVENT.TAGS.__zbx_sd_request_id}\')) {\r\n        throw \'Parameter "sd_request_id" can\\\'t be empty for update operation.\';\r\n    }\r\n\r\n    MEngine.setParams(sd);\r\n    MEngine.setProxy(params.HTTPProxy);\r\n\r\n    if (MEngine.params.on_premise.toLowerCase() !== \'true\') {\r\n        MEngine.refreshAccessToken();\r\n    }\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        var id = MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n\r\n        result.tags.__zbx_sd_request_id = id;\r\n        result.tags.__zbx_sd_request_link = MEngine.createLink(id, params.sd_url);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (params.event_update_status === \'1\') {\r\n            MEngine.request(\'post\', \'requests/\' + params.sd_request_id + \'/notes\',\r\n                MEngine.createPaylaod(fields, true)\r\n            );\r\n        }\r\n        delete fields[\'field_string:description\'];\r\n        MEngine.request(\'put\', \'requests/\' + params.sd_request_id, MEngine.createPaylaod(fields));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ ManageEngine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sd_request_link}','ManageEngine: {EVENT.TAGS.__zbx_sd_request_id}','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('1','5','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('2','5','bot_token','<YOUR BOT TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('3','5','mattermost_url','<YOUR MATTERMOST URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('4','5','send_mode','alarm');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('5','5','send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('6','5','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('8','5','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('10','5','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('11','5','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('12','5','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('13','5','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('14','5','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('15','5','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('16','5','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('18','5','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('19','5','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('20','5','host_name','{HOST.HOST}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('21','5','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('22','5','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('23','5','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('24','5','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('25','5','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('37','6','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('39','7','token','<put your key>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('40','7','eventid','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('41','7','eventname','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('42','7','hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('43','7','hostip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('44','7','severity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('45','7','triggerdesc','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('46','7','triggeropdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('47','7','eventtags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('48','7','triggerid','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('49','7','eventdate','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('50','7','eventtime','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('52','7','eventack','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('53','7','eventupdate','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('54','7','eventvalue','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('55','7','url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('56','8','token','<PUSHOVER TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('57','8','user','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('58','8','message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('59','8','title','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('60','8','url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('61','8','url_title','Zabbix');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('63','8','eventid','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('64','8','triggerid','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('65','9','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('66','9','bot_token','<PLACE YOUR KEY HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('67','9','channel','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('68','9','slack_mode','alarm');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('69','9','slack_as_user','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('71','9','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('73','9','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('75','9','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('76','9','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('77','9','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('78','9','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('79','9','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('80','9','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('81','9','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('83','9','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('84','9','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('85','9','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('87','9','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('88','9','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('89','9','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('90','9','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('91','10','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('92','10','discord_endpoint','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('93','10','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('94','10','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('95','10','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('96','10','event_name','{EVENT.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('97','10','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('98','10','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('99','10','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('100','10','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('101','10','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('102','10','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('103','10','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('104','10','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('105','10','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('106','10','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('107','10','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('108','10','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('109','10','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('110','10','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('111','10','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('112','10','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('113','10','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('114','10','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('115','10','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('116','10','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('117','8','endpoint','https://api.pushover.net/1/messages.json');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('118','8','retry','60');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('119','8','expire','1200');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('120','11','teamsecret','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('121','11','Subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('122','11','Message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('123','11','Severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('125','11','Hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('127','12','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('128','12','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('129','12','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('130','12','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('131','12','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('132','12','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('133','12','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('134','12','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('135','12','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('136','12','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('137','12','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('138','12','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('139','12','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('140','12','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('141','12','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('142','12','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('143','12','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('144','13','<\'DATETIME\' CUSTOMFIELD FOR EVENT RECOVERY TIME>','{EVENT.RECOVERY.DATE}T{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('145','13','<\'DATETIME\' CUSTOMFIELD FOR EVENT TIME>','{EVENT.DATE}T{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('146','13','<\'NUMBER\' CUSTOMFIELD FOR EVENT.ID>','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('147','13','<\'NUMBER\' CUSTOMFIELD FOR TRIGGER.ID>','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('148','13','<\'STRING\' CUSTOMFIELD FOR HOST\\IP>','{HOST.HOST} [{HOST.IP}]');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('149','13','<\'STRING\' CUSTOMFIELD FOR OPERATIONAL DATA>','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('150','13','<\'STRING\' CUSTOMFIELD FOR SEVERITY>','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('151','13','<\'URL\' CUSTOMFIELD FOR EVENT URL>','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('152','13','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('153','13','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('154','13','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('155','13','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('156','13','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('157','13','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('158','13','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('159','13','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('160','13','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('161','13','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('162','13','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('163','13','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('164','13','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('165','13','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('166','13','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('167','13','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('168','13','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('169','14','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('170','14','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('171','14','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('172','14','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('173','14','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('174','14','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('175','14','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('176','14','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('177','14','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('178','14','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('179','14','event_status','{EVENT.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('180','14','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('181','14','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('182','14','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('183','14','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('184','14','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('185','14','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('186','14','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('187','14','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('188','14','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('189','14','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('190','14','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('191','14','teams_endpoint','<PLACE WEBHOOK URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('192','14','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('193','14','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('194','14','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('195','14','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('196','15','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('197','15','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('198','15','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('199','15','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('200','15','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('201','15','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('202','15','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('203','15','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('204','15','redmine_access_key','<PUT YOUR ACCESS KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('205','15','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('206','15','redmine_project','<PUT YOUR PROJECT ID OR NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('207','15','redmine_tracker_id','<PUT YOUR TRACKER ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('208','15','redmine_url','<PUT YOUR REDMINE URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('209','15','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('210','15','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('211','16','Message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('212','16','ParseMode','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('213','16','Subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('214','16','To','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('215','16','Token','<PLACE YOUR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('216','17','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('217','17','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('218','17','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('219','17','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('220','17','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('221','17','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('222','17','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('223','17','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('224','17','severity_average','normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('225','17','severity_default','-');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('226','17','severity_disaster','urgent');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('227','17','severity_high','high');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('228','17','severity_information','low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('229','17','severity_not_classified','low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('230','17','severity_warning','normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('231','17','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('232','17','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('233','17','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('234','17','zendesk_token','<put your {enduser_email_address}/token:{api_token}>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('235','17','zendesk_type','incident');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('236','17','zendesk_url','<put your Zendesk URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('237','18','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('238','18','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('239','18','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('240','18','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('241','18','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('242','18','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('243','18','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('244','18','servicenow_password','<PLACE PASSWORD HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('245','18','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('246','18','servicenow_url','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('247','18','servicenow_user','<PLACE USERNAME HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('248','18','urgency_for_average','2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('249','18','urgency_for_disaster','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('250','18','urgency_for_high','2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('251','18','urgency_for_information','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('252','18','urgency_for_not_classified','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('253','18','urgency_for_warning','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('254','19','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('255','19','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('256','19','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('257','19','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('258','19','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('259','19','event_tags','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('260','19','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('261','19','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('262','19','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('263','19','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('264','19','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('265','19','zammad_access_token','<PUT YOUR ACCESS TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('266','19','zammad_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('267','19','zammad_enable_tags','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('268','19','zammad_ticket_id','{EVENT.TAGS.__zbx_zammad_ticket_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('269','19','zammad_url','<PUT YOUR ZAMMAD URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('270','20','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('271','20','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('272','20','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('273','20','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('274','20','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('275','20','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('276','20','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('277','20','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('278','20','jira_request_key','{EVENT.TAGS.__zbx_jira_requestkey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('279','20','jira_request_type_id','<PLACE REQUEST TYPE ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('280','20','jira_servicedesk_id','<PLACE SERVICEDESK ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('281','20','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('282','20','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('283','21','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('284','21','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('285','21','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('286','21','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('287','21','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('288','21','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('289','21','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('290','21','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('291','21','otrs_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('292','21','otrs_auth_user','<PUT YOUR USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('293','21','otrs_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('294','21','otrs_default_priority_id','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('295','21','otrs_queue','<PUT YOUR QUEUE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('296','21','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('297','21','otrs_ticket_state','new');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('298','21','otrs_time_unit','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('299','21','otrs_url','<PUT YOUR OTRS URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('300','21','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('301','21','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('302','11','Event_Ack_Status','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('303','11','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('304','11','Event_ID','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('305','11','Event_Update_Action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('306','11','Event_Update_Status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('307','11','Host_IP','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('308','11','Trigger_ID','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('309','11','Trigger_Status','{TRIGGER.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('310','11','User','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('311','11','Zabbix_URL','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('312','10','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('313','22','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('314','22','.ILERT.INCIDENT.SUMMARY','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('315','22','ALERT.MESSAGE','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('316','22','ALERT.SUBJECT','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('317','22','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('318','22','EVENT.DATE','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('319','22','EVENT.ID','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('320','22','EVENT.NAME','{EVENT.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('321','22','EVENT.NSEVERITY','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('322','22','EVENT.OPDATA','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('323','22','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('324','22','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('325','22','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('326','22','EVENT.SEVERITY','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('327','22','EVENT.TAGS','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('328','22','EVENT.TIME','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('329','22','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('330','22','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('331','22','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('332','22','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('333','22','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('334','22','EVENT.VALUE','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('335','22','HOST.HOST','{HOST.HOST}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('336','22','HOST.IP','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('337','22','HOST.NAME','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('338','22','ITEM.ID1','{ITEM.ID1}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('339','22','ITEM.ID2','{ITEM.ID2}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('340','22','ITEM.ID3','{ITEM.ID3}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('341','22','ITEM.ID4','{ITEM.ID4}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('342','22','ITEM.ID5','{ITEM.ID5}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('343','22','ITEM.NAME1','{ITEM.NAME1}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('344','22','ITEM.NAME2','{ITEM.NAME2}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('345','22','ITEM.NAME3','{ITEM.NAME3}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('346','22','ITEM.NAME4','{ITEM.NAME4}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('347','22','ITEM.NAME5','{ITEM.NAME5}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('348','22','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('349','22','TRIGGER.ID','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('350','22','TRIGGER.NAME','{TRIGGER.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('351','22','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('352','22','TRIGGER.STATUS','{TRIGGER.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('353','22','TRIGGER.URL','{TRIGGER.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('354','22','TRIGGER.VALUE','{TRIGGER.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('355','22','USER.FULLNAME','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('356','22','ZABBIX.URL','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('357','5','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('358','5','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('359','5','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('360','5','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('361','5','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('362','6','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('363','6','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('364','6','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('365','6','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('366','6','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('367','6','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('368','6','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('369','6','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('370','6','opsgenie_api','<put your opsgenie api>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('371','6','opsgenie_tags','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('372','6','opsgenie_teams','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('373','6','opsgenie_token','<put your token>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('374','6','opsgenie_web','<put your opsgenie web>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('375','6','severity_average','P3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('376','6','severity_default','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('377','6','severity_disaster','P1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('378','6','severity_high','P2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('379','6','severity_information','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('380','6','severity_not_classified','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('381','6','severity_warning','P4');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('382','6','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('383','6','zbxuser','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('384','7','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('385','7','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('386','8','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('387','8','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('388','8','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('389','8','priority_average','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('390','8','priority_default','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('391','8','priority_disaster','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('392','8','priority_high','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('393','8','priority_information','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('394','8','priority_not_classified','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('395','8','priority_warning','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('396','9','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('397','9','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('398','9','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('399','9','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('400','9','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('401','9','host_conn','{HOST.CONN}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('402','23','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('403','23','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('404','23','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('405','23','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('406','23','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('407','23','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('408','23','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('409','23','priority_average','Medium');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('410','23','priority_default','Low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('411','23','priority_disaster','Critical');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('412','23','priority_high','High');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('413','23','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('414','23','samanage_token','<PUT YOUR TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('415','23','samanage_url','<PUT YOUR INSTANCE URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('416','24','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('417','24','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('418','24','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('419','24','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('420','24','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('421','24','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('422','24','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('423','24','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('424','24','sysaid_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('425','24','sysaid_auth_user','<PUT YOUR USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('426','24','sysaid_category_level_1','<PUT YOUR CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('427','24','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('428','24','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('429','24','sysaid_default_priority_id','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('430','24','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('431','24','sysaid_incident_state','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('432','24','sysaid_template_id','<PUT YOUR TEMPLATE ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('433','24','sysaid_urgency_id','<PUT YOUR URGENCY ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('434','24','sysaid_url','<PUT YOUR SYSAID URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('435','24','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('436','24','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('437','25','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('438','25','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('439','25','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('440','25','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('441','25','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('442','25','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('443','25','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('444','25','severity_average','P3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('445','25','severity_default','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('446','25','severity_disaster','P1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('447','25','severity_high','P2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('448','25','severity_information','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('449','25','severity_not_classified','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('450','25','severity_warning','P4');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('451','25','topdesk_api','<put your TOPdesk API URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('452','25','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('453','25','topdesk_password','<put your TOPdesk application password>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('454','25','topdesk_status','<put default status for new tickets>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('455','25','topdesk_user','<put your TOPdesk username>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('456','25','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('457','25','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('458','26','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('459','26','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('460','26','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('461','26','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('462','26','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('463','26','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('464','26','itop_api_version','1.3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('465','26','itop_class','UserRequest');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('466','26','itop_comment','Created by Zabbix action {ACTION.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('467','26','itop_id','{EVENT.TAGS.__zbx_itop_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('468','26','itop_log','private_log');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('469','26','itop_organization_id','<PLACE ORGANIZATION ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('470','26','itop_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('471','26','itop_url','<PLACE YOUR ITOP URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('472','26','itop_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('473','27','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('474','27','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('475','27','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('476','27','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('477','27','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('478','27','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('479','27','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('480','27','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('481','27','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('482','27','field_1_full:Host','{HOST.NAME} [{HOST.IP}]');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('483','27','field_2_short:Severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('484','27','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('485','27','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('486','27','field_4_short_r:Event duration','{EVENT.DURATION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('487','27','field_5_short:Operational data','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('488','27','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('489','27','rc_api_url','api/v1/');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('490','27','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('491','27','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('492','27','rc_send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('493','27','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('494','27','rc_url','<PLACE YOUR INSTANCE URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('495','27','rc_user_id','<PLACE USER ID HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('496','27','rc_user_token','<PLACE TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('497','27','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('498','28','event_info','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('499','28','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('500','28','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('501','28','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('502','28','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('503','28','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('504','28','field:entity_display_name','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('505','28','field:entity_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('506','28','field:hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('507','28','field:monitoring_tool','Zabbix');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('508','28','field:operational_data','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('509','28','field:severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('510','28','field:state_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('511','28','field_p:trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('512','28','field_r:event_duration','{EVENT.DURATION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('513','28','field_r:recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('514','28','priority_average','WARNING');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('515','28','priority_default','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('516','28','priority_disaster','CRITICAL');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('517','28','priority_high','WARNING');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('518','28','priority_information','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('519','28','priority_not_classified','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('520','28','priority_resolved','OK');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('521','28','priority_update','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('522','28','priority_warning','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('523','28','vops_endpoint','<PLACE ENDPOINT URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('524','28','vops_routing_key','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('525','29','endpoint','<PLACE HTTP API URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('526','29','flash','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('527','29','password','<PLACE PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('528','29','ring','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('529','29','send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('530','29','telauto','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('531','29','text','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('532','29','username','<PLACE USERNAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('533','9','channel_id','{EVENT.TAGS.__channel_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('534','9','message_ts','{EVENT.TAGS.__message_ts}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('535','30','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('536','30','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('537','30','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('538','30','express_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('539','30','express_send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('540','30','express_tags','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('541','30','express_token','<PLACE BOT TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('542','30','express_url','<PLACE INSTANCE URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('543','31','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('544','31','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('545','31','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('546','31','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('547','31','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('548','31','field_ref:requester','<PLACE API USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('549','31','field_string:description','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('550','31','field_string:subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('551','31','priority_average','Normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('552','31','priority_default','Normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('553','31','priority_disaster','High');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('554','31','priority_high','High');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('555','31','priority_information','Low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('556','31','priority_not_classified','Low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('557','31','priority_warning','Medium');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('558','31','sd_on_demand_client_id','<PLACE ON DEMAND CLIENT ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('559','31','sd_on_demand_client_secret','<PLACE ON DEMAND CLIENT SECRET>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('560','31','sd_on_demand_refresh_token','<PLACE ON DEMAND REFRESH TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('561','31','sd_on_demand_url_auth','<PLACE AUTHENTICATION URL FOR ON DEMAND>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('562','31','sd_on_premise','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('563','31','sd_on_premise_auth_token','<PLACE ON PREMISE TECHNICIAN_KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('564','31','sd_request_id','{EVENT.TAGS.__zbx_sd_request_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('565','31','sd_url','<PLACE INSTANCE URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('566','31','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('10','3','2','0','','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('16','11','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('17','11','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('18','11','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('19','11','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('20','11','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('21','12','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('22','12','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('23','12','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('24','12','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('25','12','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('26','13','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('27','13','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('28','13','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('29','13','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('30','13','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('31','14','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('32','14','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('33','14','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('34','14','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('35','14','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('36','15','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('37','15','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('38','15','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('39','15','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('40','15','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('41','16','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('42','16','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('43','16','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('44','16','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('45','16','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('46','17','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('47','17','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('48','17','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('49','17','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('50','17','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('51','17','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('52','18','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('53','18','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('54','18','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('55','18','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('56','18','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('57','19','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('58','19','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('59','19','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('60','19','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('61','19','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('62','20','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('63','20','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('64','20','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('65','20','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('66','20','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('67','21','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('68','21','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('69','21','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('70','21','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('71','21','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('72','10','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('73','10','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('74','10','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('75','10','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('76','10','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('77','22','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('78','22','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('79','22','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('80','5','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('81','5','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('82','5','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('83','5','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('84','5','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('85','6','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('86','6','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('87','6','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('88','6','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('89','6','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('90','7','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('91','7','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('92','7','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('93','7','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('94','7','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('95','8','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('96','8','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('97','8','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('98','8','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('99','8','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('100','9','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('101','9','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('102','9','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('103','9','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('104','9','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('105','23','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n\r\nTrigger description: {TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('106','23','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('107','23','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('108','23','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('109','23','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('110','24','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('111','24','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('112','24','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('113','24','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('114','24','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('115','25','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('116','25','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('117','25','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('118','25','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('119','25','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('120','26','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('121','26','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('122','26','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('123','26','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('124','26','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('125','27','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('126','27','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('127','27','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('128','27','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('129','27','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('130','28','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('131','28','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('132','28','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('133','28','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('134','28','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('135','29','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('136','29','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('137','29','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('138','29','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('139','29','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('140','30','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('141','30','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('142','30','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('143','30','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('144','30','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('145','31','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('146','31','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('147','31','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('148','31','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('149','31','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('7','Zabbix administrators','0','0','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('8','Guests','1','0','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('9','Disabled','0','1','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('11','Enabled debug mode','0','0','1');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('12','No access to the frontend','3','0','0');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('2','8','2');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('3','9','2');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('4','7','1');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`) values ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`) values ('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`) values ('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('2','Auto discovery. Linux servers.','1','0','1','0','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('3','Report problems to Zabbix administrators','0','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('4','Report not supported items','3','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('5','Report not supported low level discovery rules','3','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('6','Report unknown triggers','3','0','1','1h','','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('1','2','6','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('2','2','4','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('3','3','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('4','4','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('5','5','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('6','6','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('7','3','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('8','4','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('9','5','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('10','6','11','0','1','1','0','1');
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('3','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('4','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('5','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('6','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('7','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('8','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('9','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('10','1','','',NULL);
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('1','3','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('2','4','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('3','5','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('4','6','7');
INSERT INTO `opgroup` (`opgroupid`,`operationid`,`groupid`) values ('1','2','2');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('2','2','10','0','0','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('3','2','8','0','9','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('4','2','12','2','Linux','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('6','4','23','0','0','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('7','5','23','0','2','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('8','6','23','0','4','');
INSERT INTO `config` (`configid`,`refresh_unsupported`,`work_period`,`alert_usrgrpid`,`discovery_groupid`) values ('1','10m','1-5,09:00-18:00','7','5');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `globalmacro` (`globalmacroid`,`macro`,`value`,`description`,`type`) values ('2','{$SNMP_COMMUNITY}','public','','0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('1','File systems for discovery','ext3');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('2','Network interfaces for discovery','eth0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('3','Storage devices for SNMP discovery','/boot');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('4','Windows service names for discovery','SysmonLog');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('5','Windows service startup states for discovery','automatic');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('6','5','^(automatic|automatic delayed)$','3',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('7','2','^Software Loopback Interface','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('9','2','^NULL[0-9.]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('10','2','^[Ll]o[0-9.]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('11','2','^[Ss]ystem$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('12','2','^Nu[0-9.]*$','4',',','1');
INSERT INTO `config_autoreg_tls` (`autoreg_tlsid`,`tls_psk_identity`,`tls_psk`) values ('1','','');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10001',NULL,'Template OS Linux by Zabbix agent','3','-1','2','','','Template OS Linux by Zabbix agent','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.\r\n\r\nKnown Issues:\r\n\r\n  Description: Network discovery. Zabbix agent as of 4.2 doesn\'t support items such as net.if.status, net.if.speed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10047',NULL,'Template App Zabbix Server','3','-1','2','','','Template App Zabbix Server','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10048',NULL,'Template App Zabbix Proxy','3','-1','2','','','Template App Zabbix Proxy','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10050',NULL,'Template Module Zabbix agent','3','-1','2','','','Template Module Zabbix agent','0',NULL,'Use this template for agents reachable from Zabbix server/proxy (passive mode).\r\n\r\nTemplate tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10074',NULL,'Template OS OpenBSD','3','-1','2','','','Template OS OpenBSD','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10075',NULL,'Template OS FreeBSD','3','-1','2','','','Template OS FreeBSD','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10076',NULL,'Template OS AIX','3','-1','2','','','Template OS AIX','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10077',NULL,'Template OS HP-UX','3','-1','2','','','Template OS HP-UX','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10078',NULL,'Template OS Solaris','3','-1','2','','','Template OS Solaris','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10079',NULL,'Template OS Mac OS X','3','-1','2','','','Template OS Mac OS X','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10081',NULL,'Template OS Windows by Zabbix agent','3','-1','2','','','Template OS Windows by Zabbix agent','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10093',NULL,'Template App FTP Service','3','-1','2','','','Template App FTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10094',NULL,'Template App HTTP Service','3','-1','2','','','Template App HTTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10095',NULL,'Template App HTTPS Service','3','-1','2','','','Template App HTTPS Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10096',NULL,'Template App IMAP Service','3','-1','2','','','Template App IMAP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10097',NULL,'Template App LDAP Service','3','-1','2','','','Template App LDAP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10098',NULL,'Template App NNTP Service','3','-1','2','','','Template App NNTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10099',NULL,'Template App NTP Service','3','-1','2','','','Template App NTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10100',NULL,'Template App POP Service','3','-1','2','','','Template App POP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10101',NULL,'Template App SMTP Service','3','-1','2','','','Template App SMTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10102',NULL,'Template App SSH Service','3','-1','2','','','Template App SSH Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10103',NULL,'Template App Telnet Service','3','-1','2','','','Template App Telnet Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10169',NULL,'Template App Generic Java JMX','3','-1','2','','','Template App Generic Java JMX','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10170',NULL,'Template DB MySQL','3','-1','2','','','Template DB MySQL','0',NULL,'Requirements for template operation:\r\n1.Install Zabbix agent and MySQL client.\r\n2.Copy Template_DB_MySQL.conf into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget restart zabbix-agent. \r\n3.Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT USAGE,REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. \r\n4.Create .my.cnf in home directory of Zabbix agent for Linux (/var/lib/zabbix by default ) or my.cnf in c:\\ for Windows. For example:\r\n[client]\r\nuser=zbx_monitor\r\npassword=<password>','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10171',NULL,'Template Server Intel SR1530 IPMI','3','-1','2','','','Template Server Intel SR1530 IPMI','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10172',NULL,'Template Server Intel SR1630 IPMI','3','-1','2','','','Template Server Intel SR1630 IPMI','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10173',NULL,'Template VM VMware','3','-1','2','','','Template VM VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10174',NULL,'Template VM VMware Guest','3','-1','2','','','Template VM VMware Guest','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10175',NULL,'Template VM VMware Hypervisor','3','-1','2','','','Template VM VMware Hypervisor','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10183',NULL,'Template Module EtherLike-MIB SNMP','3','-1','2','','','Template Module EtherLike-MIB SNMP','0',NULL,'Template EtherLike-MIB (duplex control only)\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10185',NULL,'Template Module HOST-RESOURCES-MIB SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB SNMP','0',NULL,'HOST-RESOURCES-MIB: CPU, memory and storage(vfs.fs.file) linked together.\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10186',NULL,'Template Module ICMP Ping','3','-1','2','','','Template Module ICMP Ping','0',NULL,'Template Module ICMP Ping\r\n\r\nTemplate tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10188',NULL,'Template Module Interfaces Simple SNMP','3','-1','2','','','Template Module Interfaces Simple SNMP','0',NULL,'Template Module Interfaces Simple (no ifXTable). This is the exact copy of Template Module Interfaces template with the exception that metrics from ifXTable are replaced with ifTable counters where possible. Use this template with devices where IF-MIB::ifXtable is not available. If supported by the host - use Template Module Interfaces template instead.\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: 32bit counters are used in this template (since there is no ifXtable available). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10190',NULL,'Template Module Interfaces SNMP','3','-1','2','','','Template Module Interfaces SNMP','0',NULL,'Template Module Interfaces\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10192',NULL,'Template Module Interfaces Windows SNMP','3','-1','2','','','Template Module Interfaces Windows SNMP','0',NULL,'Template Interfaces Windows\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: 32bit counters are used in this template (since 64bit are not supported by Windows OS). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10204',NULL,'Template Module Generic SNMP','3','-1','2','','','Template Module Generic SNMP','0',NULL,'Template Module Generic\r\n\r\nMIBs used:\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10207',NULL,'Template Net Alcatel Timetra TiMOS SNMP','3','-1','2','','','Template Net Alcatel Timetra TiMOS SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS\r\n\r\nMIBs used:\r\nTIMETRA-CHASSIS-MIB\r\nTIMETRA-SYSTEM-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10208',NULL,'Template Net Brocade FC SNMP','3','-1','2','','','Template Net Brocade FC SNMP','0',NULL,'Template Net Brocade FC\r\n\r\nMIBs used:\r\nSW-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: no IF-MIB::ifAlias is available\r\n  Version: v6.3.1c, v7.0.0c,  v7.4.1c\r\n  Device: all\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10209',NULL,'Template Module Brocade_Foundry Performance SNMP','3','-1','2','','','Template Module Brocade_Foundry Performance SNMP','0',NULL,'Template Module Brocade_Foundry Performance\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10210',NULL,'Template Net Brocade_Foundry Nonstackable SNMP','3','-1','2','','','Template Net Brocade_Foundry Nonstackable SNMP','0',NULL,'Template Net Brocade_Foundry Nonstackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10211',NULL,'Template Net Brocade_Foundry Stackable SNMP','3','-1','2','','','Template Net Brocade_Foundry Stackable SNMP','0',NULL,'Template Brocade_Foundry Stackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\nFOUNDRY-SN-STACKING-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Correct fan(returns fan status as \'other(1)\' and temperature (returns 0) for the non-master Switches are not available in SNMP\r\n  Version: Version 08.0.40b and above\r\n  Device: ICX 7750 in stack\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10212',NULL,'Template Module Cisco CISCO-MEMORY-POOL-MIB SNMP','3','-1','2','','','Template Module Cisco CISCO-MEMORY-POOL-MIB SNMP','0',NULL,'Template Cisco CISCO-MEMORY-POOL-MIB\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10213',NULL,'Template Module Cisco CISCO-PROCESS-MIB SNMP','3','-1','2','','','Template Module Cisco CISCO-PROCESS-MIB SNMP','0',NULL,'Template Cisco CISCO-PROCESS-MIB\r\n\r\nMIBs used:\r\nCISCO-PROCESS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10215',NULL,'Template Module Cisco OLD-CISCO-CPU-MIB SNMP','3','-1','2','','','Template Module Cisco OLD-CISCO-CPU-MIB SNMP','0',NULL,'Template Cisco OLD-CISCO-CPU-MIB\r\n\r\nMIBs used:\r\nOLD-CISCO-CPU-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10216',NULL,'Template Module Cisco Inventory SNMP','3','-1','2','','','Template Module Cisco Inventory SNMP','0',NULL,'Template Cisco Inventory\r\n\r\nMIBs used:\r\nENTITY-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10217',NULL,'Template Module Cisco CISCO-ENVMON-MIB SNMP','3','-1','2','','','Template Module Cisco CISCO-ENVMON-MIB SNMP','0',NULL,'Template Cisco CISCO-ENVMON-MIB\r\n\r\nMIBs used:\r\nCISCO-ENVMON-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10218',NULL,'Template Net Cisco IOS SNMP','3','-1','2','','','Template Net Cisco IOS SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later\r\n\r\nKnown Issues:\r\n\r\n  Description: no if(in|out)(Errors|Discards) are available for vlan ifType\r\n  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2\r\n  Device: C2911, C7600\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10220',NULL,'Template Net Cisco IOS prior to 12.0_3_T SNMP','3','-1','2','','','Template Net Cisco IOS prior to 12.0_3_T SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10221',NULL,'Template Net Dell Force S-Series SNMP','3','-1','2','','','Template Net Dell Force S-Series SNMP','0',NULL,'Template Dell Force S-Series\r\n\r\nMIBs used:\r\nF10-S-SERIES-CHASSIS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10222',NULL,'Template Net D-Link DES 7200 SNMP','3','-1','2','','','Template Net D-Link DES 7200 SNMP','0',NULL,'Template D-Link DES 7200\r\n\r\nMIBs used:\r\nMY-PROCESS-MIB\r\nSNMPv2-MIB\r\nMY-MEMORY-MIB\r\nENTITY-MIB\r\nMY-SYSTEM-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10223',NULL,'Template Net D-Link DES_DGS Switch SNMP','3','-1','2','','','Template Net D-Link DES_DGS Switch SNMP','0',NULL,'Template D-Link DES_DGS Switch\r\n\r\nMIBs used:\r\nDLINK-AGENT-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nEQUIPMENT-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: D-Link reports missing PSU as fail(4)\r\n  Version: Firmware: 1.73R008,hardware revision: B1\r\n  Device: DGS-3420-26SC Gigabit Ethernet Switch\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10224',NULL,'Template Net Extreme EXOS SNMP','3','-1','2','','','Template Net Extreme EXOS SNMP','0',NULL,'Template Extreme EXOS\r\n\r\nMIBs used:\r\nEXTREME-SOFTWARE-MONITOR-MIB\r\nEXTREME-SYSTEM-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10226',NULL,'Template Net Network Generic Device SNMP','3','-1','2','','','Template Net Network Generic Device SNMP','0',NULL,'Template Net Network Generic Device\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10227',NULL,'Template Net HP Comware HH3C SNMP','3','-1','2','','','Template Net HP Comware HH3C SNMP','0',NULL,'Template Net HP Comware (HH3C)\r\n\r\nMIBs used:\r\nENTITY-MIB\r\nHH3C-ENTITY-EXT-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature\r\n  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP\r\n  Device: HP 1910-48\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10229',NULL,'Template Net Huawei VRP SNMP','3','-1','2','','','Template Net Huawei VRP SNMP','0',NULL,'Template Net Huawei VRP\r\n\r\nMIBs used:\r\nHUAWEI-ENTITY-EXTENT-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10230',NULL,'Template Net Intel_Qlogic Infiniband SNMP','3','-1','2','','','Template Net Intel_Qlogic Infiniband SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband\r\n\r\nMIBs used:\r\nICS-CHASSIS-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10231',NULL,'Template Net Juniper SNMP','3','-1','2','','','Template Net Juniper SNMP','0',NULL,'Template Net Juniper\r\n\r\nMIBs used:\r\nJUNIPER-ALARM-MIB\r\nJUNIPER-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10233',NULL,'Template Net Mikrotik SNMP','3','-1','2','','','Template Net Mikrotik SNMP','0',NULL,'Template Net Mikrotik\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nMIKROTIK-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t have ifHighSpeed filled. fixed in more recent versions\r\n  Version: RouterOS 6.28 or lower\r\n\r\n  Description: Doesn\'t have any temperature sensors\r\n  Version: RouterOS 6.38.5\r\n  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10234',NULL,'Template Net Netgear Fastpath SNMP','3','-1','2','','','Template Net Netgear Fastpath SNMP','0',NULL,'Template Net Netgear Fastpath\r\n\r\nMIBs used:\r\nFASTPATH-SWITCHING-MIB\r\nFASTPATH-BOXSERVICES-PRIVATE-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10235',NULL,'Template Net QTech QSW SNMP','3','-1','2','','','Template Net QTech QSW SNMP','0',NULL,'Template Net QTech QSW\r\n\r\nMIBs used:\r\nQTECH-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10236',NULL,'Template Net TP-LINK SNMP','3','-1','2','','','Template Net TP-LINK SNMP','0',NULL,'Template Net TP-LINK\r\n\r\nMIBs used:\r\nTPLINK-SYSINFO-MIB\r\nTPLINK-SYSMONITOR-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch (TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firmware: https://www.tp-link.com/en/support/download/t2600g-28ts/#Firmware\r\n  Version: 2.0.0 Build 20170628 Rel.55184 (Beta)\r\n  Device: T2600G-28TS 2.0\r\n\r\n  Description: The Serial number of the product (tpSysInfoSerialNum) is missing in HW versions prior to V2_170323\r\n  Version: Prior to version V2_170323\r\n  Device: T2600G-28TS 2.0\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10237',NULL,'Template Net Ubiquiti AirOS SNMP','3','-1','2','','','Template Net Ubiquiti AirOS SNMP','0',NULL,'Template Net Ubiquiti AirOS\r\n\r\nMIBs used:\r\nIEEE802dot11-MIB\r\nFROGFOOT-RESOURCES-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces\r\n  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513\r\n  Device: UBNT UAP-LR\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead\r\n  Version: all above\r\n  Device: NanoStation, UAP-LR\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10248',NULL,'Template OS Linux SNMP','3','-1','2','','','Template OS Linux SNMP','0',NULL,'Template OS Linux\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10249',NULL,'Template OS Windows SNMP','3','-1','2','','','Template OS Windows SNMP','0',NULL,'Official Windows SNMP template. Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t support In/Out 64 bit counters even though IfxTable is present:\r\nCurrently, Windows gets it’s interface status from MIB-2. Since these 64bit SNMP counters (ifHCInOctets, ifHCOutOctets, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.\r\nhttps://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen\r\n\r\n  Version: Win2008, Win2012R2.\r\n\r\n  Description: Doesn\'t support ifXTable at all\r\n  Version: WindowsXP\r\n\r\n  Description: EtherLike MIB is not supported\r\n  Version: *\r\n  Device: *\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10250',NULL,'Template Net HP Enterprise Switch SNMP','3','-1','2','','','Template Net HP Enterprise Switch SNMP','0',NULL,'Template Net HP Enterprise Switch\r\n\r\nMIBs used:\r\nSEMI-MIB\r\nNETSWITCH-MIB\r\nHP-ICF-CHASSIS\r\nENTITY-SENSORS-MIB\r\nENTITY-MIB\r\nSTATISTICS-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10251',NULL,'Template Net Mellanox SNMP','3','-1','2','','','Template Net Mellanox SNMP','0',NULL,'The updated template for monitoring the Mellanox network switches over SNMP agent. All items collected in one template without any linked templates.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10252',NULL,'Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5\r\n\r\nMIBs used:\r\nCISCO-PROCESS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10253',NULL,'Template Net Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Template Net Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10254',NULL,'Template Net Arista SNMP','3','-1','2','','','Template Net Arista SNMP','0',NULL,'Template Net Arista\r\n\r\nMIBs used:\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10255',NULL,'Template Server Dell iDRAC SNMP','3','-1','2','','','Template Server Dell iDRAC SNMP','0',NULL,'Template Server iDRAC\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10256',NULL,'Template Server HP iLO SNMP','3','-1','2','','','Template Server HP iLO SNMP','0',NULL,'Template Server HP iLO\r\n\r\nMIBs used:\r\nCPQSINFO-MIB\r\nCPQHLTH-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10258',NULL,'Template Server IBM IMM SNMP','3','-1','2','','','Template Server IBM IMM SNMP','0',NULL,'Template Server IBM IMM\r\n\r\nMIBs used:\r\nIMM-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Some IMMs (IMM1) do not return disks\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\n  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10259',NULL,'Template Server Supermicro Aten SNMP','3','-1','2','','','Template Server Supermicro Aten SNMP','0',NULL,'Template Server Supermicro Aten\r\n\r\nMIBs used:\r\nATEN-IPMI-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10260',NULL,'Template App Apache Tomcat JMX','3','-1','2','','','Template App Apache Tomcat JMX','0',NULL,'The template to monitor Apache Tomcat by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411862-discussion-thread-for-official-zabbix-template-tomcat\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10261',NULL,'Template App Remote Zabbix server','3','-1','2','','','Template App Remote Zabbix server','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10262',NULL,'Template App Remote Zabbix proxy','3','-1','2','','','Template App Remote Zabbix proxy','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10263',NULL,'Template DB PostgreSQL','3','-1','2','','','Template DB PostgreSQL','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10264',NULL,'Template App Apache by Zabbix agent','3','-1','2','','','Template App Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10265',NULL,'Template App Apache by HTTP','3','-1','2','','','Template App Apache by HTTP','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10266',NULL,'Template App Nginx by Zabbix agent','3','-1','2','','','Template App Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nTemplate tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10267',NULL,'Template App Nginx by HTTP','3','-1','2','','','Template App Nginx by HTTP','0',NULL,'Get metrics from stub status module using HTTP agent\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nTemplate tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10268',NULL,'Template Module Linux memory SNMP','3','-1','2','','','Template Module Linux memory SNMP','0',NULL,'MIBs used:\r\nUCD-SNMP-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Please note that memory utilization is a rough estimate, since memory available is calculated as free+buffers+cached, which is not 100% accurate, but the best we can get using SNMP.\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10269',NULL,'Template Module Linux block devices SNMP','3','-1','2','','','Template Module Linux block devices SNMP','0',NULL,'MIBs used:\r\nUCD-DISKIO-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10270',NULL,'Template Module Linux CPU SNMP','3','-1','2','','','Template Module Linux CPU SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\nUCD-SNMP-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10271',NULL,'Template Module Linux filesystems SNMP','3','-1','2','','','Template Module Linux filesystems SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\nUCD-SNMP-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10272',NULL,'Template Module Linux CPU by Zabbix agent','3','-1','2','','','Template Module Linux CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10273',NULL,'Template Module Linux filesystems by Zabbix agent','3','-1','2','','','Template Module Linux filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10274',NULL,'Template Module Linux memory by Zabbix agent','3','-1','2','','','Template Module Linux memory by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10275',NULL,'Template Module Linux block devices by Zabbix agent','3','-1','2','','','Template Module Linux block devices by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10276',NULL,'Template Module Linux network interfaces by Zabbix agent','3','-1','2','','','Template Module Linux network interfaces by Zabbix agent','0',NULL,'Known Issues:\r\n\r\n  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10277',NULL,'Template Module Linux generic by Zabbix agent','3','-1','2','','','Template Module Linux generic by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10278',NULL,'Template Module Linux CPU by Zabbix agent active','3','-1','2','','','Template Module Linux CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10279',NULL,'Template Module Linux filesystems by Zabbix agent active','3','-1','2','','','Template Module Linux filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10280',NULL,'Template Module Linux memory by Zabbix agent active','3','-1','2','','','Template Module Linux memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10281',NULL,'Template Module Linux block devices by Zabbix agent active','3','-1','2','','','Template Module Linux block devices by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10282',NULL,'Template Module Linux network interfaces by Zabbix agent active','3','-1','2','','','Template Module Linux network interfaces by Zabbix agent active','0',NULL,'Known Issues:\r\n\r\n  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10283',NULL,'Template Module Linux generic by Zabbix agent active','3','-1','2','','','Template Module Linux generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10284',NULL,'Template OS Linux by Zabbix agent active','3','-1','2','','','Template OS Linux by Zabbix agent active','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.\r\n\r\nKnown Issues:\r\n\r\n  Description: Network discovery. Zabbix agent as of 4.2 doesn\'t support items such as net.if.status, net.if.speed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10285',NULL,'Template OS Linux by Prom','3','-1','2','','','Template OS Linux by Prom','0',NULL,'Official Linux template using node exporter.\r\n\r\nKnown Issues:\r\n\r\n  Description: node_exporter v0.16.0 renamed many metrics. CPU utilization for \'guest\' and \'guest_nice\' metrics are not supported in this template with node_exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as \'best effort\'.  \r\n See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.\r\n  Version: below 0.16.0\r\n\r\n  Description: metric node_network_info with label \'device\' cannot be found, so network discovery is not possible.\r\n  Version: below 0.18\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10286',NULL,'Template Module Windows CPU by Zabbix agent','3','-1','2','','','Template Module Windows CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10287',NULL,'Template Module Windows memory by Zabbix agent','3','-1','2','','','Template Module Windows memory by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10288',NULL,'Template Module Windows filesystems by Zabbix agent','3','-1','2','','','Template Module Windows filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10289',NULL,'Template Module Windows physical disks by Zabbix agent','3','-1','2','','','Template Module Windows physical disks by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10290',NULL,'Template Module Windows generic by Zabbix agent','3','-1','2','','','Template Module Windows generic by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10291',NULL,'Template Module Windows network by Zabbix agent','3','-1','2','','','Template Module Windows network by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10292',NULL,'Template Module Zabbix agent active','3','-1','2','','','Template Module Zabbix agent active','0',NULL,'Use this template instead of \'Template Module Zabbix agent\' for agents running in active mode only.\r\n\r\nTemplate tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10293',NULL,'Template Module Windows CPU by Zabbix agent active','3','-1','2','','','Template Module Windows CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10294',NULL,'Template Module Windows memory by Zabbix agent active','3','-1','2','','','Template Module Windows memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10295',NULL,'Template Module Windows filesystems by Zabbix agent active','3','-1','2','','','Template Module Windows filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10296',NULL,'Template Module Windows physical disks by Zabbix agent active','3','-1','2','','','Template Module Windows physical disks by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10297',NULL,'Template Module Windows generic by Zabbix agent active','3','-1','2','','','Template Module Windows generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10298',NULL,'Template Module Windows network by Zabbix agent active','3','-1','2','','','Template Module Windows network by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10299',NULL,'Template OS Windows by Zabbix agent active','3','-1','2','','','Template OS Windows by Zabbix agent active','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10300',NULL,'Template App RabbitMQ cluster by Zabbix agent','3','-1','2','','','Template App RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10301',NULL,'Template App RabbitMQ node by Zabbix agent','3','-1','2','','','Template App RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10302',NULL,'Template App RabbitMQ cluster by HTTP','3','-1','2','','','Template App RabbitMQ cluster by HTTP','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10303',NULL,'Template App RabbitMQ node by HTTP','3','-1','2','','','Template App RabbitMQ node by HTTP','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10304',NULL,'Template Server Cisco UCS SNMP','3','-1','2','','','Template Server Cisco UCS SNMP','0',NULL,'Template Server Cisco UCS\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10305',NULL,'Template Module HOST-RESOURCES-MIB CPU SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB CPU SNMP','0',NULL,'Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10306',NULL,'Template Module HOST-RESOURCES-MIB memory SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB memory SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10307',NULL,'Template Module HOST-RESOURCES-MIB storage SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB storage SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10308',NULL,'Template App HAProxy by Zabbix agent','3','-1','2','','','Template App HAProxy by Zabbix agent','0',NULL,'Get metrics from status page using Zabbix agent\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.\r\nExample configuration of HAProxy:\r\n  frontend stats\r\n      bind *:8404\r\n      stats enable\r\n      stats uri /stats\r\n      stats refresh 10s\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nTemplate tooling version used: 0.39','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10309',NULL,'Template App HAProxy by HTTP','3','-1','2','','','Template App HAProxy by HTTP','0',NULL,'Get metrics from status page using HTTP agent\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.\r\nExample configuration of HAProxy:\r\n  frontend stats\r\n      bind *:8404\r\n      stats enable\r\n      stats uri /stats\r\n      stats refresh 10s\r\n      #stats auth Username:Password  # Authentication credentials\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nTemplate tooling version used: 0.39','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10310',NULL,'Template DB Redis','3','-1','2','','','Template DB Redis','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis\r\n\r\nTemplate tooling version used: 0.33','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10314',NULL,'Template Module Windows services by Zabbix agent','3','-1','2','','','Template Module Windows services by Zabbix agent','0',NULL,'Template Services OS Windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10315',NULL,'Template Module Windows services by Zabbix agent active','3','-1','2','','','Template Module Windows services by Zabbix agent active','0',NULL,'Template Services OS Windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10316',NULL,'Template DB MySQL by Zabbix agent','3','-1','2','','','Template DB MySQL by Zabbix agent','0',NULL,'Requirements for template operation:\r\n1.Install Zabbix agent and MySQL client.\r\n2.Copy template_db_mysql.conf into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart zabbix-agent. \r\n3.Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. \r\n4.Create .my.cnf in home directory of Zabbix agent for Linux (/var/lib/zabbix by default ) or my.cnf in c:\\ for Windows. For example:\r\n[client]\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10317',NULL,'Template DB MySQL by ODBC','3','-1','2','','','Template DB MySQL by ODBC','0',NULL,'Requirements for template operation:\r\n1. Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. \r\n2. Set the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10318',NULL,'Template App Docker','3','-1','2','','','Template App Docker','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum \r\n\r\nTemplate tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10319',NULL,'Template App Memcached','3','-1','2','','','Template App Memcached','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached\r\n\r\nTemplate tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10320',NULL,'Template DB MySQL by Zabbix agent 2','3','-1','2','','','Template DB MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:\r\n1. Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\nExamples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\nLeave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10321',NULL,'Template Server Chassis by IPMI','3','-1','2','','','Template Server Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts. \r\nAll metrics are collected at once, thanks to Zabbix\'s bulk data collection. The template is available starting from Zabbix version 5.0. \r\nIt collects metrics by polling BMC remotely using an IPMI agent.\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi\r\n\r\nTemplate tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10322',NULL,'Template App Elasticsearch Cluster by HTTP','3','-1','2','','','Template App Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected in one pass remotely using an HTTP agent. \r\nThey are getting values from REST API _cluster/health, _cluster/stats, _nodes/stats requests.\r\nYou can set {$ELASTICSEARCH.USERNAME} and {$ELASTICSEARCH.PASSWORD} macros in the template for using on the host level.\r\nIf you use an atypical location ES API, don\'t forget to change the macros {$ELASTICSEARCH.SCHEME},{$ELASTICSEARCH.PORT}.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10323',NULL,'Template DB ClickHouse by HTTP','3','-1','2','','','Template DB ClickHouse by HTTP','0',NULL,'Get node metrics from ClickHouse HTTP interface using HTTP agent.\r\n\r\nTemplate tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10324',NULL,'Template App Etcd by HTTP','3','-1','2','','','Template App Etcd by HTTP','0',NULL,'Get Etcd metrics by HTTP agent.\r\n\r\nTemplate tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10325',NULL,'Template App IIS by Zabbix agent','3','-1','2','','','Template App IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nTemplate tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10326',NULL,'Template App IIS by Zabbix agent active','3','-1','2','','','Template App IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nTemplate tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10327',NULL,'Template DB MSSQL by ODBC','3','-1','2','','','Template DB MSSQL by ODBC','0',NULL,'1. Create an MSSQL user for monitoring.\r\n  View Server State and View Any Definition permissions should be granted to the user.\r\n  Grant this user read permissions to the sysjobschedules, sysjobhistory, sysjobs tables.  \r\n  For more information, see MSSQL documentation.\r\n2. Set the user name and password in host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).\r\n  Do not forget to install Microsoft ODBC driver on Zabbix server or Zabbix proxy.\r\n  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver15.\r\n  Note! Credentials in the odbc.ini do not work for MSSQL.\r\n3. For named instance set the value of {$MSSQL.INSTANCE} macro as MSSQL$instance name.\r\nThe "Service\'s TCP port state" item uses {HOST.CONN} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10328',NULL,'Template DB PostgreSQL Agent 2','3','-1','2','','','Template DB PostgreSQL Agent 2','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10330',NULL,'Template VM VMware macros','3','-1','2','','','Template VM VMware macros','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10331',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10332',NULL,'{#VM.UUID}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10333',NULL,'Template DB Oracle by Zabbix Agent 2','3','-1','2','','','Template DB Oracle by Zabbix Agent 2','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10334',NULL,'Template App Ceph by Zabbix Agent2','3','-1','2','','','Template App Ceph by Zabbix Agent2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410059-discussion-thread-for-official-zabbix-template-ceph\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10335',NULL,'Template App PHP-FPM by Zabbix agent','3','-1','2','','','Template App PHP-FPM by Zabbix agent','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10336',NULL,'Template App PHP-FPM by HTTP','3','-1','2','','','Template App PHP-FPM by HTTP','0',NULL,'Get PHP-FPM metrics using the Zabbix HTTP agent.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10337',NULL,'Template App Squid SNMP','3','-1','2','','','Template App Squid SNMP','0',NULL,'Template for monitoring Squid caching proxy via SNMP\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/409339-discussion-thread-for-official-zabbix-template-squid\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10339',NULL,'Template App Hadoop by HTTP','3','-1','2','','','Template App Hadoop by HTTP','0',NULL,'The template gets the Hadoop metrics from cluster\'s hosts (ResourceManager, NodeManagers, NameNode, DataNodes) by HTTP agent. You should define the IP address (or FQDN) and Web-UI port for the ResourceManager in {$HADOOP.RESOURCEMANAGER.HOST} and {$HADOOP.RESOURCEMANAGER.PORT} macros and for the NameNode in {$HADOOP.NAMENODE.HOST} and {$HADOOP.NAMENODE.PORT} macros respectively. Macros can be set in the template or overridden at the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/413459-discussion-thread-for-official-zabbix-template-hadoop\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10340',NULL,'Template APP Apache Kafka by JMX','3','-1','2','','','Template APP Apache Kafka by JMX','0',NULL,'Official JMX Template for Apache Kafka.\r\n  The metrics are collected by JMX.\r\n  You can set {$KAFKA.USER} and {$KAFKA.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10341',NULL,'Template App Zookeeper by HTTP','3','-1','2','','','Template App Zookeeper by HTTP','0',NULL,'Get Apache Zookeeper metrics by HTTP agent.\r\n  This template works with standalone and cluster instances. Metrics are collected from each Zookeper node by requests to AdminServer.  \r\n  Don\'t forget to change macros {$ZOOKEEPER.COMMAND_URL}, {$ZOOKEEPER.PORT}, {$ZOOKEEPER.SCHEME}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10342',NULL,'Template DB Apache Cassandra by JMX','3','-1','2','','','Template DB Apache Cassandra by JMX','0',NULL,'The template to monitor Apache Cassandra by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected by JMX.\r\nYou can set {$CASSANDRA.USER} and {$CASSANDRA.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410057-discussion-thread-for-official-zabbix-template-apache-cassandra\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10343',NULL,'Template Net Morningstar ProStar MPPT SNMP','3','-1','2','','','Template Net Morningstar ProStar MPPT SNMP','0',NULL,'MIBs used:\r\nPROSTAR-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10344',NULL,'Template Net Morningstar ProStar PWM SNMP','3','-1','2','','','Template Net Morningstar ProStar PWM SNMP','0',NULL,'MIBs used:\r\nPROSTAR-PWM\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10345',NULL,'Template Net Morningstar SunSaver MPPT SNMP','3','-1','2','','','Template Net Morningstar SunSaver MPPT SNMP','0',NULL,'MIBs used:\r\nSUNSAVER-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10346',NULL,'Template Net Morningstar SureSine SNMP','3','-1','2','','','Template Net Morningstar SureSine SNMP','0',NULL,'MIBs used:\r\nSURESINE\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10347',NULL,'Template Net Morningstar TriStar MPPT 600V SNMP','3','-1','2','','','Template Net Morningstar TriStar MPPT 600V SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10348',NULL,'Template Net Morningstar TriStar MPPT SNMP','3','-1','2','','','Template Net Morningstar TriStar MPPT SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10349',NULL,'Template Net Morningstar TriStar PWM SNMP','3','-1','2','','','Template Net Morningstar TriStar PWM SNMP','0',NULL,'MIBs used:\r\nTRISTAR\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10350',NULL,'Template App Apache ActiveMQ by JMX','3','-1','2','','','Template App Apache ActiveMQ by JMX','0',NULL,'The template to monitor Apache ActiveMQ by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\nYou can set macro values and add macros with context for specific brokers or destinations following macro description.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411049-discussion-thread-for-official-zabbix-template-amq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10351',NULL,'Template App Microsoft Exchange Server 2016 by Zabbix agent','3','-1','2','','','Template App Microsoft Exchange Server 2016 by Zabbix agent','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent.\r\nRecommended to use it with "OS Windows by Zabbix agent" template.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10352',NULL,'Template App Microsoft Exchange Server 2016 by Zabbix agent active','3','-1','2','','','Template App Microsoft Exchange Server 2016 by Zabbix agent active','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent active.\r\nRecommended to use it with "OS Windows by Zabbix agent active" template.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10353',NULL,'Template SAN NetApp FAS3220 SNMP','3','-1','2','','','Template SAN NetApp FAS3220 SNMP','0',NULL,'The template to monitor SAN NetApp FAS3220 cluster by Zabbix SNMP agent.\r\n\r\nMIBs used:\r\nNETAPP-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/416694-discussion-thread-for-official-zabbix-template-netapp-fas3220\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10354',NULL,'Template DB Ignite by JMX','3','-1','2','','','Template DB Ignite by JMX','0',NULL,'The template to monitor Apache Ignite by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.  \r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$IGNITE.USER} and {$IGNITE.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10355',NULL,'Template Module SMART by Zabbix agent 2','3','-1','2','','','Template Module SMART by Zabbix agent 2','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule finds all Vendor Specific Attributes for each disk. If you want to skip some attributes, please set regular expressions with disk names in {$SMART.DISK.NAME.MATCHES} and with attribute IDs in {$SMART.ATTRIBUTE.ID.MATCHES} macros on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10356',NULL,'Template Module SMART by Zabbix agent active 2','3','-1','2','','','Template Module SMART by Zabbix agent active 2','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent active 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule finds all Vendor Specific Attributes for each disk. If you want to skip some attributes, please set regular expressions with disk names in {$SMART.DISK.NAME.MATCHES} and with attribute IDs in {$SMART.ATTRIBUTE.ID.MATCHES} macros on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10357',NULL,'Template SAN Huawei OceanStor 5300 V5 SNMP','3','-1','2','','','Template SAN Huawei OceanStor 5300 V5 SNMP','0',NULL,'The template to monitor SAN Huawei OceanStor 5300 V5 by Zabbix SNMP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10358',NULL,'RabbitMQ cluster by Zabbix agent','3','-1','2','','','RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10359',NULL,'RabbitMQ node by Zabbix agent','3','-1','2','','','RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10360',NULL,'RabbitMQ cluster by HTTP','3','-1','2','','','RabbitMQ cluster by HTTP','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10361',NULL,'RabbitMQ node by HTTP','3','-1','2','','','RabbitMQ node by HTTP','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10362',NULL,'Template DB MongoDB node by Zabbix Agent 2','3','-1','2','','','Template DB MongoDB node by Zabbix Agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10363',NULL,'Template DB MongoDB cluster by Zabbix Agent 2','3','-1','2','','','Template DB MongoDB cluster by Zabbix Agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\n  All sharded Mongodb nodes (mongod) will be discovered with attached template "MongoDB node".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10364',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10365',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10366',NULL,'Cisco Catalyst 3750V2-24FS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24FS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24FS\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nSNMPv2-MIB\r\nCISCO-PROCESS-MIB\r\nCISCO-ENVMON-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10367',NULL,'Cisco Catalyst 3750V2-24PS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24PS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24PS\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nSNMPv2-MIB\r\nCISCO-PROCESS-MIB\r\nCISCO-ENVMON-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10368',NULL,'Cisco Catalyst 3750V2-24TS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24TS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24TS\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nSNMPv2-MIB\r\nCISCO-PROCESS-MIB\r\nCISCO-ENVMON-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10369',NULL,'Cisco Catalyst 3750V2-48PS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48PS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48PS\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nSNMPv2-MIB\r\nCISCO-PROCESS-MIB\r\nCISCO-ENVMON-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10370',NULL,'Cisco Catalyst 3750V2-48TS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48TS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48TS\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nSNMPv2-MIB\r\nCISCO-PROCESS-MIB\r\nCISCO-ENVMON-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10371',NULL,'Template Power APC UPS SNMP','3','-1','2','','','Template Power APC UPS SNMP','0',NULL,'Template Power APC UPS\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10372',NULL,'Template SAN NetApp AFF A700 by HTTP','3','-1','2','','','Template SAN NetApp AFF A700 by HTTP','0',NULL,'The template to monitor SAN NetApp AFF A700 cluster by Zabbix HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10373',NULL,'Template Power APC UPS Galaxy 3500 SNMP','3','-1','2','','','Template Power APC UPS Galaxy 3500 SNMP','0',NULL,'Template Power APC UPS Galaxy 3500\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10374',NULL,'Template Power APC Smart-UPS 2200 RM SNMP','3','-1','2','','','Template Power APC Smart-UPS 2200 RM SNMP','0',NULL,'Template Power APC Smart-UPS 2200 RM\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10375',NULL,'Template Power APC Smart-UPS 3000 XLM SNMP','3','-1','2','','','Template Power APC Smart-UPS 3000 XLM SNMP','0',NULL,'Template Power APC Smart-UPS 3000 XLM\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10376',NULL,'Template Power APC Smart-UPS RT 1000 RM XL SNMP','3','-1','2','','','Template Power APC Smart-UPS RT 1000 RM XL SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 RM XL\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10377',NULL,'Template Power APC Smart-UPS RT 1000 XL SNMP','3','-1','2','','','Template Power APC Smart-UPS RT 1000 XL SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 XL\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10378',NULL,'Template Power APC Smart-UPS SRT 5000 SNMP','3','-1','2','','','Template Power APC Smart-UPS SRT 5000 SNMP','0',NULL,'Template Power APC Smart-UPS SRT 5000\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10379',NULL,'Template Power APC Smart-UPS SRT 8000 SNMP','3','-1','2','','','Template Power APC Smart-UPS SRT 8000 SNMP','0',NULL,'Template Power APC Smart-UPS SRT 8000\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10380',NULL,'Template Power APC UPS Symmetra LX SNMP','3','-1','2','','','Template Power APC UPS Symmetra LX SNMP','0',NULL,'Template Power APC UPS Symmetra LX\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10381',NULL,'Template Power APC UPS Symmetra RM SNMP','3','-1','2','','','Template Power APC UPS Symmetra RM SNMP','0',NULL,'Template Power APC UPS Symmetra RM\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10382',NULL,'Template Power APC UPS Symmetra RX SNMP','3','-1','2','','','Template Power APC UPS Symmetra RX SNMP','0',NULL,'Template Power APC UPS Symmetra RX\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10383',NULL,'Template APP WildFly Domain by JMX','3','-1','2','','','Template APP WildFly Domain by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with Domain Controller.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10384',NULL,'Template APP WildFly Server by JMX','3','-1','2','','','Template APP WildFly Server by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with standalone and domain instances.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10385',NULL,'Template ZYXEL AAM1212-51 IES-612 SNMP','3','-1','2','','','Template ZYXEL AAM1212-51 IES-612 SNMP','0',NULL,'ZYXEL AAM1212-51 / IES-612\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL AAM1212-51 / IES-612\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10386',NULL,'Template ZYXEL ES3500-8PD SNMP','3','-1','2','','','Template ZYXEL ES3500-8PD SNMP','0',NULL,'ZYXEL ES3500-8PD\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-ES3500-8PD-MIB\r\nIF-MIB\r\nZYXEL-ES3500-8PD-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL ES3500-8PD\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10387',NULL,'Template ZYXEL GS-4012F SNMP','3','-1','2','','','Template ZYXEL GS-4012F SNMP','0',NULL,'ZYXEL GS-4012F\r\n\r\nMIBs used:\r\nZYXEL-GS4012F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL GS-4012F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10388',NULL,'Template ZYXEL IES-500x SNMP','3','-1','2','','','Template ZYXEL IES-500x SNMP','0',NULL,'ZYXEL IES-500x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-500x\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10389',NULL,'Template ZYXEL IES-6000 SNMP','3','-1','2','','','Template ZYXEL IES-6000 SNMP','0',NULL,'ZYXEL IES-6000\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-6000\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10390',NULL,'Template ZYXEL IES1248-51 SNMP','3','-1','2','','','Template ZYXEL IES1248-51 SNMP','0',NULL,'ZYXEL IES1248-51\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES1248-51\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10391',NULL,'Template ZYXEL MES-3528 SNMP','3','-1','2','','','Template ZYXEL MES-3528 SNMP','0',NULL,'ZYXEL MES-3528\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-MES3528-MIB\r\nZYXEL-MES3528-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES-3528\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10392',NULL,'Template ZYXEL MES3500-10 SNMP','3','-1','2','','','Template ZYXEL MES3500-10 SNMP','0',NULL,'ZYXEL MES3500-10\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-MES3500-10-MIB\r\n ZYXEL-MES3500-10-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-10\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10393',NULL,'Template ZYXEL MES3500-24 SNMP','3','-1','2','','','Template ZYXEL MES3500-24 SNMP','0',NULL,'ZYXEL MES3500-24\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-MES3500-24-MIB\r\nZYXEL-MES3500-24-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-24\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10394',NULL,'Template ZYXEL MGS-3712 SNMP','3','-1','2','','','Template ZYXEL MGS-3712 SNMP','0',NULL,'ZYXEL MGS-3712\r\n\r\nMIBs used:\r\nZYXEL-MGS3712F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10395',NULL,'Template ZYXEL MGS-3712F SNMP','3','-1','2','','','Template ZYXEL MGS-3712F SNMP','0',NULL,'ZYXEL MGS-3712F\r\n\r\nMIBs used:\r\nZYXEL-MGS3712F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10396',NULL,'Template ZYXEL MES3500-24S SNMP','3','-1','2','','','Template ZYXEL MES3500-24S SNMP','0',NULL,'ZYXEL MES3500-24S\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10397',NULL,'Template ZYXEL MGS3520-28x SNMP','3','-1','2','','','Template ZYXEL MGS3520-28x SNMP','0',NULL,'ZYXEL MGS3520-28x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10398',NULL,'Template ZYXEL XGS-4728F SNMP','3','-1','2','','','Template ZYXEL XGS-4728F SNMP','0',NULL,'ZYXEL XGS-4728F\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-XGS4728F-MIB\r\nIF-MIB\r\n ZYXEL-XGS4728F-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL XGS-4728F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10399',NULL,'Template App Nginx Plus by HTTP','3','-1','2','','','Template App Nginx Plus by HTTP','0',NULL,'Get Nginx Plus metrics by HTTP agent.\r\nMetrics are collected by requests to Nginx Plus API.\r\nDon\'t forget to change macros {$NGINX.API.ENDPOINT}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10400',NULL,'Template Server Cisco UCS Manager SNMP','3','-1','2','','','Template Server Cisco UCS Manager SNMP','0',NULL,'This is a template for Cisco UCS Manager monitoring via Zabbix SNMP Agent that works without any external scripts.\r\n\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nSNMPv2-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\nIF-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10402',NULL,'Template Server DELL PowerEdge R720 SNMP','3','-1','2','','','Template Server DELL PowerEdge R720 SNMP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10404',NULL,'Template Server DELL PowerEdge R740 SNMP','3','-1','2','','','Template Server DELL PowerEdge R740 SNMP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10406',NULL,'Template Server DELL PowerEdge R820 SNMP','3','-1','2','','','Template Server DELL PowerEdge R820 SNMP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10408',NULL,'Template Server DELL PowerEdge R840 SNMP','3','-1','2','','','Template Server DELL PowerEdge R840 SNMP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10409',NULL,'Template Server HPE ProLiant BL460 SNMP','3','-1','2','','','Template Server HPE ProLiant BL460 SNMP','0',NULL,'Template for HPE ProLiant BL460 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10410',NULL,'Template Server HPE ProLiant BL920 SNMP','3','-1','2','','','Template Server HPE ProLiant BL920 SNMP','0',NULL,'Template for HPE ProLiant BL920 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10411',NULL,'Template Server HPE ProLiant DL360 SNMP','3','-1','2','','','Template Server HPE ProLiant DL360 SNMP','0',NULL,'Template for HPE ProLiant DL360 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10412',NULL,'Template Server HPE ProLiant DL380 SNMP','3','-1','2','','','Template Server HPE ProLiant DL380 SNMP','0',NULL,'Template for HPE ProLiant DL380 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10413',NULL,'Template APP Systemd by Zabbix agent 2','3','-1','2','','','Template APP Systemd by Zabbix agent 2','0',NULL,'Get systemd units metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the Systemd monitoring plugin.\r\n  2. Set filters with macros if you want to override default filter parameters.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10414',NULL,'Template DB GridGain by JMX','3','-1','2','','','Template DB GridGain by JMX','0',NULL,'The template to monitor GridGain In-Memory Computing Platform by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.  \r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$GRIDGAIN.USER} and {$GRIDGAIN.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10415',NULL,'Template F5 Big-IP SNMP','3','-1','2','','','Template F5 Big-IP SNMP','0',NULL,'MIBs used:\r\nRFC1213-MIB\r\nF5-BIGIP-LOCAL-MIB\r\nF5-BIGIP-SYSTEM-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10416',NULL,'Template App Website certificate by Zabbix agent 2','3','-1','2','','','Template App Website certificate by Zabbix agent 2','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.\r\nZabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring\r\n\r\nTemplate tooling version used: 0.39','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10417',NULL,'Template Net Cisco ASAv SNMP','3','-1','2','','','Template Net Cisco ASAv SNMP','0',NULL,'Template Net Cisco ASAv\r\n\r\nMIBs used:\r\nCISCO-PORT-MIB\r\nCISCO-MEMORY-POOL-MIB\r\nCISCO-REMOTE-ACCESS-MONITOR-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n CISCO-REMOTE-ACCESS-MONITOR-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10418',NULL,'Template Net ZYXEL AAM1212-51 IES-612 SNMP','3','-1','2','','','Template Net ZYXEL AAM1212-51 IES-612 SNMP','0',NULL,'ZYXEL AAM1212-51 / IES-612\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL AAM1212-51 / IES-612\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10419',NULL,'Template Net ZYXEL ES3500-8PD SNMP','3','-1','2','','','Template Net ZYXEL ES3500-8PD SNMP','0',NULL,'ZYXEL ES3500-8PD\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-ES3500-8PD-MIB\r\nIF-MIB\r\nZYXEL-ES3500-8PD-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL ES3500-8PD\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10420',NULL,'Template Net ZYXEL GS-4012F SNMP','3','-1','2','','','Template Net ZYXEL GS-4012F SNMP','0',NULL,'ZYXEL GS-4012F\r\n\r\nMIBs used:\r\nZYXEL-GS4012F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL GS-4012F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10421',NULL,'Template Net ZYXEL IES-500x SNMP','3','-1','2','','','Template Net ZYXEL IES-500x SNMP','0',NULL,'ZYXEL IES-500x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-500x\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10422',NULL,'Template Net ZYXEL IES-6000 SNMP','3','-1','2','','','Template Net ZYXEL IES-6000 SNMP','0',NULL,'ZYXEL IES-6000\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-6000\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10423',NULL,'Template Net ZYXEL IES1248-51 SNMP','3','-1','2','','','Template Net ZYXEL IES1248-51 SNMP','0',NULL,'ZYXEL IES1248-51\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES1248-51\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10424',NULL,'Template Net ZYXEL MES-3528 SNMP','3','-1','2','','','Template Net ZYXEL MES-3528 SNMP','0',NULL,'ZYXEL MES-3528\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-MES3528-MIB\r\nZYXEL-MES3528-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES-3528\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10425',NULL,'Template Net ZYXEL MES3500-10 SNMP','3','-1','2','','','Template Net ZYXEL MES3500-10 SNMP','0',NULL,'ZYXEL MES3500-10\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-MES3500-10-MIB\r\n ZYXEL-MES3500-10-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-10\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10426',NULL,'Template Net ZYXEL MES3500-24 SNMP','3','-1','2','','','Template Net ZYXEL MES3500-24 SNMP','0',NULL,'ZYXEL MES3500-24\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-MES3500-24-MIB\r\nZYXEL-MES3500-24-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-24\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10427',NULL,'Template Net ZYXEL MGS-3712 SNMP','3','-1','2','','','Template Net ZYXEL MGS-3712 SNMP','0',NULL,'ZYXEL MGS-3712\r\n\r\nMIBs used:\r\nZYXEL-MGS3712F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10428',NULL,'Template Net ZYXEL MGS-3712F SNMP','3','-1','2','','','Template Net ZYXEL MGS-3712F SNMP','0',NULL,'ZYXEL MGS-3712F\r\n\r\nMIBs used:\r\nZYXEL-MGS3712F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10429',NULL,'Template Net ZYXEL MES3500-24S SNMP','3','-1','2','','','Template Net ZYXEL MES3500-24S SNMP','0',NULL,'ZYXEL MES3500-24S\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10430',NULL,'Template Net ZYXEL MGS3520-28x SNMP','3','-1','2','','','Template Net ZYXEL MGS3520-28x SNMP','0',NULL,'ZYXEL MGS3520-28x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`) values ('10431',NULL,'Template Net ZYXEL XGS-4728F SNMP','3','-1','2','','','Template Net ZYXEL XGS-4728F SNMP','0',NULL,'ZYXEL XGS-4728F\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-XGS4728F-MIB\r\nIF-MIB\r\n ZYXEL-XGS4728F-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL XGS-4728F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('1','10331','{#CLUSTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('2','10331','{#DATACENTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('4','10332','{#CLUSTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('5','10332','{#DATACENTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('6','10332','{#HV.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('24','10364','MongoDB sharded cluster/{#REPLICASET}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('26','10365','MongoDB sharded cluster/{#ID}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('52','10331','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('53','10332','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('54','10364','','13',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('55','10365','','13',NULL);
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('3','System performance','2','7','10001',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('4','Zabbix server health','2','3','10047',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('5','System performance','2','2','10076',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('6','System performance','2','2','10077',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('7','System performance','2','2','10075',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('9','System performance','2','3','10074',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('10','System performance','2','3','10078',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('16','Zabbix server','2','2',NULL,'1','0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('17','Zabbix proxy health','2','2','10048',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('18','System performance','1','2','10079',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('19','System performance','2','6','10081',NULL,'0');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('20','MySQL performance','2','4','10170',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('21','Zabbix server health','2','3','10261',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('22','Zabbix proxy health','2','2','10262',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('23','PostgreSQL databases','2','4','10263',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('24','PostgreSQL stat','2','4','10263',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('25','Apache performance','2','3','10264',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('26','Apache performance','2','3','10265',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('27','Nginx performance','2','2','10266',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('28','Nginx performance','2','2','10267',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('29','System performance','2','6','10248',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('30','Network interfaces','1','1','10276',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('31','Network interfaces','1','1','10282',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('32','System performance','2','7','10284',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('33','System performance','2','7','10285',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('34','Network interfaces','1','1','10285',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('37','System performance','2','6','10299',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('38','RabbitMQ overview','2','3','10300',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('39','RabbitMQ node status','2','3','10301',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('40','RabbitMQ overview','2','3','10302',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('41','RabbitMQ node status','2','3','10303',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('43','Network interfaces','1','1','10190',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('45','Network interfaces','1','1','10188',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('46','Network interfaces','1','1','10192',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('47','System performance','2','3','10185',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('48','HAProxy Backend performance','1','3','10308',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('49','HAProxy Frontend performance','1','4','10308',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('50','HAProxy Server performance','1','3','10308',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('51','HAProxy Backend performance','1','3','10309',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('52','HAProxy Frontend performance','1','4','10309',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('53','HAProxy Server performance','1','3','10309',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('54','Redis overview','2','5','10310',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('55','Redis performance','2','2','10310',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('57','MySQL performance','2','3','10316',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('58','MySQL performance','2','3','10317',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('59','Docker overview','2','5','10318',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('60','MySQL performance','2','3','10320',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('61','PostgreSQL databases','2','5','10328',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('62','RabbitMQ overview','2','3','10358',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('63','RabbitMQ node status','2','3','10359',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('64','RabbitMQ overview','2','3','10360',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('65','RabbitMQ node status','2','3','10361',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('66','Network interfaces','1','1','10251',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('67','System performance','2','3','10251',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('68','UPS Summary','3','4','10371',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('69','UPS Summary','3','4','10373',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('70','UPS Summary','3','4','10374',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('71','UPS Summary','3','4','10375',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('72','UPS Summary','3','4','10376',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('73','UPS Summary','3','4','10377',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('74','UPS Summary','3','4','10378',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('75','UPS Summary','3','4','10379',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('76','UPS Summary','3','4','10380',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('77','UPS Summary','3','4','10381',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('78','UPS Summary','3','4','10382',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('79','Zabbix server processes','2','2','10047',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('80','Zabbix server processes','2','2','10261',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('81','Network interfaces','1','1','10400',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('82','Network interfaces','1','1','10291',NULL,'1');
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`templateid`,`userid`,`private`) values ('83','Network interfaces','1','1','10298',NULL,'1');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('44','16','2','1','500','100','0','0','2','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('1954','20','0','862','750','200','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('1955','20','0','863','750','200','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('1956','20','0','860','750','200','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('1957','20','0','859','750','200','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('1958','20','0','861','750','200','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('1959','20','0','864','750','200','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5526','38','0','1029','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5527','38','0','1027','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5528','38','0','1030','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5529','38','0','1028','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5530','38','0','1031','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5531','39','0','1011','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5532','39','0','1012','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5533','39','0','1008','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5534','39','0','1009','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5535','39','0','1007','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5536','39','0','1010','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5537','40','0','1018','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5538','40','0','1016','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5539','40','0','1019','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5540','40','0','1017','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5541','40','0','1020','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5542','41','0','1025','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5543','41','0','1026','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5544','41','0','1022','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5545','41','0','1023','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5546','41','0','1021','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('5547','41','0','1024','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7854','25','0','1174','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7855','25','0','1176','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7856','25','20','1172','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7857','25','20','1173','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7858','25','0','1175','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7859','26','0','838','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7860','26','0','839','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7861','26','20','836','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7862','26','20','837','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7863','26','0','840','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7864','59','0','1125','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7865','59','0','1129','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7866','59','0','1128','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7867','59','0','1126','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7868','59','0','1127','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7869','48','20','1710','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7870','48','20','1711','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7871','48','20','1709','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7872','49','20','1714','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7873','49','20','1712','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7874','49','20','1715','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7875','49','20','1713','500','100','0','3','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7876','50','20','1718','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7877','50','20','1717','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7878','50','20','1716','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7879','51','20','1720','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7880','51','20','1721','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7881','51','20','1719','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7882','52','20','1724','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7883','52','20','1722','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7884','52','20','1725','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7885','52','20','1723','500','100','0','3','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7886','53','20','1728','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7887','53','20','1727','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7888','53','20','1726','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7889','27','0','841','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7890','27','0','843','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7891','27','0','842','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7892','28','0','845','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7893','28','0','847','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7894','28','0','846','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7895','62','0','1419','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7896','62','0','1414','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7897','62','0','1421','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7898','62','0','1423','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7899','62','0','1420','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7900','63','0','1422','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7901','63','0','1425','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7902','63','0','1415','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7903','63','0','1418','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7904','63','0','1416','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7905','63','0','1424','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7906','64','0','1432','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7907','64','0','1428','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7908','64','0','1434','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7909','64','0','1436','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7910','64','0','1433','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7911','65','0','1435','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7912','65','0','1438','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7913','65','0','1429','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7914','65','0','1431','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7915','65','0','1430','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7916','65','0','1437','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7917','4','0','1545','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7918','4','0','1539','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7919','4','0','1541','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7920','4','0','1537','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7921','4','0','1535','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7922','4','0','1543','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7923','79','0','1527','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7924','79','0','1531','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7925','79','0','1529','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7926','79','0','1525','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7927','21','0','1557','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7928','21','0','1554','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7929','21','0','1555','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7930','21','0','1553','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7931','21','0','1552','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7932','21','0','1556','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7933','80','0','1548','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7934','80','0','1550','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7935','80','0','1549','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7936','80','0','1547','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7937','22','0','806','500','212','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7938','22','0','804','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7939','22','0','805','500','100','0','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7940','22','0','803','500','128','1','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7941','17','0','532','500','212','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7942','17','0','530','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7943','17','0','531','500','100','0','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7944','17','0','529','500','128','1','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7945','5','0','469','500','148','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7946','5','0','471','500','100','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7947','5','0','498','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7948','5','0','540','500','100','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7949','7','0','463','500','120','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7950','7','0','462','500','106','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7951','7','0','541','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7952','7','0','464','500','300','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7953','6','0','475','500','114','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7954','6','0','474','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7955','6','0','542','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7956','18','0','487','750','100','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7957','18','0','543','750','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7958','9','0','457','500','120','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7959','9','0','456','500','106','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7960','9','0','544','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7961','9','0','458','500','300','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7962','9','1','22838','500','100','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7963','9','1','22837','500','100','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7964','10','0','481','500','114','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7965','10','0','480','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7966','10','0','545','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7967','10','0','482','500','300','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7968','10','1','22998','500','100','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7969','10','1','22997','500','100','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7970','57','0','1112','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7971','57','0','1113','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7972','57','0','1110','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7973','57','0','1109','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7974','57','0','1111','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7975','57','0','1114','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7976','60','0','1139','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7977','60','0','1140','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7978','60','0','1137','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7979','60','0','1136','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7980','60','0','1138','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7981','60','0','1141','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7982','58','0','1118','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7983','58','0','1119','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7984','58','0','1116','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7985','58','0','1115','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7986','58','0','1117','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7987','58','0','1120','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7988','23','20','821','500','200','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7989','23','20','816','500','200','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7990','23','20','814','500','200','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7991','23','20','820','500','200','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7992','23','20','817','500','200','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7993','23','20','815','500','200','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7994','23','20','818','500','200','0','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7995','23','20','819','500','200','1','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7996','24','0','824','500','200','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7997','24','0','827','500','200','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7998','24','0','825','500','200','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('7999','24','0','828','500','200','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8000','24','0','826','500','200','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8001','24','0','829','500','200','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8002','24','0','822','500','200','0','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8003','24','0','823','500','200','1','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8004','61','20','1212','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8005','61','20','1210','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8006','61','20','1213','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8007','61','20','1211','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8008','54','0','1091','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8009','54','0','1095','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8010','54','0','1092','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8011','54','0','1094','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8012','54','0','1099','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8013','54','0','1100','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8014','54','0','1101','500','100','0','3','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8015','54','0','1102','500','100','1','3','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8016','54','20','1090','500','100','0','4','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8017','55','0','1093','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8018','55','0','1098','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8019','55','0','1096','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8020','55','0','1097','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8021','47','0','1071','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8022','47','20','1061','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8023','47','20','1066','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8024','45','20','741','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8025','43','20','745','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8026','46','20','766','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8027','66','20','1476','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8028','67','0','1479','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8029','67','20','1478','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8030','67','20','1477','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8031','3','0','903','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8032','3','0','909','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8033','3','0','918','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8034','3','0','921','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8035','3','20','888','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8036','3','20','1218','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8037','3','20','1215','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8038','3','20','1221','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8039','3','20','900','500','100','0','6','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8040','30','20','899','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8041','31','20','934','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8042','32','0','937','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8043','32','0','941','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8044','32','0','947','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8045','32','0','949','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8046','32','20','927','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8047','32','20','1226','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8048','32','20','1224','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8049','32','20','1228','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8050','32','20','935','500','100','0','6','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8051','33','0','957','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8052','33','0','959','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8053','33','0','962','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8054','33','0','963','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8055','33','20','953','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8056','33','20','954','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8057','33','20','955','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8058','33','20','956','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8059','33','20','952','500','100','0','6','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8060','34','20','952','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8061','29','0','881','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8062','29','20','869','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8063','29','0','877','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8064','29','0','879','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8065','29','20','873','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8066','29','20','867','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8067','29','19','29033','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8068','29','20','865','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8069','19','0','977','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8070','19','1','29485','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8071','19','0','979','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8072','19','0','981','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8073','19','20','965','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8074','19','20','1230','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8075','19','20','1232','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8076','19','20','1840','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8077','82','20','1839','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8078','37','0','995','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8079','37','1','29592','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8080','37','0','997','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8081','37','0','999','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8082','37','20','983','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8083','37','20','1234','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8084','37','20','1236','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8085','37','20','1842','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8086','83','20','1841','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8087','69','3','33570','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8088','69','3','33585','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8089','69','3','33580','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8090','69','3','33591','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8091','69','3','33592','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8092','69','3','33594','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8093','69','0','1489','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8094','69','0','1491','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8095','69','0','1490','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8096','70','3','33621','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8097','70','3','33636','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8098','70','3','33631','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8099','70','3','33642','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8100','70','3','33643','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8101','70','3','33645','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8102','70','0','1492','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8103','70','0','1494','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8104','70','0','1493','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8105','71','3','33672','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8106','71','3','33687','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8107','71','3','33682','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8108','71','3','33693','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8109','71','3','33694','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8110','71','3','33696','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8111','71','0','1495','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8112','71','0','1497','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8113','71','0','1496','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8114','72','3','33723','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8115','72','3','33738','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8116','72','3','33733','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8117','72','3','33744','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8118','72','3','33745','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8119','72','3','33747','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8120','72','0','1498','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8121','72','0','1500','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8122','72','0','1499','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8123','73','3','33774','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8124','73','3','33789','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8125','73','3','33784','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8126','73','3','33795','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8127','73','3','33796','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8128','73','3','33798','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8129','73','0','1501','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8130','73','0','1503','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8131','73','0','1502','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8132','74','3','33825','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8133','74','3','33840','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8134','74','3','33835','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8135','74','3','33846','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8136','74','3','33847','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8137','74','3','33849','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8138','74','0','1504','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8139','74','0','1506','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8140','74','0','1505','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8141','75','3','33876','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8142','75','3','33891','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8143','75','3','33886','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8144','75','3','33897','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8145','75','3','33898','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8146','75','3','33900','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8147','75','0','1507','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8148','75','0','1509','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8149','75','0','1508','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8150','68','3','33434','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8151','68','3','33449','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8152','68','3','33444','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8153','68','3','33455','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8154','68','3','33456','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8155','68','3','33458','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8156','68','0','1510','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8157','68','0','1482','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8158','68','0','1481','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8159','76','3','33932','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8160','76','3','33947','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8161','76','3','33942','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8162','76','3','33953','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8163','76','3','33954','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8164','76','3','33956','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8165','76','0','1511','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8166','76','0','1513','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8167','76','0','1512','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8168','77','3','33983','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8169','77','3','33998','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8170','77','3','33993','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8171','77','3','34004','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8172','77','3','34005','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8173','77','3','34007','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8174','77','0','1514','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8175','77','0','1516','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8176','77','0','1515','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8177','78','3','34034','500','100','0','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8178','78','3','34049','500','100','1','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8179','78','3','34044','500','100','2','0','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8180','78','3','34055','500','100','0','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8181','78','3','34056','500','100','1','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8182','78','3','34058','500','100','2','1','1','1','1','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8183','78','0','1517','300','300','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8184','78','0','1519','400','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8185','78','0','1518','400','100','2','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('8186','81','20','1676','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('179','10047','Zabbix server','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('253','10074','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('254','10074','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('255','10074','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('256','10074','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('257','10074','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('258','10074','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('259','10074','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('260','10074','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('261','10074','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('263','10075','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('264','10075','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('265','10075','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('266','10075','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('267','10075','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('268','10075','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('269','10075','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('270','10075','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('271','10075','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('273','10076','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('274','10076','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('275','10076','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('276','10076','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('277','10076','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('278','10076','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('279','10076','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('280','10076','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('281','10076','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('283','10077','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('284','10077','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('285','10077','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('286','10077','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('287','10077','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('288','10077','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('289','10077','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('290','10077','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('291','10077','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('293','10078','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('294','10078','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('295','10078','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('296','10078','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('297','10078','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('298','10078','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('299','10078','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('300','10078','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('301','10078','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('303','10079','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('304','10079','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('305','10079','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('306','10079','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('307','10079','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('308','10079','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('309','10079','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('310','10079','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('311','10079','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('331','10076','Logical partitions','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('345','10084','Zabbix server','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('356','10048','Zabbix proxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('446','10093','FTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('447','10094','HTTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('448','10095','HTTPS service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('449','10096','IMAP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('450','10097','LDAP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('451','10098','NNTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('452','10099','NTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('453','10100','POP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('454','10101','SMTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('455','10102','SSH service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('456','10103','Telnet service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('740','10170','MySQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('741','10171','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('742','10171','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('743','10171','Voltage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('744','10172','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('745','10172','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('746','10172','Voltage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('771','10183','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('780','10186','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('782','10188','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('784','10190','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('786','10192','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('799','10204','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('800','10204','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('803','10207','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('804','10207','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('805','10207','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('806','10207','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('807','10207','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('808','10207','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('809','10207','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('810','10207','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('811','10208','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('812','10208','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('813','10208','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('814','10208','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('815','10208','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('816','10208','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('817','10208','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('818','10208','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('819','10208','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('820','10210','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('821','10210','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('822','10210','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('823','10211','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('824','10211','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('825','10211','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('826','10209','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('827','10209','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('828','10210','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('829','10210','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('830','10210','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('831','10210','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('832','10211','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('833','10211','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('834','10211','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('835','10211','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('836','10210','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('837','10210','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('838','10211','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('839','10211','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('840','10218','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('841','10218','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('842','10218','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('846','10220','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('847','10220','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('848','10212','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('849','10213','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('851','10215','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('852','10216','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('853','10217','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('854','10217','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('855','10217','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('856','10218','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('857','10218','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('858','10218','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('859','10218','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('860','10218','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('861','10218','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('868','10220','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('869','10220','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('870','10220','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('871','10220','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('872','10220','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('873','10220','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('874','10221','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('875','10221','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('876','10221','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('877','10221','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('878','10221','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('879','10221','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('880','10221','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('881','10221','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('882','10221','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('883','10222','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('884','10222','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('885','10222','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('886','10222','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('887','10222','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('888','10222','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('889','10222','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('890','10222','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('891','10222','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('892','10223','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('893','10223','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('894','10223','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('895','10223','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('896','10223','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('897','10223','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('898','10223','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('899','10223','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('900','10223','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('901','10224','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('902','10224','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('903','10224','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('904','10224','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('905','10224','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('906','10224','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('907','10224','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('908','10224','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('909','10224','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('913','10226','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('914','10226','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('915','10226','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('916','10227','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('917','10227','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('918','10227','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('919','10227','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('920','10227','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('921','10227','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('922','10227','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('923','10227','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('924','10227','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('934','10229','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('935','10229','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('936','10229','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('937','10229','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('938','10229','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('939','10229','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('940','10229','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('941','10229','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('942','10230','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('943','10230','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('944','10230','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('945','10230','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('946','10230','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('947','10230','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('948','10230','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('949','10231','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('950','10231','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('951','10231','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('952','10231','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('953','10231','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('954','10231','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('955','10231','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('956','10231','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('957','10231','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('969','10233','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('970','10233','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('971','10233','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('972','10233','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('973','10233','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('974','10233','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('975','10233','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('976','10233','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('977','10234','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('978','10234','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('979','10234','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('980','10234','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('981','10234','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('982','10234','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('983','10234','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('984','10234','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('985','10234','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('986','10235','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('987','10235','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('988','10235','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('989','10235','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('990','10235','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('991','10235','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('992','10236','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('993','10236','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('994','10236','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('995','10236','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('996','10236','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('997','10236','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('998','10237','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('999','10237','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1000','10237','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1001','10237','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1002','10237','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1003','10237','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1028','10250','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1029','10250','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1030','10250','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1031','10250','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1032','10250','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1033','10250','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1034','10250','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1035','10250','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1036','10250','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1044','10251','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1045','10251','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1046','10251','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1047','10251','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1048','10253','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1049','10253','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1050','10253','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1051','10253','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1052','10253','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1053','10253','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1054','10253','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1055','10253','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1056','10252','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1057','10253','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1058','10254','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1059','10254','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1060','10254','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1062','10254','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1064','10254','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1066','10254','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1068','10254','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1069','10255','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1070','10255','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1071','10255','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1072','10255','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1073','10255','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1074','10255','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1075','10255','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1076','10255','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1077','10255','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1078','10256','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1079','10256','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1080','10256','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1081','10256','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1082','10256','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1083','10256','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1084','10256','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1085','10256','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1086','10256','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1094','10258','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1095','10258','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1096','10258','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1097','10258','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1098','10258','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1099','10258','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1100','10258','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1101','10259','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1102','10259','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1103','10259','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1104','10259','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1109','10260','Tomcat','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1110','10261','Zabbix server','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1111','10262','Zabbix proxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1114','10263','PostgreSQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1115','10263','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1116','10264','Apache','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1117','10264','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1118','10265','Apache','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1119','10265','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1120','10266','Nginx','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1121','10266','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1122','10267','Nginx','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1123','10267','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1124','10170','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1125','10248','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1126','10248','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1127','10248','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1128','10268','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1129','10269','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1130','10270','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1131','10271','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1132','10248','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1133','10248','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1134','10248','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1135','10249','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1136','10249','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1141','10249','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1142','10272','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1143','10273','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1144','10274','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1145','10275','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1146','10275','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1147','10276','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1148','10277','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1149','10277','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1150','10277','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1151','10277','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1152','10001','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1153','10001','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1154','10001','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1155','10001','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1156','10001','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1157','10001','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1158','10001','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1159','10001','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1160','10001','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1161','10001','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1162','10084','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1163','10084','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1164','10084','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1165','10084','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1166','10084','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1167','10084','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1168','10084','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1169','10084','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1170','10084','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1171','10084','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1173','10278','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1174','10279','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1175','10280','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1176','10281','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1177','10281','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1178','10282','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1179','10283','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1180','10283','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1181','10283','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1182','10283','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1183','10284','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1184','10284','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1185','10284','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1186','10284','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1187','10284','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1188','10284','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1189','10284','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1190','10284','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1191','10284','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1192','10284','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1193','10285','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1194','10285','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1195','10285','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1196','10285','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1197','10285','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1198','10285','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1199','10285','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1200','10285','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1201','10285','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1202','10286','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1203','10287','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1204','10288','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1205','10289','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1207','10290','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1208','10290','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1209','10290','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1210','10291','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1211','10291','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1212','10081','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1213','10081','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1214','10081','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1215','10081','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1216','10081','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1217','10081','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1218','10081','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1219','10081','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1220','10081','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1221','10050','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1222','10050','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1223','10292','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1224','10292','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1225','10001','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1226','10074','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1227','10074','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1228','10075','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1229','10075','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1230','10076','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1231','10076','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1232','10077','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1233','10077','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1234','10078','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1235','10078','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1236','10079','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1237','10079','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1238','10081','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1240','10084','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1241','10299','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1242','10299','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1243','10293','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1244','10294','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1245','10295','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1246','10296','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1248','10297','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1249','10297','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1250','10297','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1251','10298','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1252','10298','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1253','10299','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1254','10299','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1255','10299','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1256','10299','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1257','10299','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1258','10299','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1259','10299','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1260','10299','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1261','10300','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1262','10300','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1263','10301','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1264','10301','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1265','10302','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1266','10302','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1267','10303','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1268','10303','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1269','10284','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1270','10304','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1271','10304','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1272','10304','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1273','10304','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1274','10304','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1275','10304','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1276','10304','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1277','10304','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1278','10304','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1279','10207','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1280','10235','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1281','10235','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1282','10235','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1283','10305','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1284','10306','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1285','10307','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1286','10185','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1287','10185','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1288','10185','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1292','10249','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1293','10249','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1294','10249','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1295','10254','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1296','10254','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1297','10254','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1298','10308','HAProxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1299','10308','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1300','10309','HAProxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1301','10309','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1302','10310','Redis','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1303','10310','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1310','10314','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1311','10081','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1312','10315','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1313','10299','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1314','10316','MySQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1315','10316','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1316','10317','MySQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1317','10317','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1318','10318','Docker','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1319','10318','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1320','10319','Memcached','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1321','10319','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1322','10320','MySQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1323','10320','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1324','10321','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1325','10321','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1326','10322','ES cluster','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1327','10322','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1328','10323','ClickHouse','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1329','10323','ClickHouse ZooKeeper','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1330','10323','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1331','10324','Etcd','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1332','10324','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1333','10325','IIS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1334','10326','IIS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1335','10327','MSSQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1336','10327','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1337','10328','PostgreSQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1338','10328','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1341','10169','JMX','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1342','10173','VMware','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1343','10174','VMware','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1344','10175','VMware','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1345','10333','Oracle','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1346','10333','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1347','10233','Wireless','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1348','10334','Ceph','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1349','10334','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1350','10335','PHP-FPM','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1351','10335','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1352','10336','PHP-FPM','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1353','10336','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1354','10337','Squid','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1357','10339','Hadoop','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1358','10339','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1359','10340','Kafka','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1360','10341','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1361','10341','Zookeeper','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1362','10342','Cassandra','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1363','10254','Voltage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1364','10254','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1365','10343','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1366','10343','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1367','10343','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1368','10343','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1369','10343','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1370','10343','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1371','10343','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1372','10344','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1373','10344','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1374','10344','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1375','10344','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1376','10344','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1377','10344','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1378','10344','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1379','10345','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1380','10345','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1381','10345','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1382','10345','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1383','10345','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1384','10345','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1385','10345','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1386','10346','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1387','10346','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1388','10346','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1389','10346','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1390','10346','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1391','10347','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1392','10347','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1393','10347','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1394','10347','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1395','10347','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1396','10347','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1397','10348','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1398','10348','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1399','10348','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1400','10348','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1401','10348','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1402','10348','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1403','10349','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1404','10349','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1405','10349','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1406','10349','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1407','10349','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1408','10349','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1409','10349','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1410','10350','ActiveMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1411','10351','MS Exchange','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1412','10352','MS Exchange','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1413','10353','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1414','10353','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1415','10353','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1416','10353','NetApp FAS3220','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1417','10353','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1418','10354','Ignite','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1419','10355','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1420','10356','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1421','10357','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1422','10357','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1423','10357','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1424','10357','Huawei','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1425','10358','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1426','10358','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1427','10359','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1428','10359','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1429','10360','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1430','10360','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1431','10361','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1432','10361','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1433','10362','MongoDB','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1434','10362','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1435','10363','MongoDB sharded cluster','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1436','10363','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1437','10366','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1438','10366','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1439','10366','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1440','10366','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1441','10366','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1442','10366','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1443','10366','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1444','10366','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1445','10366','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1446','10367','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1447','10367','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1448','10367','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1449','10367','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1450','10367','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1451','10367','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1452','10367','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1453','10367','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1454','10367','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1455','10368','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1456','10368','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1457','10368','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1458','10368','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1459','10368','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1460','10368','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1461','10368','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1462','10368','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1463','10368','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1464','10369','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1465','10369','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1466','10369','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1467','10369','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1468','10369','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1469','10369','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1470','10369','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1471','10369','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1472','10369','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1473','10370','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1474','10370','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1475','10370','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1476','10370','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1477','10370','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1478','10370','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1479','10370','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1480','10370','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1481','10370','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1482','10251','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1483','10251','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1484','10251','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1485','10251','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1486','10251','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1487','10251','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1488','10371','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1489','10371','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1490','10372','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1491','10372','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1492','10373','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1493','10373','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1494','10374','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1495','10374','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1496','10375','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1497','10375','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1498','10376','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1499','10376','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1500','10377','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1501','10377','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1502','10378','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1503','10378','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1504','10379','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1505','10379','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1506','10380','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1507','10380','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1508','10381','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1509','10381','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1510','10382','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1511','10382','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1512','10383','WildFly','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1513','10384','WildFly','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1514','10261','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1515','10385','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1516','10385','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1517','10385','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1518','10385','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1519','10385','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1520','10386','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1521','10386','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1522','10386','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1523','10386','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1524','10386','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1525','10386','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1526','10386','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1527','10387','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1528','10387','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1529','10387','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1530','10387','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1531','10387','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1532','10387','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1533','10387','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1534','10388','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1535','10388','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1536','10388','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1537','10388','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1538','10388','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1539','10388','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1540','10388','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1541','10388','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1542','10389','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1543','10389','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1544','10389','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1545','10389','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1546','10389','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1547','10389','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1548','10389','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1549','10389','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1550','10390','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1551','10390','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1552','10390','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1553','10390','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1554','10390','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1555','10390','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1556','10391','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1557','10391','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1558','10391','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1559','10391','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1560','10392','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1561','10392','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1562','10392','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1563','10392','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1564','10392','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1565','10392','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1566','10392','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1567','10393','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1568','10393','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1569','10393','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1570','10393','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1571','10393','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1572','10393','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1573','10393','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1574','10394','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1575','10394','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1576','10394','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1577','10394','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1578','10394','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1579','10394','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1580','10394','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1581','10395','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1582','10395','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1583','10395','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1584','10395','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1585','10395','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1586','10395','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1587','10395','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1588','10396','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1589','10396','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1590','10396','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1591','10396','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1592','10396','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1593','10396','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1594','10396','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1595','10396','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1596','10397','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1597','10397','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1598','10397','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1599','10397','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1600','10397','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1601','10397','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1602','10397','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1603','10397','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1604','10398','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1605','10398','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1606','10398','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1607','10398','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1608','10398','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1609','10398','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1610','10398','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1611','10398','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1612','10399','Nginx','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1613','10399','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1614','10400','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1615','10400','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1616','10400','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1617','10400','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1618','10400','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1619','10400','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1620','10400','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1621','10400','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1622','10400','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1623','10400','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1633','10402','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1634','10402','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1635','10402','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1636','10402','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1637','10402','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1638','10402','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1639','10402','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1640','10402','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1641','10402','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1651','10404','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1652','10404','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1653','10404','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1654','10404','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1655','10404','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1656','10404','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1657','10404','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1658','10404','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1659','10404','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1669','10406','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1670','10406','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1671','10406','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1672','10406','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1673','10406','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1674','10406','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1675','10406','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1676','10406','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1677','10406','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1687','10408','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1688','10408','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1689','10408','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1690','10408','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1691','10408','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1692','10408','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1693','10408','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1694','10408','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1695','10408','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1696','10409','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1697','10409','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1698','10409','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1699','10409','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1700','10409','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1701','10409','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1702','10409','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1703','10409','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1704','10409','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1705','10409','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1706','10410','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1707','10410','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1708','10410','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1709','10410','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1710','10410','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1711','10410','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1712','10410','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1713','10410','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1714','10410','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1715','10410','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1716','10411','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1717','10411','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1718','10411','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1719','10411','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1720','10411','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1721','10411','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1722','10411','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1723','10411','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1724','10411','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1725','10411','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1726','10412','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1727','10412','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1728','10412','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1729','10412','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1730','10412','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1731','10412','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1732','10412','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1733','10412','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1734','10412','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1735','10412','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1736','10413','Systemd','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1737','10413','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1738','10414','GridGain','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1739','10415','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1740','10415','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1741','10415','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1742','10415','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1743','10415','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1744','10415','Modules','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1745','10415','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1746','10415','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1747','10415','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1748','10415','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1749','10415','TCP/UDP stat','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1750','10415','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1751','10415','Voltage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1752','10416','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1753','10416','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1754','10417','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1755','10417','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1756','10417','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1757','10417','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1758','10418','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1759','10418','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1760','10418','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1761','10418','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1762','10418','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1763','10419','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1764','10419','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1765','10419','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1766','10419','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1767','10419','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1768','10419','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1769','10419','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1770','10420','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1771','10420','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1772','10420','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1773','10420','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1774','10420','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1775','10420','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1776','10420','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1777','10421','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1778','10421','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1779','10421','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1780','10421','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1781','10421','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1782','10421','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1783','10421','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1784','10421','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1785','10422','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1786','10422','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1787','10422','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1788','10422','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1789','10422','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1790','10422','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1791','10422','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1792','10422','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1793','10423','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1794','10423','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1795','10423','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1796','10423','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1797','10423','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1798','10423','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1799','10424','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1800','10424','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1801','10424','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1802','10424','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1803','10425','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1804','10425','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1805','10425','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1806','10425','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1807','10425','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1808','10425','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1809','10425','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1810','10426','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1811','10426','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1812','10426','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1813','10426','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1814','10426','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1815','10426','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1816','10426','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1817','10427','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1818','10427','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1819','10427','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1820','10427','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1821','10427','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1822','10427','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1823','10427','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1824','10428','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1825','10428','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1826','10428','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1827','10428','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1828','10428','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1829','10428','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1830','10428','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1831','10429','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1832','10429','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1833','10429','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1834','10429','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1835','10429','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1836','10429','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1837','10429','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1838','10429','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1839','10430','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1840','10430','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1841','10430','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1842','10430','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1843','10430','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1844','10430','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1845','10430','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1846','10430','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1847','10431','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1848','10431','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1849','10431','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1850','10431','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1851','10431','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1852','10431','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1853','10431','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1854','10431','Temperature','0');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('1','10084','1','1','1','127.0.0.1','','10050');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('1','Service state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('2','Host availability');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('3','Windows service state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('4','APC Battery Replacement Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('5','APC Battery Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('6','HP Insight System Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('7','Dell Open Manage System Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('8','SNMP interface status (ifOperStatus)');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('9','SNMP device status (hrDeviceStatus)');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('10','Zabbix agent ping status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('11','SNMP interface status (ifAdminStatus)');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('12','VMware VirtualMachinePowerState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('13','VMware status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('14','Maintenance status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('15','Value cache operating mode');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('16','Windows service startup type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('17','HTTP response status code');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('18','ENTITY-SENSORS-MIB::EntitySensorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('19','EtherLike-MIB::dot3StatsDuplexStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('20','IF-MIB::ifOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('21','IF-MIB::ifType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('22','zabbix.host.available');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('23','TIMETRA-CHASSIS-MIB::TmnxDeviceState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('24','SW-MIB::swSensorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('25','SW-MIB::swOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('26','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('27','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('28','CISCO-ENVMON-MIB::CiscoEnvMonState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('29','F10-S-SERIES-CHASSIS-MIB::extremeFanOperational');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('30','F10-S-SERIES-CHASSIS-MIB::chSysFanTrayOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('31','F10-S-SERIES-CHASSIS-MIB::chSysPowerSupplyOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('32','MY-SYSTEM-MIB::mySystemFanIsNormal');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('33','EQUIPMENT-MIB::swFanStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('34','EQUIPMENT-MIB::swPowerStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('35','TruthValue');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('36','EXTREME-SYSTEM-MIB::extremeFanOperational');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('37','EXTREME-SYSTEM-MIB::extremeOverTemperatureAlarm');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('38','EXTREME-SYSTEM-MIB::extremePowerSupplyStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('39','HH3C-ENTITY-EXT-MIB::hh3cEntityExtErrorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('40','HP-ICF-CHASSIS::hpicfSensorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('41','HUAWEI-ENTITY-EXTENT-MIB::hwEntityFanState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('42','ICS-CHASSIS-MIB::icsChassisFanOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('43','ICS-CHASSIS-MIB::icsChassisSensorSlotOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('44','ICS-CHASSIS-MIB::icsChassisPowerSupplyOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('45','ICS-CHASSIS-MIB::icsChassisTemperatureStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('46','JUNIPER-ALARM-MIB::jnxRedAlarmState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('47','JUNIPER-ALARM-MIB::jnxOperatingState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('48','ENTITY-STATE-MIB::EntityOperState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('49','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesPowSupplyItemState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('50','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesFanItemState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('51','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesTempSensorState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('52','QTECH-MIB::sysFanStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('53','QTECH-MIB::sysPowerStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('54','CPQSINFO-MIB::status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('55','CPQHLTH-MIB::cpqHeTemperatureLocale');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('56','CPQIDA-MIB::cpqDaCntlrModel');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('57','CPQIDA-MIB::cpqDaPhyDrvStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('58','IMM-MIB::systemHealthStat');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('59','IDRAC-MIB-SMIv2::ObjectStatusEnum');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('60','IDRAC-MIB-SMIv2::StatusProbeEnum');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('61','IDRAC-MIB-SMIv2::physicalDiskComponentStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('62','IDRAC-MIB-SMIv2::BooleanType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('63','IDRAC-MIB-SMIv2::physicalDiskMediaType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('64','IDRAC-MIB-SMIv2::batteryState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('65','IDRAC-MIB-SMIv2::virtualDiskLayout');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('66','IDRAC-MIB-SMIv2::virtualDiskOperationalState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('67','IDRAC-MIB-SMIv2::virtualDiskWritePolicy');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('68','IDRAC-MIB-SMIv2::virtualDiskReadPolicy');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('69','IDRAC-MIB-SMIv2::virtualDiskState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('70','CPQIDA-MIB::cpqDaPhyDrvSmartStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('71','CPQIDA-MIB::cpqDaAccelStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('72','CPQIDA-MIB::cpqDaAccelBattery');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('73','CPQIDA-MIB::cpqDaPhyDrvMediaType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('74','CPQIDA-MIB::cpqDaLogDrvFaultTol');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('75','CPQIDA-MIB::cpqDaLogDrvStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('76','PostgreSQL recovery role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('77','PostgreSQL replication status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('78','Linux::Interface protocol types');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('79','Win32_NetworkAdapter::AdapterTypeId');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('80','CIM_LogicalDevice::Availability');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('81','Win32_NetworkAdapter::NetConnectionStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('82','RabbitMQ healthcheck');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('83','Alarm state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('84','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('85','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('86','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('87','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('88','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('89','Redis bgwrite status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('90','Redis flag');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('91','Redis repl offset');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('92','Redis bgsave time');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('93','Docker flag');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('94','ES cluster state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('95','Replicas state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('96','Etcd healthcheck');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('97','Etcd leader');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('98','Application pool state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('99','MSSQL DB state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('100','MSSQL AG Connected state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('101','MSSQL AG Join state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('102','MSSQL AG Operational state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('103','MSSQL AG Recovery health');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('104','MSSQL AG Role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('105','MSSQL AG Suspend state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('106','MSSQL AG Synchronization health');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('107','MSSQL - Yes / No');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('108','MSSQL Mirroring State');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('109','MSSQL Mirroring Role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('110','MSSQL Safety level');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('111','MSSQL Witness state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('112','Oracle DB open status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('113','Oracle DB role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('114','Oracle instance status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('115','Oracle instance role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('116','Oracle archiver state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('117','Oracle tablespace status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('118','Oracle Archivelog status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('119','Oracle force log status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('120','Oracle log mode');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('121','Ceph cluster status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('122','Kafka controller state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('123','ProStar MPPT charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('124','ProStar MPPT load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('125','ProStar PWM charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('126','ProStar PWM load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('127','Morningstar flags');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('128','SunSaver MPPT charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('129','SunSaver MPPT load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('130','SureSine load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('131','TriStar MPPT 600V charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('132','TriStar MPPT charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('133','TriStar PWM charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('134','TriStar PWM load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('135','TriStar PWM control mode');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('136','Exchange database copy role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('137','Exchange database state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('138','FAS3220 Over-temperature');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('139','FAS3220 NVRAM battery status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('140','FAS3220 HA cannot takeover cause');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('141','FAS3220 HA settings');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('142','FAS3220 Port link state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('143','FAS3220 Port health');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('144','FAS3220 Port UP by administrator');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('145','FAS3220 Port role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('146','FAS3220 Port type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('147','FAS3220 Port speed');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('148','CPQHLTH-MIB::cpqHeTemperatureCondition');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('149','Huawei storage: Controller role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('150','Huawei storage: Health status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('151','Huawei storage: LUN status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('152','Huawei storage: Running status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('153','MongoDB flag');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('154','ReplicaSet node state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('155','PowerNet-MIB::uioSensorStatusAlarmStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('156','PowerNet-MIB::upsAdvBatteryReplaceIndicator');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('157','PowerNet-MIB::upsAdvInputLineFailCause');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('158','PowerNet-MIB::upsBasicBatteryStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('159','PowerNet-MIB::upsBasicOutputStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('160','WildFly flag');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('161','MSSQL Job Run Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('162','SNMP available');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('163','ZYXEL AAM1212-51 / IES-612 module status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('164','ZYXEL AAM1212-51 / IES-612 operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('165','ZYXEL AAM1212-51 / IES-612 operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('166','ZYXEL AAM1212-51 / IES-612 port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('167','ZYXEL AAM1212-51 / IES-612 port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('168','ZYXEL ES3500-8PD operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('169','ZYXEL ES3500-8PD operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('170','ZYXEL ES3500-8PD port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('171','ZYXEL ES3500-8PD port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('172','ZYXEL ES3500-8PD SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('173','ZYXEL GS-4012F operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('174','ZYXEL GS-4012F operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('175','ZYXEL GS-4012F port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('176','ZYXEL GS-4012F port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('177','ZYXEL GS-4012F SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('178','ZYXEL IES-500x module status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('179','ZYXEL IES-500x module type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('180','ZYXEL IES-500x operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('181','ZYXEL IES-500x operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('182','ZYXEL IES-500x port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('183','ZYXEL IES-500x port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('184','ZYXEL IES-6000 module status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('185','ZYXEL IES-6000 module type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('186','ZYXEL IES-6000 operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('187','ZYXEL IES-6000 operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('188','ZYXEL IES-6000 port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('189','ZYXEL IES-6000 port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('190','ZYXEL IES1248-51 module status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('191','ZYXEL IES1248-51 operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('192','ZYXEL IES1248-51 operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('193','ZYXEL IES1248-51 port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('194','ZYXEL IES1248-51 port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('195','ZYXEL MES-3528 operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('196','ZYXEL MES-3528 operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('197','ZYXEL MES-3528 port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('198','ZYXEL MES-3528 port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('199','ZYXEL MES-3528 SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('200','ZYXEL MES3500-10 operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('201','ZYXEL MES3500-10 operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('202','ZYXEL MES3500-10 port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('203','ZYXEL MES3500-10 port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('204','ZYXEL MES3500-10 SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('205','ZYXEL MES3500-24 operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('206','ZYXEL MES3500-24 operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('207','ZYXEL MES3500-24 port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('208','ZYXEL MES3500-24 port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('209','ZYXEL MES3500-24 SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('210','ZYXEL MGS-3712 operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('211','ZYXEL MGS-3712 operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('212','ZYXEL MGS-3712 port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('213','ZYXEL MGS-3712 port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('214','ZYXEL MGS-3712 SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('215','ZYXEL MGS-3712F operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('216','ZYXEL MGS-3712F operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('217','ZYXEL MGS-3712F port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('218','ZYXEL MGS-3712F port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('219','ZYXEL MGS-3712F SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('220','ZYXEL MES3500-24S operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('221','ZYXEL MES3500-24S operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('222','ZYXEL MES3500-24S port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('223','ZYXEL MES3500-24S port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('224','ZYXEL MES3500-24S SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('225','ZYXEL MGS3520-28x operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('226','ZYXEL MGS3520-28x operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('227','ZYXEL MGS3520-28x port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('228','ZYXEL MGS3520-28x port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('229','ZYXEL MGS3520-28x SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('230','ZYXEL XGS-4728F operational mode port speed duplex');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('231','ZYXEL XGS-4728F operational mode port link up type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('232','ZYXEL XGS-4728F port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('233','ZYXEL XGS-4728F port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('234','ZYXEL XGS-4728F SFP status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('235','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageTechnology');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('236','CPQNIC-MIB::cpqNicIfPhysAdapterStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('237','Unit Load State');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('238','Unit Active State');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('239','Unit File State');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('240','Chassis status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('241','Module provision level');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('242','Pause state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('243','Server mode');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('244','Cisco ASAv algorithm validate packets');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('245','Cisco ASAv encryption algorithm');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('246','Cisco ASAv port admin status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('247','Cisco ASAv port operational status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('248','Cisco ASAv session protocol');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('249','Cisco ASAv user authenticate method');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('250','Physical class');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10061','5','','10047','Zabbix server: Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed float values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10062','5','','10047','Zabbix server: Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed character/string values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10063','5','','10047','Zabbix server: Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed log values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10064','5','','10047','Zabbix server: Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed numeric (unsigned) values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10065','5','','10047','Zabbix server: Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed text values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10066','5','','10047','Zabbix server: Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of times item processing resulted in item becoming unsupported or keeping that state.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10067','5','','10048','Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10068','5','','10048','Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10069','5','','10048','Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10070','5','','10048','Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10071','5','','10048','Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10072','5','','10048','Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22183','5','','10047','Zabbix server: History write cache, % used','zabbix[wcache,history,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used history buffer.\r\nHistory cache is used to store item values. A high number indicates performance problems on the database side.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22185','5','','10047','Zabbix server: Trend write cache, % used','zabbix[wcache,trend,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used trend buffer.\r\nTrend cache stores aggregate for the current hour for all items that receive data.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22187','5','','10047','Zabbix server: Number of processed values per second','zabbix[wcache,values]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nTotal number of values processed by Zabbix server or Zabbix proxy, except unsupported items.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22189','5','','10047','Zabbix server: Configuration cache, % used','zabbix[rcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Availability statistics of Zabbix configuration cache. Percentage of used buffer','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22191','5','','10047','Zabbix server: Value cache, % used','zabbix[vcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Availability statistics of Zabbix value cache. Percentage of used buffer','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22196','5','','10047','Zabbix server: Value cache hits','zabbix[vcache,cache,hits]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'Effectiveness statistics of Zabbix value cache. Number of cache hits (history values taken from the cache)','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22199','5','','10047','Zabbix server: Value cache misses','zabbix[vcache,cache,misses]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'Effectiveness statistics of Zabbix value cache. Number of cache misses (history values taken from the database)','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22219','5','','10047','Zabbix server: Queue over 10 minutes','zabbix[queue,10m]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of monitored items in the queue which are delayed at least by 10 minutes','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22231','0','','10050','Version of Zabbix agent running','agent.version','1h','7d','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22232','0','','10050','Zabbix agent ping','agent.ping','1m','7d','365d','0','3','','','','',NULL,'10','','','0','','','','','0',NULL,'The agent always returns 1 for this item. It could be used in combination with nodata() for availability check.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22396','5','','10047','Zabbix server: History index cache, % used','zabbix[wcache,index,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used history index buffer.\r\nHistory index cache is used to index values stored in history cache.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22399','5','','10047','Zabbix server: Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22400','5','','10047','Zabbix server: Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time unreachable poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22401','5','','10047','Zabbix server: Utilization of vmware data collector processes, in %','zabbix[process,vmware collector,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time vmware collector processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22402','5','','10047','Zabbix server: Utilization of http poller data collector processes, in %','zabbix[process,http poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time http poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22404','5','','10047','Zabbix server: Utilization of trapper data collector processes, in %','zabbix[process,trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time trapper processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22406','5','','10047','Zabbix server: Utilization of history syncer internal processes, in %','zabbix[process,history syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time history syncer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22408','5','','10047','Zabbix server: Utilization of housekeeper internal processes, in %','zabbix[process,housekeeper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time housekeeper processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22412','5','','10047','Zabbix server: Utilization of configuration syncer internal processes, in %','zabbix[process,configuration syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time configuration syncer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22414','5','','10047','Zabbix server: Utilization of self-monitoring internal processes, in %','zabbix[process,self-monitoring,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time self-monitoring processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22416','5','','10047','Zabbix server: Utilization of ipmi poller data collector processes, in %','zabbix[process,ipmi poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time ipmi poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22418','5','','10047','Zabbix server: Utilization of icmp pinger data collector processes, in %','zabbix[process,icmp pinger,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time icmp pinger processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22420','5','','10047','Zabbix server: Utilization of proxy poller data collector processes, in %','zabbix[process,proxy poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time proxy poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22422','5','','10047','Zabbix server: Utilization of escalator internal processes, in %','zabbix[process,escalator,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time escalator processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22424','5','','10047','Zabbix server: Utilization of alerter internal processes, in %','zabbix[process,alerter,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time alerter processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22426','5','','10047','Zabbix server: Utilization of timer internal processes, in %','zabbix[process,timer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time timer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22430','5','','10047','Zabbix server: Utilization of discoverer data collector processes, in %','zabbix[process,discoverer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time discoverer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22689','5','','10047','Zabbix server: Utilization of java poller data collector processes, in %','zabbix[process,java poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time java poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22835','0','','10074','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22836','0','','10074','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22837','0','','10074','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22838','0','','10074','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22839','0','','10074','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22840','0','','10074','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22841','0','','10074','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22842','0','','10074','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22843','0','','10074','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22844','0','','10074','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22845','0','','10074','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22846','0','','10074','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22848','0','','10074','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22851','0','','10074','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22852','0','','10074','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22853','0','','10074','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22854','0','','10074','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22855','0','','10074','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22856','0','','10074','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22857','0','','10074','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22858','0','','10074','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22859','0','','10074','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22860','0','','10074','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22861','0','','10074','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22862','0','','10074','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22863','0','','10074','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22867','0','','10074','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22868','0','','10074','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22869','0','','10074','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22870','0','','10074','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22871','0','','10074','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22872','0','','10074','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22875','0','','10075','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22876','0','','10075','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22877','0','','10075','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22878','0','','10075','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22879','0','','10075','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22880','0','','10075','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22881','0','','10075','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22882','0','','10075','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22883','0','','10075','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22884','0','','10075','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22885','0','','10075','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22886','0','','10075','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22888','0','','10075','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22891','0','','10075','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22892','0','','10075','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22893','0','','10075','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22894','0','','10075','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22895','0','','10075','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22896','0','','10075','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22897','0','','10075','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22898','0','','10075','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22899','0','','10075','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22900','0','','10075','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22901','0','','10075','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22902','0','','10075','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22903','0','','10075','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22907','0','','10075','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22908','0','','10075','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22909','0','','10075','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22910','0','','10075','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22911','0','','10075','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22912','0','','10075','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22917','0','','10076','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22918','0','','10076','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22920','0','','10076','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22921','0','','10076','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22922','0','','10076','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22923','0','','10076','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22924','0','','10076','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22933','0','','10076','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22934','0','','10076','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22938','0','','10076','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22939','0','','10076','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22940','0','','10076','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22941','0','','10076','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22942','0','','10076','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22943','0','','10076','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22944','0','','10076','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22945','0','','10076','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22946','0','','10076','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22947','0','','10076','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22948','0','','10076','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22949','0','','10076','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22950','0','','10076','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22951','0','','10076','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22952','0','','10076','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22961','0','','10077','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22962','0','','10077','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22963','0','','10077','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22965','0','','10077','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22968','0','','10077','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22971','0','','10077','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22972','0','','10077','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22973','0','','10077','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22974','0','','10077','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22978','0','','10077','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22980','0','','10077','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22981','0','','10077','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22982','0','','10077','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22983','0','','10077','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22984','0','','10077','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22985','0','','10077','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22986','0','','10077','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22987','0','','10077','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22988','0','','10077','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22989','0','','10077','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22990','0','','10077','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22991','0','','10077','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22992','0','','10077','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22996','0','','10078','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22997','0','','10078','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22998','0','','10078','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22999','0','','10078','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23000','0','','10078','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23001','0','','10078','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23002','0','','10078','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23003','0','','10078','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23004','0','','10078','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23005','0','','10078','CPU idle