import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.3
import QtQuick.Controls.Material 2.2
import QtGraphicalEffects 1.0

ScrollView {
    id: pane
    objectName: 'credentialsView'

    Accessible.ignored: true

    property var filtered: 0

    contentHeight: filteredCredentials().count > 0 ? grid.contentHeight : app.height - toolBar.height

    ScrollBar.vertical: ScrollBar {
        id: paneScrollBar
        width: 8
        anchors.top: pane.top
        anchors.right: pane.right
        anchors.bottom: pane.bottom
        hoverEnabled: true
        z: 2
    }

    property string title: ""

    function filteredCredentials() {
        if (entries !== null && toolBar.searchField.text.length > 0) {
            var filteredEntries = entriesComponent.createObject(app, {

                                                                })
            for (var i = 0; i < entries.count; i++) {
                var entry = entries.get(i)
                if (!!entry && !!entry.credential) {
                    if (entry.credential.key.toLowerCase().indexOf(
                                toolBar.searchField.text.toLowerCase(
                                    )) !== -1) {
                        filteredEntries.append(entry)
                    }
                }
            }
            return filteredEntries
        }
        return entries
    }

    function calculate() {
        if (grid.currentIndex !== -1) {
            grid.currentItem.calculateCard(true)
        }
    }

    Component {
        id: entriesComponent
        EntriesModel {
        }
    }

    MouseArea {
        onClicked: grid.currentIndex = -1
        height: app.height
        width: app.width
        enabled: entries.count > 0
        Accessible.ignored: true
    }

    NoCredentialsSection {
        visible: entries.count === 0 && !!yubiKey.currentDevice && yubiKey.currentDeviceValidated
        enabled: visible
        Accessible.ignored: true
    }

    NoResultsSection {
        visible: entries.count > 0 && !!yubiKey.currentDevice && yubiKey.currentDeviceValidated
                 && filteredCredentials().count === 0
        enabled: visible
        Accessible.ignored: true
    }

    NoYubiKeySection {
        visible: !yubiKey.availableDevices.some(dev => dev.selectable)
        enabled: visible
        Accessible.ignored: true
    }

    GridView {
        id: grid
        displayMarginBeginning: cellHeight
        displayMarginEnd: cellHeight
        width: (Math.min(model.count, Math.floor(parent.width / cellWidth)) * cellWidth) || cellWidth
        height: (Math.min(model.count, Math.floor((parent.height - toolBar.height) / cellHeight)) * cellHeight) || cellHeight
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: parent.top
        onCurrentItemChanged: app.currentCredentialCard = currentItem
        visible: entries.count > 0
        enabled: visible
        keyNavigationWraps: false
        model: filteredCredentials()
        cellWidth: app.width <= 360 ? app.width + 2 : 362
        cellHeight: 82
        Accessible.role: Accessible.MenuItem
        Accessible.focusable: true
        delegate: CredentialCard {
            credential: model.credential
            code: model.code
        }
        focus: visible
        Component.onCompleted: currentIndex = -1
        KeyNavigation.backtab: !!(app.currentCredentialCard && navigator.currentItem
                                  && navigator.currentItem.objectName === 'credentialsView') ? toolBar.favoriteBtn : toolBar.addCredentialBtn
        KeyNavigation.tab: toolBar.settingsBtn
        KeyNavigation.up: paneScrollBar.position === 0 ? toolBar.searchField : null
        interactive: false
        highlightFollowsCurrentItem: false
        Keys.onPressed: interactive = true
        Keys.onReleased: interactive = false
        Keys.onEscapePressed: {
            toolBar.searchField.text = ""
            navigator.forceActiveFocus()
            currentIndex = -1
        }
        Keys.onSpacePressed: calculate()
        Keys.onEnterPressed: calculate()
        Keys.onReturnPressed: calculate()
        Keys.onDeletePressed: {
            if (currentIndex !== -1) {
                currentItem.deleteCard()
            }
        }
    }
}
