#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

@interface Option : NSObject
{
    @public
    id control;
    BOOL enabled;
    id con;
    NSString *errMsg;
}

+ optEnumerator;

- initWithController:(id)theCon;

- setOptEnabled:(BOOL)eflag;
- (BOOL)optEnabled;

- (BOOL)usedByA2PS;
- (BOOL)usedByGS;

- (NSArray *)optionsForA2PS;
- (NSArray *)optionsForGS;

- control;
- (NSString *)title;
- (NSString *)errMsg;

- cleanupOption;

- (NSMutableDictionary *)dataDict:(NSDictionary *)src;

- (NSUserDefaults *)writeUserDefaults;
- (NSUserDefaults *)readUserDefaults;

@end


@interface RadioOpt : Option

- initWithController:(id)theCon;

- (NSArray *)titles;

- setOptEnabled:(BOOL)eflag;

- (NSUserDefaults *)writeUserDefaults;
- (NSUserDefaults *)readUserDefaults;

@end

@interface OrientationOpt : RadioOpt

- initWithController:(id)theCon;

- (NSArray *)titles;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface BorderOpt : RadioOpt

- (NSArray *)titles;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface DuplexOpt : RadioOpt

- (NSArray *)titles;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface DeviceOpt : RadioOpt

- (NSArray *)titles;

- (NSArray *)optionsForGS;

- (NSString *)title;

@end

@interface PredefVirtOpt : Option

- initWithController:(id)theCon;

- setOptEnabled:(BOOL)eflag;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

- (NSUserDefaults *)writeUserDefaults;
- (NSUserDefaults *)readUserDefaults;

@end


@interface OptFromA2PS : Option
{
    NSMutableDictionary *entries;
}

- initWithController:(id)theCon;

- setOptEnabled:(BOOL)eflag;

- (NSString *)titleForLookup;
- doLookup:(id)sender;

- (void)browser:(NSBrowser *)sender createRowsForColumn:(int)column
       inMatrix:(NSMatrix *)matrix;

- (NSString *)key;

- (BOOL)isDivider:(NSString *)line;
- (NSMutableArray *)dividers:(NSArray *)lines;

- cleanupOption;

- (NSUserDefaults *)writeUserDefaults;
- (NSUserDefaults *)readUserDefaults;

@end

@interface MediaOpt : OptFromA2PS

- initWithController:(id)theCon;

- (NSString *)titleForLookup;

- (NSArray *)optionsForA2PS;
- (NSSize)mediumSize;

- (NSString *)title;

@end

@interface StyleSheetOpt : OptFromA2PS

- initWithController:(id)theCon;

- (NSString *)titleForLookup;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface EncodingOpt : OptFromA2PS

- initWithController:(id)theCon;

- (NSString *)titleForLookup;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface PrologueOpt : OptFromA2PS

- initWithController:(id)theCon;

- (NSString *)titleForLookup;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

- (BOOL)isDivider:(NSString *)line;

@end


@interface FormOpt : Option

- initWithController:(id)theCon;

- (NSArray *)entries;

- setOptEnabled:(BOOL)eflag;

- (NSUserDefaults *)writeUserDefaults;
- (NSUserDefaults *)readUserDefaults;

@end

@interface VirtualsOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface TitleOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface FooterOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end


@interface FontSizeOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface PagesOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface MarginOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface TOCOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface JobTitleOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface LinesPerPageOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface CharsPerLineOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end

@interface HeaderOpt : FormOpt

- (NSArray *)entries;

- (NSArray *)optionsForA2PS;

- (NSString *)title;

@end


