#define asm__call_add_space(v0,v1,func) \
    __asm__("mov x0, %0\n""mov x20, %1\n" : :"r"(v0), "r"(v1) :"x0", "x20"); ((void (*)())(func))();

#define asm__call_move_space(v0,v1,v2,v3,func) \
    __asm__("mov x0, %0\n""mov x1, %1\n""mov x2, %2\n""mov x20, %3\n" : :"r"(v0), "r"(v1), "r"(v2), "r"(v3) :"x0", "x1", "x2", "x20"); ((void (*)())(func))();

uint64_t get_dock_spaces_offset(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return 0x118000;
    } else if (os_version.majorVersion == 12) {
        return 0x8000;
    }

    return 0;
}

uint64_t get_dppm_offset(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return 0xA000;
    } else if (os_version.majorVersion == 12) {
        return 0x7000;
    }

    return 0;
}

uint64_t get_fix_animation_offset(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return 0x1E0000;
    } else if (os_version.majorVersion == 12) {
        return 0x230000;
    }

    return 0;
}

uint64_t get_add_space_offset(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return 0x1E0000;
    } else if (os_version.majorVersion == 12) {
        return 0x220000;
    }

    return 0;
}

uint64_t get_remove_space_offset(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return 0x2A0000;
    } else if (os_version.majorVersion == 12) {
        return 0x2E0000;
    }

    return 0;
}

uint64_t get_move_space_offset(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return 0x290000;
    } else if (os_version.majorVersion == 12) {
        return 0x2D0000;
    }

    return 0;
}

uint64_t get_set_front_window_offset(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return 0x48000;
    } else if (os_version.majorVersion == 12) {
        return 0x4D000;
    }

    return 0;
}

const char *get_dock_spaces_pattern(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return "B3 17 00 90 73 C2 3D 91 60 02 40 F9 E2 03 17 AA B6 9F 07 94 FD 03 1D AA 14 86 07 94 E0 07 00 F9 88 16 00 90 00 0D 41 F9 9C 85 07 94 02 00 80 D2 6E AB 07 94 E0 13 00 F9 60 02 40 F9 FC 1F 00 F9 E2 03 1C AA C9 CF 07 94 FD 03 1D AA 07 86 07 94 F5 03 00 AA 88 16 00 ?? ?? ?? ?? F9";
    } else if (os_version.majorVersion == 12) {
        return "55 21 00 ?? B5 ?? ?? 91 A0 02 40 F9 ?? 1F 00 ?? 01 ?? ?? F9 E2 03 1B AA ?? ?? 0C 94 FD 03 1D AA ?? ?? 0C 94 E0 13 00 F9 ?? 20 00 ?? 00 ?? ?? F9 ?? ?? 0C 94 E8 1F 00 ?? 13 ?? ?? F9 E1 03 13 AA 02 00 80 D2 ?? ?? 0C 94 E0 27 00 F9 A0 02 40 F9 08 20 00 ?? 01 ?? ?? F9";
    }

    return NULL;
}

const char *get_dppm_pattern(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return "00 20 00 D0 00 C0 3F 91 E1 03 13 AA 41 BF 0B 94 13 2E 00 B4 16 20 00 D0 D6 E2 3F 91 00 00 80 D2 E1 03 16 AA E7 B4 0B 94 E8 1E 00 D0 00 ED 42 F9 78 D9 0B 94 FD 03 1D AA 26 BF 0B 94 F4 03 00 AA";
    } else if (os_version.majorVersion == 12) {
        return "?? 21 00 ?? 00 ?? ?? 91 E1 03 13 AA ?? ?? 0C 94 ?? ?? 00 B4 ?? 20 00 ?? 00 ?? ?? F9 ?? ?? 00 ?? 19 ?? ?? F9 E1 03 19 AA ?? ?? 0C 94 FD 03 1D AA ?? ?? 0C 94 F4 03 00 AA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? ?? ??";
    }

    return NULL;
}

const char *get_fix_animation_pattern(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return "00 10 6A 1E E0 03 14 AA E1 03 18 AA E2 03 17 AA A8 43 01 D1";
    } else if (os_version.majorVersion == 12) {
        return "00 10 6A 1E E0 03 14 AA E2 03 13 AA A8 43 01 D1 04 01 50 B8";
    }

    return NULL;
}

const char *get_add_space_pattern(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return "7F 23 03 D5 FF C3 01 D1 E1 03 1E AA ?? ?? 00 94 FE 03 01 AA FD 7B 06 A9 FD 83 01 91 F5 03 14 AA F3 03 00 AA 89 E2 40 39 96 16 40 F9 C8 FE 7E D3 3F 05 00 71 A1 00 00 54 ?? 14 00 B5 C8 E2 7D 92 17 09 40 F9 ?? 00 00 14 ?? ?? 00 B5 C8 E2 7D 92 17 09 40 F9 ?? ?? 00 94 ?? ?? 00 B4 F8 06 00 F1 ?? 15 00 54 DA 0A 42 F2 E1 17 9F 1A E0 03 18 AA E2 03 16 AA ?? ?? ?? 97 ?? 14 00 B5 C8 0E 18 8B ?? ?? 00 94 F4 03 00 AA";
    } else if (os_version.majorVersion == 12) {
        return "7F 23 03 D5 FF C3 01 D1 E1 03 1E AA ?? ?? 00 94 FE 03 01 AA FD 7B 06 A9 FD 83 01 91 F5 03 14 AA F3 03 00 AA 89 E2 40 39 96 16 40 F9 C8 FE 7E D3 3F 05 00 71 A1 00 00 54 ?? 14 00 B5 C8 E2 7D 92 17 09 40 F9 ?? 00 00 14 ?? ?? 00 B5 C8 E2 7D 92 17 09 40 F9 ?? ?? 00 94 ?? ?? 00 B4 F8 06 00 F1 ?? 15 00 54 DA 0A 42 F2 E1 17 9F 1A E0 03 18 AA E2 03 16 AA ?? ?? FD 97 ?? 14 00 B5 C8 0E 18 8B ?? ?? 00 94 F4 03 00 AA";
    }

    return NULL;
}

const char *get_remove_space_pattern(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return "7F 23 03 D5 FF 83 ?? D1 FC 6F ?? A9 FA 67 ?? A9 F8 5F ?? A9 F6 57 ?? A9 F4 4F ?? A9 FD 7B ?? A9 FD 43 ?? 91 ?? 03 03 AA ?? 03 02 AA ?? 03 01 AA F3 03 00 AA C7 2F FD 97 FC 03 00 AA 08 FC 7E D3 E8 20 00 B5 88 E3 7D 92 00 09 40 F9 1F 08 00 F1 2B 0F 00 54 F5 53 01 A9 C8 0A 00 B0 1F 20 03 D5 08 35 47 F9 68 02 08 8B 14 55 40 A9 48 0B 00 F0 1F 20 03 D5 00 F9 47 F9 28 0A 00 B0 01 BD 41 F9 F3 13 00 F9";
    } else if (os_version.majorVersion == 12) {
        return "7F 23 03 D5 FF 83 03 D1 FC 6F 08 A9 FA 67 09 A9 F8 5F 0A A9 F6 57 0B A9 F4 4F 0C A9 FD 7B 0D A9 FD 43 03 91 F7 03 03 AA F6 03 02 AA F5 03 01 AA F3 03 00 AA F4 03 01 AA ?? ?? FD 97 F4 03 00 AA 08 FC 7E D3 ?? ?? 00 B5 88 E2 7D 92 00 09 40 F9 1F 08 00 F1 ?? 0E 00 54 ?? ?? ?? ?? F5 ?? ?? ?? ?? ?? 00 ?? 1F 20 03 D5 08 ?? ?? F9 68 02 08 8B 14 69 40 A9 ?? 0A 00 ?? 1F 20 03 D5 00 ?? ?? F9 48 09 00 ?? 01 ?? ?? F9 F3 ?? 00 F9 E2 03 13 AA";
    }

    return NULL;
}

const char *get_move_space_pattern(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return "7F 23 03 D5 E3 03 1E AA ?? ?? 00 94 FE 03 03 AA FD 7B 06 A9 FD 83 01 91 ?? 03 14 AA ?? 03 02 AA FA 03 01 AA FB 03 00 AA ?? ?? 00 ?? ?? ?? ?? 91 ?? ?? 40 F9 ?? 68 68 F8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 ?? AA ?? 03 ?? AA ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? 00 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ??";
    } else if (os_version.majorVersion == 12) {
        return "7F 23 03 D5 E3 03 1E AA ?? ?? 00 94 FE 03 03 AA FD 7B 06 A9 FD 83 01 91 ?? 03 14 AA ?? 03 02 AA FA 03 01 AA FB 03 00 AA ?? 0A 00 ?? ?? ?? ?? 91 ?? ?? 40 F9 ?? 68 68 F8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 ?? AA ?? 03 ?? AA ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? 00 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ??";
    }

    return NULL;
}

const char *get_set_front_window_pattern(NSOperatingSystemVersion os_version) {
    if (os_version.majorVersion == 13) {
        return "7F 23 03 D5 FF ?? 02 D1 F6 57 ?? A9 F4 4F ?? A9 FD 7B ?? A9 FD ?? 02 91 ?? 1A 00 ?? 08 ?? ?? F9 08 01 40 F9 A8 83 1D F8 ?? ?? 00 ?? ?? ?? ?? ?? ?? 03 ?? AA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ??";
    } else if (os_version.majorVersion == 12) {
        return "7F 23 03 D5 FF ?? 02 D1 F6 57 ?? A9 F4 4F ?? A9 FD 7B ?? A9 FD ?? 02 91 ?? 1A 00 ?? 08 ?? 44 F9 08 01 40 F9 A8 83 1D F8 ?? ?? 00 ?? ?? ?? ?? ?? ?? 03 ?? AA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ??";
    }

    return NULL;
}
