#ifndef _XRDPSS_API_H
#define _XRDPSS_API_H
/******************************************************************************/
/*                                                                            */
/*                             X r d P s s . h h                              */
/*                                                                            */
/* (c) 2010 by the Board of Trustees of the Leland Stanford, Jr., University  */
/*                            All Rights Reserved                             */
/*   Produced by Andrew Hanushevsky for Stanford University under contract    */
/*              DE-AC02-76-SFO0515 with the Department of Energy              */
/*                                                                            */
/* This file is part of the XRootD software suite.                            */
/*                                                                            */
/* XRootD is free software: you can redistribute it and/or modify it under    */
/* the terms of the GNU Lesser General Public License as published by the     */
/* Free Software Foundation, either version 3 of the License, or (at your     */
/* option) any later version.                                                 */
/*                                                                            */
/* XRootD is distributed in the hope that it will be useful, but WITHOUT      */
/* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or      */
/* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public       */
/* License for more details.                                                  */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public License   */
/* along with XRootD in a file called COPYING.LESSER (LGPL license) and file  */
/* COPYING (GPL license).  If not, see <http://www.gnu.org/licenses/>.        */
/*                                                                            */
/* The copyright holder's institutional names and contributor's names may not */
/* be used to endorse or promote products derived from this software without  */
/* specific prior written permission of the institution or contributor.       */
/******************************************************************************/

#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include "XrdSys/XrdSysHeaders.hh"
#include "XrdOuc/XrdOucExport.hh"
#include "XrdOuc/XrdOucName2Name.hh"
#include "XrdOuc/XrdOucPList.hh"
#include "XrdOuc/XrdOucSid.hh"
#include "XrdOss/XrdOss.hh"

/******************************************************************************/
/*                             X r d P s s D i r                              */
/******************************************************************************/

class XrdPssDir : public XrdOssDF
{
public:
int     Close(long long *retsz=0);
int     Opendir(const char *, XrdOucEnv &);
int     Readdir(char *buff, int blen);

        // Constructor and destructor
        XrdPssDir(const char *tid) : tident(tid), myDir(0) {}
       ~XrdPssDir() {if (myDir) Close();}
private:
const    char      *tident;
         DIR       *myDir;
};
  
/******************************************************************************/
/*                            X r d P s s F i l e                             */
/******************************************************************************/

struct XrdOucIOVec;
class  XrdSfsAio;
  
class XrdPssFile : public XrdOssDF
{
public:

// The following two are virtual functions to allow for upcasting derivations
// of this implementation
//
virtual int     Close(long long *retsz=0);
virtual int     Open(const char *, int, mode_t, XrdOucEnv &);

int     Fchmod(mode_t mode) {return XrdOssOK;}
int     Fstat(struct stat *);
int     Fsync();
int     Fsync(XrdSfsAio *aiop);
int     Ftruncate(unsigned long long);
off_t   getMmap(void **addr);
int     isCompressed(char *cxidp=0);
ssize_t Read(               off_t, size_t);
ssize_t Read(       void *, off_t, size_t);
int     Read(XrdSfsAio *aiop);
ssize_t ReadV(XrdOucIOVec *readV, int n);
ssize_t ReadRaw(    void *, off_t, size_t);
ssize_t Write(const void *, off_t, size_t);
int     Write(XrdSfsAio *aiop);
 
         // Constructor and destructor
         XrdPssFile(const char *tid) : tident(tid), tpcPath(0)
                                       {fd = -1;}

virtual ~XrdPssFile() {if (fd >= 0) Close();
                       if (tpcPath) free(tpcPath);
                      }

private:

const char *tident;
      char *tpcPath;
};

/******************************************************************************/
/*                             X r d P s s S y s                              */
/******************************************************************************/
  
class XrdNetSecurity;
class XrdOucEnv;
class XrdOucStream;
class XrdOucTList;
class XrdPssUrlInfo;
class XrdSysError;

struct XrdVersionInfo;

class XrdPssSys : public XrdOss
{
public:
virtual XrdOssDF *newDir(const char *tident)
                       {return (XrdOssDF *)new XrdPssDir(tident);}
virtual XrdOssDF *newFile(const char *tident)
                       {return (XrdOssDF *)new XrdPssFile(tident);}

int       Chmod(const char *, mode_t mode, XrdOucEnv *eP=0);
virtual
int       Create(const char *, const char *, mode_t, XrdOucEnv &, int opts=0);
void      EnvInfo(XrdOucEnv *envP);
int       Init(XrdSysLogger *, const char *);
int       Lfn2Pfn(const char *Path, char *buff, int blen);
const
char     *Lfn2Pfn(const char *Path, char *buff, int blen, int &rc);
int       Mkdir(const char *, mode_t mode, int mkpath=0, XrdOucEnv *eP=0);
int       Remdir(const char *, int Opts=0, XrdOucEnv *eP=0);
int       Rename(const char *, const char *,
                 XrdOucEnv *eP1=0, XrdOucEnv *eP2=0);
int       Stat(const char *, struct stat *, int opts=0, XrdOucEnv *eP=0);
int       Truncate(const char *, unsigned long long, XrdOucEnv *eP=0);
int       Unlink(const char *, int Opts=0, XrdOucEnv *eP=0);

static const int    PolNum = 2;
enum   PolAct {PolPath = 0, PolObj = 1};

static int   P2DST(int &retc, char *hBuff, int hBlen, PolAct pType,
                   const char *path);
static int   P2OUT(char *pbuff, int pblen, XrdPssUrlInfo &uInfo);
static int   P2URL(char *pbuff, int pblen, XrdPssUrlInfo &uInfo,
                   bool doN2N=true);
static
const  char *valProt(const char *pname, int &plen, int adj=0);

static const char  *ConfigFN;       // -> Pointer to the config file name
static const char  *myHost;
static const char  *myName;
static
XrdOucPListAnchor   XPList;        // Exported path list

static XrdNetSecurity *Police[PolNum];
static XrdOucTList *ManList;
static const char  *protName;
static const char  *hdrData;
static int          hdrLen;
static int          Streams;
static int          Workers;
static int          Trace;
static int          dcaCTime;

static bool         outProxy; // True means outgoing proxy
static bool         pfxProxy; // True means outgoing proxy is prefixed
static bool         xLfn2Pfn;
static bool         dcaCheck;
static bool         dcaWorld;

         XrdPssSys();
virtual ~XrdPssSys() {}

private:

char              *LocalRoot;// -> pss Local n2n root, if any
XrdOucName2Name   *theN2N;   // -> File mapper object
unsigned long long DirFlags; // Defaults for exports
XrdVersionInfo    *myVersion;// -> Compilation version

int    Configure(const char *);
int    ConfigProc(const char *ConfigFN);
int    ConfigXeq(char*, XrdOucStream&);
const
char  *getDomain(const char *hName);
int    xconf(XrdSysError *Eroute, XrdOucStream &Config);
int    xdef( XrdSysError *Eroute, XrdOucStream &Config);
int    xdca( XrdSysError *errp,   XrdOucStream &Config);
int    xexp( XrdSysError *Eroute, XrdOucStream &Config);
int    xperm(XrdSysError *errp,   XrdOucStream &Config);
int    xorig(XrdSysError *errp,   XrdOucStream &Config);
};
#endif
