#line 2 "xpkg.c"

#line 4 "xpkg.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 31
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <stdint.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE xpkgmainrestart(xpkgmainin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int xpkgmainleng;

extern FILE *xpkgmainin, *xpkgmainout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up xpkgmaintext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up xpkgmaintext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via xpkgmainrestart()), so that the user can continue scanning by
	 * just pointing xpkgmainin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when xpkgmaintext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int xpkgmainleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow xpkgmainwrap()'s to do buffer switches
 * instead of setting up a fresh xpkgmainin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void xpkgmainrestart (FILE *input_file  );
void xpkgmain_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE xpkgmain_create_buffer (FILE *file,int size  );
void xpkgmain_delete_buffer (YY_BUFFER_STATE b  );
void xpkgmain_flush_buffer (YY_BUFFER_STATE b  );
void xpkgmainpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void xpkgmainpop_buffer_state (void );

static void xpkgmainensure_buffer_stack (void );
static void xpkgmain_load_buffer_state (void );
static void xpkgmain_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER xpkgmain_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE xpkgmain_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE xpkgmain_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE xpkgmain_scan_bytes (yyconst char *bytes,int len  );

void *xpkgmainalloc (yy_size_t  );
void *xpkgmainrealloc (void *,yy_size_t  );
void xpkgmainfree (void *  );

#define yy_new_buffer xpkgmain_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        xpkgmainensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            xpkgmain_create_buffer(xpkgmainin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        xpkgmainensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            xpkgmain_create_buffer(xpkgmainin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define xpkgmainwrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *xpkgmainin = (FILE *) 0, *xpkgmainout = (FILE *) 0;

typedef int yy_state_type;

extern int xpkgmainlineno;

int xpkgmainlineno = 1;

extern char *xpkgmaintext;
#define yytext_ptr xpkgmaintext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up xpkgmaintext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	xpkgmainleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 17
#define YY_END_OF_BUFFER 18
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[107] =
    {   0,
        0,    0,   18,   16,   15,   15,   16,   16,   15,   15,
        0,   12,   10,    2,    5,   13,    3,    9,    0,    4,
       11,    6,    1,    0,   14,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    8,    7,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    4,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    5,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    6,    7,    8,    9,

       10,   11,   12,   13,   14,    1,    1,   15,   16,   17,
       18,   19,   20,   21,   22,   23,   24,   25,    1,    1,
       26,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[27] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[110] =
    {   0,
        0,    3,  121,  122,  122,  122,    4,  117,  116,  115,
       22,  122,  122,  122,  122,  122,  122,  122,    4,  122,
      122,  122,  122,  114,  122,   95,  105,   93,  103,   95,
       97,   86,   99,   98,    3,   97,  122,  122,   96,   98,
       98,   88,   80,   79,   90,   87,   76,   83,   84,   74,
       88,   69,   70,   72,   67,   66,   67,   73,   63,   68,
       63,    4,   60,   70,   71,   74,   53,   56,   55,   70,
       57,   60,   63,   57,   67,   47,   46,   59,   45,   48,
       61,   49,   22,   53,   56,   51,   50,   42,   49,   43,
       50,   34,   39,   47,   37,   35,   35,   26,   38,   34,

       35,   33,   32,   12,   13,  122,   15,    9,    0
    } ;

static yyconst flex_int16_t yy_def[110] =
    {   0,
      107,  108,  106,  106,  106,  106,  106,  109,  109,  109,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  109,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,

      106,  106,  106,  106,  106,    0,  106,  106,  106
    } ;

static yyconst flex_int16_t yy_nxt[149] =
    {   0,
       24,    5,    6,    7,    9,   10,    7,   11,   12,    8,
       71,   13,   14,   15,   37,    4,   16,   17,   18,   48,
       38,   49,   13,   19,   20,   72,   21,   22,   23,   26,
       27,   28,   90,  105,   29,   30,   31,  104,   91,  103,
      102,   32,   33,   38,   34,   35,   36,   37,  101,   15,
      100,   99,   98,   97,   20,   96,   95,   94,   12,   23,
       22,   93,   92,   17,   89,   88,   87,   86,   85,   84,
       83,   82,   81,   80,   79,   78,   77,   76,   75,   74,
       15,   14,   73,   70,   69,   21,   68,   67,   18,   66,
       16,   65,   64,   63,   62,   61,   60,   59,   58,   57,

       56,   55,   54,   53,   52,   51,   50,   47,   46,   45,
       44,   43,   42,   41,   40,   39,   25,   25,   25,   25,
      106,    3,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106
    } ;

static yyconst flex_int16_t yy_chk[149] =
    {   0,
      109,    1,    1,    1,    2,    2,    2,    7,    7,  108,
       62,    7,    7,    7,   19,  107,    7,    7,    7,   35,
       19,   35,  105,    7,    7,   62,    7,    7,    7,   11,
       11,   11,   83,  104,   11,   11,   11,  103,   83,  102,
      101,   11,   11,  100,   11,   11,   11,   99,   98,   97,
       96,   95,   94,   93,   92,   91,   90,   89,   88,   87,
       86,   85,   84,   82,   81,   80,   79,   78,   77,   76,
       75,   74,   73,   72,   71,   70,   69,   68,   67,   66,
       65,   64,   63,   61,   60,   59,   58,   57,   56,   55,
       54,   53,   52,   51,   50,   49,   48,   47,   46,   45,

       44,   43,   42,   41,   40,   39,   36,   34,   33,   32,
       31,   30,   29,   28,   27,   26,   24,   10,    9,    8,
        3,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int xpkgmain_flex_debug;
int xpkgmain_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *xpkgmaintext;
#line 1 "xpkg.l"
/*_
 * Copyright (c) 2005, 2006 Markus W. Weissmann <mww@opendarwin.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of OpenDarwin nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: xpkg.l,v 1.4 2006/02/22 22:22:12 mww Exp $
 *
 */
#define YY_NO_INPUT 1
#line 41 "xpkg.l"
#include <assert.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>
#include <unistd.h>
#include "xpkg.h"
#include "config.h"
#include "util.h"
#include "usage.txtstr.h"

#define ecerr(x,y) if( x ) { fprintf(stderr,"error: %s\n", y); goto CLEANUP; }

#define A_NOACTION 0
#define A_ERROR 1
#define A_HELP 2
#define A_VERSION 3
#define A_INSTALL 4
#define A_REGISTER 5
#define A_DELETE 6
#define A_UPGRADE 7
#define A_QUERY_NAME 8
#define A_QUERY_FILE 9
#define A_LIST 10
#define A_CREATEDB 11
#define A_TEST 12

	int action = A_NOACTION;
	char** targets = NULL;
	int targetcount = 0;

	void add_target(char* text) {
		assert(text);
		assert(strlen(text) > 0);
		if (0 == targetcount) {
			assert(NULL == targets);
			targets = calloc(1,sizeof(char*));
		} else {
			assert(targets);
			targets = realloc(targets, (targetcount+1) * sizeof(char*));
		}
		targets[targetcount] = strdup(text);
		targetcount++;
	}

	void print_version() {
		fprintf(stdout, "xpkg, version %s\n", VERSION);
	}

	void print_help() {
		const char *help = STR_STR_usage;
		fprintf(stdout, help);
	}

	void print_error() {
		fprintf(stderr, "error in arguments!\n");
	}

	void set_action(int an_action) {
		if (A_NOACTION == action)
			action = an_action;
		else
			action = A_ERROR;
	}
	
	int package_register() {
		int i;
		xpkg_registry_t reg;
		xpkg_pkg_t pkg = NULL;

		ecerr( NULL==targets, "no targets given" )
		reg = xpkg_registry_open(getenv("XPKG_REGFILE"));
		printf("error: %s\n", xpkg_strerror(errno));
		ecerr( XPKG_OK!=xpkg_registry_transaction_begin( reg ), "being transaction" );
		for( i=0; i<targetcount; i++ ) {
			pkg = xpkg_pkg_open(targets[i]);
			ecerr( XPKG_OK!=xpkg_registry_registerpkg( reg, pkg ), "registering package" );
			ecerr( XPKG_OK!=xpkg_pkg_close( pkg ), "closing package" );
		}
		ecerr( XPKG_OK!=xpkg_registry_transaction_commit( reg ), "commiting transaction" );
		ecerr( XPKG_OK!=xpkg_registry_close( &reg ), "closing registry" );
		xpkg_pkg_free( &pkg );
		return 0;

		CLEANUP: {
			xpkg_pkg_close( pkg );
			xpkg_registry_transaction_rollback( reg );
			xpkg_registry_close( &reg );
			xpkg_pkg_free( &pkg );
			return -1;
		}
	}

	int package_install() {
		int i;
		xpkg_registry_t reg = NULL;
		xpkg_pkg_t pkg = NULL;

		ecerr( NULL==targets, "no targets given" )
		fprintf( stdout, "installing packages... " );
		reg = xpkg_registry_open(getenv("XPKG_REGFILE"));
		ecerr( XPKG_OK!=xpkg_registry_transaction_begin( reg ), "being transaction" );
		for( i=0; i<targetcount; i++ ) {
			pkg = xpkg_pkg_open(targets[i]);
			ecerr( XPKG_OK!=xpkg_registry_registerpkg( reg, pkg ), "registering package" );
			ecerr( XPKG_OK!=xpkg_pkg_close( pkg ), "closing package" );
		}
		ecerr( XPKG_OK!=xpkg_registry_checkconsistence( reg ), "consistency check" );
		for( i=0; i<targetcount; i++ ) {
			pkg = xpkg_pkg_open(targets[i]);
			ecerr( XPKG_OK!=xpkg_pkg_extract( pkg, getenv("XPKG_PKGROOT")), "extracting package" );
			ecerr( XPKG_OK!=xpkg_pkg_close( pkg ), "closing package" );
		}
		ecerr( XPKG_OK!=xpkg_registry_transaction_commit( reg ), "commiting transaction" );
		ecerr( XPKG_OK!=xpkg_registry_close( &reg ), "closing registry" );
		xpkg_pkg_free( &pkg );
		fprintf( stdout, "done\n" );
		return 0;

		CLEANUP: {
			xpkg_pkg_close( pkg );
			xpkg_registry_transaction_rollback( reg );
			xpkg_registry_close( &reg );
			xpkg_pkg_free( &pkg );
			fprintf( stdout, "failed\n" );
			return -1;
		}
	}

	int package_upgrade() {
		int i;
		char *c;
		xpkg_registry_t reg = NULL;
		xpkg_pkg_t pkg = NULL;

		ecerr( NULL==targets, "no targets given" )
		reg = xpkg_registry_open(getenv("XPKG_REGFILE"));
		printf("error: %s\n", xpkg_strerror(errno));
		ecerr( XPKG_OK!=xpkg_registry_transaction_begin( reg ), "being transaction" );
		for (i = 0; i < targetcount; i++) {
			pkg = xpkg_pkg_open(targets[i]);
			c = xpkg_pkg_getname(pkg);
			ecerr( XPKG_OK!=xpkg_registry_removepkg( reg, c ), "removing package" );
			free( c );
			ecerr( XPKG_OK!=xpkg_registry_registerpkg( reg, pkg ), "registering package" );
			ecerr( XPKG_OK!=xpkg_pkg_close( pkg ), "closing package" );
		}
		ecerr( XPKG_OK!=xpkg_registry_checkconsistence( reg ), "consistency check" );
		fprintf( stdout, "extracting packages..." );
		for( i=0; i<targetcount; i++ ) {
			pkg = xpkg_pkg_open(targets[i]);
			ecerr( XPKG_OK!=xpkg_pkg_extract(pkg, getenv("XPKG_PKGROOT")), "extracting package" );
			ecerr( XPKG_OK!=xpkg_pkg_close( pkg ), "closing package" );
		}
		ecerr( XPKG_OK!=xpkg_registry_transaction_commit( reg ), "commiting transaction" );
		ecerr( XPKG_OK!=xpkg_registry_close( &reg ), "closing registry" );
		xpkg_pkg_free( &pkg );
		return 0;

		CLEANUP: {
			xpkg_pkg_close( pkg );
			xpkg_registry_transaction_rollback( reg );
			xpkg_registry_close( &reg );
			xpkg_pkg_free( &pkg );
			return -1;
		}
	}

	int package_delete() {
		int i;
		xpkg_registry_t reg = NULL;
		xpkg_files_t files = NULL;

		ecerr( NULL==targets, "no targets given" );
		reg = xpkg_registry_open(getenv("XPKG_REGFILE"));
		ecerr( XPKG_OK!=xpkg_registry_transaction_begin( reg ), "starting transaction" );

		for( i=0; i<targetcount; i++ ) {
			fprintf( stdout, "removing %s\n", targets[i] );
			ecerr( XPKG_OK!=xpkg_registry_removepkg( reg, targets[i] ), "removing package" );
		}
		ecerr( XPKG_OK!=xpkg_registry_checkconsistence( reg ), "consistency check" );
		assert(0 <= xpkg_registry_getstalefiles(reg, &files));
		assert(files);

		ecerr( XPKG_OK!=xpkg_files_delete(files, getenv("XPKG_PKGROOT")), "removing files" );

		ecerr( XPKG_OK!=xpkg_registry_removestalefiles( reg ), "removing files from registry" );
		ecerr( XPKG_OK!=xpkg_registry_transaction_commit( reg ), "commiting transaction" );

		ecerr( XPKG_OK!=xpkg_registry_close( &reg ), "closing registry" );
		return 0;

		CLEANUP: {
			xpkg_registry_transaction_rollback( reg );
			xpkg_registry_close( &reg );
			return -1;
		}
	}

	int package_query(int mode) {
		int i;
		xpkg_registry_t reg = NULL;
		xpkg_pkgs_t pkgs = NULL;

		ecerr( NULL==targets, "no targets given" )
		reg = xpkg_registry_open( getenv("XPKG_REGFILE"));
		ecerr( XPKG_OK!=xpkg_registry_transaction_begin( reg ), "starting transaction" );
		for (i = 0; i < targetcount; i++) {
			assert(0 <= xpkg_registry_querypkgs(reg, targets[i], mode, &pkgs));
			if (NULL != pkgs) {
				xpkg_pkgs_print(pkgs);
				xpkg_pkgs_free(&pkgs);
			} else {
				printf("no such package: \"%s\"\n", targets[i]);
			}
		}
		ecerr( XPKG_OK!=xpkg_registry_transaction_commit( reg ), "closing transaction" );
		ecerr( XPKG_OK!=xpkg_registry_close( &reg ), "closing registry" );
		return 0;

		CLEANUP: {
			xpkg_registry_close(&reg);
			xpkg_pkgs_free(&pkgs);
			return -1;
		}
	}

	int package_listall() {
		int n;
		xpkg_registry_t reg = NULL;
		xpkg_pkgs_t pkgs = NULL;
		reg = xpkg_registry_open(getenv("XPKG_REGFILE"));
		ecerr(XPKG_OK!=xpkg_registry_transaction_begin(reg), "starting transaction" );
		n = xpkg_registry_querypkgs(reg, NULL, XPKG_QUERYMODE_LISTALL, &pkgs);
		if (n > 0) {
			xpkg_pkgs_print(pkgs);
		} else {
			fprintf(stdout, "no packages installed\n");
		}
		ecerr(XPKG_OK!=xpkg_registry_transaction_commit(reg), "closing transaction");
		ecerr(XPKG_OK!=xpkg_registry_close(&reg), "closing registry");
		xpkg_pkgs_free(&pkgs);
		return 0;

		CLEANUP: {
			xpkg_registry_close(&reg);
			xpkg_pkgs_free(&pkgs);
			return -1;
		}
	}

	int createdb() {
		xpkg_registry_t reg = NULL;
		fprintf( stdout, "initializing registry...");
		//ecerr( 0==access( getenv("XPKG_REGFILE"), F_OK ), "registry already exists" );
		reg = xpkg_registry_open(getenv("XPKG_REGFILE"));
		printf("error: %s\n", xpkg_strerror(errno));
		xpkg_registry_init( reg );
		printf("error: %s\n", xpkg_strerror(errno));
		ecerr( XPKG_OK!=xpkg_registry_close( &reg ), "closing registry" );
		fprintf( stdout, " done\n" );
		return 0;

		CLEANUP: {
			fprintf( stdout, " failed\n" );
			xpkg_registry_close( &reg );
			return -1;
		}
	}

	int execute() {
		int rc = 0;
		switch( action ) {
			case A_VERSION:
				print_version();
				break;
			case A_INSTALL:
				rc = package_install();
				break;
			case A_REGISTER:
				rc = package_register();
				break;
			case A_DELETE:
				rc = package_delete();
				break;
			case A_UPGRADE:
				rc = package_upgrade();
				break;
			case A_QUERY_NAME:
				rc = package_query( XPKG_QUERYMODE_BYNAME );
				break;
			case A_QUERY_FILE:
				rc = package_query( XPKG_QUERYMODE_BYPATH );
				break;
			case A_LIST:
				rc = package_listall();
				break;
			case A_CREATEDB:
				rc = createdb();
				break;
			case A_TEST:
				//test_p();
				printf( "noop\n" );
				break;
			case A_ERROR:
				rc = -1;
				print_error();
			case A_HELP:
			default:
				print_help();
		}
		return rc;
	}
#line 860 "xpkg.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int xpkgmainwrap (void );
#else
extern int xpkgmainwrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( xpkgmaintext, xpkgmainleng, 1, xpkgmainout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( xpkgmainin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( xpkgmainin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, xpkgmainin))==0 && ferror(xpkgmainin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(xpkgmainin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int xpkgmainlex (void);

#define YY_DECL int xpkgmainlex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after xpkgmaintext and xpkgmainleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( xpkgmainleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(xpkgmaintext[xpkgmainleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 359 "xpkg.l"

#line 1014 "xpkg.c"

	if ( (yy_init) )
		{
		(yy_init) = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! xpkgmainin )
			xpkgmainin = stdin;

		if ( ! xpkgmainout )
			xpkgmainout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			xpkgmainensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				xpkgmain_create_buffer(xpkgmainin,YY_BUF_SIZE );
		}

		xpkgmain_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of xpkgmaintext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 107 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 122 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 360 "xpkg.l"
{ setenv( "XPKG_VERBOSE", "1", 0 ); };
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 361 "xpkg.l"
{ setenv( "XPKG_DEBUG", "1", 0 ); };
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 362 "xpkg.l"
{ set_action( A_INSTALL ); };
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 363 "xpkg.l"
{ set_action( A_REGISTER ); };
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 364 "xpkg.l"
{ set_action( A_DELETE ); };
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 365 "xpkg.l"
{ set_action( A_UPGRADE ); };
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 366 "xpkg.l"
{ set_action( A_QUERY_NAME ); };
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 367 "xpkg.l"
{ set_action( A_QUERY_FILE ); };
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 368 "xpkg.l"
{ set_action( A_LIST ); };
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 369 "xpkg.l"
{ set_action( A_CREATEDB ); };
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 370 "xpkg.l"
{ set_action( A_TEST ); };
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 371 "xpkg.l"
{ set_action( A_VERSION ); }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 372 "xpkg.l"
{ set_action( A_HELP ); }
	YY_BREAK
case 14:
/* rule 14 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up xpkgmaintext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up xpkgmaintext again */
YY_RULE_SETUP
#line 373 "xpkg.l"
{ add_target( xpkgmaintext ); };
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 374 "xpkg.l"

	YY_BREAK
case 16:
YY_RULE_SETUP
#line 375 "xpkg.l"
{ set_action( A_ERROR ); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 376 "xpkg.l"
ECHO;
	YY_BREAK
#line 1188 "xpkg.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed xpkgmainin at a new source and called
			 * xpkgmainlex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = xpkgmainin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( xpkgmainwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * xpkgmaintext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of xpkgmainlex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					xpkgmainrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			xpkgmainrestart(xpkgmainin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 107 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 107 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 106);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					xpkgmainrestart(xpkgmainin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( xpkgmainwrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve xpkgmaintext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void xpkgmainrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        xpkgmainensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            xpkgmain_create_buffer(xpkgmainin,YY_BUF_SIZE );
	}

	xpkgmain_init_buffer(YY_CURRENT_BUFFER,input_file );
	xpkgmain_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void xpkgmain_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		xpkgmainpop_buffer_state();
	 *		xpkgmainpush_buffer_state(new_buffer);
     */
	xpkgmainensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	xpkgmain_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (xpkgmainwrap()) processing, but the only time this flag
	 * is looked at is after xpkgmainwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void xpkgmain_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	xpkgmainin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE xpkgmain_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) xpkgmainalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in xpkgmain_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) xpkgmainalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in xpkgmain_create_buffer()" );

	b->yy_is_our_buffer = 1;

	xpkgmain_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with xpkgmain_create_buffer()
 * 
 */
    void xpkgmain_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		xpkgmainfree((void *) b->yy_ch_buf  );

	xpkgmainfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a xpkgmainrestart() or at EOF.
 */
    static void xpkgmain_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	xpkgmain_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then xpkgmain_init_buffer was _probably_
     * called from xpkgmainrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void xpkgmain_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		xpkgmain_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void xpkgmainpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	xpkgmainensure_buffer_stack();

	/* This block is copied from xpkgmain_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from xpkgmain_switch_to_buffer. */
	xpkgmain_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void xpkgmainpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	xpkgmain_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		xpkgmain_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void xpkgmainensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)xpkgmainalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)xpkgmainrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE xpkgmain_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) xpkgmainalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in xpkgmain_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	xpkgmain_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to xpkgmainlex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       xpkgmain_scan_bytes() instead.
 */
YY_BUFFER_STATE xpkgmain_scan_string (yyconst char * yy_str )
{
    
	return xpkgmain_scan_bytes(yy_str,strlen(yy_str) );
}

/** Setup the input buffer state to scan the given bytes. The next call to xpkgmainlex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE xpkgmain_scan_bytes  (yyconst char * bytes, int  len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) xpkgmainalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in xpkgmain_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = xpkgmain_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in xpkgmain_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up xpkgmaintext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		xpkgmaintext[xpkgmainleng] = (yy_hold_char); \
		(yy_c_buf_p) = xpkgmaintext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		xpkgmainleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int xpkgmainget_lineno  (void)
{
        
    return xpkgmainlineno;
}

/** Get the input stream.
 * 
 */
FILE *xpkgmainget_in  (void)
{
        return xpkgmainin;
}

/** Get the output stream.
 * 
 */
FILE *xpkgmainget_out  (void)
{
        return xpkgmainout;
}

/** Get the length of the current token.
 * 
 */
int xpkgmainget_leng  (void)
{
        return xpkgmainleng;
}

/** Get the current token.
 * 
 */

char *xpkgmainget_text  (void)
{
        return xpkgmaintext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void xpkgmainset_lineno (int  line_number )
{
    
    xpkgmainlineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see xpkgmain_switch_to_buffer
 */
void xpkgmainset_in (FILE *  in_str )
{
        xpkgmainin = in_str ;
}

void xpkgmainset_out (FILE *  out_str )
{
        xpkgmainout = out_str ;
}

int xpkgmainget_debug  (void)
{
        return xpkgmain_flex_debug;
}

void xpkgmainset_debug (int  bdebug )
{
        xpkgmain_flex_debug = bdebug ;
}

/* xpkgmainlex_destroy is for both reentrant and non-reentrant scanners. */
int xpkgmainlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		xpkgmain_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		xpkgmainpop_buffer_state();
	}

	/* Destroy the stack itself. */
	xpkgmainfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
    	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
    	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *xpkgmainalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *xpkgmainrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void xpkgmainfree (void * ptr )
{
	free( (char *) ptr );	/* see xpkgmainrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#undef YY_NEW_FILE
#undef YY_FLUSH_BUFFER
#undef yy_set_bol
#undef yy_new_buffer
#undef yy_set_interactive
#undef yytext_ptr
#undef YY_DO_BEFORE_ACTION

#ifdef YY_DECL_IS_OURS
#undef YY_DECL_IS_OURS
#undef YY_DECL
#endif
#line 376 "xpkg.l"



int yyerror( char *c ) {
	printf( "oops: %s\n", c );
	return 0;
}

int main( int argc, char* argv[] ) {
	int i, len = 0;
	char *yybuffer = NULL;
	YY_BUFFER_STATE input_buffer = NULL;

	if( NULL==getenv("XPKG_REGFILE") ) {
		fprintf( stderr, "XPKG_REGFILE not set\n" );
		setenv( "XPKG_REGFILE", "/var/tmp/xpkg.reg", 1 );
	}
	if( NULL==getenv("XPKG_PKGROOT") ) {
		fprintf( stderr, "XPKG_PKGROOT not set\n" );
		setenv( "XPKG_PKGROOT", "/var/tmp", 1 );
	}

	yybuffer = malloc(0);
	for( i = 1; i < argc; i++ ) {
		len += 1 + strlen( argv[i] );
		yybuffer = realloc( yybuffer, len );
		strcat( yybuffer, argv[i] );
		strcat( yybuffer, "\n" );
	}

	input_buffer = xpkgmain_scan_string(yybuffer );
	i = xpkgmainlex();

	return execute();
}

