/*_
 * Copyright (c) 2005, Markus W. Weissmann <mww@opendarwin.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of OpenDarwin nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: xpkg.h,v 1.16 2005/09/09 18:38:01 mww Exp $
 *
 */

#ifndef _XPKG_H_
#define _XPKG_H_

#include <inttypes.h>

#define EXPKG_NO_FILES				1000

#define XPKG_OK						0
#define XPKG_ERROR					1
#define XPKG_REGISTRY_BUSY			2
#define XPKG_REGISTRY_INCONSISTENT	3
#define XPKG_REGISTRY_UNAVAILABLE	13
#define XPKG_REGISTRY_CANT_INIT		20
#define XPKG_REGISTRY_CLOSED		14
#define XPKG_PKG_ALREADY_REGISTERED	7
#define XPKG_CANT_ACCESS_FILE		10
#define XPKG_TRANSACTION_INPROGRESS	4
#define XPKG_FILE_CONFLICT			8
#define XPKG_FILETYPE_CONFLICT		9
#define XPKG_NO_TRANSACTION			6
#define XPKG_NO_SUCH_PACKAGE		5
#define XPKG_CONSTRAINT_ERROR		11
#define XPKG_EXTRACT_ERROR			12

#define XPKG_QUERYMODE_BYNAME		50
#define XPKG_QUERYMODE_BYPATH		51
#define XPKG_QUERYMODE_LISTALL		52

typedef struct xpkg_files_t *xpkg_files_t;
typedef struct xpkg_items_t *xpkg_items_t;
typedef struct xpkg_pkg_t *xpkg_pkg_t;
typedef struct xpkg_pkgs_t *xpkg_pkgs_t;
typedef struct xpkg_registry_t *xpkg_registry_t;

/** 
 * Method documentation. 
 * @param errnum The parameter. 
 * @return The return value. 
 */ 
char *
xpkg_strerror(int32_t errnum);
/* always returns a char* with the latest error message */

xpkg_registry_t
xpkg_registry_open(const char *filename);
/* returns NULL on error, errno set */

int32_t
xpkg_registry_close(xpkg_registry_t *reg);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_init(xpkg_registry_t reg);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_transaction_begin(xpkg_registry_t reg);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_transaction_commit(xpkg_registry_t reg);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_transaction_rollback(xpkg_registry_t reg);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_checkrequirements(xpkg_registry_t reg, xpkg_pkg_t pkg, xpkg_items_t *items);
/* returns number of items on success (>=0), negative on failure, errno set; *items may be NULL on success */

int32_t
xpkg_registry_registerpkg(xpkg_registry_t reg, xpkg_pkg_t pkg);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_querypkgs(xpkg_registry_t reg, const char *query, int32_t mode, xpkg_pkgs_t *pkgs);
/* returns number of pkgs found on success (>=0), negative on failure, errno set; *pkgs may be NULL on success */

int32_t
xpkg_registry_removepkg(xpkg_registry_t reg, const char *pkgname);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_getstalefiles(xpkg_registry_t reg, xpkg_files_t *files);
/* returns 0 on success, negative on failure, errno set; *files may be NULL on success */

int32_t
xpkg_registry_removestalefiles(xpkg_registry_t reg);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_registry_checkconsistence(xpkg_registry_t reg);
/* returns 0 if consistent, positive if inconsistent, negative on failure, errno set */

xpkg_pkg_t
xpkg_pkg_open(const char *filename);
/* returns NULL on error, errno set */

char *
xpkg_pkg_getname(xpkg_pkg_t pkg);
/* returns NULL on error, errno set */

int32_t
xpkg_pkg_extract(xpkg_pkg_t pkg, const char *rootpath);
/* returns 0 on success, negative on failure, errno set */

int32_t
xpkg_pkg_close(xpkg_pkg_t pkg);
/* returns 0 on success, negative on failure, errno set */

void
xpkg_pkg_free(xpkg_pkg_t *pkg);
/* *pkg is set to NULL on success, errno not set */

void
xpkg_pkgs_free(xpkg_pkgs_t *pkgs);
/* *pkg is set to NULL on success, errno not set */

void
xpkg_items_free(xpkg_items_t *items);
/* *pkg is set to NULL on success, errno not set */

int32_t
xpkg_files_delete(xpkg_files_t files, const char *rootpath);
/* returns 0 on success, negative on failure, errno set */

void
xpkg_files_free(xpkg_files_t *files);
/* *files is set to NULL on success, errno not set */

void
xpkg_pkgs_print(xpkg_pkgs_t pkgs);

void
xpkg_items_print(xpkg_items_t item);

void
xpkg_files_print(xpkg_files_t files);

#endif
