/*_
 * Copyright (c) 2005, Markus W. Weissmann <mww@opendarwin.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of OpenDarwin nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: xmllex.l,v 1.5 2005/09/07 10:48:38 mww Exp $
 *
 */

%option nomain
%option noinput
%option nounput
%option nostack
%option noyywrap
%option prefix="xpkgxml"

%{
#include <assert.h>
#include <string.h>

#include "pkg.h"
#include "util.h"
#include "xmlpars.tab.h"

%}

%x intag outag inattr
space [\t\n ]+
string [^<>/]+
attr [a-zA-Z0-9]+

%%

<*>{
	"<"					{ BEGIN intag; return xpkgxmltext[0]; };
	"</"				{ BEGIN intag; return xpkgxmltext[1]; };
	">"					{ BEGIN outag; return xpkgxmltext[0]; };
	{space}				;
}
<intag>{
	{attr}/=			{ BEGIN inattr; xpkgxmllval.string = strdup(xpkgxmltext); return ATTR; };
	xpkg				{ return XPKG; };
	name				{ return NAME; };
	version				{ return VERS; };
	revision			{ return REVI; };
	provides			{ return PROV; };
	requires			{ return REQU; };
	item				{ return ITEM; };
	major				{ return MAJO; };
	minor				{ return MINO; };
}
<outag>{
	{string}			{ xpkgxmllval.string = strdup(xpkgxmltext); return STRING; };
}
<inattr>{
	"="					{ return xpkgxmltext[0]; };
	\"[^\"]*/\"			{ xpkgxmllval.string = strdup(++xpkgxmltext); return STRING; };
	\'[^\']*/\'			{ xpkgxmllval.string = strdup(++xpkgxmltext); return STRING; };
	\'|\"				{ BEGIN intag; }
}
.|\n					{ assert(0); }

%%

int32_t
xpkgxml_prepare(char *xml) {
	YY_BUFFER_STATE input_buffer = NULL;

	input_buffer = yy_scan_string( xml );
	return 0;
}
