/*_
 * Copyright (c) 2005, Markus W. Weissmann <mww@opendarwin.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of OpenDarwin nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: item.c,v 1.8 2005/09/07 10:48:38 mww Exp $
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "item.h"
#include "xpkg.h"
#include "util.h"

xpkg_item_t
item_create(const char *name, int32_t major, int32_t minor) {
	xpkg_item_t i;

	assert(name);
	i = calloc(1, sizeof(struct xpkg_item_t));
	assert(i);
	i->name=strdup(name);
	i->major=major;
	i->minor=minor;
	return i;
}

xpkg_items_t
items_create() {
	xpkg_items_t t;

	t = calloc(1, sizeof(struct xpkg_items_t));
	assert(t);
	LIST_INIT(t);
	return t;
}

void
item_to_items(xpkg_items_t items, xpkg_item_t item) {
	assert(items);
	assert(item);
	LIST_INSERT_HEAD(items, item, entries);
}

xpkg_item_t item_cpy(xpkg_item_t *dst, xpkg_item_t src) {
	xpkg_item_t i;

	assert(src);
	i = item_create(src->name, src->major, src->minor);
	assert(i);
	*dst = i;
	return i;
}

void
xpkg_item_print(xpkg_item_t item) {
	assert(item);
	printf("Item: %s (%d/%d)\n", item->name, item->major, item->minor);
}

void
xpkg_items_print(xpkg_items_t items) {
	xpkg_item_t i;

	assert(items);
	for (i = (*items).lh_first; NULL != i; i = i->entries.le_next)
		xpkg_item_print(i);
}

void
xpkg_item_free(xpkg_item_t item) {

	DEBUG("freeing *item");
	assert(item);
	assert(item->name);
	FREE(item->name);
	FREE(item);
}

void
xpkg_items_free(xpkg_items_t *items) {
	xpkg_item_t i;
	xpkg_items_t n;

	if (NULL != *items) {
		n = *items;
		for(;;) {
			i = (*n).lh_first;
			if (NULL == i)
				break;
			LIST_REMOVE(i, entries);
			xpkg_item_free(i);
		}
		FREE(*items);
	}
}

