/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;

public class TreeViewer {
    public static MutableTreeNode processElement(Element element) {
        String string = element.getNamespaceURI().equals("") ? element.getLocalName() : '{' + element.getNamespaceURI() + "} " + element.getQualifiedName();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            defaultMutableTreeNode.insert(TreeViewer.processElement(elements.get(i)), i);
        }
        return defaultMutableTreeNode;
    }

    public static void display(Document document) {
        Element element = document.getRootElement();
        JTree jTree = new JTree(TreeViewer.processElement(element));
        JScrollPane jScrollPane = new JScrollPane(jTree);
        JFrame jFrame = new JFrame("XML Tree");
        String string = System.getProperty("java.version");
        if (string.startsWith("1.2") || string.startsWith("1.1")) {
            jFrame.setDefaultCloseOperation(1);
        } else {
            jFrame.setDefaultCloseOperation(3);
        }
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.show();
    }

    public static void main(String[] stringArray) {
        try {
            Builder builder = new Builder();
            for (int i = 0; i < stringArray.length; ++i) {
                Document document = builder.build(stringArray[i]);
                TreeViewer.display(document);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

