/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.ParsingException;

public class XHTMLValidator {
    private static Builder builder = new Builder(true);

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            XHTMLValidator.validate(stringArray[i]);
        }
    }

    public static void validate(String string) {
        String string2;
        String string3;
        Document document;
        try {
            document = builder.build(string);
        }
        catch (ParsingException parsingException) {
            System.out.println(string + " is invalid XML, and thus not XHTML.");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Could not read: " + string);
            return;
        }
        boolean bl = true;
        DocType docType = document.getDocType();
        if (docType == null) {
            System.out.println("No DOCTYPE");
            bl = false;
        } else {
            string3 = docType.getRootElementName();
            string2 = docType.getPublicID();
            if (!string3.equals("html")) {
                System.out.println("Incorrect root element name " + string3);
                bl = false;
            }
            if (string2 == null || !string2.equals("-//W3C//DTD XHTML 1.0 Strict//EN") && !string2.equals("-//W3C//DTD XHTML 1.0 Transitional//EN") && !string2.equals("-//W3C//DTD XHTML 1.0 Frameset//EN")) {
                bl = false;
                System.out.println(string + " does not seem to use an XHTML 1.0 DTD");
            }
        }
        string3 = document.getRootElement();
        string2 = string3.getNamespaceURI();
        String string4 = string3.getNamespacePrefix();
        if (!string2.equals("http://www.w3.org/1999/xhtml")) {
            bl = false;
            System.out.println(string + " does not properly declare the" + " http://www.w3.org/1999/xhtml namespace" + " on the root element");
        }
        if (!string4.equals("")) {
            bl = false;
            System.out.println(string + " does not use the empty prefix for XHTML");
        }
        if (bl) {
            System.out.println(string + " is valid XHTML.");
        }
    }
}

