/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class TreePrinter {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java nu.xom.samples.TreePrinter URL");
            return;
        }
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            Element element = document.getRootElement();
            TreePrinter.listChildren(element);
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public static void inspect(Element element) {
        int n;
        String string;
        String string2;
        if (element.getParent() != null) {
            System.out.println();
        }
        String string3 = element.getQualifiedName();
        System.out.println(string3 + ":");
        String string4 = element.getNamespaceURI();
        if (!string4.equals("")) {
            String string5 = element.getLocalName();
            string2 = element.getNamespaceURI();
            string = element.getNamespacePrefix();
            System.out.println("  Local name: " + string5);
            System.out.println("  Namespace URI: " + string2);
            if (!"".equals(string)) {
                System.out.println("  Namespace prefix: " + string);
            }
        }
        for (n = 0; n < element.getAttributeCount(); ++n) {
            string2 = element.getAttribute(n);
            string = string2.getQualifiedName();
            String string6 = string2.getValue();
            System.out.println("  " + string + "=\"" + string6 + "\"");
        }
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            string2 = element.getNamespacePrefix(n);
            string = element.getNamespaceURI(string2);
            System.out.println("  xmlns:" + string2 + "=\"" + string + "\"");
        }
    }

    public static void listChildren(Element element) {
        TreePrinter.inspect(element);
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            TreePrinter.listChildren(elements.get(i));
        }
    }
}

