/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.ParsingException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SchemaValidator {
    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.SchemaValidator URL");
            return;
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            Builder builder = new Builder(xMLReader, true);
            builder.build(stringArray[0]);
            System.out.println(stringArray[0] + " is schema valid.");
        }
        catch (SAXException sAXException) {
            System.out.println("Could not load Xerces.");
            System.out.println(sAXException.getMessage());
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not schema valid.");
            System.out.println(parsingException.getMessage());
            parsingException.printStackTrace();
            System.out.println(" at line " + parsingException.getLineNumber() + ", column " + parsingException.getColumnNumber());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, Xerces could not check " + stringArray[0]);
            iOException.printStackTrace();
        }
    }
}

