/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;

public class SQLToXML {
    public static void main(String[] stringArray) {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not load the JDBC-ODBC Bridge");
            return;
        }
        try {
            Element element = new Element("Budget");
            SQLToXML.writeAgencies(element);
            Document document = new Document(element);
            Serializer serializer = new Serializer((OutputStream)System.out, "UTF-8");
            serializer.write(document);
            serializer.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAgencies(Element element) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DriverManager.getConnection("jdbc:odbc:budauth", "", "");
            statement = connection.createStatement();
            String string = "SELECT DISTINCT AgencyName, AgencyCode FROM BudgetAuthorizationTable;";
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString("AgencyName");
                String string3 = resultSet.getString("AgencyCode");
                Element element2 = new Element("Agency");
                Element element3 = new Element("Name");
                Element element4 = new Element("Code");
                element3.appendChild(string2);
                element4.appendChild(string3);
                element2.appendChild((Node)element3);
                element2.appendChild((Node)element4);
                SQLToXML.writeBureaus(element2, connection, string3);
                element.appendChild((Node)element2);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
            sQLException.printStackTrace();
        }
        finally {
            try {
                statement.close();
                connection.close();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
            }
        }
    }

    private static void writeBureaus(Element element, Connection connection, String string) throws SQLException {
        String string2 = "SELECT DISTINCT BureauName, BureauCode FROM BudgetAuthorizationTable WHERE AgencyCode='" + string + "';";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            String string3 = resultSet.getString("BureauName");
            String string4 = resultSet.getString("BureauCode");
            Element element2 = new Element("Bureau");
            Element element3 = new Element("Name");
            Element element4 = new Element("Code");
            element3.appendChild(string3);
            element4.appendChild(string4);
            element2.appendChild((Node)element3);
            element2.appendChild((Node)element4);
            SQLToXML.writeAccounts(element2, connection, string, string4);
            element.appendChild((Node)element2);
        }
    }

    private static void writeAccounts(Element element, Connection connection, String string, String string2) throws SQLException {
        String string3 = "SELECT DISTINCT AccountName, AccountCode FROM BudgetAuthorizationTable WHERE AgencyCode='" + string + "' AND BureauCode='" + string2 + "';";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        while (resultSet.next()) {
            String string4 = resultSet.getString("AccountName");
            String string5 = resultSet.getString("AccountCode");
            Element element2 = new Element("Account");
            Element element3 = new Element("Name");
            Element element4 = new Element("Code");
            element3.appendChild(string4);
            element4.appendChild(string5);
            element2.appendChild((Node)element3);
            element2.appendChild((Node)element4);
            SQLToXML.writeSubfunctions(element2, connection, string, string2, string5);
            element.appendChild((Node)element2);
        }
    }

    private static void writeSubfunctions(Element element, Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT * FROM BudgetAuthorizationTable WHERE AgencyCode='" + string + "' AND BureauCode='" + string2 + "' AND AccountCode='" + string3 + "';";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        while (resultSet.next()) {
            String string5 = resultSet.getString("SubfunctionTitle");
            String string6 = resultSet.getString("SubfunctionCode");
            Element element2 = new Element("Subfunction");
            Element element3 = new Element("Name");
            Element element4 = new Element("Code");
            element3.appendChild(string5);
            element4.appendChild(string6);
            element2.appendChild((Node)element3);
            element2.appendChild((Node)element4);
            Element element5 = new Element("Amount");
            element5.addAttribute(new Attribute("year", "TransitionQuarter"));
            element5.appendChild(String.valueOf((long)resultSet.getInt("TransitionQuarter") * 1000L));
            element2.appendChild((Node)element5);
            for (int i = 1976; i <= 2006; ++i) {
                String string7 = "FY" + i;
                long l = (long)resultSet.getInt(string7) * 1000L;
                element5 = new Element("Amount");
                element5.addAttribute(new Attribute("year", String.valueOf(i)));
                element5.appendChild(String.valueOf(l));
                element2.appendChild((Node)element5);
            }
            element.appendChild((Node)element2);
        }
    }
}

