/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.benchmarks;

import java.io.IOException;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

class Reproducer {
    Reproducer() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.benchmarks.Reproducer URL");
            return;
        }
        Reproducer reproducer = new Reproducer();
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            Reproducer.bench(reproducer, document);
            long l = 0L;
            int n = 100;
            for (int i = 1; i < n; ++i) {
                l += Reproducer.bench(reproducer, document);
            }
            System.out.println((double)l / (double)n + "ms to build tree on average");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
    }

    private static long bench(Reproducer reproducer, Document document) throws IOException {
        long l = System.currentTimeMillis();
        reproducer.copy(document);
        long l2 = System.currentTimeMillis();
        return l2 - l;
    }

    private Document copy(Document document) throws IOException {
        Element element = document.getRootElement();
        Element element2 = this.copy(element);
        Document document2 = new Document(element2);
        document2.setBaseURI(document.getBaseURI());
        for (int i = 0; i < document.getChildCount(); ++i) {
            Node node = document.getChild(i);
            if (node == element) continue;
            Node node2 = this.copy(node);
            document2.insertChild(node2, i);
        }
        return document2;
    }

    private Element copy(Element element) {
        Attribute attribute;
        int n;
        Element element2 = new Element(element.getQualifiedName(), element.getNamespaceURI());
        for (n = element.getAttributeCount() - 1; n >= 0; --n) {
            attribute = element.getAttribute(n);
            element2.addAttribute(this.copy(attribute));
        }
        for (n = 0; n < element.getChildCount(); ++n) {
            attribute = this.copy(element.getChild(n));
            element2.appendChild((Node)attribute);
        }
        return element2;
    }

    private Node copy(Node node) {
        if (node instanceof Text) {
            return this.copy((Text)node);
        }
        if (node instanceof Element) {
            return this.copy((Element)node);
        }
        if (node instanceof Comment) {
            return this.copy((Comment)node);
        }
        if (node instanceof ProcessingInstruction) {
            return this.copy((ProcessingInstruction)node);
        }
        if (node instanceof DocType) {
            return this.copy((DocType)node);
        }
        return null;
    }

    private Node copy(Text text) {
        return new Text(text.getValue());
    }

    private Node copy(Comment comment) {
        return new Comment(comment.getValue());
    }

    private Node copy(ProcessingInstruction processingInstruction) {
        return new ProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
    }

    private Node copy(DocType docType) {
        return new DocType(docType.getRootElementName(), docType.getPublicID(), docType.getSystemID());
    }

    private Attribute copy(Attribute attribute) {
        Attribute attribute2 = new Attribute(attribute.getQualifiedName(), attribute.getNamespaceURI(), attribute.getValue(), attribute.getType());
        return attribute2;
    }
}

