/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xhelp.c                                                       *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : help routines (open URL in Mozilla)                      *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcHelp()                    - Open help in Mozilla     *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id$
 */

/*
   Copyright (C) 1997-2019 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "m-depend.h"

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include "xmedcon.h"

/*****************************************************************************
                              D E F I N E S
*****************************************************************************/

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcHelp(GtkWidget *widget, gpointer data)
{
  int err;

  /* mozilla */
#if _WIN32
  sprintf(xmdcstr,"\"c:\\program files\\mozilla firefox\\firefox.exe\" %s &",XMDCHELP);
#else
  sprintf(xmdcstr,"firefox '%s' &",XMDCHELP);
#endif
  err=system(xmdcstr);
  if (err == 0) {
    XMdcDisplayMesg("Opening %s docs in Mozilla Firefox ...",MDC_PRGR);
  }else{
    XMdcDisplayMesg("Online documentation available at\n%s",XMDCHELP);
  }

}

