#ifndef _SKYEPEP_H
#define _SKYEPEP_H

/* include file to hook skyviewmenu.c and skyeyep.c together.
 */

typedef struct {
    double ra, dec, alt, az;	/* location when created */
    double eyepw, eyeph;	/* width and height, rads */
    double eyepa;		/* position angle, rads E of N */
    int round;			/* true if want round, false if square */
    int solid;			/* true if want solid, else just border */
} EyePiece;

/* skyeyep.c */

extern void se_add (double ra, double dec, double alt, double az);
extern void se_cursor (Cursor c);
extern int se_getlist (EyePiece **ep);
extern void se_unmanage(void);
extern void se_manage(void);
extern int se_isOneHere (double azra, double altdec, int isradec);
extern void se_del (double azra, double altdec, int isradec);


/* For RCS Only -- Do Not Edit
 * @(#) $RCSfile: skyeyep.h,v $ $Date: 2003/05/08 00:13:34 $ $Revision: 1.5 $ $Name:  $
 */

#endif /* _SKYEPEP_H */
