#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/extensions/XInput.h>
#include <X11/extensions/XInput2.h>

int main()
{
  Display *d = XOpenDisplay(":0");
  if (d == NULL) {
    printf("Display failed to open");
  }

  int device_count;

  // Fetch the list of XInput devices.
  // Store the "count" of these devices in `device_count`
  // XDeviceInfo *inputs = XListInputDevices(d, &device_count);
  XIDeviceInfo *inputs = XIQueryDevice(d, XIAllMasterDevices, &device_count);


  for (int i = 0; i < device_count; i++) {

    // Only process pointer inputs
    if (inputs[i].use == XIMasterPointer) {
      double x, y;

      // Create throw-away storage for saving things we don't want
      Window _w;
      double _d;
      XIButtonState _xib;
      XIModifierState _xim;
      XIGroupState _xig;

      XIQueryPointer(d,                    // display
                     inputs[i].deviceid,         // deviceid
                     DefaultRootWindow(d), // "win"

                     // The rest of the arguments are passed as pointers intended for XIQueryPointer
                     // to store data into
                     &_w,   // root_return, we don't care for this example.
                     &_w,   // child_return, we don't care for this example.
                     &x,    // X coordinate
                     &y,    // Y coordinate
                     &_d,   // win_x_return, don't care for this example.
                     &_d,   // win_y_return, don't care for this example.
                     &_xib, // buttons_return, don't care for this example.
                     &_xim, // modifiers_return, don't care for this example.
                     &_xig  // group_return, don't care for this example.
      );

      printf("Pointer id:%d at location %0.0f,%0.0f\n", inputs[i].deviceid, x, y);
    }
  }

  XIFreeDeviceInfo(inputs);
}